/*
 * Decompiled with CFR 0.152.
 */
package hec.lang;

import hec.io.FieldAccessor;
import hec.lang.Array2dContainer;
import java.io.Serializable;
import java.lang.reflect.Field;

public class DoubleArray2dContainer
extends Array2dContainer
implements Serializable,
FieldAccessor {
    protected double[][] table;

    public DoubleArray2dContainer(int cols, int rows) {
        super(cols, rows);
        this.table = new double[cols][rows];
    }

    public void copyInto(DoubleArray2dContainer cont) {
        super.copyInto(cont);
        this.table = new double[cont.cols][cont.rows];
        for (int c2 = 0; c2 < cont.cols; ++c2) {
            System.arraycopy(cont.table[c2], 0, this.table[c2], 0, cont.rows);
        }
    }

    public boolean getCoordinate(int rowIndex, double[] rowArray) {
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            return false;
        }
        for (int ii = 0; ii < rowArray.length && ii < this.table.length; ++ii) {
            rowArray[ii] = this.table[ii][rowIndex];
        }
        return true;
    }

    public double getCoordinate(int rowIndex, int colIndex) {
        if (rowIndex < 0 || rowIndex >= this.getRowCount() || colIndex < 0 || colIndex >= this.getColumnCount()) {
            return -3.4028234663852886E38;
        }
        return this.table[colIndex][rowIndex];
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

