/*
 * Decompiled with CFR 0.152.
 */
package hec.lang;

import hec.util.Util;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;

public class Email {
    String message = null;
    String toName = null;
    String fromName = null;
    String subject = null;
    String emailServer = null;
    int timeOutSeconds = 10;
    Socket sock = null;
    BufferedInputStream is = null;
    OutputStream os = null;
    byte[] barray = new byte[256];
    boolean debug = false;
    boolean confirm = false;

    public Email(String emailServer) {
        this.emailServer = emailServer;
    }

    public void setDebug(boolean debug) {
        System.out.println(Util.msgTime() + " >> Email debug set to: " + debug);
        this.debug = debug;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }

    public void setTo(String toName) {
        this.toName = toName;
    }

    public void setFrom(String fromName) {
        this.fromName = fromName;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTimeOut(int timeOutSeconds) {
        this.timeOutSeconds = timeOutSeconds;
    }

    public void sendMailCommand(String command, String responseCode) throws IOException {
        if (this.debug) {
            System.out.println(command);
        }
        this.os.write((command + "\n").getBytes());
        this.os.flush();
        Email.wait(1000);
        for (int j = 0; j < 255; ++j) {
            this.barray[j] = 32;
        }
        this.is.read(this.barray);
        String resp = new String(this.barray, 0, 4);
        if (!resp.equals(responseCode)) {
            throw new InterruptedIOException("no response");
        }
        if (this.debug) {
            System.out.println(new String(this.barray));
        }
    }

    public void sendMail(String toName) throws IOException {
        this.setTo(toName);
        this.sendMail();
    }

    public static void wait(int millisecs) {
        try {
            Thread.sleep(millisecs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void sendMail(String[] emailNameList) throws IOException {
        for (int i = 0; i < emailNameList.length; ++i) {
            this.setTo(emailNameList[i]);
            this.sendMail();
        }
    }

    public void sendMail() throws IOException {
        StringBuffer sb = new StringBuffer();
        if (this.fromName == null) {
            sb.append(" [Missing >> FROM] ");
        }
        if (this.toName == null) {
            sb.append(" [Missing >> TO] ");
        }
        if (this.message == null) {
            sb.append(" [Missing >> MESSAGE] ");
        }
        if (this.subject == null) {
            sb.append(" [Missing >> SUBJECT] ");
        }
        if (sb.length() > 0) {
            throw new IOException("Undefined input for Email " + sb.toString());
        }
        this.sock = new Socket(this.emailServer, 25);
        this.os = this.sock.getOutputStream();
        this.is = new BufferedInputStream(this.sock.getInputStream());
        this.sock.setSoTimeout(this.timeOutSeconds * 1000);
        try {
            Email.wait(1000);
            this.is.read(this.barray);
            String resp = new String(this.barray, 0, 4);
            if (!resp.equals("220 ")) {
                throw new InterruptedIOException("no response");
            }
            if (this.debug) {
                System.out.println(new String(this.barray));
            }
            this.sendMailCommand("HELO hec.usace.army.mil", "250 ");
            this.sendMailCommand("MAIL FROM: " + this.fromName, "250 ");
            this.sendMailCommand("RCPT TO: " + this.toName, "250 ");
            this.sendMailCommand("DATA", "354 ");
            this.sendMailCommand("Subject: " + this.subject + "\n" + this.message + "\n.", "250 ");
            this.sendMailCommand("QUIT", "221 ");
            this.os.close();
            this.is.close();
            if (this.confirm) {
                System.out.println(Util.msgTime() + " >> Mail sent to: " + this.toName + " Subject: " + this.subject);
            }
        }
        catch (InterruptedIOException e) {
            throw new IOException(Util.msgTime() + " >> Mail Server not responding(time out = " + this.timeOutSeconds + " secs): " + this.emailServer);
        }
    }
}

