/*
 * Decompiled with CFR 0.152.
 */
package hec.lang;

import hec.io.FieldAccessor;
import hec.lang.Array2dContainer;
import java.io.Serializable;
import java.lang.reflect.Field;

public class FloatArray2dContainer
extends Array2dContainer
implements Serializable,
FieldAccessor {
    protected float[][] table;

    public FloatArray2dContainer(int cols, int rows) {
        super(cols, rows);
        this.table = new float[cols][rows];
    }

    public void copyInto(FloatArray2dContainer cont) {
        super.copyInto(cont);
        this.table = new float[cont.cols][cont.rows];
        for (int c2 = 0; c2 < cont.cols; ++c2) {
            System.arraycopy(cont.table[c2], 0, this.table[c2], 0, cont.rows);
        }
    }

    public boolean getCoordinate(int rowIndex, float[] rowArray) {
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            return false;
        }
        for (int ii = 0; ii < rowArray.length && ii < this.table.length; ++ii) {
            rowArray[ii] = this.table[ii][rowIndex];
        }
        return true;
    }

    public float getCoordinate(int rowIndex, int colIndex) {
        if (rowIndex < 0 || rowIndex >= this.getRowCount() || colIndex < 0 || colIndex >= this.getColumnCount()) {
            return -3.4028235E38f;
        }
        return this.table[colIndex][rowIndex];
    }

    public boolean setCoordinate(int rowIndex, int colIndex, float value) {
        if (rowIndex < 0 || rowIndex >= this.getRowCount() || colIndex < 0 || colIndex >= this.getColumnCount()) {
            return false;
        }
        this.table[colIndex][rowIndex] = value;
        return true;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

