/*
 * Decompiled with CFR 0.152.
 */
package hec.lang;

import hec.heclib.util.intContainer;
import java.io.Serializable;

public class FloatArrayContainer
implements Serializable {
    public float[] array;
    public int length;

    public FloatArrayContainer() {
        this.array = null;
        this.length = 0;
    }

    public FloatArrayContainer(float[] values) {
        this.array = values;
        this.length = values.length;
    }

    public FloatArrayContainer(int numberElements) {
        this.array = new float[numberElements];
        this.length = numberElements;
    }

    public int setSize(int numberElements) {
        if (numberElements < 1) {
            this.length = 0;
            this.array = null;
            return -1;
        }
        this.length = numberElements;
        this.array = new float[numberElements];
        for (int i = 0; i < numberElements; ++i) {
            this.array[i] = -3.4028235E38f;
        }
        return 0;
    }

    public int resize(int numberElements) {
        return this.resize(numberElements, 0, 0);
    }

    public int resize(int numberElements, int beginningElement) {
        float[] temp;
        if (numberElements < 1) {
            this.length = 0;
            if (this.array != null) {
                this.array = null;
            }
            return -1;
        }
        if (beginningElement < 0) {
            beginningElement = 0;
        }
        if ((temp = new float[numberElements]) == null) {
            return -1;
        }
        int diff = numberElements - this.length;
        if (diff > 0) {
            int y = beginningElement + diff - 1;
            int arrayPos = 0;
            for (int i = 0; i < numberElements; ++i) {
                if ((i < beginningElement || i > y) && arrayPos < this.length) {
                    temp[i] = this.array[arrayPos];
                    ++arrayPos;
                    continue;
                }
                temp[i] = -3.4028235E38f;
            }
        } else {
            int arrayPos = 0;
            for (int i = 0; i < numberElements; ++i) {
                arrayPos = i >= beginningElement ? i - diff : i;
                temp[i] = arrayPos < this.length ? this.array[arrayPos] : -3.4028235E38f;
            }
        }
        this.length = numberElements;
        this.array = temp;
        return 0;
    }

    public int resize(int numberElements, int beginningElementOld, int beginningElementNew) {
        float[] temp;
        if (numberElements < 1) {
            this.length = 0;
            if (this.array != null) {
                this.array = null;
            }
            return -1;
        }
        if (beginningElementOld < 0) {
            beginningElementOld = 0;
        }
        if (beginningElementNew < 0) {
            beginningElementNew = 0;
        }
        if (beginningElementOld > this.length) {
            beginningElementOld = this.length;
        }
        if (beginningElementNew > numberElements) {
            beginningElementNew = numberElements;
        }
        if ((temp = new float[numberElements]) == null) {
            return -1;
        }
        int pos = this.length - beginningElementOld + beginningElementNew;
        for (int i = 0; i < numberElements; ++i) {
            if (i >= beginningElementNew && i < pos) {
                int k = beginningElementOld + i - beginningElementNew;
                temp[i] = this.array[k];
                continue;
            }
            temp[i] = -3.4028235E38f;
        }
        this.length = numberElements;
        this.array = temp;
        return 0;
    }

    public void set(int elementNumber, float value) {
        if (elementNumber >= this.length) {
            this.resize(elementNumber + 1);
        }
        this.array[elementNumber] = value;
    }

    public float maximum(intContainer elementNumber) {
        if (!this.isDefined(elementNumber)) {
            return -3.4028235E38f;
        }
        float maximum = this.array[elementNumber.value];
        for (int i = elementNumber.value; i < this.length; ++i) {
            if (this.array[i] == -3.4028235E38f || !(this.array[i] > maximum)) continue;
            maximum = this.array[i];
            elementNumber.value = i;
        }
        return maximum;
    }

    public float minimum(intContainer elementNumber) {
        if (!this.isDefined(elementNumber)) {
            return -3.4028235E38f;
        }
        float minimum = this.array[elementNumber.value];
        for (int i = elementNumber.value; i < this.length; ++i) {
            if (this.array[i] == -3.4028235E38f || !(this.array[i] < minimum)) continue;
            minimum = this.array[i];
            elementNumber.value = i;
        }
        return minimum;
    }

    public float minimum() {
        intContainer ic = new intContainer();
        return this.minimum(ic);
    }

    public float maximum() {
        intContainer ic = new intContainer();
        return this.maximum(ic);
    }

    public boolean isDefined(intContainer elementNumber) {
        elementNumber.value = 0;
        if (this.array == null || this.length == 0) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.array[i] == -3.4028235E38f) continue;
            elementNumber.value = i;
            return true;
        }
        return false;
    }

    public boolean isDefined() {
        intContainer ic = new intContainer();
        return this.isDefined(ic);
    }
}

