/*
 * Decompiled with CFR 0.152.
 */
package hec.lang;

import hec.lang.Const;

public class InterpolateFunction {
    protected static boolean extrapolateLow = false;
    protected static boolean extrapolateHigh = false;
    private static double m_yout;
    private static float m_youtF;
    protected int numberOfOrdinates;
    protected double[] xarray;
    protected double[] yarray;

    public static void SetExtrapolateLow(boolean extrap) {
        extrapolateLow = extrap;
    }

    public static void SetExtrapolateHigh(boolean extrap) {
        extrapolateHigh = extrap;
    }

    public static boolean extrapolatesLow() {
        return extrapolateLow;
    }

    public static boolean extrapolatesHigh() {
        return extrapolateHigh;
    }

    public static double interpolate(double xin, int nuords, double[] xary, double[] yary, boolean extrapLow, boolean extrapHi) {
        extrapolateLow = extrapLow;
        extrapolateHigh = extrapHi;
        return InterpolateFunction.interpolate(xin, nuords, xary, yary);
    }

    public static double interpolate(double xin, int nuords, double[] xary, double[] yary) {
        m_yout = -3.4028234663852886E38;
        if (nuords < 1) {
            m_yout = -9.99E32;
        } else if (nuords < 2) {
            m_yout = yary[0];
        } else if (xary[nuords - 1] > xary[0]) {
            if (xin < xary[0] && !extrapolateLow) {
                m_yout = yary[0];
            } else if (xin > xary[nuords - 1] && !extrapolateHigh) {
                m_yout = yary[nuords - 1];
            } else {
                double ratio;
                for (int jx = 1; jx < nuords; ++jx) {
                    if (!(xin <= xary[jx])) continue;
                    ratio = (xin - xary[jx - 1]) / (xary[jx] - xary[jx - 1]);
                    m_yout = yary[jx - 1] + ratio * (yary[jx] - yary[jx - 1]);
                    break;
                }
                if (Const.isUndefined(m_yout)) {
                    ratio = (xin - xary[nuords - 2]) / (xary[nuords - 1] - xary[nuords - 2]);
                    m_yout = yary[nuords - 2] + ratio * (yary[nuords - 1] - yary[nuords - 2]);
                }
            }
        } else if (xin < xary[nuords - 1] && !extrapolateLow) {
            m_yout = yary[nuords - 1];
        } else if (xin > xary[0] && !extrapolateHigh) {
            m_yout = yary[0];
        } else {
            double ratio;
            for (int jx = nuords - 2; jx > -1; --jx) {
                if (!(xin <= yary[jx])) continue;
                ratio = (xin - xary[jx + 1]) / (xary[jx] - xary[jx + 1]);
                m_yout = yary[jx + 1] + ratio * (yary[jx] - yary[jx + 1]);
                break;
            }
            if (Const.isUndefined(m_yout)) {
                ratio = (xin - xary[1]) / (xary[0] - xary[1]);
                m_yout = yary[1] + ratio * (yary[0] - yary[1]);
            }
        }
        return m_yout;
    }

    public static float interpolate(float xin, int nuords, float[] xary, float[] yary) {
        m_yout = -3.4028234663852886E38;
        if (nuords < 1) {
            m_youtF = -9.99E32f;
        } else if (nuords < 2) {
            m_youtF = yary[0];
        } else if (xary[nuords - 1] > xary[0]) {
            if (xin < xary[0] && !extrapolateLow) {
                m_youtF = yary[0];
            } else if (xin > xary[nuords - 1] && !extrapolateHigh) {
                m_youtF = yary[nuords - 1];
            } else {
                float ratio;
                for (int jx = 1; jx < nuords; ++jx) {
                    if (!(xin <= xary[jx])) continue;
                    ratio = (xin - xary[jx - 1]) / (xary[jx] - xary[jx - 1]);
                    m_youtF = yary[jx - 1] + ratio * (yary[jx] - yary[jx - 1]);
                    break;
                }
                if (Const.isUndefined(m_yout)) {
                    ratio = (xin - xary[nuords - 2]) / (xary[nuords - 1] - xary[nuords - 2]);
                    m_yout = yary[nuords - 2] + ratio * (yary[nuords - 1] - yary[nuords - 2]);
                }
            }
        } else if (xin < xary[nuords - 1] && !extrapolateLow) {
            m_youtF = yary[nuords - 1];
        } else if (xin > xary[0] && !extrapolateHigh) {
            m_youtF = yary[0];
        } else {
            float ratio;
            for (int jx = nuords - 2; jx > -1; --jx) {
                if (!(xin <= yary[jx])) continue;
                ratio = (xin - xary[jx + 1]) / (xary[jx] - xary[jx + 1]);
                m_youtF = yary[jx + 1] + ratio * (yary[jx] - yary[jx + 1]);
                break;
            }
            if (Const.isUndefined(m_yout)) {
                ratio = (xin - xary[1]) / (xary[0] - xary[1]);
                m_yout = yary[1] + ratio * (yary[0] - yary[1]);
            }
        }
        return m_youtF;
    }

    public void setArrays(int nv, double[] x, double[] y) {
        this.numberOfOrdinates = nv;
        this.xarray = new double[nv];
        this.yarray = new double[nv];
        for (int i = 0; i < nv; ++i) {
            this.xarray[i] = x[i];
            this.yarray[i] = y[i];
        }
    }

    public double interpolate(double xin) {
        return InterpolateFunction.interpolate(xin, this.numberOfOrdinates, this.xarray, this.yarray);
    }

    public static void main(String[] args) {
        int nv = 2;
        double[] x = new double[]{0.0, 100.0};
        double[] y = new double[]{0.0, 1.0};
        int nva = 2;
        double[] xa = new double[]{100.0, 0.0};
        double[] ya = new double[]{0.0, 1.0};
        double yout = InterpolateFunction.interpolate(50.0, nv, x, y);
        InterpolateFunction.SetExtrapolateHigh(true);
        yout = InterpolateFunction.interpolate(150.0, nv, x, y);
        yout = InterpolateFunction.interpolate(75.0, nva, xa, ya);
        yout = InterpolateFunction.interpolate(150.0, nva, xa, ya);
        System.out.println(" yout = " + yout);
        int nvb = 3;
        double[] xb = new double[]{0.0, 50.0, 100.0};
        double[] yb = new double[]{0.0, 0.25, 1.0};
        InterpolateFunction f = new InterpolateFunction();
        f.setArrays(nvb, xb, yb);
    }
}

