/*
 * Decompiled with CFR 0.152.
 */
package hec.lang;

import hec.io.LogPrintStream;
import hec.lang.LoggingConstants;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import rma.util.RMAIO;

@Deprecated
public class Logger
implements LoggingConstants {
    private static LogPrintStream _writer = null;
    private static Hashtable<Object, Integer> _flags = new Hashtable();
    private static String _propFile;

    public static void init() {
    }

    public static void load(String propFile) {
        Properties props = new Properties();
        _flags.clear();
        _propFile = propFile;
        Field[] fields = LoggingConstants.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getType().getName().equals("java.lang.String") || fields[i].getName().equals("DEFAULT_PROP_FILE")) continue;
            try {
                Object obj = fields[i].get(null);
                if (_flags.get(obj) != null) continue;
                _flags.put(obj, new Integer(5));
                continue;
            }
            catch (Exception obj) {
                // empty catch block
            }
        }
        try {
            props.load(new BufferedInputStream(new FileInputStream(propFile)));
            System.out.println("Loaded debug logging properties file: " + propFile);
        }
        catch (Exception e) {
            System.out.println("Debug off; no logging properties file: " + propFile);
            return;
        }
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = props.get(key);
            Integer i = new Integer(RMAIO.parseInt(value.toString(), 0));
            _flags.put(key, i);
        }
    }

    public static synchronized void save() {
        if (_propFile == null) {
            return;
        }
        Set<Object> keys = _flags.keySet();
        Iterator<Object> iter = keys.iterator();
        Properties props = new Properties();
        while (iter.hasNext()) {
            Object key = iter.next();
            Integer value = _flags.get(key);
            if (value == null || value == 5) continue;
            props.setProperty(String.valueOf(key), String.valueOf(value));
        }
        try {
            System.out.println("Saving debug logging properties file: " + _propFile);
            props.store(new BufferedOutputStream(new FileOutputStream(_propFile)), "Logging Properties file");
        }
        catch (Exception e) {
            System.out.println("Error saving debug logging properties file " + _propFile + " Error:" + e);
            return;
        }
    }

    private Logger() {
    }

    public static boolean checkFlag(String flag, int val) {
        if (flag == null) {
            return false;
        }
        Integer obj = _flags.get(flag);
        if (obj == null) {
            return false;
        }
        if (obj instanceof Integer) {
            return obj > val;
        }
        return false;
    }

    public static boolean canLog(String flag) {
        return Logger.checkFlag(flag, 10);
    }

    public static boolean canDebug(String flag) {
        return Logger.checkFlag(flag, 9);
    }

    public static boolean canWarn(String flag) {
        return Logger.checkFlag(flag, 3);
    }

    public static void log(String flag, String msg) {
        if (Logger.canLog(flag)) {
            System.out.println(msg);
        }
    }

    public static void debug(String flag, String msg) {
        if (Logger.canDebug(flag)) {
            System.out.println("[DEBUG]" + msg);
        }
    }

    public static void warn(String flag, String msg) {
        if (Logger.canWarn(flag)) {
            System.out.println("{WARNING]" + msg);
        }
    }

    public static Hashtable<Object, Integer> getLogTable() {
        return (Hashtable)_flags.clone();
    }

    public static int getDebugLevel(String flag) {
        if (flag == null) {
            return -1;
        }
        Integer i = _flags.get(flag);
        if (i == null) {
            return -1;
        }
        return i;
    }

    public static void setDebugFlag(String flag, int level) {
        if (flag == null) {
            return;
        }
        _flags.put(flag, new Integer(level));
    }

    static {
        Object path = "";
        boolean found = false;
        String propPath = System.getProperty("properties.path", null);
        if (propPath != null) {
            if (propPath.startsWith("..")) {
                propPath = propPath.substring(3);
            }
            File file = new File(propPath);
            propPath = file.getAbsolutePath();
            if ((file = new File(propPath)).exists()) {
                path = propPath + "/";
                found = true;
            }
        }
        if (!found) {
            String cwmsHome = System.getProperty("CWMS_HOME");
            if (cwmsHome != null) {
                path = cwmsHome.endsWith("/") ? cwmsHome : cwmsHome + "/";
            }
            path = ((String)path).concat("config/properties/");
        }
        path = ((String)path).concat("logger.properties");
        Logger.load((String)path);
    }
}

