/*
 * Decompiled with CFR 0.152.
 */
package hec.lang;

import hec.event.ModifiableListener;
import hec.io.AsciiSerializable;
import hec.lang.annotation.Scriptable;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Stack;
import java.util.Vector;
import rma.lang.Modifiable;

@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class NamedType
extends Observable
implements Serializable,
Cloneable,
AsciiSerializable,
Observer,
Modifiable,
Comparable {
    static final long serialVersionUID = -2020130821625251277L;
    public static final String NAME_CHANGED = "NAME_CHANGED";
    public static final String DESCRIPTION_CHANGED = "DESCRIPTION_CHANGED";
    public static final String RENAME_EVENT = "RENAME_EVENT";
    @XmlElement(name="Index")
    public int _index = Integer.MIN_VALUE;
    @XmlElement(name="Name")
    public String _name = "Untitled";
    @XmlElement(name="Description")
    public String _description = "";
    protected transient boolean _modified = false;
    protected transient boolean _ignoreModifiedEvents = false;
    protected transient boolean _isValid = true;
    public static final String defaultName = "Untitled";
    public static final String defaultDescription = "";
    private static final Hashtable _aggregateFieldsTable = new Hashtable();
    private transient List _modifiedListenerList = new ArrayList();

    public NamedType() {
        this._ignoreModifiedEvents = true;
        this._ignoreModifiedEvents = false;
    }

    public NamedType(String name) {
        this();
        this._ignoreModifiedEvents = true;
        this.setName(name);
        this._ignoreModifiedEvents = false;
    }

    public NamedType(String name, String descript) {
        this();
        this._ignoreModifiedEvents = true;
        this.setName(name);
        this.setDescription(descript);
        this._ignoreModifiedEvents = false;
    }

    public NamedType(NamedType nt) {
        if (nt == null) {
            return;
        }
        this._ignoreModifiedEvents = true;
        this.setName(nt.getName());
        this.setDescription(nt.getDescription());
        this._index = nt._index;
        this._isValid = nt._isValid;
        this._ignoreModifiedEvents = false;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public void setName(String s) {
        this.setModified(true);
        this._name = s;
        this.notifyObservers(NAME_CHANGED);
    }

    public void rename(String s) {
        if (s == null) {
            return;
        }
        String oldName = this._name;
        this._name = s;
        this.setModified(true);
        this.notifyObservers("RENAME_EVENT:" + oldName + ":" + this._name);
    }

    @Scriptable
    public String getName() {
        return this._name;
    }

    public void setDescription(String s) {
        this.setModified(true);
        this._description = s;
        this.notifyObservers(DESCRIPTION_CHANGED);
    }

    @Scriptable
    public String getDescription() {
        return this._description;
    }

    public int getIndex() {
        return this._index;
    }

    public void setIndex(int i) {
        this._index = i;
    }

    @Override
    @Scriptable
    public boolean isModified() {
        if (this._modified) {
            return true;
        }
        if (this.useRecursiveModifiedTest()) {
            return this.isModifiedRecursive();
        }
        return false;
    }

    @Override
    public void setModified(boolean flag) {
        if (this._ignoreModifiedEvents) {
            return;
        }
        if (flag && !super.hasChanged()) {
            super.setChanged();
        }
        if (!flag && super.hasChanged()) {
            super.clearChanged();
        }
        this._modified = flag;
        this.fireModifiedStateChanged();
        if (!flag && this.useRecursiveModifiedTest()) {
            this.setModifiedRecursive(flag);
        }
    }

    public void setIgnoreModifiedEvents(boolean b) {
        this._ignoreModifiedEvents = b;
    }

    public boolean getIgnoreModifiedEvents() {
        return this._ignoreModifiedEvents;
    }

    public boolean isValid() {
        return this._isValid;
    }

    public void setValid(boolean flag) {
        this._isValid = flag;
    }

    public boolean useRecursiveModifiedTest() {
        return false;
    }

    private boolean isModifiedRecursive() {
        Vector fieldVec = this.getAggregateFields();
        if (fieldVec == null) {
            return false;
        }
        boolean isAsciiSerializable = this instanceof AsciiSerializable;
        Enumeration e = fieldVec.elements();
        while (e.hasMoreElements()) {
            Object[] array;
            Object fldObj = null;
            Field fld = (Field)e.nextElement();
            int mods = fld.getModifiers();
            if (Modifier.isPublic(mods)) {
                try {
                    fldObj = fld.get(this);
                }
                catch (IllegalAccessException ex) {
                    fldObj = null;
                }
            } else if (isAsciiSerializable) {
                fldObj = this.getFieldObject(fld);
            }
            if (fldObj == null) continue;
            if (fldObj instanceof Modifiable) {
                if (!((Modifiable)fldObj).isModified()) continue;
                return true;
            }
            if (fldObj instanceof Collection) {
                Collection v = (Collection)fldObj;
                for (Object o : v) {
                    if (!(o instanceof Modifiable) || !((Modifiable)o).isModified()) continue;
                    return true;
                }
                continue;
            }
            if (!fldObj.getClass().isArray()) continue;
            if (fldObj.getClass().getComponentType() == NamedType.class) {
                array = (NamedType[])fldObj;
                for (int ii = 0; ii < array.length; ++ii) {
                    if (!((NamedType)array[ii]).isModified()) continue;
                    return true;
                }
                continue;
            }
            if (fldObj.getClass().getComponentType() != Collection.class) continue;
            array = (Collection[])fldObj;
            for (int ii = 0; ii < array.length; ++ii) {
                Iterator ve = array[ii].iterator();
                while (ve.hasNext()) {
                    Object o = ve.next();
                    if (!(o instanceof NamedType) || !((NamedType)o).isModified()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void setModifiedRecursive(boolean bool) {
        Vector fieldVec = this.getAggregateFields();
        if (fieldVec == null) {
            return;
        }
        boolean isAsciiSerializable = this instanceof AsciiSerializable;
        Enumeration e = fieldVec.elements();
        while (e.hasMoreElements()) {
            Object[] array;
            Object fldObj = null;
            Field fld = (Field)e.nextElement();
            int mods = fld.getModifiers();
            if (Modifier.isPublic(mods)) {
                try {
                    fldObj = fld.get(this);
                }
                catch (IllegalAccessException ex) {
                    fldObj = null;
                }
            } else if (isAsciiSerializable) {
                fldObj = this.getFieldObject(fld);
            }
            if (fldObj == null) continue;
            if (fldObj instanceof NamedType) {
                ((NamedType)fldObj).setModified(bool);
                continue;
            }
            if (fldObj instanceof Collection) {
                Collection v = (Collection)fldObj;
                for (Object o : v) {
                    if (!(o instanceof NamedType)) continue;
                    ((NamedType)o).setModified(bool);
                }
                continue;
            }
            if (!fldObj.getClass().isArray()) continue;
            if (fldObj.getClass().getComponentType() == NamedType.class) {
                array = (NamedType[])fldObj;
                for (int ii = 0; ii < array.length; ++ii) {
                    ((NamedType)array[ii]).setModified(bool);
                }
                continue;
            }
            if (fldObj.getClass().getComponentType() != Collection.class) continue;
            array = (Collection[])fldObj;
            for (int ii = 0; ii < array.length; ++ii) {
                Iterator ve = array[ii].iterator();
                while (ve.hasNext()) {
                    Object o = ve.next();
                    if (!(o instanceof NamedType)) continue;
                    ((NamedType)o).setModified(bool);
                }
            }
        }
    }

    private Vector getAggregateFields() {
        Class<?> supclass;
        Class objclass = this.getClass();
        Vector<Field> fieldVec = (Vector<Field>)_aggregateFieldsTable.get(objclass.getName());
        if (fieldVec != null) {
            return fieldVec;
        }
        fieldVec = new Vector<Field>();
        Stack classStack = new Stack();
        Class c2 = objclass;
        classStack.push(c2);
        while ((supclass = c2.getSuperclass()) != null) {
            classStack.push(supclass);
            c2 = supclass;
        }
        while (!classStack.empty()) {
            c2 = (Class)classStack.pop();
            Field[] fieldArray = c2.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                int mods = fieldArray[i].getModifiers();
                if (Modifier.isTransient(mods) || Modifier.isStatic(mods)) continue;
                Class<?> fldClass = fieldArray[i].getType();
                if (this.classExtends(fldClass, NamedType.class) || this.classExtends(fldClass, Collection.class)) {
                    fieldVec.addElement(fieldArray[i]);
                    continue;
                }
                if (!fldClass.isArray() || !this.classExtends(fldClass.getComponentType(), NamedType.class) && !this.classExtends(fldClass.getComponentType(), Collection.class)) continue;
                fieldVec.addElement(fieldArray[i]);
            }
        }
        _aggregateFieldsTable.put(objclass.getName(), fieldVec);
        return fieldVec;
    }

    private boolean classExtends(Class c2, Class sc) {
        Class supclass;
        if (c2 == sc) {
            return true;
        }
        while ((supclass = c2.getSuperclass()) != null) {
            if (supclass == sc) {
                return true;
            }
            c2 = supclass;
        }
        return false;
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        try {
            NamedType nt = (NamedType)super.clone();
            nt._name = this._name;
            nt._description = this._description;
            nt._index = this._index;
            return nt;
        }
        catch (CloneNotSupportedException e) {
            System.out.println("Exception: " + e.getMessage());
            return null;
        }
    }

    public int compareTo(Object object) {
        return this._name.compareTo(((NamedType)object).getName());
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public void update(Observable o, Object obj) {
    }

    public void addModifiableListener(ModifiableListener listener) {
        if (listener == null) {
            return;
        }
        this._modifiedListenerList.add(listener);
    }

    public void removeModifiableListener(ModifiableListener listener) {
        this._modifiedListenerList.remove(listener);
    }

    protected void fireModifiedStateChanged() {
        for (int i = this._modifiedListenerList.size() - 1; i >= 0; --i) {
            ModifiableListener listener = (ModifiableListener)this._modifiedListenerList.get(i);
            if (listener == null) continue;
            listener.modifiedStateChanged(this, this.isModified());
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        this._modifiedListenerList = new ArrayList();
        return this;
    }

    public void set(NamedType nt) {
        this.setName(nt.getName());
        this.setDescription(nt.getDescription());
        this._index = nt._index;
        this._isValid = nt._isValid;
    }

    public String toString() {
        return this.getName();
    }
}

