/*
 * Decompiled with CFR 0.152.
 */
package hec.lang;

import java.util.Random;

public class RandomNumber {
    Random randomNumberGenerator;
    static long seedNumber;
    double maximumDeviate;
    double minimumDeviate;
    double deviate;
    double deviateConstrained;

    public RandomNumber() {
        seedNumber = System.currentTimeMillis();
        this.reset();
    }

    public void reset() {
        this.randomNumberGenerator = new Random(seedNumber);
        this.maximumDeviate = 3.0;
        this.minimumDeviate = -3.0;
    }

    public void resetSeedNumber() {
        this.randomNumberGenerator.setSeed(seedNumber);
    }

    public void setSeedNumber(long seedNumberIn) {
        seedNumber = seedNumberIn;
        this.randomNumberGenerator.setSeed(seedNumber);
    }

    public long getSeedNumber() {
        return seedNumber;
    }

    public long getDefaultSeedNumber() {
        return System.currentTimeMillis();
    }

    public void setDeviateLimits(double minDeviate, double maxDeviate) {
        this.minimumDeviate = minDeviate;
        this.maximumDeviate = maxDeviate;
    }

    public void setMaxDeviate(double maxDeviateIn) {
        this.maximumDeviate = maxDeviateIn;
    }

    public void setMinDeviate(double minDeviateIn) {
        this.minimumDeviate = minDeviateIn;
    }

    public double getMaxDeviate() {
        return this.maximumDeviate;
    }

    public double getMinDeviate() {
        return this.minimumDeviate;
    }

    public double getOneNormalRandomDeviate() {
        this.deviate = this.randomNumberGenerator.nextGaussian();
        this.deviateConstrained = Math.max(this.deviate, this.minimumDeviate);
        this.deviateConstrained = Math.min(this.deviateConstrained, this.maximumDeviate);
        return this.deviateConstrained;
    }

    public double getUniformDeviate() {
        return this.randomNumberGenerator.nextDouble();
    }

    public double getUnconstrainedNormDev() {
        return this.deviate;
    }

    public double getConstrainedNormDev() {
        return this.deviateConstrained;
    }

    public static void main(String[] args) {
        System.out.println("Test RandomNumber");
        RandomNumber r = new RandomNumber();
        for (int i = 0; i < 1000; ++i) {
            double rn = r.getOneNormalRandomDeviate();
            System.out.println("i \t" + i + "\tNumber\t" + rn);
        }
    }
}

