/*
 * Decompiled with CFR 0.152.
 */
package hec.lang;

import hec.lang.RdcField;
import java.util.Vector;

public class RdcDelim {
    protected Vector _rdcFields = new Vector(50, 50);
    protected RdcField _field;
    protected String _separators = ",";
    protected String _separatorQuote = "\"";
    protected int _numberOfFields = 0;
    protected int _numCharIn_string;
    protected String _string;
    protected int _numCharIn_fieldContent;
    protected String _fieldContent;

    public void reset() {
        this._rdcFields.removeAllElements();
        this._string = "";
        this._numberOfFields = 0;
        this._numCharIn_string = 0;
    }

    public int setSeps(String theSeps) {
        this._separators = theSeps;
        return this._separators.length();
    }

    public String getSeps() {
        return this._separators;
    }

    public int setSepsQuote(String theSepsQ) {
        this._separatorQuote = theSepsQ;
        return this._separatorQuote.length();
    }

    public String getSepsQuote() {
        return this._separatorQuote;
    }

    public int getCountOfFields() {
        return this._numberOfFields;
    }

    public int size() {
        return this._numberOfFields;
    }

    public int lengthField(int ixField) {
        if (ixField > -1 && ixField < this._rdcFields.size()) {
            return ((RdcField)this._rdcFields.elementAt(ixField)).getLength();
        }
        return 0;
    }

    public int firstCol(int ixField) {
        if (ixField > -1 && ixField < this._rdcFields.size()) {
            return ((RdcField)this._rdcFields.elementAt(ixField)).getBeginCol();
        }
        return 0;
    }

    public int lastCol(int ixField) {
        if (ixField > -1 && ixField < this._rdcFields.size()) {
            return ((RdcField)this._rdcFields.elementAt(ixField)).getEndCol();
        }
        return 0;
    }

    public StringBuffer fieldContent(int ixField) {
        return this.getFieldContent(ixField);
    }

    public StringBuffer getFieldContent(int ixField) {
        if (ixField > -1 && ixField < this._rdcFields.size()) {
            return ((RdcField)this._rdcFields.elementAt(ixField)).getFieldContent();
        }
        return new StringBuffer("");
    }

    public char getFieldSeparator(int ixField) {
        if (ixField > -1 && ixField < this._rdcFields.size()) {
            return ((RdcField)this._rdcFields.elementAt(ixField)).getSeparator();
        }
        return ' ';
    }

    public void rdcFields(StringBuffer stringIn, int firstCol, int length) {
        this.computeFields(stringIn, firstCol, length);
    }

    public void computeFields(StringBuffer stringIn) {
        int nc = stringIn.length();
        this.computeFields(stringIn, 0, nc);
    }

    public void computeFields(StringBuffer stringIn, int firstCol, int length) {
        int ixSeparator = -1;
        this.reset();
        String colVal = "  ";
        String openChar = "  ";
        boolean openquote = false;
        boolean prevquote = false;
        boolean openfield = false;
        int colLastVal = -1;
        int lastCol = Math.min(stringIn.length() - 1, firstCol + length - 1);
        this._numberOfFields = 0;
        this._string = stringIn.toString();
        char[] c2 = new char[2];
        this._field = new RdcField();
        this._field.reset();
        for (int col = 0; col <= lastCol; ++col) {
            c2[0] = this._string.charAt(col);
            c2[1] = colVal.charAt(1);
            colVal = String.copyValueOf(c2);
            if (this._separatorQuote.indexOf(this._string.charAt(col)) > -1) {
                if (!openfield) {
                    prevquote = true;
                    if (openquote) {
                        if (this._string.charAt(col) == openChar.charAt(0)) {
                            this._field.setEndCol(col - 1);
                            int l = this._field.getEndCol() - this._field.getBeginCol() + 1;
                            this._field.setLength(l);
                            ixSeparator = this._separatorQuote.indexOf(this._string.charAt(col));
                            this._field.setSeparator(this._separatorQuote.charAt(ixSeparator));
                            this._rdcFields.addElement(this._field);
                            this._field = new RdcField();
                            openquote = false;
                        }
                    } else {
                        openquote = true;
                        c2[0] = this._string.charAt(col);
                        c2[1] = openChar.charAt(1);
                        openChar = String.copyValueOf(c2);
                        this._field.setBeginCol(col + 1);
                    }
                } else if (prevquote) {
                    prevquote = false;
                }
            } else if (this._separators.indexOf(colVal.charAt(0)) > -1 && !openquote) {
                ixSeparator = this._separators.indexOf(colVal.charAt(0));
                this._field.setSeparator(this._separators.charAt(ixSeparator));
                if (!openfield) {
                    if (!prevquote && (colVal.charAt(0) > ' ' && colVal.charAt(0) < '\u007f' || colVal.charAt(0) == '\t')) {
                        this._field.setBeginCol(col - 1);
                        this._field.setEndCol(col - 1);
                        this._field.setLength(0);
                        this._rdcFields.addElement(this._field);
                        this._field = new RdcField();
                    }
                } else {
                    this._field.setEndCol(col - 1);
                    if (colLastVal > -1) {
                        this._field.setEndCol(colLastVal);
                    }
                    this._field.computeLength();
                    this._rdcFields.addElement(this._field);
                    this._field = new RdcField();
                    openfield = false;
                    colLastVal = -1;
                }
            } else if (colVal.charAt(0) > '\u001f' && colVal.charAt(0) < '{') {
                if (colVal.charAt(0) == ' ' && !openquote) continue;
                if (!openfield && !openquote) {
                    openfield = true;
                    this._field.setBeginCol(col);
                }
                colLastVal = col;
            }
            prevquote = this._separatorQuote.indexOf(colVal.charAt(0)) > -1;
        }
        if (openfield) {
            this._field.setEndCol(lastCol);
            this._field.setSeparator(' ');
            if (colLastVal > -1) {
                this._field.setEndCol(colLastVal);
            }
            this._field.computeLength();
            this._rdcFields.addElement(this._field);
            openfield = false;
            colLastVal = -1;
        } else if (openquote) {
            this._field.setEndCol(lastCol);
            this._rdcFields.addElement(this._field);
            openquote = false;
        }
        this._numberOfFields = this._rdcFields.size();
        for (int j = 0; j < this._numberOfFields; ++j) {
            ((RdcField)this._rdcFields.elementAt(j)).storeFieldContent(this._string);
        }
    }

    public void printFields() {
        System.out.println("\n----------------------------------------------------------");
        System.out.println("Parse: " + this._string);
        for (int jf = 0; jf < this._numberOfFields; ++jf) {
            ((RdcField)this._rdcFields.elementAt(jf)).printField(jf);
        }
    }

    public static void main(String[] args) {
        RdcDelim d = new RdcDelim();
        System.out.println("Test RdcDelim");
        StringBuffer s = new StringBuffer("A= apart, B = BPART");
        int nc = s.length();
        d.setSeps("=");
        d.rdcFields(s, 0, nc);
        d.printFields();
    }
}

