/*
 * Decompiled with CFR 0.152.
 */
package hec.lang;

import java.text.DecimalFormat;

public class RdcField {
    private int _posFirstChar;
    private int _posLastChar;
    private int _numCharsInField;
    private StringBuffer _fieldContents = new StringBuffer();
    private char _separator;
    private int _numDigits2RightOfDecimal = 2;
    private String _pattern = "#,###.00;-#,###.00";
    private DecimalFormat _decimalFormat;
    private boolean _useComma;
    private int _fieldWidthPrint;
    private char _justify;

    public RdcField() {
        this.reset();
    }

    public void reset() {
        this._posFirstChar = -1;
        this._posLastChar = -1;
        this._numCharsInField = 0;
        this._fieldContents = new StringBuffer();
        this._useComma = true;
        this._fieldWidthPrint = 20;
    }

    public void setBeginCol(int beginCol) {
        this._posFirstChar = beginCol;
    }

    public void setEndCol(int endCol) {
        this._posLastChar = endCol;
    }

    public void setLength(int numCol) {
        this._numCharsInField = numCol;
    }

    public void setSeparator(char separator) {
        this._separator = separator;
    }

    public char getSeparator() {
        return this._separator;
    }

    public void setFieldContent(StringBuffer fieldContent) {
        this._fieldContents = fieldContent;
    }

    public int getBeginCol() {
        return this._posFirstChar;
    }

    public int getEndCol() {
        return this._posLastChar;
    }

    public int getLength() {
        return this._numCharsInField;
    }

    public int computeLength() {
        this._numCharsInField = this._posLastChar - this._posFirstChar + 1;
        return this._numCharsInField;
    }

    public StringBuffer storeFieldContent(String theString) {
        this._numCharsInField = Math.max(this._numCharsInField, 0);
        this._fieldContents.setLength(this._numCharsInField);
        int i = 0;
        if (this._numCharsInField > 0) {
            int j = this._posFirstChar;
            while (j <= this._posLastChar) {
                this._fieldContents.setCharAt(i, theString.charAt(j));
                ++j;
                ++i;
            }
        }
        return this._fieldContents;
    }

    public StringBuffer getFieldContent() {
        return this._fieldContents;
    }

    public StringBuffer getFieldContent(String theString) {
        return this.storeFieldContent(theString);
    }

    public void printField(int j) {
        System.out.println("j " + j + " begin " + this._posFirstChar + " end " + this._posLastChar + " length " + this._numCharsInField + " separator->" + this._separator + "<- content->" + this._fieldContents.toString() + "<-");
    }

    public void setPattern(String pattern) {
        this._pattern = new String(pattern);
        this._decimalFormat = new DecimalFormat(this._pattern);
    }

    public String getPattern() {
        return this._pattern;
    }

    public DecimalFormat getDecimalFormat() {
        return this._decimalFormat;
    }

    public void setUseCommas(boolean useComma) {
        this._useComma = useComma;
    }

    public void setUseCommas() {
        this.setUseCommas(true);
    }

    public boolean useCommas() {
        return this._useComma;
    }

    public void setFieldWidthPrint(int numCharsInField) {
        this._fieldWidthPrint = numCharsInField;
    }

    public int getFieldWidthPrint() {
        return this._fieldWidthPrint;
    }

    public char setJustify(char justify) {
        this._justify = justify == 'l' || justify == 'L' ? (char)76 : (justify == 'r' || justify == 'R' ? (char)82 : (char)76);
        return this._justify;
    }

    public char getJustify() {
        return this._justify;
    }

    public boolean isRightJustified() {
        return this._justify == 'R';
    }

    public boolean isLeftJustified() {
        return this._justify == 'L';
    }

    public void setNumDigits2RightOfDecimal(int numDigits) {
        this._numDigits2RightOfDecimal = numDigits;
    }

    public int getNumDigits2RightOfDecimal() {
        return this._numDigits2RightOfDecimal;
    }

    public String computePatternDouble(boolean useComma, int numCharField, int numDecimal) {
        this.setUseCommas(useComma);
        this.setFieldWidthPrint(numCharField);
        this.setNumDigits2RightOfDecimal(numDecimal);
        this._pattern = new String(RdcField.computePatternDoubleStatic(this._fieldWidthPrint, this._numDigits2RightOfDecimal, this._useComma));
        this._decimalFormat = new DecimalFormat(this._pattern);
        return this._pattern;
    }

    public String computePatternDouble(int numCharField, int numDecimal) {
        this.setFieldWidthPrint(numCharField);
        this.setNumDigits2RightOfDecimal(numDecimal);
        this._pattern = new String(RdcField.computePatternDoubleStatic(this._fieldWidthPrint, this._numDigits2RightOfDecimal, this._useComma));
        this._decimalFormat = new DecimalFormat(this._pattern);
        return this._pattern;
    }

    public String computePatternDouble(int numDecimal) {
        this._numDigits2RightOfDecimal = numDecimal;
        int numCharField = this.getFieldWidthPrint();
        return this.computePatternDouble(numCharField, numDecimal);
    }

    public StringBuffer printString(char justify, int sinOutWidth, String sin) {
        int ib;
        int j;
        String sinTrim = sin.trim();
        int numSin = sinTrim.length();
        StringBuffer sbOut = new StringBuffer(sinOutWidth);
        for (j = 0; j < sinOutWidth; ++j) {
            sbOut.append(' ');
        }
        if (justify == 'l' || justify == 'L') {
            ib = 0;
        } else if (justify == 'r' || justify == 'R') {
            ib = sinOutWidth - numSin;
            ib = Math.max(0, ib);
        } else {
            ib = (sinOutWidth - numSin) / 2;
            ib = Math.max(0, ib);
            ib = Math.min(sinOutWidth - 1, ib);
        }
        for (j = 0; j < numSin && ib + j < sinOutWidth; ++j) {
            sbOut.setCharAt(ib + j, sinTrim.charAt(j));
        }
        return sbOut;
    }

    public StringBuffer printInteger(char justify, int sinOutWidth, int sin) {
        int ib;
        int j;
        String sinTrim = Integer.toString(sin).trim();
        int numSin = sinTrim.length();
        StringBuffer sbOut = new StringBuffer(sinOutWidth);
        for (j = 0; j < sinOutWidth; ++j) {
            sbOut.append(' ');
        }
        if (justify == 'l' || justify == 'L') {
            ib = 0;
        } else if (justify == 'r' || justify == 'R') {
            ib = sinOutWidth - numSin;
        } else {
            ib = (sinOutWidth - numSin) / 2;
            ib = Math.max(0, ib);
            ib = Math.min(sinOutWidth - 1, ib);
        }
        for (j = 0; j < numSin && ib + j < sinOutWidth; ++j) {
            sbOut.setCharAt(ib + j, sinTrim.charAt(j));
        }
        return sbOut;
    }

    public String printDouble(double doubleToPrint) {
        return this.printDouble(this._justify, this._fieldWidthPrint, doubleToPrint);
    }

    public String printDouble(char justify, double doubleToPrint) {
        return this.printDouble(justify, this._fieldWidthPrint, doubleToPrint);
    }

    public String printDouble(char justify, int fieldWidth, double doubleToPrint) {
        int ib;
        int j;
        boolean chkZero = true;
        if (Math.abs(doubleToPrint) < 1.0E-20 && chkZero) {
            this._fieldContents = new StringBuffer();
            if (this._numDigits2RightOfDecimal < 1) {
                this._fieldContents = new StringBuffer("0");
            } else {
                int jdot = fieldWidth - this._numDigits2RightOfDecimal - 1;
                jdot = Math.max(jdot, 0);
                for (int j2 = 0; j2 < fieldWidth; ++j2) {
                    if (j2 == jdot) {
                        this._fieldContents.append('.');
                        continue;
                    }
                    if (j2 > jdot) {
                        this._fieldContents.append('0');
                        continue;
                    }
                    this._fieldContents.append(' ');
                }
            }
        } else {
            this._fieldContents = new StringBuffer(this._decimalFormat.format(doubleToPrint));
        }
        int ncSbOut = this._fieldContents.length();
        if (ncSbOut > fieldWidth) {
            DecimalFormat dfs = new DecimalFormat("0.###E0");
            this._fieldContents = new StringBuffer(dfs.format(doubleToPrint));
            ncSbOut = this._fieldContents.length();
            if (ncSbOut > fieldWidth) {
                if (fieldWidth < 7) {
                    this._fieldContents.setLength(0);
                    for (int j3 = 0; j3 < fieldWidth; ++j3) {
                        this._fieldContents.append('*');
                    }
                } else {
                    dfs = new DecimalFormat("0.#E0");
                    this._fieldContents = new StringBuffer(dfs.format(doubleToPrint));
                }
                ncSbOut = this._fieldContents.length();
            }
        }
        StringBuffer sbTemp = new StringBuffer(this._fieldContents.toString());
        this._fieldContents = new StringBuffer(fieldWidth);
        for (j = 0; j < fieldWidth; ++j) {
            this._fieldContents.append(' ');
        }
        if (justify == 'l' || justify == 'L') {
            ib = 0;
        } else if (justify == 'r' || justify == 'R') {
            ib = fieldWidth - ncSbOut;
        } else {
            ib = (fieldWidth - ncSbOut) / 2;
            ib = Math.max(0, ib);
            ib = Math.min(fieldWidth - 1, ib);
        }
        for (j = 0; j < ncSbOut && ib + j < fieldWidth; ++j) {
            this._fieldContents.setCharAt(ib + j, sbTemp.charAt(j));
        }
        return this._fieldContents.toString();
    }

    public static StringBuffer printStringStatic(char justify, int sinOutWidth, String sin) {
        int ib;
        int j;
        String sinTrim = sin.trim();
        int numSin = sinTrim.length();
        StringBuffer sbOut = new StringBuffer(sinOutWidth);
        for (j = 0; j < sinOutWidth; ++j) {
            sbOut.append(' ');
        }
        if (justify == 'l' || justify == 'L') {
            ib = 0;
        } else if (justify == 'r' || justify == 'R') {
            ib = sinOutWidth - numSin;
        } else {
            ib = (sinOutWidth - numSin) / 2;
            ib = Math.max(0, ib);
            ib = Math.min(sinOutWidth - 1, ib);
        }
        for (j = 0; j < numSin && ib + j < sinOutWidth; ++j) {
            sbOut.setCharAt(ib + j, sinTrim.charAt(j));
        }
        return sbOut;
    }

    public static StringBuffer printIntegerStatic(char justify, int sinOutWidth, int sin) {
        int ib;
        int j;
        String sinTrim = Integer.toString(sin).trim();
        int numSin = sinTrim.length();
        StringBuffer sbOut = new StringBuffer(sinOutWidth);
        for (j = 0; j < sinOutWidth; ++j) {
            sbOut.append(' ');
        }
        if (justify == 'l' || justify == 'L') {
            ib = 0;
        } else if (justify == 'r' || justify == 'R') {
            ib = sinOutWidth - numSin;
        } else {
            ib = (sinOutWidth - numSin) / 2;
            ib = Math.max(0, ib);
            ib = Math.min(sinOutWidth - 1, ib);
        }
        for (j = 0; j < numSin && ib + j < sinOutWidth; ++j) {
            sbOut.setCharAt(ib + j, sinTrim.charAt(j));
        }
        return sbOut;
    }

    public static StringBuffer printDouble(char justify, int fieldWidth, int numDigitRightDecimal, double doubleToPrint) {
        StringBuffer sbOut = new StringBuffer("");
        String pattern = new String(RdcField.computePatternDoubleStatic(fieldWidth, numDigitRightDecimal));
        DecimalFormat df = new DecimalFormat(pattern);
        boolean chkZero = true;
        if (Math.abs(doubleToPrint) < 1.0E-20 && chkZero) {
            sbOut = new StringBuffer();
            if (numDigitRightDecimal < 1) {
                sbOut = new StringBuffer("0");
            } else {
                int jdot = fieldWidth - numDigitRightDecimal - 1;
                jdot = Math.max(jdot, 0);
                for (int j = 0; j < fieldWidth; ++j) {
                    if (j == jdot) {
                        sbOut.append('.');
                        continue;
                    }
                    if (j > jdot) {
                        sbOut.append('0');
                        continue;
                    }
                    sbOut.append(' ');
                }
            }
        } else {
            sbOut = new StringBuffer(df.format(doubleToPrint));
        }
        int ncSbOut = sbOut.length();
        if (ncSbOut <= fieldWidth) {
            int ib;
            int j;
            StringBuffer sbTemp = new StringBuffer(sbOut.toString());
            sbOut = new StringBuffer(fieldWidth);
            for (j = 0; j < fieldWidth; ++j) {
                sbOut.append(' ');
            }
            if (justify == 'l' || justify == 'L') {
                ib = 0;
            } else if (justify == 'r' || justify == 'R') {
                ib = fieldWidth - ncSbOut;
            } else {
                ib = (fieldWidth - ncSbOut) / 2;
                ib = Math.max(0, ib);
                ib = Math.min(fieldWidth - 1, ib);
            }
            for (j = 0; j < ncSbOut && ib + j < fieldWidth; ++j) {
                sbOut.setCharAt(ib + j, sbTemp.charAt(j));
            }
        }
        return sbOut;
    }

    public static String computePatternDoubleStatic(int fieldWidth, int numDigitRightDecimal, boolean useCommas) {
        int j;
        StringBuffer pattern = new StringBuffer(fieldWidth);
        int decimalPointLoc = fieldWidth;
        for (j = 0; j < fieldWidth; ++j) {
            pattern.append(' ');
        }
        if (numDigitRightDecimal > 0) {
            decimalPointLoc = fieldWidth - numDigitRightDecimal - 1;
            for (j = decimalPointLoc = Math.max(decimalPointLoc, 0); j < fieldWidth; ++j) {
                if (j == decimalPointLoc) {
                    pattern.setCharAt(j, '.');
                    continue;
                }
                pattern.setCharAt(j, '0');
            }
        }
        int numNum = 0;
        for (int j2 = decimalPointLoc - 1; j2 > -1 && j2 > -1; --j2) {
            if (numNum > 2 && useCommas) {
                pattern.setCharAt(j2, ',');
                numNum = 0;
                continue;
            }
            pattern.setCharAt(j2, '#');
            ++numNum;
        }
        StringBuffer patternNeg = new StringBuffer(";" + pattern.toString());
        patternNeg.setCharAt(1, '-');
        pattern.append(patternNeg);
        return pattern.toString();
    }

    public static String computePatternDoubleStatic(int fieldWidth, int numDigitRightDecimal) {
        return RdcField.computePatternDoubleStatic(fieldWidth, numDigitRightDecimal, true);
    }

    public static void main(String[] args) {
        RdcField r = new RdcField();
        r.computePatternDouble(false, 12, 4);
        String numAsString = r.printDouble(1901.1015);
        String numAsString2 = r.printDouble('r', 20, 1902.0131);
        System.out.println("Number as String: " + numAsString);
        System.out.println("Number as String: " + numAsString2);
        numAsString = r.printDouble('r', 14, 1901.1015);
        System.out.println("Number as String: " + numAsString);
        String pattern = new String(r.computePatternDouble(4));
        double big = Double.MAX_VALUE;
        String sbig = r.printDouble('r', 14, big);
        System.out.println(sbig);
        sbig = r.printDouble('r', 5, big);
        System.out.println(sbig);
        double b0 = 0.0;
        double b1 = 2.3423423423422343E8;
        double b2 = 2.345E-7;
        double b3 = -234.34225;
        double b4 = -1.23456789034225E9;
        System.out.println(r.printDouble('r', 20, b0));
        System.out.println(r.printDouble('r', 20, b1));
        System.out.println(r.printDouble('r', 20, b2));
        System.out.println(r.printDouble('r', 20, b3));
        System.out.println(r.printDouble('r', 20, b4));
        double d0 = 0.0;
        double d1 = 2.1234567;
        double d2 = 123456.1234;
        double d3 = -98765.9876;
        double d4 = 1.2345678901231235E12;
        double d5 = 1000.3;
        double d6 = 1000.6;
        StringBuffer sout = RdcField.printDouble('r', 14, 3, d0);
        System.out.println(RdcField.printDouble('r', 12, 3, 0.0));
        System.out.println(RdcField.printDouble('r', 12, 3, d1));
        System.out.println(RdcField.printDouble('r', 12, 3, d2));
        System.out.println(RdcField.printDouble('r', 12, 3, d3));
        System.out.println(RdcField.printDouble('r', 12, 3, d4));
        System.out.println(RdcField.printDouble('r', 12, 0, d2));
        System.out.println(RdcField.printDouble('r', 12, 0, d3));
        System.out.println(RdcField.printDouble('r', 12, 0, d5));
        System.out.println(RdcField.printDouble('r', 12, 0, d6));
        int done = 99;
    }
}

