/*
 * Decompiled with CFR 0.152.
 */
package hec.lang;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class Reflection {
    public static final String[] emptyParamTypes = new String[0];
    public static final Object[] emptyParams = new Object[0];

    public static Class<?> getClass(String name) throws Exception {
        String[] parts = name.split("\\[");
        if (parts.length > 1) {
            Class<?> baseClass = Reflection.getClass(parts[0]);
            int[] dimensions = new int[parts.length - 1];
            for (int i = 0; i < dimensions.length; ++i) {
                dimensions[i] = 0;
            }
            Object obj = Array.newInstance(baseClass, dimensions);
            return obj.getClass();
        }
        if (name.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("char")) {
            return Character.TYPE;
        }
        if (name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("short")) {
            return Short.TYPE;
        }
        if (name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("double")) {
            return Double.TYPE;
        }
        if (name.equals("void")) {
            return Void.TYPE;
        }
        return Class.forName(name);
    }

    public static Field getField(String className, String fieldName) throws Exception {
        return Reflection.getClass(className).getField(fieldName);
    }

    public static Constructor<? extends Object> getConstructor(String className, String ... paramTypes) throws Exception {
        Class<?> objClass = Reflection.getClass(className);
        Class[] paramClasses = new Class[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramClasses[i] = Reflection.getClass(paramTypes[i]);
        }
        return objClass.getConstructor(paramClasses);
    }

    public static Constructor<? extends Object> getConstructor(String className, String paramType) throws Exception {
        String[] paramTypes = new String[]{paramType};
        return Reflection.getConstructor(className, paramTypes);
    }

    public static Method getMethod(String className, String methodName, String ... paramTypes) throws Exception {
        Class<?> objClass = Reflection.getClass(className);
        Class[] paramClasses = new Class[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramClasses[i] = Reflection.getClass(paramTypes[i]);
        }
        return objClass.getMethod(methodName, paramClasses);
    }

    public static Method getMethod(String className, String methodName, String paramType) throws Exception {
        String[] paramTypes = new String[]{paramType};
        return Reflection.getMethod(className, methodName, paramTypes);
    }
}

