/*
 * Decompiled with CFR 0.152.
 */
package hec.lang;

public class RegressionFromConstant {
    protected int numOrds;
    protected double constant;
    protected double[] x;
    protected double[] y;
    protected double slope;
    protected double coeffOfDetermination;
    protected double stdErrorOfRegression;
    protected double[] results;
    protected boolean computed = false;

    public RegressionFromConstant() {
    }

    public RegressionFromConstant(int nv, double[] x, double[] y, double constant) {
        this.createArrays(nv);
        this.constant = constant;
        this.setX(x);
        this.setY(y);
    }

    protected void createArrays(int nv) {
        this.computed = false;
        this.numOrds = nv;
        this.x = new double[nv];
        this.y = new double[nv];
        for (int i = 0; i < nv; ++i) {
            this.x[i] = -1.7976931348623157E308;
            this.y[i] = -1.7976931348623157E308;
        }
    }

    public void setNumOrds(int n) {
        this.numOrds = n;
        this.createArrays(n);
    }

    public void setConstant(double constant) {
        this.computed = false;
        this.constant = constant;
    }

    public void setX(double[] x) {
        this.computed = false;
        for (int i = 0; i < this.numOrds; ++i) {
            this.x[i] = x[i];
        }
    }

    public void setY(double[] y) {
        this.computed = false;
        for (int i = 0; i < this.numOrds; ++i) {
            this.y[i] = y[i];
        }
    }

    public int computeRegression() {
        int i;
        int errorFlag = 0;
        double sumy = 0.0;
        double sumxx = 0.0;
        double sumx = 0.0;
        double sumxy = 0.0;
        for (i = 0; i < this.numOrds; ++i) {
            double xy = this.x[i] * this.y[i];
            double xx = this.x[i] * this.x[i];
            double xd = this.x[i];
            sumxy += xy;
            sumx += xd;
            sumxx += xx;
            sumy += this.y[i];
        }
        this.slope = (sumxy - this.constant * sumx) / sumxx;
        double ym = sumy / (double)this.numOrds;
        sumy = 0.0;
        double sumr = 0.0;
        for (i = 0; i < this.numOrds; ++i) {
            sumxx = this.y[i] - (this.constant + this.slope * this.x[i]);
            sumr += sumxx * sumxx;
            sumy += Math.pow(this.y[i] - ym, 2.0);
        }
        this.stdErrorOfRegression = Math.sqrt(sumr / (double)this.numOrds);
        this.coeffOfDetermination = 1.0 - sumr / sumy;
        this.computed = true;
        return errorFlag;
    }

    public double getSlope() {
        if (!this.computed) {
            this.computeRegression();
        }
        return this.slope;
    }

    public double getStdErrOfRegression() {
        if (!this.computed) {
            this.computeRegression();
        }
        return this.stdErrorOfRegression;
    }

    public double getCoeffOfDetermination() {
        if (!this.computed) {
            this.computeRegression();
        }
        return this.coeffOfDetermination;
    }

    public double[] getResults() {
        if (!this.computed) {
            this.computeRegression();
        }
        this.results = new double[3];
        this.results[0] = this.slope;
        this.results[1] = this.stdErrorOfRegression;
        this.results[2] = this.coeffOfDetermination;
        return this.results;
    }

    public static double[] computeRegression(int nv, double[] x, double[] y, double c2) {
        int i;
        boolean errorFlag = false;
        double sumy = 0.0;
        double sumxx = 0.0;
        double sumx = 0.0;
        double sumxy = 0.0;
        for (i = 0; i < nv; ++i) {
            double xy = x[i] * y[i];
            double xx = x[i] * x[i];
            double xd = x[i];
            sumxy += xy;
            sumx += xd;
            sumxx += xx;
            sumy += y[i];
        }
        double slope = (sumxy - c2 * sumx) / sumxx;
        double ym = sumy / (double)nv;
        sumy = 0.0;
        double sumr = 0.0;
        for (i = 0; i < nv; ++i) {
            sumxx = y[i] - (c2 + slope * x[i]);
            sumr += sumxx * sumxx;
            sumy += Math.pow(y[i] - ym, 2.0);
        }
        double stdErrorOfRegression = Math.sqrt(sumr / (double)nv);
        double coeffOfDetermination = 1.0 - sumr / sumy;
        double[] r = new double[]{slope, stdErrorOfRegression, coeffOfDetermination};
        return r;
    }

    public static void main(String[] args) {
        int nv = 3;
        double[] x = new double[]{0.0, 2.0, 4.0};
        double[] y = new double[]{0.0, 6.0, 12.0};
        double c2 = 0.0;
        double[] results = new double[3];
        results = RegressionFromConstant.computeRegression(nv, x, y, c2);
        boolean j = false;
        RegressionFromConstant r = new RegressionFromConstant(nv, x, y, c2);
        double slope = r.getSlope();
        j = true;
    }
}

