/*
 * Decompiled with CFR 0.152.
 */
package hec.lang;

import hec.heclib.util.intContainer;
import java.io.Serializable;

public class ShortArrayContainer
implements Serializable {
    public short[] array;
    public int length;

    public ShortArrayContainer() {
        this.array = null;
        this.length = 0;
    }

    public ShortArrayContainer(short[] values) {
        this.array = values;
        this.length = values.length;
    }

    public ShortArrayContainer(int numberElements) {
        this.array = new short[numberElements];
        this.length = numberElements;
    }

    public int setSize(int numberElements) {
        if (numberElements < 1) {
            this.length = 0;
            this.array = null;
            return -1;
        }
        this.length = numberElements;
        this.array = new short[numberElements];
        for (int i = 0; i < numberElements; ++i) {
            this.array[i] = Short.MIN_VALUE;
        }
        return 0;
    }

    public int resize(int numberElements, int beginningElement) {
        if (numberElements < 1) {
            this.length = 0;
            this.array = null;
            return -1;
        }
        short[] temp = new short[numberElements];
        if (temp == null) {
            return -1;
        }
        if (beginningElement < 0) {
            beginningElement = 0;
        }
        if (beginningElement > this.length) {
            beginningElement = this.length;
        }
        for (int i = 0; i < numberElements; ++i) {
            temp[i] = i < this.length - beginningElement ? this.array[i + beginningElement] : Short.MIN_VALUE;
        }
        this.array = null;
        this.length = numberElements;
        this.array = temp;
        return 0;
    }

    public int resize(int numberElements) {
        return this.resize(numberElements, 0);
    }

    public void set(int elementNumber, short value) {
        if (elementNumber >= this.length) {
            this.resize(elementNumber + 1);
        }
        this.array[elementNumber] = value;
    }

    public short maximum(intContainer elementNumber) {
        if (!this.isDefined(elementNumber)) {
            return Short.MIN_VALUE;
        }
        short maximum = this.array[elementNumber.value];
        for (int i = elementNumber.value; i < this.length; ++i) {
            if (this.array[i] == Short.MIN_VALUE || this.array[i] <= maximum) continue;
            maximum = this.array[i];
            elementNumber.value = i;
        }
        return maximum;
    }

    public short minimum(intContainer elementNumber) {
        if (!this.isDefined(elementNumber)) {
            return Short.MIN_VALUE;
        }
        short minimum = this.array[elementNumber.value];
        for (int i = elementNumber.value; i < this.length; ++i) {
            if (this.array[i] == Short.MIN_VALUE || this.array[i] >= minimum) continue;
            minimum = this.array[i];
            elementNumber.value = i;
        }
        return minimum;
    }

    public short minimum() {
        intContainer ic = new intContainer();
        return this.minimum(ic);
    }

    public short maximum() {
        intContainer ic = new intContainer();
        return this.maximum(ic);
    }

    public boolean isDefined(intContainer elementNumber) {
        elementNumber.value = 0;
        if (this.array == null || this.length == 0) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.array[i] == Short.MIN_VALUE) continue;
            elementNumber.value = i;
            return true;
        }
        return false;
    }

    public boolean isDefined() {
        intContainer ic = new intContainer();
        return this.isDefined(ic);
    }
}

