/*
 * Decompiled with CFR 0.152.
 */
package hec.lang;

import java.io.IOException;
import java.io.InputStreamReader;

public class StatisticalParameter {
    int numberOfValues;
    double sumOfValues;
    double sumOfSquaredValues;
    double meanValue;
    double stdDevOfValues;
    double m_minValue;
    double m_maxValue;

    public StatisticalParameter() {
        this.reset();
    }

    public void reset() {
        this.numberOfValues = 0;
        this.sumOfValues = 0.0;
        this.sumOfSquaredValues = 0.0;
        this.meanValue = 0.0;
        this.stdDevOfValues = 0.0;
        this.m_minValue = 1.0E30;
        this.m_maxValue = -1.0E30;
    }

    public double getMean() {
        this.meanValue = this.numberOfValues < 1 ? 0.0 : this.sumOfValues / (double)this.numberOfValues;
        return this.meanValue;
    }

    public double getStdDev() {
        double nuValMinus1;
        double nuVal;
        double sumsq;
        double result1;
        this.stdDevOfValues = this.numberOfValues < 2 ? 0.0 : ((result1 = (this.sumOfSquaredValues - (sumsq = this.sumOfValues * this.sumOfValues) / (nuVal = (double)this.numberOfValues)) / (nuValMinus1 = (double)(this.numberOfValues - 1))) <= 0.0 ? 0.0 : Math.sqrt(result1));
        return this.stdDevOfValues;
    }

    public double getVariance() {
        double variance = this.numberOfValues < 2 ? 0.0 : (this.sumOfSquaredValues - Math.pow(this.sumOfValues, 2.0) / (double)this.numberOfValues) / (double)(this.numberOfValues - 1);
        return variance;
    }

    public double getSum() {
        return this.sumOfValues;
    }

    public double getSumSquared() {
        return this.sumOfSquaredValues;
    }

    public int getNumberOfValues() {
        return this.numberOfValues;
    }

    public double getMax() {
        return this.m_maxValue;
    }

    public double getMin() {
        return this.m_minValue;
    }

    public int addValue(double valueIn) {
        this.sumOfValues += valueIn;
        this.sumOfSquaredValues += Math.pow(valueIn, 2.0);
        this.m_minValue = Math.min(this.m_minValue, valueIn);
        this.m_maxValue = Math.max(this.m_maxValue, valueIn);
        ++this.numberOfValues;
        return this.numberOfValues;
    }

    public int addValue(int numValIn, double SumIn, double SumSqIn, double minVal, double maxVal) {
        this.sumOfValues += SumIn;
        this.sumOfSquaredValues += SumSqIn;
        this.numberOfValues += numValIn;
        this.m_minValue = Math.min(this.m_minValue, minVal);
        this.m_maxValue = Math.max(this.m_maxValue, maxVal);
        return this.numberOfValues;
    }

    public static void main(String[] args) throws IOException {
        StatisticalParameter sp = new StatisticalParameter();
        double[] n = new double[]{0.0, 2.0, 5.0, 8.5, 12.0};
        int nv = 5;
        for (int i = 0; i < nv; ++i) {
            sp.addValue(n[i]);
        }
        sp.getSum();
        sp.getMean();
        sp.getMax();
        sp.getMin();
        sp.getNumberOfValues();
        System.out.println("Mean: " + sp.getMean());
        System.out.println("Max: " + sp.getMax());
        System.out.println("Min: " + sp.getMin());
        System.out.println("Num Val: " + sp.getNumberOfValues());
        System.out.println("Sum: " + sp.getSum());
        System.out.println("Std Dev: " + sp.getStdDev());
        InputStreamReader in = new InputStreamReader(System.in);
        in.read();
    }
}

