/*
 * Decompiled with CFR 0.152.
 */
package hec.lang;

public class Statistics {
    private static double[] DEVIATE_CONSTANTS = new double[]{0.99288537661894, 0.120467516143104, 0.0160781993421, 0.002686704437162, 4.99634730235E-4, 9.8898218599E-5, 2.0391812764E-5, 4.327271618E-6, 9.38081413E-7, 2.06734721E-7, 4.6159699E-8, 1.041668E-8, 2.371501E-9, 5.43928E-10, 1.25549E-10, 2.9138E-11, 6.795E-12, 1.591E-12, 3.74E-13, 8.8E-14, 2.1E-14, 5.0E-15, 1.0E-15, 0.912158803417554, -0.016266281867664, 4.33556472949E-4, 2.14438570074E-4, 2.625751076E-6, -3.02109105E-6, -1.2406062E-8, 6.2406609E-8, -5.40125E-10, -1.423208E-9, 3.4384E-11, 3.3585E-11, -1.458E-12, -8.1E-13, 5.3E-14, 2.0E-14, -2.0E-15, 0.956679709020493, -0.023107004309065, -0.004374236097508, -5.76503422651E-4, -1.0961022307E-5, 2.5108547025E-5, 1.0562336068E-5, 2.75441233E-6, 4.32484498E-7, -2.0530337E-8, -4.3891537E-8, -1.768401E-8, -3.991289E-9, -1.86932E-10, 2.72923E-10, 1.32817E-10, 3.1834E-11, 1.67E-12, -2.036E-12, -9.65E-13, -2.2E-13, -1.0E-14, 1.3E-14, 6.0E-15, 1.0E-15};
    private static double DEVIATE_H1 = -1.5488130423733;
    private static double DEVIATE_H2 = 2.5654901231478;
    private static double DEVIATE_H3 = -0.55945763132983;
    private static double DEVIATE_H4 = 2.2879157162634;
    private static double DEVIATE_R2 = -1.4142135623731;
    private static double RESULT;
    private static double[] COF_GAMMLN;
    private static double STP_GAMMLN;
    private static double[][] TABK;

    public static double getNormalStdDeviate(double prob) {
        double deviate = 0.0;
        boolean errorFlag = false;
        double probSquaredDf = prob * 2.0 - 1.0;
        double sigma = probSquaredDf <= 0.0 ? -1.0 : 1.0;
        if (probSquaredDf >= 1.0 || probSquaredDf <= -1.0) {
            errorFlag = true;
        } else {
            int compType;
            int N;
            int IPP;
            double W;
            double B;
            double absProbSquaredDf = Math.abs(probSquaredDf);
            if (absProbSquaredDf > 0.8) {
                B = Math.sqrt(-1.0 * Math.log(1.0 - absProbSquaredDf * absProbSquaredDf));
                if (probSquaredDf > 0.9975) {
                    W = DEVIATE_H3 * B + DEVIATE_H4;
                    IPP = 40;
                    N = 25;
                    compType = 2;
                } else {
                    W = DEVIATE_H1 * B + DEVIATE_H2;
                    IPP = 23;
                    N = 17;
                    compType = 2;
                }
            } else {
                B = 0.0;
                W = absProbSquaredDf * absProbSquaredDf / 0.32 - 1.0;
                IPP = 0;
                N = 23;
                compType = 1;
            }
            double X3 = 1.0;
            double X4 = W;
            double X6 = DEVIATE_CONSTANTS[IPP];
            for (int i = 1; i < N; ++i) {
                X6 += DEVIATE_CONSTANTS[IPP + i] * X4;
                double X5 = X4 * W * 2.0 - X3;
                X3 = X4;
                X4 = X5;
            }
            if (compType == 1) {
                deviate = DEVIATE_R2 * absProbSquaredDf * X6 * sigma;
            } else if (compType == 2) {
                deviate = DEVIATE_R2 * B * X6 * sigma;
            }
        }
        return deviate;
    }

    public static boolean orderArray(int nval, char direction, double[] x, double[] y) {
        boolean valid = true;
        if (direction == 'D' || direction == 'd') {
            for (int i = 1; i < nval; ++i) {
                int m = i - 1;
                for (int j = i; j < nval; ++j) {
                    if (!(x[j] > x[m])) continue;
                    m = j;
                }
                if (m == i - 1) continue;
                double dx = x[i - 1];
                double dy = y[i - 1];
                x[i - 1] = x[m];
                y[i - 1] = y[m];
                x[m] = dx;
                y[m] = dy;
            }
        } else if (direction == 'I' || direction == 'i') {
            for (int i = 1; i < nval; ++i) {
                int m = i - 1;
                for (int j = i; j < nval; ++j) {
                    if (!(x[j] < x[m])) continue;
                    m = j;
                }
                if (m == i - 1) continue;
                double dx = x[i - 1];
                double dy = y[i - 1];
                x[i - 1] = x[m];
                y[i - 1] = y[m];
                x[m] = dx;
                y[m] = dy;
            }
        } else {
            valid = false;
        }
        return valid;
    }

    public static boolean isMonotonicallyDecreasing(int nval, double[] x) {
        boolean decreasing = true;
        for (int i = 1; i < nval && decreasing; ++i) {
            if (x[i - 1] > x[i]) continue;
            decreasing = false;
        }
        return decreasing;
    }

    public static boolean isMonotonicallyIncreasing(int nval, double[] x) {
        boolean increasing = true;
        for (int i = 1; i < nval && increasing; ++i) {
            if (x[i - 1] < x[i]) continue;
            increasing = false;
        }
        return increasing;
    }

    public static int computeCurveMoments(int nuOrds, double[] prob, double[] flow, double[] results) {
        double probDiff;
        int i;
        int errorFlag = 0;
        double probTotal = 0.0;
        for (i = 1; i < nuOrds; ++i) {
            probDiff = prob[i - 1] - prob[i];
            probTotal += probDiff;
        }
        for (i = 0; i < 2; ++i) {
            results[i] = 0.0;
        }
        for (i = 1; i < nuOrds; ++i) {
            probDiff = (prob[i - 1] - prob[i]) / probTotal;
            results[0] = results[0] + 0.5 * (flow[i - 1] + flow[i]) * probDiff;
        }
        double sd = 0.0;
        for (i = 1; i < nuOrds; ++i) {
            probDiff = (prob[i - 1] - prob[i]) / probTotal;
            double x1 = Math.pow(flow[i - 1] - results[0], 2.0);
            double x2 = Math.pow(flow[i] - results[0], 2.0);
            sd += 0.5 * (x1 + x2) * probDiff;
        }
        results[1] = Math.sqrt(sd);
        return errorFlag;
    }

    public static int computeConfidenceLimits(int nyr, double probFlow, double[] probFlowExceeds) {
        int error = 0;
        double pn = 1.0 - probFlow;
        double xn = nyr;
        for (int iyr = 0; iyr < nyr; ++iyr) {
            double a = iyr + 1;
            double b = nyr - iyr;
            probFlowExceeds[iyr] = Statistics.betai(a, b, pn);
        }
        return error;
    }

    protected static double betai(double a, double b, double pn) {
        boolean errorFlag = false;
        double probExceeded = 0.0;
        if (pn < 0.0 || pn > 1.0) {
            errorFlag = true;
        } else {
            double bt;
            if (Math.abs(pn) < 1.0E-10 || Math.abs(1.0 - pn) < 1.0E-10) {
                bt = 0.0;
            } else {
                double theExponent = Statistics.gammln(a + b) - Statistics.gammln(a) - Statistics.gammln(b) + a * Math.log(pn) + b * Math.log(1.0 - pn);
                bt = Math.exp(theExponent);
            }
            probExceeded = pn < (a + 1.0) / (a + b + 2.0) ? bt * Statistics.betacf(a, b, pn) / a : 1.0 - bt * Statistics.betacf(b, a, 1.0 - pn) / b;
        }
        return probExceeded;
    }

    protected static double betacf(double a, double b, double pn) {
        boolean errorFlag = false;
        double result = 0.0;
        boolean solved = false;
        double eps = 3.0E-7;
        double az = 1.0;
        double bm = 1.0;
        double am = 1.0;
        double qab = a + b;
        double qap = a + 1.0;
        double qam = a - 1.0;
        double bz = 1.0 - qab * pn / qap;
        for (int m = 0; m < 100 && !solved; ++m) {
            double em = (double)m + 1.0;
            double tem = em + em;
            double d = em * (b - (double)m - 1.0) * pn / ((qam + tem) * (a + tem));
            double ap = az + d * am;
            double bp = bz + d * bm;
            d = -1.0 * ((a + em) * (qab + em) * pn / ((a + tem) * (qap + tem)));
            double app = ap + d * az;
            double bpp = bp + d * bz;
            double aold = az;
            am = ap / bpp;
            bm = bp / bpp;
            az = app / bpp;
            bz = 1.0;
            if (!(Math.abs(az - aold) < eps * Math.abs(az))) continue;
            solved = true;
        }
        if (!solved) {
            errorFlag = true;
        }
        result = az;
        return result;
    }

    protected static int btclmt(int nsyst, double pe, double[] pc) {
        int errorFlag = 0;
        double pn = 1.0 - pe;
        double xn = nsyst;
        for (int i = 0; i < nsyst; ++i) {
            double a = i + 1;
            double b = xn - a + 1.0;
            pc[i] = Statistics.betai(a, b, pn);
        }
        return errorFlag;
    }

    protected static double gammln(double y) {
        double xx = y;
        double x = xx - 1.0;
        double tmp = x + 5.5;
        tmp = (x + 0.5) * Math.log(tmp) - tmp;
        double ser = 1.0;
        for (int j = 0; j < 6; ++j) {
            ser += COF_GAMMLN[j] / (x += 1.0);
        }
        double resultLnGammln = tmp + Math.log(STP_GAMMLN * ser);
        return resultLnGammln;
    }

    protected static int search(int medpos, int npt, double[] sd, int[] compPos, int[] ipos) {
        int i;
        int errorFlag = 0;
        int mdifm = -1;
        int mdiff = -1;
        int mpos = -1;
        int mxend = -1;
        int mxbeg = -1;
        mxbeg = -1;
        for (i = 1; i < npt - 2 && mxbeg < 0; ++i) {
            if (!(sd[i + 1] < sd[i])) continue;
            mxbeg = i;
        }
        if (mxbeg < 0) {
            errorFlag = 1;
            mpos = -999;
        } else {
            mxend = -1;
            for (i = npt - 2; i > mxbeg && mxend < 0; --i) {
                if (!((sd[i] - sd[i - 1]) / sd[i] > 1.0E-4)) continue;
                mxend = i;
            }
            if (mxend < 0) {
                errorFlag = 2;
            } else if (mxend == mxbeg + 1) {
                errorFlag = 3;
            }
        }
        if (errorFlag == 0) {
            int i2;
            double sdMin = Double.MAX_VALUE;
            for (i2 = mxbeg; i2 <= mxend; ++i2) {
                sdMin = Math.min(sdMin, sd[i2]);
            }
            for (i2 = mxbeg; i2 <= mxend; ++i2) {
                ipos[i2] = Math.abs(sd[i2] - sdMin) / sdMin < 1.0E-4 ? 1 : 0;
            }
            mpos = -1;
            mdifm = Integer.MAX_VALUE;
            for (i2 = mxbeg; i2 <= mxend; ++i2) {
                if (ipos[i2] != 1 || (mdiff = Math.abs(medpos - i2)) >= mdifm) continue;
                mdifm = mdiff;
                mpos = i2;
            }
            if (mpos < 0) {
                errorFlag = 3;
            } else {
                compPos[0] = mxbeg;
                compPos[1] = mxend;
                compPos[2] = mpos;
            }
        }
        return errorFlag;
    }

    public static double getLP3Deviate(double stdNormDev, double skew) {
        double lp3Deviate = -1.7976931348623157E308;
        if (Math.abs(skew) < 1.0E-4) {
            lp3Deviate = stdNormDev;
        } else {
            double skewAbs10 = 0.0;
            double val2 = 0.0;
            double val1 = 0.0;
            double ratio = 0.0;
            double dev = 0.0;
            int ixDev = -1;
            int jx = -1;
            skewAbs10 = Math.abs(skew) * 10.0;
            if (skewAbs10 > 30.0) {
                skewAbs10 = 30.0;
            }
            if ((jx = (int)skewAbs10) > 29) {
                jx = 29;
            }
            dev = skew < 0.0 ? -stdNormDev : stdNormDev;
            for (int i = 1; i < 31 && ixDev < 0; ++i) {
                if (!(dev < TABK[0][i])) continue;
                ixDev = i;
            }
            if (ixDev < 0) {
                ixDev = 30;
            }
            ratio = (dev - TABK[0][ixDev - 1]) / (TABK[0][ixDev] - TABK[0][ixDev - 1]);
            val1 = TABK[jx][ixDev - 1] + ratio * (TABK[jx][ixDev] - TABK[jx][ixDev - 1]);
            val2 = TABK[jx + 1][ixDev - 1] + ratio * (TABK[jx + 1][ixDev] - TABK[jx + 1][ixDev - 1]);
            lp3Deviate = val1 + (skewAbs10 - (double)jx) * (val2 - val1);
            if (skew < 0.0) {
                lp3Deviate = -lp3Deviate;
            }
        }
        return lp3Deviate;
    }

    public static double getNormalStandardDeviate(double lp3Dev, double skew) {
        double normDeviate = -1.7976931348623157E308;
        if (Math.abs(skew) < 1.0E-4) {
            normDeviate = lp3Dev;
        } else {
            double skewAbs10 = 0.0;
            double val2 = 0.0;
            double val1 = 0.0;
            double ratio = 0.0;
            double dev = 0.0;
            int ixDev = -1;
            int jx = -1;
            skewAbs10 = Math.abs(skew) * 10.0;
            if (skewAbs10 > 30.0) {
                skewAbs10 = 30.0;
            }
            if ((jx = (int)skewAbs10) > 29) {
                jx = 29;
            }
            dev = skew < 0.0 ? -lp3Dev : lp3Dev;
            for (int i = 1; i < 31 && ixDev < 0; ++i) {
                if (!(dev < TABK[jx][i])) continue;
                ixDev = i;
            }
            if (ixDev < 0) {
                ixDev = 30;
            }
            ratio = skewAbs10 - (double)jx;
            val1 = TABK[jx][ixDev - 1] + ratio * (TABK[jx + 1][ixDev - 1] - TABK[jx][ixDev - 1]);
            val2 = TABK[jx][ixDev] + ratio * (TABK[jx + 1][ixDev] - TABK[jx][ixDev]);
            normDeviate = TABK[0][ixDev - 1] + (TABK[0][ixDev] - TABK[0][ixDev - 1]) * (dev - val1) / (val2 - val1);
            if (skew < 0.0) {
                normDeviate = -normDeviate;
            }
        }
        return normDeviate;
    }

    public static void printResult(String s, double devIn, double devOut) {
        System.out.println("Results from getting Deviate");
        System.out.println("\t " + s + "   Input: " + devIn + "     Output: " + devOut);
    }

    public static double roundRealToDouble(float sp, int numSignificantDigits) {
        if ((double)Math.abs(sp) < -29.0) {
            RESULT = 0.0;
        } else {
            double dpTemp = (double)sp < -31.0 ? (double)(-sp) : (double)sp;
            int iexp = (int)(Math.log(dpTemp) * 0.4342944819032518);
            if (iexp > 0) {
                ++iexp;
            }
            double dpTemp2 = Math.pow(10.0, iexp -= numSignificantDigits);
            dpTemp2 = dpTemp / dpTemp2;
            dpTemp2 = Math.rint(dpTemp2);
            double dpTemp3 = Math.pow(10.0, Math.rint(iexp));
            double dpTemp4 = dpTemp2 * dpTemp3;
            System.out.println("\t\t\t\t\tdpTemp4: " + dpTemp4);
            RESULT = Math.rint(dpTemp / Math.pow(10.0, iexp));
            RESULT *= Math.pow(10.0, iexp);
            if ((double)sp < -31.0) {
                RESULT = -RESULT;
            }
        }
        return RESULT;
    }

    public static double roundRealToDouble(float sp) {
        return Statistics.roundRealToDouble(sp, 7);
    }

    public static double roundIt2(float sp, int nsig) {
        StringBuffer sbOut = new StringBuffer(20);
        int numDigitOut = 0;
        boolean scientific = false;
        boolean nonZero = false;
        boolean roundUp = false;
        boolean mustIncrement = false;
        boolean doneIncrement = false;
        String validNum = "0123456789-+.";
        String validSciNoteChar = "edgEDG";
        int ixCharSciNote = -1;
        double dp = sp;
        String strNum = Double.toString(sp);
        int nc = strNum.length();
        for (int i = 0; i < nc; ++i) {
            char currChar = strNum.charAt(i);
            int ixValid = validNum.indexOf(currChar);
            if (ixValid > -1 && !scientific) {
                if (ixValid > 9) {
                    sbOut.append(currChar);
                    continue;
                }
                if (ixValid > 0) {
                    nonZero = true;
                }
                if (numDigitOut == nsig) {
                    ++numDigitOut;
                    sbOut.append('0');
                    if (ixValid <= 4) continue;
                    roundUp = true;
                    continue;
                }
                if (numDigitOut > nsig) {
                    ++numDigitOut;
                    sbOut.append('0');
                    continue;
                }
                if (nonZero) {
                    ++numDigitOut;
                }
                sbOut.append(currChar);
                continue;
            }
            ixValid = validSciNoteChar.indexOf(currChar);
            if (ixValid > -1) {
                ixCharSciNote = sbOut.length();
                scientific = true;
            }
            sbOut.append(currChar);
        }
        System.out.println("String Representation of " + dp + " is " + strNum);
        if (roundUp) {
            StringBuffer sbRounded = new StringBuffer();
            for (int j = sbOut.length() - 1; j > -1; --j) {
                if (scientific && j >= ixCharSciNote) {
                    sbRounded.append(sbOut.charAt(j));
                    continue;
                }
                if (doneIncrement) {
                    sbRounded.append(sbOut.charAt(j));
                    continue;
                }
                int ixNum = validNum.indexOf(sbOut.charAt(j));
                if (mustIncrement) {
                    ++ixNum;
                }
                if (ixNum > -1 && ixNum < 9) {
                    sbRounded.append(validNum.charAt(ixNum + 1));
                    doneIncrement = true;
                    continue;
                }
                if (ixNum == 9) {
                    sbRounded.append('0');
                    mustIncrement = true;
                    continue;
                }
                if (ixNum == 10 && mustIncrement) {
                    sbRounded.append('1');
                    mustIncrement = false;
                    doneIncrement = true;
                    continue;
                }
                sbRounded.append(sbOut.charAt(j));
            }
            sbOut = sbRounded.reverse();
        }
        RESULT = Double.parseDouble(sbOut.toString());
        return RESULT;
    }

    public static double roundIt3(float sp, int nsig) {
        int ixValid;
        char currChar;
        StringBuffer sbOut = new StringBuffer(20);
        int numDigitOut = 0;
        boolean scientific = false;
        boolean nonZero = false;
        boolean roundUp = false;
        boolean mustIncrement = false;
        boolean doneIncrement = false;
        String validNum = "0123456789-+.";
        String validSciNoteChar = "edgEDG";
        int ixCharSciNote = -1;
        int ixDecimalPoint = -1;
        double dp = sp;
        String strNum = Double.toString(dp);
        int nc = strNum.length();
        System.out.println("String Representation of " + dp + " is " + strNum);
        int ixLastSig = sbOut.length() - 1;
        int ixSciNote = -1;
        for (int i = 0; i < nc; ++i) {
            currChar = strNum.charAt(i);
            ixValid = validNum.indexOf(currChar);
            if (ixValid > -1 && ixValid < 10) {
                if (ixSciNote >= 0 || numDigitOut >= nsig) continue;
                if (ixValid == 0 && !nonZero) {
                    ixLastSig = i;
                    continue;
                }
                ++numDigitOut;
                ixLastSig = i;
                nonZero = true;
                continue;
            }
            if (ixSciNote < 0 && validSciNoteChar.indexOf(currChar) > 0) {
                ixSciNote = i;
                continue;
            }
            if (ixValid != 12 || ixSciNote >= 0) continue;
            ixDecimalPoint = i;
        }
        if (ixLastSig == nc - 1 || ixLastSig == ixSciNote - 1) {
            RESULT = dp;
        } else {
            roundUp = ixLastSig < nc - 2 && (ixLastSig < ixSciNote - 2 || ixSciNote < 0) ? (ixValid = validNum.indexOf(currChar = strNum.charAt(ixLastSig + 1))) > 4 : false;
            StringBuffer sbRounded = new StringBuffer();
            mustIncrement = true;
            for (int j = nc - 1; j > -1; --j) {
                currChar = strNum.charAt(j);
                ixValid = validNum.indexOf(currChar);
                if (ixSciNote > -1 && j >= ixSciNote) {
                    sbRounded.append(strNum.charAt(j));
                    continue;
                }
                if (!mustIncrement) {
                    sbRounded.append(currChar);
                    continue;
                }
                if (j > ixLastSig) {
                    if (j >= ixDecimalPoint) continue;
                    sbRounded.append('0');
                    continue;
                }
                if (ixValid > 9) {
                    if (j == 0 && (ixValid == 10 || ixValid == 11)) {
                        mustIncrement = false;
                        sbRounded.append('1');
                    }
                    sbRounded.append(currChar);
                    continue;
                }
                int ixNum = roundUp ? 1 + validNum.indexOf(strNum.charAt(j)) : validNum.indexOf(strNum.charAt(j));
                if (ixNum > -1 && ixNum < 9) {
                    sbRounded.append(validNum.charAt(ixNum));
                    mustIncrement = false;
                    continue;
                }
                if (ixNum == 10) {
                    sbRounded.append('0');
                    mustIncrement = true;
                    continue;
                }
                sbRounded.append(strNum.charAt(j));
            }
            if (mustIncrement) {
                sbRounded.append('1');
            }
            sbOut = sbRounded.reverse();
            RESULT = Double.parseDouble(sbOut.toString());
        }
        return RESULT;
    }

    public static void main(String[] args) {
        float[] sp = new float[]{1.2345678f, 0.1234567f, 1234567.0f, 2.05f, 0.7654321f, 1.2345678E9f, -1.2345678f, -0.1234567f, -1234567.0f, -2.05f, -0.7654321f, -1.2345678E9f};
        for (int j = 0; j < 12; ++j) {
            double result = Statistics.roundIt3(sp[j], 6);
            System.out.println("Result for " + sp[j] + " is " + result);
        }
    }

    static {
        COF_GAMMLN = new double[]{76.18009173, -86.50532033, 24.01409822, -1.231739516, 0.00120858003, -5.36382E-6};
        STP_GAMMLN = 2.50662827465;
        TABK = new double[][]{{-3.71902, -3.29053, -3.09023, -2.87816, -2.57583, -2.32635, -2.05375, -1.95996, -1.75069, -1.64485, -1.28155, -0.84162, -0.5244, -0.25335, -0.17733, 0.0, 0.17733, 0.25335, 0.5244, 0.84162, 1.28155, 1.64485, 1.75069, 1.95996, 2.05375, 2.32635, 2.57583, 2.87816, 3.09023, 3.29053, 3.71902}, {-3.50703, -3.12767, -2.94834, -2.75706, -2.48187, -2.25258, -1.99973, -1.91219, -1.7158, -1.61594, -1.27037, -0.84611, -0.53624, -0.26882, -0.19339, -0.01662, 0.16111, 0.23763, 0.51207, 0.83639, 1.29178, 1.67279, 1.78462, 2.00688, 2.10697, 2.39961, 2.66965, 2.99978, 3.23322, 3.45513, 3.93453}, {-3.29921, -2.96698, -2.80786, -2.63672, -2.38795, -2.1784, -1.94499, -1.8636, -1.67999, -1.58607, -1.25824, -0.84986, -0.54757, -0.28403, -0.20925, -0.03325, 0.14472, 0.22168, 0.49927, 0.83044, 1.30105, 1.69971, 1.81756, 2.0529, 2.15935, 2.47226, 2.76321, 3.12169, 3.37703, 3.62113, 4.15301}, {-3.09631, -2.80889, -2.66915, -2.51741, -2.29423, -2.10394, -1.88959, -1.81427, -1.64329, -1.55527, -1.24516, -0.85285, -0.55839, -0.29897, -0.22492, -0.04993, 0.1282, 0.20552, 0.486, 0.82377, 1.30936, 1.72562, 1.84949, 2.09795, 2.21081, 2.54421, 2.85636, 3.24371, 3.52139, 3.7882, 4.37394}, {-2.89907, -2.6539, -2.53261, -2.39942, -2.20092, -2.02933, -1.83361, -1.76427, -1.60574, -1.52357, -1.23114, -0.85508, -0.56867, -0.31362, -0.24037, -0.06651, 0.11154, 0.18916, 0.47228, 0.81638, 1.31671, 1.75048, 1.88039, 2.14202, 2.26133, 2.61539, 2.949, 3.36566, 3.66608, 3.95605, 4.59687}, {-2.70836, -2.50257, -2.39867, -2.28311, -2.10825, -1.95472, -1.77716, -1.71366, -1.5674, -1.49101, -1.21618, -0.85653, -0.5784, -0.32796, -0.25558, -0.08302, 0.09478, 0.17261, 0.45812, 0.80829, 1.32309, 1.77428, 1.91022, 2.18505, 2.31084, 2.68572, 3.04102, 3.48737, 3.8109, 4.12443, 4.82141}, {-2.52507, -2.35549, -2.2678, -2.16884, -2.01644, -1.88029, -1.72033, -1.66253, -1.5283, -1.45762, -1.20028, -0.85718, -0.58757, -0.34198, -0.27047, -0.09945, 0.07791, 0.15589, 0.44352, 0.7995, 1.3285, 1.79701, 1.93896, 2.22702, 2.35931, 2.75514, 3.13232, 3.60872, 3.95567, 4.29311, 5.04718}, {-2.35015, -2.21328, -2.14053, -2.05701, -1.9258, -1.80621, -1.66325, -1.61099, -1.48852, -1.42345, -1.18347, -0.85703, -0.59615, -0.35565, -0.28516, -0.11578, 0.06097, 0.13901, 0.42851, 0.79002, 1.33294, 1.81864, 1.9666, 2.2679, 2.4067, 2.82359, 3.22281, 3.72957, 4.10022, 4.46189, 5.27389}, {-2.18448, -2.07661, -2.01739, -1.94806, -1.8366, -1.73271, -1.60604, -1.55914, -1.44813, -1.38855, -1.16574, -0.85607, -0.60412, -0.36889, -0.29961, -0.13199, 0.04397, 0.12199, 0.41309, 0.77986, 1.3364, 1.83916, 1.99311, 2.30764, 2.45298, 2.89101, 3.31243, 3.84981, 4.24439, 4.63057, 5.50124}, {-2.02891, -1.94611, -1.89894, -1.84244, -1.74919, -1.66001, -1.54886, -1.50712, -1.4072, -1.35299, -1.14712, -0.85426, -0.61146, -0.38186, -0.31368, -0.14807, 0.02693, 0.10486, 0.39729, 0.76902, 1.33889, 1.85856, 2.01848, 2.34623, 2.49811, 2.95735, 3.40109, 3.96932, 4.38807, 4.79899, 5.72899}, {-1.8841, -1.82241, -1.78572, -1.74062, -1.6639, -1.58838, -1.49188, -1.45507, -1.36584, -1.31684, -1.12762, -0.85161, -0.61815, -0.39434, -0.3274, -0.16397, 0.00987, 0.08763, 0.38111, 0.75752, 1.34039, 1.87683, 2.04269, 2.38364, 2.54206, 3.02256, 3.48874, 4.08802, 4.53112, 4.96701, 5.95691}, {-1.75053, -1.70603, -1.67825, -1.64305, -1.5811, -1.51808, -1.43529, -1.40314, -1.32414, -1.28019, -1.10726, -0.84809, -0.62415, -0.40638, -0.34075, -0.17968, -0.00719, 0.07032, 0.36458, 0.74537, 1.34092, 1.89395, 2.06573, 2.41984, 2.5848, 3.0866, 3.5753, 4.20582, 4.67344, 5.13449, 6.1848}, {-1.62838, -1.59738, -1.57695, -1.55016, -1.50114, -1.44942, -1.37929, -1.35153, -1.28225, -1.24313, -1.08608, -0.84369, -0.62944, -0.41794, -0.3537, -0.19517, -0.02421, 0.05297, 0.34772, 0.73257, 1.34047, 1.90992, 2.08758, 2.45482, 2.62631, 3.14944, 3.66073, 4.32263, 4.81492, 5.3013, 6.41249}, {-1.51752, -1.49673, -1.48216, -1.46232, -1.42439, -1.38267, -1.32412, -1.30042, -1.24028, -1.20578, -1.06413, -0.83841, -0.634, -0.42899, -0.3662, -0.2104, -0.04116, 0.0356, 0.33054, 0.71915, 1.33904, 1.92472, 2.10823, 2.48855, 2.66657, 3.21103, 3.74497, 4.43839, 4.95549, 5.46735, 6.6398}, {-1.41753, -1.40413, -1.39408, -1.37981, -1.35114, -1.31815, -1.26999, -1.25004, -1.19842, -1.16827, -1.04144, -0.83223, -0.63779, -0.43949, -0.37824, -0.22535, -0.05803, 0.01824, 0.31307, 0.70512, 1.33665, 1.93836, 2.12768, 2.52102, 2.70556, 3.27134, 3.82798, 4.55304, 5.09505, 5.63252, 6.86661}, {-1.32774, -1.31944, -1.31275, -1.30279, -1.28167, -1.25611, -1.21716, -1.20059, -1.15682, -1.13075, -1.0181, -0.82516, -0.6408, -0.44942, -0.38977, -0.23996, -0.07476, 9.2E-4, 0.29535, 0.6905, 1.3333, 1.95083, 2.14591, 2.55222, 2.74325, 3.33035, 3.90973, 4.66651, 5.23353, 5.79673, 7.09277}, {-1.24728, -1.24235, -1.23805, -1.23132, -1.21618, -1.1968, -1.16584, -1.15229, -1.11566, -1.09338, -0.99418, -0.8172, -0.643, -0.45873, -0.40075, -0.25422, -0.09132, -0.01631, 0.2774, 0.67532, 1.329, 1.96213, 2.16293, 2.58214, 2.77964, 3.38804, 3.99016, 4.77875, 5.37087, 5.9599, 7.31818}, {-1.1752, -1.1724, -1.16974, -1.16534, -1.15477, -1.14042, -1.11628, -1.10537, -1.07513, -1.05631, -0.96977, -0.80837, -0.64436, -0.46739, -0.41116, -0.26808, -0.10769, -0.03344, 0.25925, 0.65959, 1.32376, 1.97227, 2.17873, 2.61076, 2.81472, 3.44438, 4.06926, 4.88971, 5.50701, 6.12196, 7.54272}, {-1.11054, -1.10901, -1.10743, -1.10465, -1.09749, -1.08711, -1.06864, -1.06001, -1.03543, -1.01973, -0.94496, -0.79868, -0.64488, -0.47538, -0.42095, -0.2815, -0.12381, -0.0504, 0.24094, 0.64335, 1.3176, 1.98124, 2.19332, 2.6381, 2.84848, 3.49935, 4.147, 4.99937, 5.6419, 6.28285, 7.76632}, {-1.05239, -1.05159, -1.05068, -1.04898, -1.04427, -1.03695, -1.02311, -1.0164, -0.99672, -0.98381, -0.91988, -0.78816, -0.64453, -0.48265, -0.43008, -0.29443, -0.13964, -0.06718, 0.2225, 0.62662, 1.31054, 1.98906, 2.2067, 2.66413, 2.88091, 3.55295, 4.22336, 5.10768, 5.77549, 6.44251, 7.98888}, {-0.9999, -0.9995, -0.999, -0.998, -0.99499, -0.98995, -0.9798, -0.97468, -0.95918, -0.94871, -0.89464, -0.77686, -0.64333, -0.48917, -0.43854, -0.30685, -0.15516, -0.08371, 0.20397, 0.60944, 1.30259, 1.99573, 2.21888, 2.68888, 2.91202, 3.60517, 4.29832, 5.21461, 5.90776, 6.6009, 8.21034}, {-0.95234, -0.95215, -0.95188, -0.95131, -0.94945, -0.94607, -0.93878, -0.93495, -0.92295, -0.91458, -0.86938, -0.76482, -0.64125, -0.49494, -0.44628, -0.31872, -0.1703, -0.09997, 0.1854, 0.59183, 1.29377, 2.00128, 2.22986, 2.71234, 2.94181, 3.656, 4.37186, 5.32014, 6.03865, 6.75798, 8.43064}, {-0.90908, -0.90899, -0.90885, -0.90854, -0.90742, -0.90521, -0.90009, -0.89728, -0.88814, -0.88156, -0.84422, -0.75211, -0.63833, -0.49991, -0.45329, -0.32999, -0.18504, -0.1159, 0.16682, 0.57383, 1.28412, 2.0057, 2.23967, 2.73451, 2.97028, 3.70543, 4.44398, 5.42426, 6.16816, 6.9137, 8.64971}, {-0.86956, -0.86952, -0.86945, -0.86929, -0.86863, -0.86723, -0.86371, -0.86169, -0.85486, -0.84976, -0.81929, -0.7388, -0.63456, -0.50409, -0.45953, -0.34063, -0.19933, -0.13148, 0.14827, 0.55549, 1.27365, 2.00903, 2.24831, 2.75541, 2.99744, 3.75347, 4.51467, 5.52694, 6.29626, 7.06804, 8.86753}, {-0.83333, -0.83331, -0.83328, -0.8332, -0.83283, -0.83196, -0.82959, -0.82817, -0.82315, -0.81927, -0.79472, -0.72495, -0.62999, -0.50744, -0.46499, -0.35062, -0.21313, -0.14665, 0.12979, 0.53683, 1.2624, 2.01128, 2.25581, 2.77506, 3.0233, 3.80013, 4.58393, 5.62818, 6.42292, 7.77098, 9.08403}, {-0.8, -0.79999, -0.79998, -0.79994, -0.79973, -0.79921, -0.79765, -0.79667, -0.79306, -0.79015, -0.77062, -0.71067, -0.62463, -0.50999, -0.46966, -0.35992, -0.22642, -0.16138, 0.11143, 0.51789, 1.25039, 2.01247, 2.26217, 2.79345, 3.04787, 3.8454, 4.65176, 5.72796, 6.54814, 7.3725, 9.2992}, {-0.76923, -0.76923, -0.76922, -0.7692, -0.76909, -0.76878, -0.76779, -0.76712, -0.76456, -0.76242, -0.74709, -0.69602, -0.61854, -0.51171, -0.47353, -0.36852, -0.23915, -0.17564, 0.09323, 0.49872, 1.23766, 2.01263, 2.26743, 2.81062, 3.07116, 3.8893, 4.71815, 5.82629, 6.67191, 7.52258, 9.51301}, {-0.74074, -0.74074, -0.74074, -0.74073, -0.74067, -0.74049, -0.73987, -0.73943, -0.73765, -0.7361, -0.72422, -0.68111, -0.61176, -0.51263, -0.4766, -0.3764, -0.25129, -0.18939, 0.07523, 0.47934, 1.22422, 2.01177, 2.2716, 2.82658, 3.0932, 3.93183, 4.78313, 5.92316, 6.79421, 7.67121, 9.72543}, {-0.71429, -0.71429, -0.71428, -0.71428, -0.71425, -0.71415, -0.71377, -0.71348, -0.71227, -0.71116, -0.70209, -0.66603, -0.60434, -0.51276, -0.47888, -0.38353, -0.26282, -0.20259, 0.05746, 0.4598, 1.21013, 2.00992, 2.2747, 2.84134, 3.11399, 3.97301, 4.84669, 6.01858, 6.91505, 7.81839, 9.93643}, {-0.68966, -0.68966, -0.68965, -0.68965, -0.68964, -0.68959, -0.68935, -0.68917, -0.68836, -0.68759, -0.68075, -0.65086, -0.59634, -0.51212, -0.48037, -0.38991, -0.27372, -0.21523, 0.03997, 0.44015, 1.19539, 2.0071, 2.27676, 2.85492, 3.13356, 4.01286, 4.90884, 6.11254, 7.03443, 7.96411, 10.14602}, {-0.66667, -0.66667, -0.66667, -0.66667, -0.66666, -0.66663, -0.66649, -0.66638, -0.66585, -0.66532, -0.66023, -0.63569, -0.58783, -0.51073, -0.48109, -0.39554, -0.28395, -0.22726, 0.02279, 0.4204, 1.18006, 2.00335, 2.2778, 2.86735, 3.15193, 4.05138, 4.96959, 6.20506, 7.15235, 8.10836, 10.35418}};
    }
}

