/*
 * Decompiled with CFR 0.152.
 */
package hec.lang;

import hec.heclib.util.Heclib;
import rma.util.RMAIO;

public class TimeStep {
    public static final String[] TIME_STEP_STRINGS = new String[]{"5 Minutes", "10 Minutes", "15 Minutes", "20 Minutes", "30 Minutes", "1 Hour", "2 Hours", "3 Hours", "4 Hours", "6 Hours", "12 Hours", "1 Day", "1 Month"};

    public static int getTimeStep(String timeString) {
        if (timeString == null) {
            return -1;
        }
        int index = timeString.indexOf(" ");
        if (index < 0 && (index = TimeStep.intervalNameBegin(timeString)) < 0) {
            return -1;
        }
        return RMAIO.parseInt(timeString.substring(0, index).trim());
    }

    private static int intervalNameBegin(String timeString) {
        for (int i = 0; i < timeString.length(); ++i) {
            if (!Character.isLetter(timeString.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static int getTimeIncrement(String timeString) {
        if (timeString == null) {
            return -1;
        }
        int index = timeString.indexOf(" ");
        if (index < 0 && (index = TimeStep.intervalNameBegin(timeString)) < 0) {
            return -1;
        }
        String increment = timeString.substring(index).trim().toUpperCase();
        if (increment.indexOf("HOUR") != -1) {
            return 2;
        }
        if (increment.indexOf("DAY") != -1) {
            return 3;
        }
        if (increment.indexOf("MIN") != -1) {
            return 1;
        }
        if (increment.indexOf("SEC") != -1) {
            return 0;
        }
        if (increment.indexOf("MON") != -1) {
            return -1;
        }
        return -1;
    }

    public static String getTimeStepString(int timeStep, int timeInc) {
        Object timeString = "Undef";
        switch (timeInc) {
            case 3: {
                timeString = timeStep + " Day";
                break;
            }
            case 1: {
                timeString = timeStep + " Minute";
                break;
            }
            case 2: {
                timeString = timeStep + " Hour";
                break;
            }
            case 0: {
                timeString = timeStep + " Second";
                break;
            }
            default: {
                return "Invalid Time Increment";
            }
        }
        if (timeStep > 1) {
            timeString = (String)timeString + "s";
        }
        return timeString;
    }

    public static String getDssIntervalString(int timeStep, int timeInc) {
        Object timeString = "Undef";
        switch (timeInc) {
            case 3: {
                timeString = timeStep + "DAY";
                break;
            }
            case 1: {
                timeString = timeStep + "MIN";
                break;
            }
            case 2: {
                timeString = timeStep + "HOUR";
                break;
            }
            case 0: {
                timeString = timeStep + "SEC";
                break;
            }
            default: {
                return "Invalid Time Increment";
            }
        }
        return timeString;
    }

    public static String getEPartFromIntervalMinutes(int intervalMinutes) {
        int[] status = new int[]{0};
        String ePart = Heclib.getEPartFromInterval(intervalMinutes, status);
        return ePart;
    }

    public static int getTimeStepMinutes(int timeStep, int incrementType) {
        if (timeStep < 0) {
            return timeStep;
        }
        if (incrementType == 3) {
            return timeStep * 1440;
        }
        if (incrementType == 2) {
            return timeStep * 60;
        }
        if (incrementType == 1) {
            return timeStep;
        }
        if (incrementType == 0) {
            return timeStep / 60;
        }
        return timeStep;
    }

    public static int getTimeStepMinutes(String timeString) {
        int ts = TimeStep.getTimeStep(timeString);
        int increment = TimeStep.getTimeIncrement(timeString);
        return TimeStep.getTimeStepMinutes(ts, increment);
    }

    public static void main(String[] args) {
        String str = "1HOUR";
        int timestep = TimeStep.getTimeStep(str);
        int incr = TimeStep.getTimeIncrement(str);
        str = "1 HOUR";
        timestep = TimeStep.getTimeStep(str);
        incr = TimeStep.getTimeIncrement(str);
    }
}

