/*
 * Decompiled with CFR 0.152.
 */
package hec.lang;

import com.google.common.flogger.FluentLogger;
import com.google.common.flogger.StackSize;
import hec.lang.UserIdKey;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

public final class UserId {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private static volatile UserId _userIdObj = null;
    private final Map<String, UserIdKey> _appMap = new Hashtable<String, UserIdKey>();
    private final UserIdKey _userIdKey = new UserIdKey();

    private UserId() {
    }

    private UserIdKey getUserIdKey() {
        return this._userIdKey;
    }

    public static UserId buildUserId() {
        ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atFinest()).withStackTrace(StackSize.FULL)).log("Tracing buildUserId()");
        if (_userIdObj == null) {
            _userIdObj = new UserId();
        }
        return _userIdObj;
    }

    public static void removeUserId(String userId, String app) {
        ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atFinest()).withStackTrace(StackSize.FULL)).log("Tracing removeUserId(userId,app)");
        if (app == null || app.isEmpty() || userId == null || userId.isEmpty()) {
            return;
        }
        UserId userIdObj = UserId.getUserIDObj();
        if (userIdObj == null) {
            return;
        }
        UserIdKey idKey = userIdObj._appMap.get(app);
        if (idKey == null) {
            return;
        }
        if (userId.equals(idKey.getUserId())) {
            userIdObj._appMap.remove(app);
        }
    }

    public static void setUserId(String userId, long key, String app) {
        ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atFinest()).withStackTrace(StackSize.FULL)).log("Tracing setUserId(userId,key,app)");
        if (app == null || app.isEmpty()) {
            UserId.setUserId(userId, key);
            return;
        }
        UserId userIdObj = UserId.getUserIDObj();
        if (userIdObj == null) {
            UserId.setUserId(userId, key);
        } else {
            ((FluentLogger.Api)LOGGER.atFine()).log("setUserId: Setting user=" + userId + " key=" + (key >> 16) + " for app " + app);
            userIdObj._appMap.put(app, new UserIdKey(userId, key));
        }
    }

    public static void setUserId(String userId, long key) {
        ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atFinest()).withStackTrace(StackSize.FULL)).log("Tracing setUserId(userId,key)");
        UserId userIdObj = UserId.getUserIDObj();
        ((FluentLogger.Api)LOGGER.atFine()).log("setUserId: Setting main user=" + userId + " key=" + (key >> 16));
        Objects.requireNonNull(userIdObj, "UserIdObj is null, it must first be created before setting a user id and key");
        if (userIdObj.getUserIdKey().getUserId() == null || userIdObj.getUserIdKey().getKey() == -1L) {
            userIdObj.getUserIdKey().setUserId(userId);
            userIdObj.getUserIdKey().setKey(key);
        }
    }

    public static String getUserId(String app) {
        ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atFinest()).withStackTrace(StackSize.FULL)).log("Tracing getUserId(app,returnUserDotNameOnServer)");
        if (app == null || app.isEmpty()) {
            return UserId.getUserId();
        }
        UserId userIdObj = UserId.getUserIDObj();
        if (userIdObj == null) {
            return UserId.getUserId();
        }
        ((FluentLogger.Api)LOGGER.atFine()).log("getUserId: looking for userId for " + app);
        UserIdKey idKey = userIdObj._appMap.get(app);
        if (idKey == null) {
            return UserId.getUserId();
        }
        ((FluentLogger.Api)LOGGER.atFine()).log("getUserId: return " + idKey.getUserId() + " for " + app);
        return idKey.getUserId();
    }

    public static String getUserId() {
        ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atFinest()).withStackTrace(StackSize.FULL)).log("Tracing getUserId()");
        UserId userIdObj = UserId.getUserIDObj();
        if (userIdObj == null) {
            ((FluentLogger.Api)LOGGER.atFine()).log("getUserId: no UserID Object! returning user.name");
            return System.getProperty("user.name");
        }
        String userId = userIdObj.getUserIdKey().getUserId();
        if (userId != null) {
            ((FluentLogger.Api)LOGGER.atFine()).log("getUserId: returning " + userId);
            return userId;
        }
        ((FluentLogger.Api)LOGGER.atFine()).log("getUserId: No userId. Returning user.name");
        return System.getProperty("user.name");
    }

    public static UserId getUserIDObj() {
        return _userIdObj;
    }

    public static long getUserKey() {
        UserId userIdObj = UserId.getUserIDObj();
        if (userIdObj == null) {
            return -1L;
        }
        long userKey = userIdObj.getUserIdKey().getKey();
        if (userKey != -1L) {
            return userKey;
        }
        return -1L;
    }

    public static Map getUserIdMap() {
        if (_userIdObj != null) {
            return Collections.unmodifiableMap(UserId._userIdObj._appMap);
        }
        return null;
    }
}

