/*
 * Decompiled with CFR 0.152.
 */
package hec.lang;

import java.util.HashMap;
import java.util.Map;

public class WorkspaceNameFactory {
    private static Map _standardModels = new HashMap();

    public static String getWorkspaceName(String model) {
        return WorkspaceNameFactory.getWorkspaceName(model, false);
    }

    public static String getWorkspaceName(String model, boolean returnStdModelsOnly) {
        if (model == null || model.equals("")) {
            return "main";
        }
        String modelUpper = model.toUpperCase();
        String wkspName = (String)_standardModels.get(modelUpper);
        if (wkspName != null) {
            return wkspName;
        }
        if (returnStdModelsOnly) {
            return null;
        }
        return model;
    }

    public static void addStandardModel(String model, String wkspName) {
        if (model == null || wkspName == null) {
            return;
        }
        _standardModels.put(model.toUpperCase(), wkspName);
    }

    static {
        WorkspaceNameFactory.addStandardModel("RSS", "rss");
        WorkspaceNameFactory.addStandardModel("RES", "rss");
        WorkspaceNameFactory.addStandardModel("ResSim", "rss");
        WorkspaceNameFactory.addStandardModel("HMS", "hfp");
        WorkspaceNameFactory.addStandardModel("HMS/HFP", "hfp");
        WorkspaceNameFactory.addStandardModel("HFP", "hfp");
        WorkspaceNameFactory.addStandardModel("RAS", "ras");
        WorkspaceNameFactory.addStandardModel("CAVI", "cavi");
        WorkspaceNameFactory.addStandardModel("FDA", "fda");
        WorkspaceNameFactory.addStandardModel("FIA", "fia");
        WorkspaceNameFactory.addStandardModel("gridUtil", "gridUtil");
        WorkspaceNameFactory.addStandardModel("MFP", "mfp");
        WorkspaceNameFactory.addStandardModel("SIA", "sia");
        WorkspaceNameFactory.addStandardModel("supmod", "supplemental");
        WorkspaceNameFactory.addStandardModel("supplemental", "supplemental");
        WorkspaceNameFactory.addStandardModel("dssmapgui", "dssmapgui");
        WorkspaceNameFactory.addStandardModel("resprm", "resprm");
        WorkspaceNameFactory.addStandardModel("rma", "rma");
        WorkspaceNameFactory.addStandardModel("rma2", "rma");
        WorkspaceNameFactory.addStandardModel("rma11", "rma");
        WorkspaceNameFactory.addStandardModel("hec5q", "hec5q");
    }
}

