/*
 * Decompiled with CFR 0.152.
 */
package hec.lang.annotation;

import hec.lang.annotation.EntityBean;
import hec.lang.annotation.EntityBeanAdapterException;
import hec.lang.annotation.EntityBeanMap;
import hec.lang.annotation.EntityBeanType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EntityBeanAdapter<T1, T2> {
    private static final Logger logger = Logger.getLogger(EntityBeanAdapter.class.getName());
    private Class<T1> _entityClass;
    private Class<T2> _beanClass;
    private String _domain;

    public EntityBeanAdapter(String domain, Class<T1> entityClass, Class<T2> beanClass) {
        this._domain = domain;
        this._entityClass = entityClass;
        this._beanClass = beanClass;
    }

    public T2 entityToBean(T1 entityInstance) throws EntityBeanAdapterException {
        T2 retval = null;
        if (entityInstance == null) {
            return retval;
        }
        Class<?> entityInstanceClass = entityInstance.getClass();
        if (entityInstanceClass == null) {
            throw new EntityBeanAdapterException("entityInstanceClass is null");
        }
        EntityBeanType entityBeanTypeAnnotation = entityInstanceClass.getAnnotation(EntityBeanType.class);
        if (entityBeanTypeAnnotation == null) {
            logger.warning(String.format("Class %s does not have %s annotation. Nothing to map in entityToBean.", entityInstanceClass.getName(), EntityBeanType.class.getName()));
        } else {
            String beanType = entityBeanTypeAnnotation.beanType();
            try {
                Class<?> beanTypeClass = Class.forName(beanType);
                if (!beanTypeClass.equals(this._beanClass)) {
                    throw new EntityBeanAdapterException("Entity annotated class, " + beanType + " does not map to Bean class, " + this._beanClass.getName() + ".");
                }
                T2 beanInstance = this._beanClass.newInstance();
                retval = this.entity2Bean(entityInstanceClass, entityInstance, beanInstance);
            }
            catch (ClassNotFoundException e) {
                throw new EntityBeanAdapterException(e);
            }
            catch (InstantiationException e) {
                throw new EntityBeanAdapterException(e);
            }
            catch (IllegalAccessException e) {
                throw new EntityBeanAdapterException(e);
            }
        }
        return retval;
    }

    public T1 beanToEntity(T2 beanInstance) throws EntityBeanAdapterException {
        T1 entityInstance = null;
        if (beanInstance == null) {
            return entityInstance;
        }
        try {
            entityInstance = this._entityClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new EntityBeanAdapterException(e);
        }
        catch (IllegalAccessException e) {
            throw new EntityBeanAdapterException(e);
        }
        return this.bean2Entity(this._entityClass, entityInstance, beanInstance);
    }

    private T1 bean2Entity(Class entityInstanceClass, T1 entityInstance, T2 beanInstance) throws EntityBeanAdapterException {
        String classname = entityInstanceClass.getName();
        logger.log(Level.FINEST, String.format("bean2Entity: mapping bean %s to entity instance %s class %s", beanInstance.getClass().getName(), entityInstance.getClass().getName(), classname.substring(classname.lastIndexOf(46) + 1)));
        Method[] allMethods = this._entityClass.getMethods();
        Collection<Method> entityMethods = EntityBeanAdapter.skipCovariant(Arrays.asList(allMethods));
        int diff = Math.abs(allMethods.length - entityMethods.size());
        if (diff != 0) {
            StringBuilder message = new StringBuilder();
            String superDetailed = "  In other words the class Overrides a method signature with an implementation that returns a more specific return type.   The entity class getMethods() call returns the more-general overriden method signature AND the more-specific method signature.  EntityBeanAdapter fully handles this situation by skipping the more general signatures.  ";
            message.append(String.format("bean2Entity: This is an informational message that the entity class %s was detected to have one or more methods with covariant return types.The following %d methods appear to be the less specific instances of methods with covariant return types:\n", this._entityClass.getName(), diff));
            HashSet<Method> skipped = new HashSet<Method>(Arrays.asList(allMethods));
            skipped.removeAll(Arrays.asList(entityMethods));
            for (Method skippedMethod : skipped) {
                message.append('\t');
                message.append(skippedMethod.toGenericString());
                message.append('\n');
            }
            logger.fine(message.toString());
        }
        for (Method entityMethod : entityMethods) {
            try {
                this.entityGetter2Setter(this._entityClass, entityMethod, entityInstance, beanInstance);
            }
            catch (SecurityException e) {
                throw new EntityBeanAdapterException(e);
            }
            catch (IllegalArgumentException e) {
                throw new EntityBeanAdapterException(e);
            }
            catch (NoSuchMethodException e) {
                throw new EntityBeanAdapterException(e);
            }
            catch (IllegalAccessException e) {
                throw new EntityBeanAdapterException(e);
            }
            catch (InvocationTargetException e) {
                throw new EntityBeanAdapterException(e);
            }
        }
        Class superclass = entityInstanceClass.getSuperclass();
        EntityBeanType superEntityBeanType = superclass.getAnnotation(EntityBeanType.class);
        if (superEntityBeanType != null) {
            String beanType = superEntityBeanType.beanType();
            if (beanType.equals(beanInstance.getClass().getName())) {
                String classname1 = entityInstanceClass.getName();
                logger.log(Level.FINE, String.format("bean2Entity: %s has superclass %s annotated to %s which equals current beanInstance %s", classname1.substring(classname1.lastIndexOf(46) + 1), superclass.getName(), beanType.substring(beanType.lastIndexOf(46) + 1), beanInstance.getClass().getName()));
                this.bean2Entity(superclass, entityInstance, beanInstance);
            } else {
                EntityBeanType entityEntityBeanType = entityInstance.getClass().getAnnotation(EntityBeanType.class);
                String entityEntityBeanTypeBeanType = entityEntityBeanType.beanType();
                String entityClassName = entityInstanceClass.getName();
                logger.log(Level.FINE, String.format("bean2Entity: %s has superclass %s annotated to %s which differs from current beanInstance %s annotated to %s", entityClassName.substring(entityClassName.lastIndexOf(46) + 1), superclass.getName(), beanType.substring(beanType.lastIndexOf(46) + 1), beanInstance.getClass().getName(), entityEntityBeanTypeBeanType.substring(entityEntityBeanTypeBeanType.lastIndexOf(46) + 1)));
                logger.log(Level.FINE, "bean2Entity:Not recursively ascending into superclass because the annotation type was different.");
            }
        }
        return entityInstance;
    }

    private T2 entity2Bean(Class<? extends Object> entityInstanceClass, T1 entityInstance, T2 beanInstance) throws EntityBeanAdapterException {
        Method[] declaredMethods;
        String classname = entityInstanceClass.getName();
        logger.log(Level.FINEST, String.format("entity2Bean: mapping class %s entity %s to bean %s. ", classname.substring(classname.lastIndexOf(46) + 1), entityInstance.getClass().getName(), beanInstance.getClass().getName()));
        for (Method declaredMethod : declaredMethods = entityInstanceClass.getDeclaredMethods()) {
            try {
                this.entityMethod2Bean(declaredMethod, entityInstance, beanInstance);
            }
            catch (IllegalArgumentException e) {
                throw new EntityBeanAdapterException(e);
            }
            catch (SecurityException e) {
                throw new EntityBeanAdapterException(e);
            }
            catch (NoSuchMethodException e) {
                throw new EntityBeanAdapterException(e);
            }
            catch (InvocationTargetException e) {
                throw new EntityBeanAdapterException(e);
            }
            catch (IllegalAccessException e) {
                throw new EntityBeanAdapterException(e);
            }
            catch (ClassNotFoundException e) {
                throw new EntityBeanAdapterException(e);
            }
            catch (InstantiationException e) {
                throw new EntityBeanAdapterException(e);
            }
        }
        Class<? extends Object> superclass = entityInstanceClass.getSuperclass();
        EntityBeanType superEntityBeanType = superclass.getAnnotation(EntityBeanType.class);
        if (superEntityBeanType != null) {
            String beanType = superEntityBeanType.beanType();
            if (beanType.equals(beanInstance.getClass().getName())) {
                String entityClassname = entityInstanceClass.getName();
                logger.log(Level.FINER, String.format("entty2Bean: %s has superclass %s annotated to %s which equals current beanInstance %s", entityClassname.substring(entityClassname.lastIndexOf(46) + 1), superclass.getName(), beanType.substring(beanType.lastIndexOf(46) + 1), beanInstance.getClass().getName()));
                this.entity2Bean(superclass, entityInstance, beanInstance);
            } else {
                EntityBeanType entityEntityBeanType = entityInstance.getClass().getAnnotation(EntityBeanType.class);
                String entityEntityBeanTypeBeanType = entityEntityBeanType.beanType();
                String entityClassname = entityInstanceClass.getName();
                logger.log(Level.FINER, String.format("entity2Bean: %s has superclass %s annotated to %s which differs from current beanInstance %s annotated to %s, not ascending to supertype.", entityClassname.substring(entityClassname.lastIndexOf(46) + 1), superclass.getName(), beanType.substring(beanType.lastIndexOf(46) + 1), beanInstance.getClass().getName(), entityEntityBeanTypeBeanType.substring(entityEntityBeanTypeBeanType.lastIndexOf(46) + 1)));
            }
        }
        return beanInstance;
    }

    private void entityGetter2Setter(Class entityClass, Method entityMethod, T1 entityInstance, T2 beanInstance) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, EntityBeanAdapterException {
        Class<?> methodDeclaringClass = entityMethod.getDeclaringClass();
        if (methodDeclaringClass.equals(entityInstance.getClass())) {
            EntityBean beanAnnotation = entityMethod.getAnnotation(EntityBean.class);
            EntityBeanMap beanMapAnnotation = entityMethod.getAnnotation(EntityBeanMap.class);
            if (beanAnnotation == null && beanMapAnnotation == null) {
                logger.log(Level.FINEST, "entityGetter2Setter:no annotation on " + entityInstance.getClass().getName() + "." + entityMethod.getName());
            } else {
                String entityAttributeName = entityMethod.getName().substring(3);
                String entitySetterMethodName = this.buildMethodName(entityAttributeName, "set");
                if (beanAnnotation != null) {
                    String beanAttributeName = beanAnnotation.attributeName();
                    String classname = entityInstance.getClass().getAnnotation(EntityBeanType.class).beanType();
                    logger.log(Level.FINEST, String.format("entityGetter2Setter:%s.%s annotated to %s:%s", entityInstance.getClass().getName(), entityMethod.getName(), classname.substring(classname.lastIndexOf(46) + 1), beanAttributeName));
                    Method beanValueGetMethod = this.getBeanGetterMethod(beanAttributeName);
                    Object beanValue = beanValueGetMethod.invoke(beanInstance, (Object[])null);
                    if (beanValue != null) {
                        Method entitySetMethod;
                        T1 innerEntityInstance;
                        block10: {
                            Class<?> beanValueClass = beanValue.getClass();
                            Class<?> innerEntityClass = entityMethod.getReturnType();
                            EntityBeanAdapter beanAdapter = this.getInstance(this._domain, innerEntityClass, beanValueClass);
                            innerEntityInstance = beanAdapter.beanToEntity(beanValue);
                            Class<?> parameterTypes = innerEntityClass;
                            entitySetMethod = null;
                            try {
                                entitySetMethod = entityClass.getMethod(entitySetterMethodName, parameterTypes);
                            }
                            catch (NoSuchMethodException e) {
                                entitySetMethod = EntityBeanAdapter.getMethodCheckInterfaces(entityClass, entitySetterMethodName, innerEntityClass);
                                if (entitySetMethod != null) break block10;
                                throw new EntityBeanAdapterException(e);
                            }
                        }
                        entitySetMethod.invoke(entityInstance, innerEntityInstance);
                    } else {
                        logger.finer(String.format("beanValueGetMethod method %s.%s returned null, not calling entity set method.", entityInstance.getClass().getName(), beanValueGetMethod.getName()));
                    }
                } else if (beanMapAnnotation != null) {
                    String beanAttributeName = beanMapAnnotation.attributeName();
                    Method beanValueGetMethod = this.getBeanGetterMethod(beanAttributeName);
                    Object beanValue = beanValueGetMethod.invoke(beanInstance, (Object[])null);
                    Class<?> beanType = beanValueGetMethod.getReturnType();
                    this.callEntitySetterMethod(entityInstance, entityAttributeName, beanValue, beanType);
                }
            }
        }
    }

    protected void callEntitySetterMethod(T1 entityInstance, String entityAttributeName, Object beanValue, Class<?> beanType) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String entitySetterMethodName = this.buildMethodName(entityAttributeName, "set");
        Method entitySetMethod = this._entityClass.getMethod(entitySetterMethodName, beanType);
        if (beanValue == null) {
            entitySetMethod.invoke(entityInstance, beanValue);
        } else {
            entitySetMethod.invoke(entityInstance, beanValue);
        }
    }

    protected EntityBeanAdapter getInstance(String domain, Class<?> innerEntityClass, Class<? extends Object> beanValueClass) {
        return new EntityBeanAdapter(domain, innerEntityClass, beanValueClass);
    }

    private static Method getMethodCheckInterfaces(Class entityClass, String entitySetterMethodName, Class innerEntityClass) {
        Method[] methods;
        Method retval = null;
        for (Method method : methods = entityClass.getMethods()) {
            Class<?>[] interfaces;
            Class<?> firstParam;
            if (!method.getName().equals(entitySetterMethodName) || !(firstParam = method.getParameterTypes()[0]).isInterface()) continue;
            for (Class<?> iface : interfaces = innerEntityClass.getInterfaces()) {
                if (!iface.equals(firstParam)) continue;
                return method;
            }
        }
        return retval;
    }

    protected Method getEntityGetterMethod(String entityGetterMethodName) throws NoSuchMethodException {
        Class<?>[] parameterTypes = null;
        return this._entityClass.getMethod(entityGetterMethodName, parameterTypes);
    }

    private Method getBeanGetterMethod(String beanAttributeName) throws NoSuchMethodException {
        String beanGetterMethodName = this.buildMethodName(beanAttributeName, "get");
        return this._beanClass.getMethod(beanGetterMethodName, null);
    }

    protected Method getBeanMethod(Object parameterValue, Class parameterClass, String attributeName) throws NoSuchMethodException {
        String beanSetMethodName = this.buildMethodName(attributeName, "set");
        Class parameterTypes = parameterClass;
        return this._beanClass.getMethod(beanSetMethodName, parameterTypes);
    }

    protected Class<? extends Object> getBeanAttributeClass(String beanAttributeName) throws NoSuchMethodException {
        Method beanGetterMethod = this.getBeanGetterMethod(beanAttributeName);
        Class<?> returnType = beanGetterMethod.getReturnType();
        return returnType;
    }

    protected void callBeanSetterMethod(Object entityMethodReturnValue, Class<?> entityType, String beanAttributeName, T2 beanInstance) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method beanSetterMethod = this.getBeanMethod(entityMethodReturnValue, entityType, beanAttributeName);
        beanSetterMethod.invoke(beanInstance, entityMethodReturnValue);
    }

    private void entityMethod2Bean(Method entityMethod, T1 entityInstance, T2 beanInstance) throws IllegalAccessException, InvocationTargetException, ClassNotFoundException, EntityBeanAdapterException, InstantiationException, NoSuchMethodException {
        EntityBean beanAnnotation = entityMethod.getAnnotation(EntityBean.class);
        EntityBeanMap beanMapAnnotation = entityMethod.getAnnotation(EntityBeanMap.class);
        if (beanAnnotation == null && beanMapAnnotation == null) {
            logger.log(Level.FINEST, String.format("entityMethod2Bean: no annotation on %s.%s", entityInstance.getClass().getName(), entityMethod.getName()));
        } else if (beanAnnotation != null) {
            String classname = entityInstance.getClass().getAnnotation(EntityBeanType.class).beanType();
            logger.log(Level.FINEST, String.format("entityGetter2Setter:%s.%s annotated to %s.%s", entityInstance.getClass().getName(), entityMethod.getName(), classname.substring(classname.lastIndexOf(46) + 1), beanAnnotation.attributeName()));
            this.setBeanFromAnnotatedEntity(entityMethod, entityInstance, beanInstance, beanAnnotation);
        } else if (beanMapAnnotation != null) {
            String classname = entityInstance.getClass().getAnnotation(EntityBeanType.class).beanType();
            logger.log(Level.FINEST, String.format("entityGetter2Setter:%s.%s mapped to %s.%s", entityInstance.getClass().getName(), entityMethod.getName(), classname.substring(classname.lastIndexOf(46) + 1), beanMapAnnotation.attributeName()));
            this.setBeanFromMapAnnotatedEntity(entityMethod, entityInstance, beanInstance, beanMapAnnotation);
        }
    }

    private void setBeanFromMapAnnotatedEntity(Method entityMethod, T1 entityInstance, T2 beanInstance, EntityBeanMap beanMapAnnotation) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object[] args = new Object[]{};
        Class<?>[] entityMethodParameters = entityMethod.getParameterTypes();
        if (entityMethodParameters.length == 0) {
            Object entityMethodReturnValue = entityMethod.invoke(entityInstance, args);
            if (entityMethodReturnValue != null) {
                String beanAttributeName = beanMapAnnotation.attributeName();
                this.callBeanSetterMethod(entityMethodReturnValue, entityMethod.getReturnType(), beanAttributeName, beanInstance);
            } else {
                logger.finer(String.format("getter method %s.%s returned null, not calling bean set method.", entityInstance.getClass().getName(), entityMethod.getName()));
            }
        }
    }

    private void setBeanFromAnnotatedEntity(Method entityMethod, T1 entityInstance, T2 beanInstance, EntityBean beanAnnotation) throws IllegalAccessException, InvocationTargetException, ClassNotFoundException, EntityBeanAdapterException, InstantiationException, NoSuchMethodException {
        Object[] args = null;
        Object entityMethodReturnValue = entityMethod.invoke(entityInstance, args);
        if (entityMethodReturnValue != null) {
            Class<?> innerEntityClass = entityMethodReturnValue.getClass();
            EntityBeanType annotation = innerEntityClass.getAnnotation(EntityBeanType.class);
            if (annotation != null) {
                String innerBeanType = annotation.beanType();
                Class<?> innerBeanClass = Class.forName(innerBeanType);
                EntityBeanAdapter beanAdapter = this.getInstance(this._domain, innerEntityClass, innerBeanClass);
                T2 innerBeanInstance = beanAdapter.entityToBean(entityMethodReturnValue);
                String beanAttributeName = beanAnnotation.attributeName();
                Method beanSetterMethod = this.getBeanMethod(innerBeanInstance, innerBeanClass, beanAttributeName);
                beanSetterMethod.invoke(beanInstance, innerBeanInstance);
            }
        } else {
            logger.finer(String.format("entity getter method %s.%s returned null, not calling bean setter.", entityInstance.getClass().getName(), entityMethod.getName()));
        }
    }

    protected String buildMethodName(String attributeName, String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(attributeName);
        sb.setCharAt(0, Character.toUpperCase(attributeName.charAt(0)));
        sb.insert(0, prefix);
        String beanMethodName = sb.toString();
        return beanMethodName;
    }

    private static Collection<Method> skipCovariant(Collection<Method> entityMethods) {
        ArrayList<Method> methods = new ArrayList<Method>(entityMethods.size());
        Collection<Method> toSkip = EntityBeanAdapter.getLessSpecificCovarients(entityMethods);
        for (Method method : entityMethods) {
            if (toSkip.contains(method)) continue;
            methods.add(method);
        }
        return methods;
    }

    private static Collection<Method> getLessSpecificCovarients(Collection<Method> allMethods) {
        HashMap<List<Object>, HashSet<Method>> map = new HashMap<List<Object>, HashSet<Method>>();
        for (Method aMethod : allMethods) {
            String name = aMethod.getName();
            List<Class<?>> paramList = Arrays.asList(aMethod.getParameterTypes());
            List<Object> nameAndParams = Arrays.asList(name, paramList);
            HashSet<Method> matchingMethods = (HashSet<Method>)map.get(nameAndParams);
            if (matchingMethods == null) {
                matchingMethods = new HashSet<Method>();
                map.put(nameAndParams, matchingMethods);
            }
            matchingMethods.add(aMethod);
        }
        HashSet<Method> lessSpecificMethods = new HashSet<Method>();
        for (Map.Entry entrySet : map.entrySet()) {
            List key = (List)entrySet.getKey();
            Set methodsWithSameNameAndParams = (Set)entrySet.getValue();
            for (Method method : methodsWithSameNameAndParams) {
                if (EntityBeanAdapter.isMostSpecific(method, methodsWithSameNameAndParams)) continue;
                lessSpecificMethods.add(method);
            }
        }
        return lessSpecificMethods;
    }

    private static boolean isMostSpecific(Method query, Set<Method> alsoMatchingParameters) {
        boolean isMostSpecific = true;
        if (!alsoMatchingParameters.isEmpty()) {
            Class<?> queryReturnType = query.getReturnType();
            Iterator<Method> iterator1 = alsoMatchingParameters.iterator();
            while (isMostSpecific && iterator1.hasNext()) {
                Method method = iterator1.next();
                Class<?> returnType = method.getReturnType();
                isMostSpecific = isMostSpecific && returnType.isAssignableFrom(queryReturnType);
            }
        }
        return isMostSpecific;
    }
}

