/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.LegendItem;
import hec.map.MapScale;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

public abstract class AbstractLegendItem
extends JComponent
implements LegendItem {
    protected static final int BORDER_WIDTH = 2;
    protected int _x;
    protected int _y;
    protected int _width;
    protected int _height;
    protected String _legendTitle = "";
    protected boolean _dirty = true;

    public boolean isDirty() {
        return this._dirty;
    }

    public void setLegendTitle(String title) {
        this._legendTitle = title != null ? title : "";
    }

    @Override
    public Dimension getPreferredSize() {
        return null;
    }

    public String getLegendTitle() {
        return this._legendTitle;
    }

    public void drawBorder(Graphics g2) {
        Color oldColor = g2.getColor();
        g2.setColor(Color.black);
        g2.drawRect(this._x, this._y, this._width - 1, this._height - 1);
        g2.drawRect(this._x + 1, this._y + 1, this._width - 3, this._height - 3);
        g2.setColor(oldColor);
    }

    @Override
    public void setSize(int width, int height) {
        if (this._width == width || this._height == height) {
            return;
        }
        this._width = width;
        this._height = height;
        this._dirty = true;
    }

    @Override
    public void setLocation(int x, int y) {
        this._x = x;
        this._y = y;
    }

    @Override
    public void setBounds(Rectangle r) {
        this._x = r.x;
        this._y = r.y;
        if (this._width == r.width || this._height == r.height) {
            return;
        }
        this._width = r.width;
        this._height = r.height;
        this._dirty = true;
    }

    @Override
    public abstract void draw(Graphics var1, MapScale var2);

    @Override
    public int getHeight() {
        return this._height;
    }

    @Override
    public int getWidth() {
        return this._width;
    }

    @Override
    public LegendItem.LegendLocation getPreferredLocation() {
        return LegendItem.LegendLocation.UpperLeft;
    }
}

