/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.AbstractLegendItem;
import hec.map.MapScale;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Observer;
import rma.util.ColorContour;
import rma.util.contour.ColorContourRecord;

public class ColorContourLegendItem
extends AbstractLegendItem {
    ColorContourRecord _colorContourRecord = null;
    BufferedImage _legendImage = null;
    BufferedImage _contourImage = null;
    double[] _labelVals = null;
    int[] _ticLabelYPos = null;
    int[] _ticLabelXPos = null;
    int _precision = 1;
    double _ticDistance = 1.0;
    Font baseFont;
    FontMetrics fm;
    int colorBarWidth;
    Font boldFont;
    FontMetrics boldFontMetrics;
    int RIGHT_MARGIN = 5;
    int LEFT_MARGIN = 5;
    int TOP_MARGIN = 5;
    int BOTTOM_MARGIN = 5;
    int TITLE_COLORBAR_SPACER = 5;
    int TIC_LABEL_COLORBAR_SPACER = 3;
    int TITLE_WIDTH;
    int MIN_COLOR_BAR_WIDTH = 20;
    DecimalFormat _df = null;

    public void setColorContour(ColorContour cc) {
        this.setColorContour(new CCDataRecord(cc));
    }

    public void setColorContour(ColorContourRecord ccRecord) {
        this._colorContourRecord = ccRecord;
    }

    private void computeMetrics() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics g, MapScale scl) {
        this.baseFont = g.getFont();
        this.fm = g.getFontMetrics(this.baseFont);
        this.boldFont = new Font(this.baseFont.getName(), 1, this.baseFont.getSize());
        this.boldFontMetrics = g.getFontMetrics(this.boldFont);
        this.TITLE_WIDTH = this.boldFontMetrics.getHeight();
        ColorContour colorContor = this._colorContourRecord.getColorContour();
        double maxValue = colorContor.getMaxValue();
        double minValue = colorContor.getMinValue();
        String sMaxValue = this.convertValueToString(maxValue);
        String sMinValue = this.convertValueToString(minValue);
        int maxValueWidth = this.fm.stringWidth(sMaxValue);
        int minValueWidth = this.fm.stringWidth(sMinValue);
        if (minValueWidth > maxValueWidth) {
            maxValueWidth = minValueWidth;
        }
        this.colorBarWidth = this._width - maxValueWidth - this.LEFT_MARGIN - this.RIGHT_MARGIN - this.TITLE_COLORBAR_SPACER - this.TITLE_WIDTH - this.TIC_LABEL_COLORBAR_SPACER;
        if (this.colorBarWidth < this.MIN_COLOR_BAR_WIDTH) {
            this._width += this.MIN_COLOR_BAR_WIDTH - this.colorBarWidth;
            this.colorBarWidth = this.MIN_COLOR_BAR_WIDTH;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            if (this._colorContourRecord == null) {
                return;
            }
            if (this.getWidth() == 0 || this.getHeight() == 0) {
                return;
            }
            if (this.isDirty() || this._legendImage == null) {
                this._legendImage = g2.getDeviceConfiguration().createCompatibleImage(this.getWidth(), this.getHeight());
                Graphics2D imagesGfx = (Graphics2D)this._legendImage.getGraphics();
                imagesGfx.setColor(Color.WHITE);
                imagesGfx.translate(-this._x, -this._y);
                imagesGfx.fillRect(this._x, this._y, this._width - 1, this._height - 1);
                this.updateLabels();
                this.paintContour(imagesGfx);
                this.drawBorder(imagesGfx);
                this._dirty = false;
            }
            g2.drawImage(this._legendImage, this._x, this._y, this._legendImage.getWidth(), this._legendImage.getHeight(), null);
        }
        finally {
            g2.dispose();
        }
    }

    private void paintContour(Graphics g) {
        if (g != null) {
            ColorContour colorContor = this._colorContourRecord.getColorContour();
            double maxValue = colorContor.getMaxValue();
            String sMaxValue = this.convertValueToString(maxValue);
            AffineTransform rotate = AffineTransform.getRotateInstance(4.71238898038469);
            Font ROTATED_FONT = this.boldFont.deriveFont(rotate);
            String title = this.getLegendTitle();
            int TITLE_LENGTH = this.boldFontMetrics.stringWidth(title);
            g.setFont(ROTATED_FONT);
            int TITLE_Y_LOCATION = this._y + this._height / 2 + TITLE_LENGTH / 2;
            int TITLE_X_LOCATION = this._x + this.LEFT_MARGIN + this.boldFontMetrics.getAscent();
            g.setColor(Color.black);
            g.drawString(title, TITLE_X_LOCATION, TITLE_Y_LOCATION);
            g.setFont(this.baseFont);
            int maxValueHeight = this.fm.getHeight();
            int colorBarYLocation = this._y + maxValueHeight / 2 + this.TOP_MARGIN;
            int colorBarXLocation = this._x + this.RIGHT_MARGIN + this.TITLE_WIDTH + this.TITLE_COLORBAR_SPACER;
            int maxValueWidth = this.fm.stringWidth(sMaxValue);
            int colorBarHeight = this._height - this.fm.getHeight() - this.TOP_MARGIN - this.BOTTOM_MARGIN;
            if (this.colorBarWidth < 0) {
                this.colorBarWidth = 0;
            }
            this.paintScale(this.colorBarWidth, colorBarHeight);
            int offset = 0;
            int numLabels = this._labelVals != null ? this._labelVals.length : 0;
            for (int zz = 0; zz < numLabels; ++zz) {
                String val = this.convertValueToString(this._labelVals[zz]);
                int w = this.fm.stringWidth(val);
                if (w <= maxValueWidth) continue;
                offset = w - maxValueWidth;
                maxValueWidth = w;
            }
            if (this._contourImage != null) {
                Composite oldac = null;
                if (g instanceof Graphics2D) {
                    Graphics2D g2 = (Graphics2D)g;
                    oldac = g2.getComposite();
                    AlphaComposite ac = AlphaComposite.getInstance(3, this._colorContourRecord.getAlpha());
                    g2.setComposite(ac);
                    g2.drawImage(this._contourImage, colorBarXLocation - offset, colorBarYLocation, this.colorBarWidth, colorBarHeight, this);
                    if (oldac != null) {
                        g2.setComposite(oldac);
                    }
                }
            }
            AffineTransform oldTx = ((Graphics2D)g).getTransform();
            Graphics g2d = g.create();
            g2d.setFont(this.baseFont);
            int fontHeight = this.fm.getHeight();
            int fontAscent = this.fm.getAscent();
            if (this._labelVals != null) {
                g.setColor(Color.black);
                for (int ii = 0; ii < this._labelVals.length; ++ii) {
                    if (this._ticLabelYPos[ii] == Integer.MIN_VALUE) continue;
                    String val = "";
                    val = this.convertValueToString(this._labelVals[ii]);
                    int stringWidth = this.fm.stringWidth(val);
                    int x = this._width - stringWidth - this.RIGHT_MARGIN;
                    if (x < 0) {
                        x = 0;
                    }
                    if (this._ticLabelYPos[ii] - fontHeight > 0) {
                        g.drawString(val, this._x + x, colorBarYLocation + this._ticLabelYPos[ii] - 1);
                        continue;
                    }
                    g.drawString(val, this._x + x, colorBarYLocation + this._ticLabelYPos[ii] + fontAscent);
                }
            }
            g2d.dispose();
        }
    }

    public void updateLabels() {
    }

    public void paintScale(int width, int height) {
        int numberTics;
        int fontHeight = 10;
        if (width < 1 || height < 1) {
            return;
        }
        ColorContour cc = this._colorContourRecord.getColorContour();
        double max = cc.getMaxValue();
        double min = cc.getMinValue();
        double scl = (max - min) / (double)height;
        double ticDistance = this._colorContourRecord.getTicInterval();
        if (ticDistance <= 0.0) {
            return;
        }
        String s = String.valueOf(ticDistance);
        int idx = s.indexOf(".");
        if (idx > -1) {
            s = s.substring(idx);
            this._precision = s.length() - idx;
        } else {
            this._precision = 1;
        }
        double valHeight = max - min;
        if (valHeight > 0.0) {
            if (ticDistance > valHeight) {
                ticDistance = valHeight;
            }
            numberTics = (int)(valHeight / ticDistance);
        } else {
            numberTics = height;
        }
        this._ticDistance = ticDistance;
        double numPixelsPerTic = (double)height / (double)numberTics;
        if (numPixelsPerTic == 0.0 || Math.round(numPixelsPerTic) == 0L) {
            numPixelsPerTic = 1.0;
        }
        if (numberTics < 1) {
            numberTics = 1;
        }
        int numLabels = numberTics + 1;
        double[] tmpLabelVals = new double[numLabels];
        this._ticLabelXPos = new int[numLabels];
        this._ticLabelYPos = new int[numLabels];
        Arrays.fill(this._ticLabelYPos, Integer.MIN_VALUE);
        int ticCount = 0;
        boolean _drawTics = true;
        this._contourImage = new BufferedImage(width, height, 2);
        WritableRaster working = this._contourImage.getRaster();
        DataBufferInt rasterDB = (DataBufferInt)working.getDataBuffer();
        int[] pix = rasterDB.getData();
        int blackRgb = Color.black.getRGB();
        int backRgb = Color.white.getRGB();
        int lastII = 0;
        double lastTicLabel = max;
        int halfTextHeight = fontHeight / 3;
        for (int ii = 0; ii < height; ++ii) {
            int rgb;
            int valRgb;
            if (ii == height - 1 && _drawTics) {
                this._ticLabelXPos[ticCount] = 0;
                this._ticLabelYPos[ticCount] = ii + halfTextHeight;
                if (ticCount > 0 && this._ticLabelYPos[ticCount] - this._ticLabelYPos[ticCount - 1] < fontHeight) {
                    this._ticLabelYPos[ticCount] = this._ticLabelYPos[ticCount - 1] + fontHeight;
                }
                tmpLabelVals[ticCount++] = min;
                rgb = valRgb = blackRgb;
                lastII = ii;
            } else if (ii == 0 && _drawTics) {
                this._ticLabelXPos[ticCount] = 0;
                this._ticLabelYPos[ticCount] = ii - halfTextHeight;
                tmpLabelVals[ticCount++] = max;
                rgb = blackRgb;
                valRgb = blackRgb;
                lastII = ii;
            } else if ((long)(height - (ii + 1)) % Math.round(numPixelsPerTic) == 0L && _drawTics && ii - lastII > 2 * fontHeight) {
                double numTicsCounted = (double)(height - (ii + 1)) / numPixelsPerTic;
                this._ticLabelXPos[ticCount] = 0;
                this._ticLabelYPos[ticCount] = ii + halfTextHeight;
                tmpLabelVals[ticCount++] = min + ticDistance * numTicsCounted;
                rgb = blackRgb;
                valRgb = blackRgb;
                lastII = ii;
            } else {
                double val = max - (double)ii * scl;
                rgb = cc.getRGB(val, 1.0);
                valRgb = backRgb;
            }
            for (int jj = 0; jj < width; ++jj) {
                pix[ii * width + jj] = rgb;
            }
        }
        if (ticCount != tmpLabelVals.length) {
            this._labelVals = new double[ticCount];
            System.arraycopy(tmpLabelVals, 0, this._labelVals, 0, this._labelVals.length);
        } else {
            this._labelVals = tmpLabelVals;
        }
    }

    private String convertValueToString(double d) {
        return this.convertValueToString(d, this._precision);
    }

    private String convertValueToString(double d, int precision) {
        if (this._df == null) {
            this._df = new DecimalFormat();
        }
        this._df.setMaximumFractionDigits(precision);
        this._df.setMinimumFractionDigits(precision);
        return this._df.format(d);
    }

    public void setTicInterval(double tic) {
        if (this._colorContourRecord instanceof CCDataRecord) {
            ((CCDataRecord)this._colorContourRecord).setTicInterval(tic);
        }
    }

    private class CCDataRecord
    implements ColorContourRecord {
        private ColorContour _cc = null;
        private double _ticInterval = -1.0;

        public CCDataRecord(ColorContour cc) {
            this._cc = cc;
        }

        @Override
        public float getAlpha() {
            return 1.0f;
        }

        @Override
        public void deleteObserver(Observer observer) {
        }

        @Override
        public void addObserver(Observer observer) {
        }

        @Override
        public ColorContour getColorContour() {
            return this._cc;
        }

        @Override
        public int getUnitSystem() {
            return 1;
        }

        @Override
        public double getTicInterval() {
            double min;
            if (this._ticInterval >= 0.0) {
                return this._ticInterval;
            }
            double max = this._cc.getMaxValue();
            double difference = max - (min = this._cc.getMinValue());
            if (difference == 0.0) {
                return 0.0;
            }
            double exp = Math.log(difference) / Math.log(10.0);
            if (exp > 1.0) {
                return Math.pow(10.0, Math.floor(exp) - 1.0);
            }
            return 2.0;
        }

        @Override
        public String getUnits() {
            return "";
        }

        @Override
        public int getParamId() {
            return -1;
        }

        public void setTicInterval(double tic) {
            this._ticInterval = tic;
        }
    }
}

