/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.JLayerSelection;
import hec.map.JLayerSelectionParent;
import hec.map.MapGlyph;
import hec.map.MapPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.UIManager;
import rma.swing.RmaJList;

public abstract class ColorListJLayerSelection
extends JLayerSelection {
    protected RmaJList _list;
    protected Map _color2ImageMap = new HashMap();
    protected Map _imageToImageIconMap = new HashMap();

    public ColorListJLayerSelection(JLayerSelectionParent parent, JFrame parentFrame, MapPanel mapPanel, MapGlyph glyph) {
        super(parent, parentFrame, mapPanel, glyph);
        this._list = new RmaJList();
        this.fillList();
    }

    protected abstract void fillList();

    protected ColorImageIcon getColorImageIcon(Image img) {
        ColorImageIcon cii = (ColorImageIcon)this._imageToImageIconMap.get(img);
        if (cii == null) {
            cii = new ColorImageIcon(img);
            this._imageToImageIconMap.put(img, cii);
        }
        return cii;
    }

    protected Image makeImage(Color clr) {
        int i;
        Image img = (Image)this._color2ImageMap.get(clr);
        if (img != null) {
            return img;
        }
        int w = 14;
        int h = 14;
        int myClr = clr.getRGB();
        int[] pix = new int[w * h];
        for (int i2 = 0; i2 < pix.length; ++i2) {
            pix[i2] = myClr;
        }
        int lastrow = pix.length - w;
        int blk = Color.black.getRGB();
        for (i = 0; i < w; ++i) {
            pix[i] = blk;
            pix[i + lastrow] = blk;
        }
        for (i = 0; i < pix.length - w; i += w) {
            pix[i] = blk;
            pix[i + w - 1] = blk;
        }
        MemoryImageSource mis = new MemoryImageSource(w, h, pix, 0, w);
        img = Toolkit.getDefaultToolkit().createImage(mis);
        this._color2ImageMap.put(clr, img);
        return img;
    }

    public class ColorImageIcon
    extends ImageIcon {
        Object value;

        public ColorImageIcon(Image img, Object o) {
            super(img);
            this.value = o;
        }

        public ColorImageIcon(Image img) {
            super(img);
            this.value = "";
        }

        @Override
        public String toString() {
            return this.value.toString();
        }
    }

    public class ColorListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            if (value instanceof ColorImageIcon) {
                ColorImageIcon cii = (ColorImageIcon)value;
                this.setIcon(cii);
                this.setText(cii.toString());
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                this.setEnabled(list.isEnabled());
                this.setFont(list.getFont());
                this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
                return this;
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

