/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.LocalRect;
import hec.map.MapScale;
import hec.map.MapTextObject;
import hec.map.WorldLine;
import hec.map.WorldPt;
import hec.map.WorldRect;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public class ConformingMapText
extends MapTextObject {
    WorldLine _line;
    MapScale _scl;
    int _x;
    int _y;
    double _slope;
    int _offset;

    public ConformingMapText() {
    }

    public ConformingMapText(String txt, int x, int y, double slope, int offset, float priority, Font font, Color fg, Color bg, Graphics g) {
        super(txt, priority, font, fg, bg, g);
    }

    public ConformingMapText(String txt, WorldLine line, MapScale scl, float priority, Font font, Color fg, Color bg, Graphics g) {
        super(txt, priority, font, fg, bg, g);
        this._line = line;
        this._scl = scl;
    }

    @Override
    public LocalRect getBounds() {
        if (this._bounds == null) {
            WorldRect rc = this._line.getBounds();
            int hh = (int)((double)this._h / 2.0 + 0.5);
            this._bounds = new LocalRect(this._scl.e2x(rc.w) - hh, this._scl.n2y(rc.n) - hh, this._scl.e2x(rc.e) + hh, this._scl.n2y(rc.s) + hh);
        }
        return this._bounds;
    }

    @Override
    public boolean intersects(MapTextObject obj) {
        if (this._bounds == null) {
            this.getBounds();
        }
        return this._bounds.intersects(obj.getBounds());
    }

    @Override
    public void draw(Graphics g) {
        double coord;
        if (this._text == null) {
            return;
        }
        if (this._line == null) {
            return;
        }
        int numchar = this._text.length();
        if (numchar < 1) {
            return;
        }
        g.setFont(this._font);
        g.setColor(this._fgcolor);
        FontMetrics metrics = g.getFontMetrics();
        int strwidth = metrics.stringWidth(this._text);
        int h = metrics.getHeight();
        int ascent = metrics.getAscent();
        int descent = metrics.getDescent();
        int hoff = (int)((double)h / 2.0 + 0.5) - ascent;
        int w = metrics.getMaxAdvance();
        double strmlen = this._line.getLength();
        WorldPt pt = (WorldPt)this._line.pts.elementAt(0);
        int strmlenLocal = this._scl.e2x(pt.e + strmlen) - this._scl.e2x(pt.e);
        double localScl = (double)strmlenLocal / strmlen;
        double coordScl = 1.0 / (double)strmlenLocal;
        if (strmlen < coordScl * (double)strwidth) {
            return;
        }
        WorldPt firstpt = this._line.getFirstPt();
        WorldPt lastpt = this._line.getLastPt();
        int idir = 1;
        if (firstpt.e > lastpt.e) {
            idir = -1;
        }
        if ((coord = 0.5 - coordScl * (double)strwidth * 0.55 * (double)idir) < 0.0) {
            coord = 0.0;
        }
        if (coord > 1.0) {
            coord = 1.0;
        }
        AffineTransform at = new AffineTransform();
        WorldPt loc = new WorldPt();
        WorldPt slp = new WorldPt();
        for (int i = 0; i < numchar; ++i) {
            String cstr = this._text.substring(i, i + 1);
            double sw = (double)metrics.stringWidth(cstr) * 1.1;
            int hsw = (int)(sw / 2.0 + 0.5);
            this._line.getSlopeAtCoord(coord + (double)idir * coordScl * (double)hsw, loc, slp);
            ((Graphics2D)g).translate(this._scl.e2x(loc.e), this._scl.n2y(loc.n));
            ((Graphics2D)g).rotate(Math.atan2(-slp.n * (double)idir, slp.e * (double)idir));
            ((Graphics2D)g).drawString(cstr, -hsw, -hoff);
            coord += coordScl * sw * (double)idir;
            at.setToIdentity();
            ((Graphics2D)g).setTransform(at);
        }
    }
}

