/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.DisplayCoordinateReferenceSystemFactory;
import hec.map.crs.CoordinateReferenceSystem;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import rma.util.lookup.Lookup;

public abstract class DisplayCoordinateReferenceSystem {
    public static final String DISPLAY_REF_PROPERTY = "DISPLAY_REF_PROPERTY";
    private static DisplayCoordinateReferenceSystem DP = null;
    PropertyChangeSupport mSupport = new PropertyChangeSupport(this);

    protected DisplayCoordinateReferenceSystem() {
    }

    public static DisplayCoordinateReferenceSystem getDefault() {
        if (DP == null) {
            DisplayCoordinateReferenceSystemFactory factory = (DisplayCoordinateReferenceSystemFactory)Lookup.getDefault().lookup(DisplayCoordinateReferenceSystemFactory.class);
            if (factory != null) {
                DP = factory.createDisplayCoordinateReferenceSystem();
            }
            if (DP == null && (DP = (DisplayCoordinateReferenceSystem)Lookup.getDefault().lookup(DisplayCoordinateReferenceSystem.class)) == null) {
                DP = new TrivialDisplayProjection();
            }
        }
        return DP;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.mSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.mSupport.removePropertyChangeListener(listener);
    }

    public abstract CoordinateReferenceSystem getCoordinateRefereceSystem();

    public static class TrivialDisplayProjection
    extends DisplayCoordinateReferenceSystem {
        CoordinateReferenceSystem displayReferencSystem = null;

        @Override
        public CoordinateReferenceSystem getCoordinateRefereceSystem() {
            return this.displayReferencSystem;
        }

        public void setCoordinateReferenceSystem(CoordinateReferenceSystem refSystem) {
            CoordinateReferenceSystem oldSystem = this.displayReferencSystem;
            this.displayReferencSystem = refSystem;
            this.mSupport.firePropertyChange(DisplayCoordinateReferenceSystem.DISPLAY_REF_PROPERTY, oldSystem, this.displayReferencSystem);
        }
    }
}

