/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.ElevationGlyph;
import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.LocalRegion;
import hec.map.MapCanvas;
import hec.map.MapGlyph;
import hec.map.MapMouseAdapter;
import hec.map.MapPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import rma.util.RMAConst;

public class ElevationAdapter
extends MapMouseAdapter {
    boolean _zoomIn = false;
    boolean _drawDragRect = false;
    LocalPt _beginPt = new LocalPt();
    LocalPt _endPt = new LocalPt();
    LocalRect _dragRect = new LocalRect();
    LocalRect _oldDragRect = new LocalRect();
    boolean _drawingRegion = false;
    LocalRegion _region = new LocalRegion();
    DecimalFormat df = null;

    public ElevationAdapter(MapPanel panel, MapCanvas canvas) {
        super(panel, canvas);
    }

    public List getElevationGlyphs() {
        ArrayList<MapGlyph> glyphList = new ArrayList<MapGlyph>();
        for (int i = 0; i < this._mapPanel.glyphList().size(); ++i) {
            MapGlyph glyph = (MapGlyph)this._mapPanel.glyphList().get(i);
            if (glyph == null || !(glyph instanceof ElevationGlyph)) continue;
            glyphList.add(glyph);
        }
        return glyphList;
    }

    private String setPrecision(double value) {
        if (this.df == null) {
            this.df = new DecimalFormat("###############.##");
        }
        return this.df.format(value);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (ElevationAdapter.pressedButton1(e) && !this._drawingRegion) {
            MapGlyph glyph = null;
            List glyphList = this.getElevationGlyphs();
            for (int i = 0; i < glyphList.size(); ++i) {
                float depth;
                glyph = (MapGlyph)glyphList.get(i);
                if (!glyph.isShown() || !RMAConst.isValidValue(depth = ((ElevationGlyph)((Object)glyph)).getElevationAt(e.getX(), e.getY()))) continue;
                String str = this.setPrecision(depth);
                Graphics gfx = this._mapCanvas.getGraphics();
                gfx.setPaintMode();
                gfx.setFont(new Font("SansSerif", 0, 12));
                FontMetrics fm = gfx.getFontMetrics();
                int h = fm.getHeight();
                int w = fm.stringWidth(str);
                gfx.setColor(Color.white);
                gfx.fillRect(e.getX() - 1, e.getY() - fm.getMaxAscent() - 1, w + 2, h + 2);
                gfx.setColor(Color.black);
                gfx.drawString(str, e.getX(), e.getY());
                gfx.setPaintMode();
                break;
            }
        } else if (ElevationAdapter.pressedButton1(e) && this._drawingRegion) {
            Graphics gfx = this._mapCanvas.getGraphics();
            gfx.setColor(Color.black);
            gfx.setXORMode(Color.white);
            gfx.drawLine(this._endPt.x, this._endPt.y, this._beginPt.x, this._beginPt.y);
            for (int i = 0; i < this._mapPanel.glyphList().size(); ++i) {
                MapGlyph glyph = (MapGlyph)this._mapPanel.glyphList().get(i);
                if (glyph == null || !(glyph instanceof ElevationGlyph) || !glyph.isShown()) continue;
                ((ElevationGlyph)((Object)glyph)).drawElevationStats(gfx, this._region);
            }
            gfx.setPaintMode();
            this._drawingRegion = false;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this._beginPt.init(e.getX(), e.getY());
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (ElevationAdapter.pressedButton1(e) && (Math.abs(this._endPt.x - e.getX()) > 2 || Math.abs(this._endPt.y - e.getY()) > 2)) {
            Graphics gfx = this._mapCanvas.getGraphics();
            gfx.setColor(Color.black);
            gfx.setXORMode(Color.white);
            if (!this._drawingRegion) {
                this._drawingRegion = true;
                this._region.pts.removeAllElements();
                this._region.pts.addElement(new LocalPt(this._beginPt));
                this._endPt.init(this._beginPt);
            }
            gfx.drawLine(this._endPt.x, this._endPt.y, e.getX(), e.getY());
            this._endPt.init(e.getX(), e.getY());
            this._region.pts.addElement(new LocalPt(this._endPt));
        }
    }
}

