/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.io.AsciiSerializable;
import hec.map.ElevationGlyph;
import hec.map.ElevationMap;
import hec.map.GlyphDataRecord;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import rma.util.Clipping;
import rma.util.ColorContour;
import rma.util.RMAIO;
import rma.util.TerrainColorContour;
import rma.util.contour.ColorContourRecord;

public class ElevationGlyphDataRecord
extends GlyphDataRecord
implements Cloneable,
ColorContourRecord,
Serializable,
AsciiSerializable {
    protected boolean _set = false;
    protected boolean _autoContour = true;
    protected ColorContour _colorContour = new TerrainColorContour();
    protected boolean _aspectEnabled = true;
    protected double _aspectAngle = 160.0;
    protected double _asimuthAngle = 30.0;
    protected double _elevFactor = 10.0;
    protected boolean _drawEdges = false;
    protected int _numberConturs = 20;
    protected float _alpha = 1.0f;
    protected double _ticInterval = 10.0;
    protected String _units = "";
    protected int _unitSystem = 0;

    public void setGlyph(ElevationGlyph g) {
        double min = g.getMinimumElevation();
        double max = g.getMaximumElevation();
        this.getColorContour().setMinValue(min);
        this.getColorContour().setMaxValue(max);
        this.getMaxClipping().setValue(max);
        this.getMinClipping().setValue(min);
        this._set = true;
    }

    public void setSet(boolean b) {
        this._set = b;
    }

    public boolean isSet() {
        return this._set;
    }

    @Override
    public void setMap(Collection maps) {
        double min = this.getColorContour().getMinValue();
        double max = this.getColorContour().getMaxValue();
        for (Object o : maps) {
            if (!(o instanceof ElevationMap)) continue;
            double d = ((ElevationMap)o).getMinimumElevation();
            if (min == Double.NEGATIVE_INFINITY) {
                min = d;
            } else if (d < min) {
                min = d;
            }
            d = ((ElevationMap)o).getMaximumElevation();
            if (max == Double.NEGATIVE_INFINITY) {
                max = d;
                continue;
            }
            if (!(d > max)) continue;
            max = d;
        }
        this.getColorContour().setMinValue(min);
        this.getColorContour().setMaxValue(max);
        this.getMaxClipping().setValue(max);
        this.getMinClipping().setValue(min);
        this._set = true;
    }

    @Override
    public Object clone() {
        Object clone = super.clone();
        ElevationGlyphDataRecord d = (ElevationGlyphDataRecord)clone;
        d.setAutoContour(this._autoContour);
        d.setAspectAngle(this._aspectAngle);
        d.setAspectEnabled(this._aspectEnabled);
        d.setColorContour((ColorContour)this._colorContour.clone());
        d.setAsimuthAngle(this._asimuthAngle);
        d.setElevFactor(this._elevFactor);
        d.setDrawEdges(this._drawEdges);
        d.setNumberConturs(this._numberConturs);
        d.setUnits(this._units);
        d.setUnitSystem(this._unitSystem);
        return d;
    }

    public boolean getAutoContour() {
        return this._autoContour;
    }

    public void setAutoContour(boolean tf) {
        this._autoContour = tf;
    }

    @Override
    public ColorContour getColorContour() {
        return this._colorContour;
    }

    public void setColorContour(ColorContour c2) {
        this._colorContour = c2;
    }

    public double getBrightness() {
        return this._colorContour.getBrightness();
    }

    public void setBrightness(double d) {
        this._colorContour.setBrightness(d);
    }

    public double getSaturation() {
        return this._colorContour.getSaturation();
    }

    public void setSaturation(double d) {
        this._colorContour.setSaturation(d);
    }

    public boolean getAspectEnabled() {
        return this._aspectEnabled;
    }

    public void setAspectEnabled(boolean tf) {
        this._aspectEnabled = tf;
    }

    public double getAspectAngle() {
        return this._aspectAngle;
    }

    public void setAspectAngle(double d) {
        this._aspectAngle = d;
    }

    public double getAsimuthAngle() {
        return this._asimuthAngle;
    }

    public void setAsimuthAngle(double d) {
        this._asimuthAngle = d;
    }

    public double getElevFactor() {
        return this._elevFactor;
    }

    public void setElevFactor(double d) {
        this._elevFactor = d;
    }

    public boolean getDrawEdges() {
        return this._drawEdges;
    }

    public void setDrawEdges(boolean d) {
        this._drawEdges = d;
    }

    public int getNumberConturs() {
        return this._numberConturs;
    }

    public void setNumberConturs(int d) {
        this._numberConturs = d;
    }

    public Clipping getMinClipping() {
        return this._colorContour.getMinClipping();
    }

    public void setMinClipping(Clipping c2) {
        this._colorContour.setMinClipping(c2);
    }

    public Clipping getMaxClipping() {
        return this._colorContour.getMaxClipping();
    }

    public void setMaxClipping(Clipping c2) {
        this._colorContour.setMaxClipping(c2);
    }

    public boolean getScaleToClipping() {
        return this._colorContour.getScaleToClipping();
    }

    public void setScaleToClipping(boolean b) {
        this._colorContour.setScaleToClipping(b);
    }

    @Override
    public double getTicInterval() {
        return this._ticInterval;
    }

    public void setTicInterval(double d) {
        this._ticInterval = d;
    }

    public boolean getSet() {
        return this._set;
    }

    @Override
    public float getAlpha() {
        return this._alpha;
    }

    public void setAlpha(float f) {
        this._alpha = f;
    }

    @Override
    public String getUnits() {
        return this._units;
    }

    public void setUnits(String units) {
        this._units = units;
    }

    @Override
    public int getUnitSystem() {
        return this._unitSystem;
    }

    public void setUnitSystem(int unitSystem) {
        this._unitSystem = unitSystem;
    }

    @Override
    protected void read0(String type, String param, BufferedReader input) throws IOException {
        if (type.compareTo("AutoContour") == 0) {
            this.setAutoContour(Boolean.valueOf(param));
        } else if (type.compareTo("AspectEnabled") == 0) {
            this.setAspectEnabled(Boolean.valueOf(param));
        } else if (type.compareTo("AspectAngle") == 0) {
            this.setAspectAngle(new Double(param));
        } else if (type.compareTo("AsimuthAngle") == 0) {
            this.setAsimuthAngle(new Double(param));
        } else if (type.compareTo("ElevFactor") == 0) {
            this.setElevFactor(new Double(param));
        } else if (type.compareTo("DrawEdges") == 0) {
            this.setDrawEdges(Boolean.valueOf(param));
        } else if (type.compareTo("NumberConturs") == 0) {
            this.setNumberConturs(new Integer(param));
        } else if (type.compareTo("TicInterval") == 0) {
            this._ticInterval = new Double(param);
        } else if (type.compareTo("ColorContour") == 0) {
            try {
                Class<?> ccClass = Class.forName(param);
                Object obj = ccClass.newInstance();
                if (obj instanceof ColorContour) {
                    this._colorContour = (ColorContour)obj;
                    this._colorContour.read(input);
                }
            }
            catch (Exception e) {
                System.out.println("Error reading Color Contour.  " + e);
            }
        } else if (type.compareTo("Units") == 0) {
            this._units = param;
        } else if (type.compareTo("UnitSystem") == 0) {
            this.setUnitSystem(RMAIO.parseInt(param));
        }
        this._set = true;
    }

    @Override
    protected void write0(BufferedWriter output) throws IOException {
        output.write("TicInterval=" + this.getTicInterval());
        output.newLine();
        output.write("AutoContour=" + this.getAutoContour());
        output.newLine();
        output.write("AspectEnabled=" + this.getAspectEnabled());
        output.newLine();
        output.write("AspectAngle=" + Double.toString(this.getAspectAngle()));
        output.newLine();
        output.write("AsimuthAngle=" + Double.toString(this.getAsimuthAngle()));
        output.newLine();
        output.write("ElevFactor=" + Double.toString(this.getElevFactor()));
        output.newLine();
        output.write("DrawEdges=" + this.getDrawEdges());
        output.newLine();
        output.write("NumberConturs=" + Integer.toString(this.getNumberConturs()));
        output.newLine();
        this._colorContour.write(output);
        output.write("ColorContourEnd");
        output.newLine();
        if (this._units != null && this._units.length() > 0) {
            output.write("Units=" + this._units);
            output.newLine();
        }
        if (this._unitSystem != 0) {
            output.write("UnitSystem=" + this._unitSystem);
            output.newLine();
        }
    }

    @Override
    public int getParamId() {
        return -1;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

