/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.appInterface.AppDaddy;
import hec.data.ParamDouble;
import hec.map.ElevationGlyph;
import hec.map.ElevationGlyphDataRecord;
import hec.map.JLayerSelection;
import hec.map.MapPanel;
import hec.map.MapScaleEditorPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rma.services.ServiceLookup;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJLabel;
import rma.util.Clipping;
import rma.util.ColorContour;
import rma.util.RMAIO;
import rma.util.RMAUtil;
import rma.util.contour.ColorContourJPanel;

public class ElevationGlyphOptionJDlg
extends RmaJDialog
implements ImageObserver,
Observer {
    MapPanel _mapPanel = null;
    ElevationGlyph _glyph = null;
    protected ElevationGlyphDataRecord _data = null;
    protected JLayerSelection _layerSel = null;
    Frame _parent = null;
    private boolean _listenersAdded = false;
    ColorContourJPanel jPanelColorScale;
    JLabel jLabelName;
    JPanel jPanelOptions;
    JPanel jPanelOptionExtras;
    RmaJComboBox _comboColorContour;
    protected RmaJCheckBox jCheckBoxDrawEdges;
    JPanel jPanelContourLimits;
    RmaJCheckBox jCheckBoxAutoContour;
    RmaJLabel jLabelContourLimitMax;
    RmaJDecimalField jTextFieldContourLimitMax;
    RmaJLabel jLabelContourLimitMin;
    RmaJDecimalField jTextFieldContourLimitMin;
    JPanel jPanelBody;
    JLabel jLabelBright;
    JSlider jSliderBright;
    RmaJDecimalField jTextFieldBright;
    JLabel jLabelSat;
    JSlider jSliderSat;
    RmaJDecimalField jTextFieldSat;
    RmaJCheckBox jCheckBoxAspect;
    JLabel jLabelAngle;
    JSlider jSliderAspect;
    RmaJDecimalField jTextFieldAspect;
    RmaJCheckBox jCheckBoxClippingMin;
    RmaJLabel jLabelClippingMin;
    JSlider jSliderClippingMin;
    RmaJDecimalField jTextFieldClippingMin;
    RmaJLabel jLabelClippingColorMin;
    ColorButton jButtonClippingColorMin;
    RmaJCheckBox jCheckBoxScaleToClip;
    RmaJCheckBox jCheckBoxClippingMax;
    RmaJLabel jLabelClippingMax;
    JSlider jSliderClippingMax;
    RmaJDecimalField jTextFieldClippingMax;
    RmaJLabel jLabelClippingColorMax;
    ColorButton jButtonClippingColorMax;
    JLabel jLabelTransparency;
    JSlider jSliderTransparency;
    RmaJDecimalField jTextFieldTransparency;
    JLabel jLabelTicInterval;
    RmaJDecimalField jTextFieldTicInterval;
    ButtonCmdPanel cmdPanel;
    JToggleButton jButtonAdvanced;
    SymAction lSymAction = new SymAction();
    MapScaleEditorPanel m_mapScalePanel = new MapScaleEditorPanel();
    SymChange lSymChange = new SymChange();
    private double _clippingScale = 1.0;

    public ElevationGlyphOptionJDlg(Frame parent, boolean modal) {
        super(parent, modal);
        this.setTitle("Elevation Options");
        this.setDefaultCloseOperation(2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setBackground(new JPanel().getBackground());
        this.getContentPane().setLayout(gridBagLayout);
        this.setSize(300, 500);
        this.jLabelName = new JLabel("Glyph Name");
        this.jLabelName.setHorizontalAlignment(0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.jLabelName, gbc);
        JTabbedPane tabbedPane = new JTabbedPane();
        this.getContentPane().add((Component)tabbedPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 5), 0, 0));
        JPanel propertiesPanel = new JPanel(new GridBagLayout());
        tabbedPane.add("Properties", propertiesPanel);
        tabbedPane.add("Scale", this.m_mapScalePanel);
        this.jPanelOptions = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.weightx = 2.0;
        gbc.weighty = 1.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        propertiesPanel.add((Component)this.jPanelOptions, gbc);
        this._comboColorContour = new RmaJComboBox<Object>(ColorContour.getTypes());
        this._comboColorContour.setModifiable(true);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelOptions.add((Component)this._comboColorContour, gbc);
        this.jPanelOptionExtras = new JPanel(new BorderLayout());
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelOptions.add((Component)this.jPanelOptionExtras, gbc);
        this.jCheckBoxDrawEdges = new RmaJCheckBox("Draw Edges");
        this.jCheckBoxDrawEdges.setActionCommand("DrawEdges");
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelOptions.add((Component)this.jCheckBoxDrawEdges, gbc);
        this.jLabelTicInterval = new RmaJLabel("Tic Interval(%S)");
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelOptions.add((Component)this.jLabelTicInterval, gbc);
        this.jTextFieldTicInterval = new RmaJDecimalField();
        this.jTextFieldTicInterval.setMinValue(0.0);
        this.jTextFieldTicInterval.setChangeColor(Color.red);
        this.jLabelTicInterval.setLabelFor(this.jTextFieldTicInterval);
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.ipadx = 40;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelOptions.add((Component)this.jTextFieldTicInterval, gbc);
        this.jButtonAdvanced = new JToggleButton("Advanced");
        this.jButtonAdvanced.setHorizontalTextPosition(10);
        this.jButtonAdvanced.setIcon(RmaImage.getImageIcon("Images/forwardbutton.gif"));
        this.jButtonAdvanced.setSelectedIcon(RmaImage.getImageIcon("Images/backbutton.gif"));
        this.jButtonAdvanced.setVisible(false);
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.insets(2, 2, 2, 2);
        this.jPanelOptions.add((Component)this.jButtonAdvanced, gbc);
        this.jPanelContourLimits = new JPanel(new GridBagLayout());
        EtchedBorder eBorder = new EtchedBorder();
        TitledBorder tBorder = new TitledBorder(eBorder, "Contour Limits");
        this.jPanelContourLimits.setBorder(tBorder);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelOptions.add((Component)this.jPanelContourLimits, gbc);
        this.jCheckBoxAutoContour = new RmaJCheckBox("System Specified Min/Max Values");
        this.jCheckBoxAutoContour.setActionCommand("Automatic");
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelContourLimits.add((Component)this.jCheckBoxAutoContour, gbc);
        this.jLabelContourLimitMax = new RmaJLabel("Maximum(%S)", 4);
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelContourLimits.add((Component)this.jLabelContourLimitMax, gbc);
        this.jTextFieldContourLimitMax = new RmaJDecimalField();
        this.jTextFieldContourLimitMax.setColumns(10);
        this.jTextFieldContourLimitMax.setMinValue(-1.7976931348623157E308);
        this.jTextFieldContourLimitMax.setMaxValue(Double.MAX_VALUE);
        this.jLabelContourLimitMax.setLabelFor(this.jTextFieldContourLimitMax);
        this.jTextFieldContourLimitMax.setMargin(new Insets(0, 0, 0, 0));
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelContourLimits.add((Component)this.jTextFieldContourLimitMax, gbc);
        this.jLabelContourLimitMin = new RmaJLabel("Minimum(%S)", 4);
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelContourLimits.add((Component)this.jLabelContourLimitMin, gbc);
        this.jTextFieldContourLimitMin = new RmaJDecimalField();
        this.jTextFieldContourLimitMin.setMinValue(-1.7976931348623157E308);
        this.jTextFieldContourLimitMin.setMaxValue(Double.MAX_VALUE);
        this.jTextFieldContourLimitMin.setColumns(10);
        this.jLabelContourLimitMin.setLabelFor(this.jTextFieldContourLimitMin);
        this.jTextFieldContourLimitMin.setMargin(new Insets(0, 0, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelContourLimits.add((Component)this.jTextFieldContourLimitMin, gbc);
        this.jPanelBody = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelOptions.add((Component)this.jPanelBody, gbc);
        this.jLabelBright = new JLabel();
        this.jLabelBright.setText("Brightness (0.0-1.0)");
        this.jLabelBright.setHorizontalAlignment(4);
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelBody.add((Component)this.jLabelBright, gbc);
        this.jSliderBright = new JSlider();
        this.jSliderBright.setSnapToTicks(false);
        gbc = new GridBagConstraints();
        gbc.weightx = 3.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelBody.add((Component)this.jSliderBright, gbc);
        this.jTextFieldBright = new RmaJDecimalField();
        this.jTextFieldBright.setMinValue(0.0);
        this.jTextFieldBright.setMaxValue(1.0);
        this.jTextFieldBright.setChangeColor(Color.red);
        this.jTextFieldBright.setMargin(new Insets(0, 0, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.jPanelBody.add((Component)this.jTextFieldBright, gbc);
        this.jLabelSat = new JLabel("Saturation (0.0-1.0)", 4);
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelBody.add((Component)this.jLabelSat, gbc);
        this.jSliderSat = new JSlider();
        this.jSliderSat.setSnapToTicks(false);
        gbc = new GridBagConstraints();
        gbc.weightx = 3.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelBody.add((Component)this.jSliderSat, gbc);
        this.jTextFieldSat = new RmaJDecimalField();
        this.jTextFieldSat.setMaxValue(1.0);
        this.jTextFieldSat.setMinValue(0.0);
        this.jTextFieldSat.setChangeColor(Color.red);
        this.jTextFieldSat.setMargin(new Insets(0, 0, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.jPanelBody.add((Component)this.jTextFieldSat, gbc);
        this.jLabelTransparency = new JLabel("Transparency (0.0-1.0)", 4);
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelBody.add((Component)this.jLabelTransparency, gbc);
        this.jSliderTransparency = new JSlider();
        this.jSliderTransparency.setSnapToTicks(false);
        gbc = new GridBagConstraints();
        gbc.weightx = 3.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelBody.add((Component)this.jSliderTransparency, gbc);
        this.jTextFieldTransparency = new RmaJDecimalField();
        this.jTextFieldTransparency.setMargin(new Insets(0, 0, 0, 0));
        this.jTextFieldTransparency.setMinValue(0.0);
        this.jTextFieldTransparency.setMaxValue(1.0);
        this.jTextFieldTransparency.setChangeColor(Color.red);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.jPanelBody.add((Component)this.jTextFieldTransparency, gbc);
        this.jCheckBoxAspect = new RmaJCheckBox("Aspect Shading");
        this.jCheckBoxAspect.setActionCommand("Aspect Shading");
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelBody.add((Component)this.jCheckBoxAspect, gbc);
        this.jLabelAngle = new JLabel("Angle (0-360 Degrees)", 4);
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelBody.add((Component)this.jLabelAngle, gbc);
        this.jSliderAspect = new JSlider();
        this.jSliderAspect.setRequestFocusEnabled(false);
        this.jSliderAspect.setValue(100);
        this.jSliderAspect.setMaximum(360);
        gbc = new GridBagConstraints();
        gbc.weightx = 3.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelBody.add((Component)this.jSliderAspect, gbc);
        this.jTextFieldAspect = new RmaJDecimalField();
        this.jTextFieldAspect.setChangeColor(Color.red);
        this.jTextFieldAspect.setMinValue(0.0);
        this.jTextFieldAspect.setMaxValue(360.0);
        this.jTextFieldAspect.setMargin(new Insets(0, 0, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.jPanelBody.add((Component)this.jTextFieldAspect, gbc);
        this.jCheckBoxScaleToClip = new RmaJCheckBox("Adjust Color Scale to Clipping Area");
        this.jCheckBoxScaleToClip.setActionCommand("Scale to Clip");
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelBody.add((Component)this.jCheckBoxScaleToClip, gbc);
        this.jCheckBoxClippingMax = new RmaJCheckBox("Maximum Clipping");
        this.jCheckBoxClippingMax.setActionCommand("Maximum Clipping");
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelBody.add((Component)this.jCheckBoxClippingMax, gbc);
        this.jLabelClippingMax = new RmaJLabel("Value", 4);
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelBody.add((Component)this.jLabelClippingMax, gbc);
        this.jSliderClippingMax = new JSlider();
        this.jSliderClippingMax.setSnapToTicks(false);
        gbc = new GridBagConstraints();
        gbc.weightx = 3.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelBody.add((Component)this.jSliderClippingMax, gbc);
        this.jTextFieldClippingMax = new RmaJDecimalField();
        this.jTextFieldClippingMax.setMargin(new Insets(0, 0, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.jPanelBody.add((Component)this.jTextFieldClippingMax, gbc);
        this.jLabelClippingColorMax = new RmaJLabel("Color", 4);
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelBody.add((Component)this.jLabelClippingColorMax, gbc);
        this.jButtonClippingColorMax = new ColorButton();
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.fill = 3;
        gbc.insets = new Insets(0, 2, 0, 2);
        this.jPanelBody.add((Component)this.jButtonClippingColorMax, gbc);
        this.jCheckBoxClippingMin = new RmaJCheckBox("Minimum Clipping");
        this.jCheckBoxClippingMin.setActionCommand("Minimum Clipping");
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelBody.add((Component)this.jCheckBoxClippingMin, gbc);
        this.jLabelClippingMin = new RmaJLabel("Value", 4);
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelBody.add((Component)this.jLabelClippingMin, gbc);
        this.jSliderClippingMin = new JSlider();
        this.jSliderClippingMin.setSnapToTicks(false);
        gbc = new GridBagConstraints();
        gbc.weightx = 3.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelBody.add((Component)this.jSliderClippingMin, gbc);
        this.jTextFieldClippingMin = new RmaJDecimalField();
        this.jTextFieldClippingMin.setMargin(new Insets(0, 0, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.jPanelBody.add((Component)this.jTextFieldClippingMin, gbc);
        this.jLabelClippingColorMin = new RmaJLabel("Color", 4);
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.jPanelBody.add((Component)this.jLabelClippingColorMin, gbc);
        this.jButtonClippingColorMin = new ColorButton();
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.fill = 3;
        gbc.insets = new Insets(0, 2, 0, 2);
        this.jPanelBody.add((Component)this.jButtonClippingColorMin, gbc);
        this.jPanelColorScale = new ColorContourJPanel();
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        propertiesPanel.add((Component)this.jPanelColorScale, gbc);
        this.cmdPanel = new ButtonCmdPanel(14);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.anchor = 14;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.cmdPanel, gbc);
        this.jPanelBody.setVisible(!this.jButtonAdvanced.isVisible());
        this.pack();
        this.jTextFieldContourLimitMax.setChangeColor(Color.red);
        this.jTextFieldContourLimitMin.setChangeColor(Color.red);
        this.jTextFieldClippingMax.setChangeColor(Color.red);
        this.jTextFieldClippingMin.setChangeColor(Color.red);
    }

    public ElevationGlyphOptionJDlg(Frame parent, boolean modal, MapPanel panel, ElevationGlyph glyph, ElevationGlyphDataRecord datarec, JLayerSelection jls) {
        this(parent, modal);
        this._mapPanel = panel;
        this.setMapGlyph(glyph);
        this._layerSel = jls;
        this.m_mapScalePanel.setMapPanel(this._mapPanel);
        this.setGlyphDataRecord(datarec);
        this.addListeners();
    }

    protected void addListeners() {
        if (this._listenersAdded) {
            return;
        }
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this._comboColorContour.removeActionListener(this.lSymAction);
        this._comboColorContour.addActionListener(this.lSymAction);
        this.jButtonClippingColorMin.addActionListener(this.lSymAction);
        this.jButtonClippingColorMax.addActionListener(this.lSymAction);
        this.jCheckBoxClippingMax.addActionListener(this.lSymAction);
        this.jCheckBoxDrawEdges.addActionListener(this.lSymAction);
        this.jCheckBoxAutoContour.addActionListener(this.lSymAction);
        this.jCheckBoxScaleToClip.addActionListener(this.lSymAction);
        this.jSliderBright.addChangeListener(this.lSymChange);
        this.jSliderTransparency.addChangeListener(this.lSymChange);
        this.jSliderSat.addChangeListener(this.lSymChange);
        this.jSliderClippingMin.addChangeListener(this.lSymChange);
        this.jSliderClippingMax.addChangeListener(this.lSymChange);
        this.jCheckBoxAspect.addActionListener(this.lSymAction);
        this.jCheckBoxClippingMin.addActionListener(this.lSymAction);
        this.jSliderAspect.addChangeListener(this.lSymChange);
        SymKey aSymKey = new SymKey();
        this.jTextFieldContourLimitMin.addKeyListener(aSymKey);
        this.jTextFieldContourLimitMax.addKeyListener(aSymKey);
        this.jTextFieldBright.addKeyListener(aSymKey);
        this.jTextFieldTransparency.addKeyListener(aSymKey);
        this.jTextFieldSat.addKeyListener(aSymKey);
        this.jTextFieldAspect.addKeyListener(aSymKey);
        this.jTextFieldClippingMin.addKeyListener(aSymKey);
        this.jTextFieldClippingMax.addKeyListener(aSymKey);
        this.jTextFieldContourLimitMin.addKeyListener(aSymKey);
        this.jTextFieldTicInterval.addKeyListener(aSymKey);
        this.jButtonAdvanced.addActionListener(this.lSymAction);
        this._listenersAdded = true;
        this.cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        ElevationGlyphOptionJDlg.this.jButtonOk_actionPerformed(e);
                        break;
                    }
                    case 2: {
                        ElevationGlyphOptionJDlg.this.jButtonApply_actionPerformed(e);
                        break;
                    }
                    case 4: {
                        ElevationGlyphOptionJDlg.this.jButtonCancel_actionPerformed(e);
                    }
                }
            }
        });
    }

    public void setMapPanel(MapPanel mapPanel) {
        this._mapPanel = mapPanel;
    }

    public void setMapGlyph(ElevationGlyph mapGlyph) {
        this._glyph = mapGlyph;
        if (this._glyph != null) {
            this.jTextFieldClippingMin.setMaxValue(this._glyph.getMaximumElevation());
            this.jTextFieldClippingMin.setMinValue(this._glyph.getMinimumElevation());
            this.jTextFieldClippingMax.setMaxValue(this._glyph.getMaximumElevation());
            this.jTextFieldClippingMax.setMinValue(this._glyph.getMinimumElevation());
        }
    }

    public void setGlyphDataRecord(ElevationGlyphDataRecord rec) {
        this._data = (ElevationGlyphDataRecord)rec.clone();
        this.jPanelColorScale.setDataRecord(this._data);
        String name = null;
        if (name == null) {
            name = this._glyph.getName();
        }
        name = RMAIO.trimToFilename(name);
        this.jLabelName.setText(name);
        this.setTicInterval(this._data.getTicInterval());
        ColorContour cc = this._data.getColorContour();
        this.setColorContour(cc);
        this.setDrawEdges(this._data.getDrawEdges());
        this.setAutoContour(this._data.getAutoContour());
        this.setBrightness(this._data.getBrightness());
        this.setAlpha(this._data.getAlpha());
        this.setSaturation(this._data.getSaturation());
        this.setAspect(this._data.getAspectEnabled(), this._data.getAspectAngle());
        this.setScaleToClip(this._data.getScaleToClipping());
        Clipping clip = this._data.getMaxClipping();
        this.setMaxClipping(clip);
        clip = this._data.getMinClipping();
        this.setMinClipping(clip);
        this.m_mapScalePanel.setScale(this._glyph.getMinimumScale(), this._glyph.getMaximumScale());
        this.setModified(false);
    }

    public void setAdvancedButtonVisible(boolean b) {
        this.jButtonAdvanced.setVisible(b);
        this.jPanelBody.setVisible(!b);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return false;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof ColorContour) {
            this._data.setColorContour((ColorContour)arg);
            this._data.setModified(true);
            this.jPanelColorScale.paintScale();
        }
    }

    protected ImageIcon getColorIcon(Color c2) {
        int w = 12;
        int h = 12;
        int rgb = c2.getRGB();
        int[] pix = new int[h * w];
        for (int ii = 0; ii < pix.length; ++ii) {
            pix[ii] = rgb;
        }
        MemoryImageSource mis = new MemoryImageSource(w, h, pix, 0, w);
        Image img = Toolkit.getDefaultToolkit().createImage(mis);
        ImageIcon imgIcon = new ImageIcon(img);
        return imgIcon;
    }

    protected void setScaleToClip(boolean scaleToClip) {
        this.jCheckBoxScaleToClip.setSelected(scaleToClip);
    }

    protected void setMaxClipping(Clipping clip) {
        Color c2 = clip.getColor();
        double val = clip.getValue();
        boolean enabled = clip.getEnabled();
        this.jSliderClippingMax.setValue((int)(val * this._clippingScale));
        this.jSliderClippingMax.invalidate();
        this.jSliderClippingMax.validate();
        this.jSliderClippingMax.repaint();
        if (!this.jTextFieldClippingMax.hasFocus()) {
            ParamDouble x = new ParamDouble(val, this._data.getParamId());
            x.setUnitSystem(this._data.getUnitSystem());
            x.setPrecision(2);
            this.jTextFieldClippingMax.setValue(x);
            this.jTextFieldClippingMax.setDisplayUnitsSystem(AppDaddy.getApp().getClientUnitSystem());
            if (Boolean.getBoolean("DEBUG")) {
                System.out.println("Setting text field value in setMaxClipping");
            }
        }
        this.jButtonClippingColorMax.setIcon(this.getColorIcon(c2));
        this.jButtonClippingColorMax.repaint();
        this.jCheckBoxClippingMax.setSelected(enabled);
        this.jSliderClippingMax.setEnabled(enabled);
        this.jButtonClippingColorMax.setEnabled(enabled);
        this.jTextFieldClippingMax.setEnabled(enabled);
    }

    protected void setTicInterval(double interval) {
        ParamDouble x = new ParamDouble(interval, this._data.getParamId());
        x.setUnitSystem(this._data.getUnitSystem());
        x.setPrecision(3);
        this.jTextFieldTicInterval.setValue(x);
        this.jTextFieldTicInterval.setDisplayUnitsSystem(AppDaddy.getApp().getClientUnitSystem());
        if (Boolean.getBoolean("DEBUG")) {
            System.out.println("Setting text field value in setTicInterval");
        }
    }

    protected void setMinClipping(Clipping clip) {
        Color c2 = clip.getColor();
        double val = clip.getValue();
        boolean enabled = clip.getEnabled();
        this.jSliderClippingMin.setValue((int)(val * this._clippingScale));
        this.jSliderClippingMin.invalidate();
        this.jSliderClippingMin.validate();
        this.jSliderClippingMin.repaint();
        if (!this.jTextFieldClippingMin.hasFocus()) {
            ParamDouble x = new ParamDouble(val, this._data.getParamId());
            x.setUnitSystem(this._data.getUnitSystem());
            x.setPrecision(2);
            this.jTextFieldClippingMin.setValue(x);
        }
        this.jButtonClippingColorMin.setIcon(this.getColorIcon(c2));
        this.jButtonClippingColorMin.repaint();
        this.jCheckBoxClippingMin.setSelected(enabled);
        this.jSliderClippingMin.setEnabled(enabled);
        this.jButtonClippingColorMin.setEnabled(enabled);
        this.jTextFieldClippingMin.setEnabled(enabled);
    }

    protected void setColorContour(ColorContour cc) {
        cc.addExtras(this.jPanelOptionExtras, this);
        Object type = ColorContour.getType(cc);
        if (type != null) {
            this._comboColorContour.removeActionListener(this.lSymAction);
            this._comboColorContour.setSelectedItem(type);
            this._comboColorContour.addActionListener(this.lSymAction);
        }
    }

    protected void setDrawEdges(boolean tf) {
        this.jCheckBoxDrawEdges.setSelected(tf);
    }

    public boolean isInAdvancedMode() {
        if (this.jButtonAdvanced.isVisible()) {
            return this.jButtonAdvanced.isSelected();
        }
        return false;
    }

    public void setInAdvancedMode(boolean advanced) {
        if (this.jButtonAdvanced.isVisible() && this.jButtonAdvanced.isSelected() != advanced) {
            this.jButtonAdvanced.doClick();
        }
    }

    protected void setAutoContour(boolean tf) {
        this.jCheckBoxAutoContour.setSelected(tf);
        this.jTextFieldContourLimitMax.setEnabled(!tf);
        this.jTextFieldContourLimitMin.setEnabled(!tf);
        double max = this._data.getColorContour().getMaxValue();
        double min = this._data.getColorContour().getMinValue();
        int paramId = this._data.getParamId();
        if (tf && !this.jTextFieldContourLimitMax.hasFocus() && this.jTextFieldContourLimitMax.getText().length() == 0) {
            this.jTextFieldContourLimitMax.setValue(new ParamDouble(max, paramId, ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem(), 3));
            this.jTextFieldContourLimitMax.setDisplayUnitsSystem(ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem());
            if (Boolean.getBoolean("DEBUG")) {
                System.out.println("Setting jTextFieldContourLimitMax  value in setAutoContour");
            }
        }
        if (tf && !this.jTextFieldContourLimitMin.hasFocus() && this.jTextFieldContourLimitMin.getText().length() == 0) {
            this.jTextFieldContourLimitMin.setValue(new ParamDouble(min, paramId, ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem(), 3));
            this.jTextFieldContourLimitMin.setDisplayUnitsSystem(ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem());
            if (Boolean.getBoolean("DEBUG")) {
                System.out.println("Setting jTextFieldContourLimitMin value in setAutoContour");
            }
        }
        if (!tf && !this.jTextFieldContourLimitMax.hasFocus()) {
            this.jTextFieldContourLimitMax.setValue(new ParamDouble(max, paramId, ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem(), 2));
            this.jTextFieldContourLimitMax.setDisplayUnitsSystem(ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem());
        }
        if (!tf && !this.jTextFieldContourLimitMin.hasFocus()) {
            this.jTextFieldContourLimitMin.setValue(new ParamDouble(min, paramId, ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem(), 2));
            this.jTextFieldContourLimitMin.setDisplayUnitsSystem(ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem());
        }
        this.jPanelColorScale.paintScale();
        this.jSliderClippingMin.removeChangeListener(this.lSymChange);
        this.jSliderClippingMin.setMinimum((int)(min * this._clippingScale));
        this.jSliderClippingMin.setMaximum((int)(max * this._clippingScale));
        this.jSliderClippingMin.addChangeListener(this.lSymChange);
        this.jSliderClippingMax.removeChangeListener(this.lSymChange);
        this.jSliderClippingMax.setMinimum((int)(min * this._clippingScale));
        this.jSliderClippingMax.setMaximum((int)(max * this._clippingScale));
        this.jSliderClippingMax.addChangeListener(this.lSymChange);
    }

    protected void setAspect(boolean enabled, double val) {
        this.jCheckBoxAspect.setSelected(enabled);
        this.jSliderAspect.setEnabled(enabled);
        this.jTextFieldAspect.setEnabled(enabled);
        this.jSliderAspect.setValue((int)val);
        if (!this.jTextFieldAspect.hasFocus()) {
            this.jTextFieldAspect.setText(RMAIO.toTable(val));
        }
    }

    protected void setBrightness(double val) {
        if (val < 0.0 || val > 1.0) {
            val = 1.0;
        }
        int sliderVal = (int)(val * 100.0);
        this.jSliderBright.setValue(sliderVal);
        if (!this.jTextFieldBright.hasFocus()) {
            this.jTextFieldBright.setText(RMAIO.toTable(val));
        }
    }

    protected void setAlpha(float val) {
        if (val < 0.0f || val > 1.0f) {
            val = 1.0f;
        }
        val = 1.0f - val;
        int sliderVal = (int)(val * 100.0f);
        this.jSliderTransparency.setValue(sliderVal);
        if (!this.jTextFieldTransparency.hasFocus()) {
            this.jTextFieldTransparency.setText(RMAIO.toTable(val));
        }
    }

    protected void setTransparency(float val) {
        if (val < 0.0f || val > 1.0f) {
            val = 1.0f;
        }
        int sliderVal = (int)(val * 100.0f);
        this.jSliderTransparency.setValue(sliderVal);
        if (!this.jTextFieldTransparency.hasFocus()) {
            this.jTextFieldTransparency.setText(RMAIO.toTable(val));
        }
    }

    protected void setSaturation(double val) {
        if (val < 0.0 || val > 1.0) {
            val = 1.0;
        }
        int sliderVal = (int)(val * 100.0);
        this.jSliderSat.setValue(sliderVal);
        if (!this.jTextFieldSat.hasFocus()) {
            this.jTextFieldSat.setText(RMAIO.toTable(val));
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocation();
            this.jPanelColorScale.setDataRecord(this._data);
            this.jPanelColorScale.paintScale();
            this.pack();
            super.setVisible(b);
            this.repaint(10L);
            this.jPanelColorScale.paintScale();
        } else {
            super.setVisible(b);
        }
    }

    void ElevationGlyphOptionJDlg_WindowClosing(WindowEvent event) {
        this.setVisible(false);
    }

    void jButtonAdvanced_actionPerformed(ActionEvent event) {
        this.jPanelBody.setVisible(!this.jPanelBody.isVisible());
        this.pack();
    }

    void comboColorContour_actionPerformed(ActionEvent event) {
        Object o = this._comboColorContour.getSelectedItem();
        ColorContour cc = ColorContour.getInstanceForType(o);
        this.jPanelOptionExtras.removeAll();
        if (cc != null) {
            this._data.getColorContour().copyInto(cc);
            this._data.setColorContour(cc);
            this._data.setModified(true);
            cc.addExtras(this.jPanelOptionExtras, this);
            this.jPanelOptionExtras.invalidate();
            this.jPanelOptionExtras.validate();
            this.jPanelOptionExtras.repaint();
            this.jPanelColorScale.paintScale();
        }
    }

    void jButtonOk_actionPerformed(ActionEvent event) {
        if (this.isModified()) {
            this.jButtonApply_actionPerformed(event);
        }
        this.setVisible(false);
    }

    protected void jButtonApply_actionPerformed(ActionEvent event) {
        if (this._layerSel != null) {
            this._layerSel.setDataRecord(this._data);
        }
        this._data.setModified(true);
        this._data.notifyObservers(this._layerSel);
        if (this._mapPanel != null) {
            this._mapPanel.paintMap();
        }
        this._data = (ElevationGlyphDataRecord)this._data.clone();
        this.jPanelColorScale.setDataRecord(this._data);
        this._glyph.setMaximumScale(this.m_mapScalePanel.getMaximumScale());
        this._glyph.setMinimumScale(this.m_mapScalePanel.getMinimumScale());
        this.setModified(false);
    }

    void jButtonCancel_actionPerformed(ActionEvent event) {
        this._data = null;
        this.jPanelColorScale.setDataRecord(this._data);
        this.setVisible(false);
    }

    void jButtonClippingColorMin_actionPerformed(ActionEvent event) {
        Color oldColor = this._data.getMinClipping().getColor();
        Color newColor = RMAUtil.colorChooser(this, oldColor);
        this._data.getMinClipping().setColor(newColor);
        this._data.setModified(true);
        this.setMinClipping(this._data.getMinClipping());
        this.jPanelColorScale.paintScale();
    }

    void jButtonClippingColorMax_actionPerformed(ActionEvent event) {
        Color oldColor = this._data.getMaxClipping().getColor();
        Color newColor = RMAUtil.colorChooser(this, oldColor);
        this._data.getMaxClipping().setColor(newColor);
        this._data.setModified(true);
        this.setMaxClipping(this._data.getMaxClipping());
        this.jPanelColorScale.paintScale();
    }

    void jCheckBoxClippingMin_actionPerformed(ActionEvent event) {
        Clipping clip = this._data.getMinClipping();
        Object o = event.getSource();
        AbstractButton jCheckBox = (AbstractButton)o;
        clip.setEnabled(jCheckBox.isSelected());
        this._data.setModified(true);
        this.setMinClipping(clip);
        this.jPanelColorScale.paintScale();
    }

    void jCheckBoxScaleToClip_actionPerformed(ActionEvent event) {
        Object o = event.getSource();
        AbstractButton jCheckBox = (AbstractButton)o;
        this._data.getColorContour().setScaleToClipping(jCheckBox.isSelected());
        this.jPanelColorScale.paintScale();
    }

    void jCheckBoxClippingMax_actionPerformed(ActionEvent event) {
        Clipping clip = this._data.getMaxClipping();
        Object o = event.getSource();
        AbstractButton jCheckBox = (AbstractButton)o;
        clip.setEnabled(jCheckBox.isSelected());
        this._data.setModified(true);
        this.setMaxClipping(clip);
        this.jPanelColorScale.paintScale();
    }

    void jCheckBoxDrawEdges_actionPerformed(ActionEvent event) {
        Object o = event.getSource();
        AbstractButton jRadioButton = (AbstractButton)o;
        this._data.setDrawEdges(jRadioButton.isSelected());
        this._data.setModified(true);
    }

    void jCheckBoxAutoContour_actionPerformed(ActionEvent event) {
        Object o = event.getSource();
        AbstractButton jRadioButton = (AbstractButton)o;
        this._data.setAutoContour(jRadioButton.isSelected());
        this._data.setModified(true);
        ColorContour cc = this._data.getColorContour();
        if (jRadioButton.isSelected()) {
            cc.setMaxValue(this._glyph.getMaximumElevation());
            cc.setMinValue(this._glyph.getMinimumElevation());
        } else {
            double min;
            double max = this.jTextFieldContourLimitMax.getValueUndefined();
            if (max != Double.NEGATIVE_INFINITY) {
                this._glyph.setMaximumScale((int)max);
                cc.setMaxValue(max);
            }
            if ((min = this.jTextFieldContourLimitMin.getValueUndefined()) != Double.NEGATIVE_INFINITY) {
                this._glyph.setMinimumScale((int)max);
                cc.setMinValue(min);
            }
        }
        this.setAutoContour(this._data.getAutoContour());
        this.setMinClipping(cc.getMinClipping());
        this.setMaxClipping(cc.getMaxClipping());
        this.jPanelColorScale.paintScale();
    }

    void jCheckBoxAspect_actionPerformed(ActionEvent event) {
        Object o = event.getSource();
        AbstractButton jRadioButton = (AbstractButton)o;
        this._data.setAspectEnabled(jRadioButton.isSelected());
        this._data.setModified(true);
        this.setAspect(this._data.getAspectEnabled(), this._data.getAspectAngle());
    }

    void jSliderBright_stateChanged(ChangeEvent event) {
        JSlider jSlider = (JSlider)event.getSource();
        int val = jSlider.getValue();
        double dval = (double)val / 100.0;
        if (!this.jTextFieldBright.hasFocus()) {
            this.jTextFieldBright.setText(RMAIO.toTable(dval));
        }
        this._data.setBrightness(dval);
        this._data.setModified(true);
        this.jPanelColorScale.paintScale();
        this.setModified(true);
    }

    void jSliderTransparency_stateChanged(ChangeEvent event) {
        JSlider jSlider = (JSlider)event.getSource();
        int val = jSlider.getValue();
        float fval = (float)val / 100.0f;
        if (!this.jTextFieldTransparency.hasFocus()) {
            this.jTextFieldTransparency.setText(RMAIO.toTable(fval));
        }
        fval = 1.0f - fval;
        this._data.setAlpha(fval);
        this._data.setModified(true);
        this.jPanelColorScale.paintScale();
        this.setModified(true);
    }

    void jSliderSat_stateChanged(ChangeEvent event) {
        JSlider jSlider = (JSlider)event.getSource();
        int val = jSlider.getValue();
        double dval = (double)val / 100.0;
        if (!this.jTextFieldSat.hasFocus()) {
            this.jTextFieldSat.setText(RMAIO.toTable(dval));
        }
        this._data.setSaturation(dval);
        this._data.setModified(true);
        this.jPanelColorScale.paintScale();
        this.setModified(true);
    }

    void jSliderClippingMin_stateChanged(ChangeEvent event) {
        JSlider jSlider = (JSlider)event.getSource();
        int val = jSlider.getValue();
        double dval = val;
        dval /= this._clippingScale;
        if (!this.jTextFieldClippingMin.hasFocus()) {
            this.jTextFieldClippingMin.setValue(new ParamDouble(dval, this._data.getParamId(), this._data.getUnitSystem(), 2));
            if (Boolean.getBoolean("DEBUG")) {
                System.out.println("Setting text field value in jSliderMinVAl_StageChagned");
            }
        }
        this.jTextFieldClippingMin.setDisplayUnitsSystem(AppDaddy.getApp().getClientUnitSystem());
        this._data.getMinClipping().setValue(dval);
        this._data.setModified(true);
        this.jPanelColorScale.paintScale();
        this.setModified(true);
    }

    public void setSliderClippingScale(double scale) {
        this._clippingScale = scale;
    }

    void jSliderClippingMax_stateChanged(ChangeEvent event) {
        JSlider jSlider = (JSlider)event.getSource();
        int val = jSlider.getValue();
        double dval = val;
        dval /= this._clippingScale;
        if (!this.jTextFieldClippingMax.hasFocus()) {
            this.jTextFieldClippingMax.setValue(new ParamDouble(dval, this._data.getParamId(), this._data.getUnitSystem(), 2));
            if (Boolean.getBoolean("DEBUG")) {
                System.out.println("Setting text field value in jSliderClippingMax_stateChanged");
            }
        }
        this.jTextFieldClippingMax.setDisplayUnitsSystem(AppDaddy.getApp().getClientUnitSystem());
        this._data.getMaxClipping().setValue(dval);
        this._data.setModified(true);
        this.jPanelColorScale.paintScale();
        this.setModified(true);
    }

    void jSliderAspect_stateChanged(ChangeEvent event) {
        JSlider jSlider = (JSlider)event.getSource();
        int val = jSlider.getValue();
        double dval = val;
        if (!this.jTextFieldAspect.hasFocus()) {
            this.jTextFieldAspect.setText(RMAIO.toTable(dval));
        }
        this._data.setAspectAngle(dval);
        this._data.setModified(true);
        this.jPanelColorScale.paintScale();
        this.setModified(true);
    }

    protected double validateText(JTextField jTextField, double min, double max) {
        String text = jTextField.getText();
        double dval = RMAIO.parseDouble(text);
        if (dval == Double.NEGATIVE_INFINITY) {
            if (text.length() == 0) {
                return Double.NEGATIVE_INFINITY;
            }
            if (text.length() == 1 && (text.equals("-") || text.equals("."))) {
                return Double.NEGATIVE_INFINITY;
            }
            if (text.length() == 2 && text.equals("-.")) {
                return Double.NEGATIVE_INFINITY;
            }
            String newText = text.substring(0, text.length() - 1);
            jTextField.setText(newText);
            return this.validateText(jTextField, min, max);
        }
        if (dval > max) {
            dval = max;
        } else if (dval < min) {
            dval = min;
        }
        return dval;
    }

    void jTextFieldTicInterval_keyReleased(KeyEvent event) {
        RmaJDecimalField decimalField = (RmaJDecimalField)event.getSource();
        ColorContour cc = this._data.getColorContour();
        double dval = decimalField.getValueUndefined();
        if (dval != Double.NEGATIVE_INFINITY) {
            this._data.setTicInterval(dval);
            this._data.setModified(true);
        }
        this.jPanelColorScale.paintScale();
        this.setModified(true);
    }

    void jTextFieldContourLimitMin_keyReleased(KeyEvent event) {
        RmaJDecimalField jTextField = (RmaJDecimalField)event.getSource();
        double dval = jTextField.getValueUndefined();
        if (dval != Double.NEGATIVE_INFINITY) {
            ColorContour cc = this._data.getColorContour();
            cc.setMinValue(dval);
            this.setAutoContour(this.jCheckBoxAutoContour.isSelected());
            Clipping clip = cc.getMinClipping();
            this._data.setModified(true);
            this.setMinClipping(clip);
        }
        this.jPanelColorScale.paintScale();
        this.setModified(true);
    }

    void jTextFieldContourLimitMax_keyReleased(KeyEvent event) {
        RmaJDecimalField jTextField = (RmaJDecimalField)event.getSource();
        double dval = jTextField.getValueUndefined();
        if (dval != Double.NEGATIVE_INFINITY) {
            ColorContour cc = this._data.getColorContour();
            cc.setMaxValue(dval);
            this.setAutoContour(this.jCheckBoxAutoContour.isSelected());
            Clipping clip = cc.getMaxClipping();
            this._data.setModified(true);
            this.setMaxClipping(clip);
        }
        this.jPanelColorScale.paintScale();
        this.setModified(true);
    }

    void jTextFieldBright_keyReleased(KeyEvent event) {
        JTextField jTextField = (JTextField)event.getSource();
        double dval = this.validateText(jTextField, 0.0, 1.0);
        if (dval != Double.NEGATIVE_INFINITY) {
            this._data.setBrightness(dval);
            this._data.setModified(true);
            this.setBrightness(dval);
        }
        this.jPanelColorScale.paintScale();
        this.setModified(true);
    }

    void jTextFieldTransparency_keyReleased(KeyEvent event) {
        JTextField jTextField = (JTextField)event.getSource();
        float fval = (float)this.validateText(jTextField, 0.0, 1.0);
        if ((double)fval != Double.NEGATIVE_INFINITY) {
            fval = 1.0f - fval;
            this._data.setAlpha(fval);
            this._data.setModified(true);
            this.setAlpha(fval);
        }
        this.jPanelColorScale.paintScale();
        this.setModified(true);
    }

    void jTextFieldSat_keyReleased(KeyEvent event) {
        JTextField jTextField = (JTextField)event.getSource();
        double dval = this.validateText(jTextField, 0.0, 1.0);
        if (dval != Double.NEGATIVE_INFINITY) {
            this._data.setSaturation(dval);
            this._data.setModified(true);
            this.setSaturation(dval);
        }
        this.jPanelColorScale.paintScale();
        this.setModified(true);
    }

    void jTextFieldAspect_keyReleased(KeyEvent event) {
        JTextField jTextField = (JTextField)event.getSource();
        double dval = this.validateText(jTextField, 0.0, 360.0);
        if (dval != Double.NEGATIVE_INFINITY) {
            this._data.setAspectAngle(dval);
            this._data.setModified(true);
            this.setAspect(this.jCheckBoxAspect.isSelected(), dval);
        }
        this.setModified(true);
    }

    void jTextFieldClippingMin_keyReleased(KeyEvent event) {
        RmaJDecimalField jTextField = (RmaJDecimalField)event.getSource();
        double dval = jTextField.getValueUndefined();
        if (dval != Double.NEGATIVE_INFINITY) {
            Clipping clip = this._data.getMinClipping();
            clip.setValue(dval);
            this._data.setModified(true);
            this.setMinClipping(clip);
        }
        this.jPanelColorScale.paintScale();
        this.setModified(true);
    }

    void jTextFieldClippingMax_keyReleased(KeyEvent event) {
        RmaJDecimalField jTextField = (RmaJDecimalField)event.getSource();
        double dval = jTextField.getValueUndefined();
        if (dval != Double.NEGATIVE_INFINITY) {
            Clipping clip = this._data.getMaxClipping();
            clip.setValue(dval);
            this._data.setModified(true);
            this.setMaxClipping(clip);
        }
        this.jPanelColorScale.paintScale();
        this.setModified(true);
    }

    @Override
    public void setModified(boolean modified) {
        super.setModified(modified);
        String title = this.getTitle();
        if (modified && !title.endsWith("*")) {
            this.setTitle(title + "*");
        } else if (!modified && title.endsWith("*")) {
            this.setTitle(this.getTitle().substring(0, title.length() - 1));
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == ElevationGlyphOptionJDlg.this.jButtonClippingColorMin) {
                ElevationGlyphOptionJDlg.this.jButtonClippingColorMin_actionPerformed(event);
            } else if (object == ElevationGlyphOptionJDlg.this.jButtonClippingColorMax) {
                ElevationGlyphOptionJDlg.this.jButtonClippingColorMax_actionPerformed(event);
            } else if (object == ElevationGlyphOptionJDlg.this._comboColorContour) {
                ElevationGlyphOptionJDlg.this.comboColorContour_actionPerformed(event);
            } else if (object == ElevationGlyphOptionJDlg.this.jCheckBoxScaleToClip) {
                ElevationGlyphOptionJDlg.this.jCheckBoxScaleToClip_actionPerformed(event);
            } else if (object == ElevationGlyphOptionJDlg.this.jCheckBoxClippingMax) {
                ElevationGlyphOptionJDlg.this.jCheckBoxClippingMax_actionPerformed(event);
            } else if (object == ElevationGlyphOptionJDlg.this.jCheckBoxDrawEdges) {
                ElevationGlyphOptionJDlg.this.jCheckBoxDrawEdges_actionPerformed(event);
            } else if (object == ElevationGlyphOptionJDlg.this.jCheckBoxAutoContour) {
                ElevationGlyphOptionJDlg.this.jCheckBoxAutoContour_actionPerformed(event);
            } else if (object == ElevationGlyphOptionJDlg.this.jCheckBoxAspect) {
                ElevationGlyphOptionJDlg.this.jCheckBoxAspect_actionPerformed(event);
            } else if (object == ElevationGlyphOptionJDlg.this.jCheckBoxClippingMin) {
                ElevationGlyphOptionJDlg.this.jCheckBoxClippingMin_actionPerformed(event);
            } else if (object == ElevationGlyphOptionJDlg.this.jButtonAdvanced) {
                ElevationGlyphOptionJDlg.this.jButtonAdvanced_actionPerformed(event);
            }
            ElevationGlyphOptionJDlg.this.repaint(10L);
        }
    }

    class SymChange
    implements ChangeListener {
        SymChange() {
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            Object object = event.getSource();
            if (object == ElevationGlyphOptionJDlg.this.jSliderBright) {
                ElevationGlyphOptionJDlg.this.jSliderBright_stateChanged(event);
            } else if (object == ElevationGlyphOptionJDlg.this.jSliderTransparency) {
                ElevationGlyphOptionJDlg.this.jSliderTransparency_stateChanged(event);
            } else if (object == ElevationGlyphOptionJDlg.this.jSliderSat) {
                ElevationGlyphOptionJDlg.this.jSliderSat_stateChanged(event);
            } else if (object == ElevationGlyphOptionJDlg.this.jSliderClippingMin) {
                ElevationGlyphOptionJDlg.this.jSliderClippingMin_stateChanged(event);
            } else if (object == ElevationGlyphOptionJDlg.this.jSliderClippingMax) {
                ElevationGlyphOptionJDlg.this.jSliderClippingMax_stateChanged(event);
            } else if (object == ElevationGlyphOptionJDlg.this.jSliderAspect) {
                ElevationGlyphOptionJDlg.this.jSliderAspect_stateChanged(event);
            }
            ElevationGlyphOptionJDlg.this.repaint(10L);
        }
    }

    class ColorButton
    extends JButton {
        protected Color _color = Color.gray;

        public Color getColor() {
            return this._color;
        }

        public void setColor(Color c2) {
            this._color = c2;
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == ElevationGlyphOptionJDlg.this) {
                ElevationGlyphOptionJDlg.this.ElevationGlyphOptionJDlg_WindowClosing(event);
            }
        }
    }

    class SymKey
    extends KeyAdapter {
        SymKey() {
        }

        @Override
        public void keyReleased(KeyEvent event) {
            if (!Character.isDigit(event.getKeyChar()) && event.getKeyChar() != '-') {
                return;
            }
            Object object = event.getSource();
            if (object == ElevationGlyphOptionJDlg.this.jTextFieldContourLimitMin) {
                ElevationGlyphOptionJDlg.this.jTextFieldContourLimitMin_keyReleased(event);
            } else if (object == ElevationGlyphOptionJDlg.this.jTextFieldContourLimitMax) {
                ElevationGlyphOptionJDlg.this.jTextFieldContourLimitMax_keyReleased(event);
            } else if (object == ElevationGlyphOptionJDlg.this.jTextFieldBright) {
                ElevationGlyphOptionJDlg.this.jTextFieldBright_keyReleased(event);
            } else if (object == ElevationGlyphOptionJDlg.this.jTextFieldTransparency) {
                ElevationGlyphOptionJDlg.this.jTextFieldTransparency_keyReleased(event);
            } else if (object == ElevationGlyphOptionJDlg.this.jTextFieldSat) {
                ElevationGlyphOptionJDlg.this.jTextFieldSat_keyReleased(event);
            } else if (object == ElevationGlyphOptionJDlg.this.jTextFieldAspect) {
                ElevationGlyphOptionJDlg.this.jTextFieldAspect_keyReleased(event);
            } else if (object == ElevationGlyphOptionJDlg.this.jTextFieldClippingMin) {
                ElevationGlyphOptionJDlg.this.jTextFieldClippingMin_keyReleased(event);
            } else if (object == ElevationGlyphOptionJDlg.this.jTextFieldClippingMax) {
                ElevationGlyphOptionJDlg.this.jTextFieldClippingMax_keyReleased(event);
            } else if (object == ElevationGlyphOptionJDlg.this.jTextFieldTicInterval) {
                ElevationGlyphOptionJDlg.this.jTextFieldTicInterval_keyReleased(event);
            }
            ElevationGlyphOptionJDlg.this.repaint(10L);
        }
    }
}

