/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.appInterface.AppDaddy;
import hec.map.WorldRect;
import hec.map.appInterface.MapApplicationFrame;
import hec.map.appInterface.MapWorkspace;
import hec.map.transform.CoordinateInfo;
import hec.map.transform.CoordinateTransformDialog;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTextField;
import rma.util.RMAIO;

public class GeoDialog
extends RmaJDialog {
    protected WorldRect _extents = new WorldRect();
    CoordinateInfo _coordSys = null;
    protected boolean _growToExtents = false;
    protected boolean _canceled = true;
    boolean _showUnitMultiplier = false;
    JPanel panel1;
    JPanel panel3;
    JPanel panel4;
    JPanel panel5;
    JLabel label1;
    JLabel label2;
    JLabel label3;
    JLabel label4;
    JLabel label5;
    JLabel label6;
    protected JCheckBox chkGrowToExtents;
    JButton btnSetCoordinatesToView;
    JTextField txtCoordSystem;
    protected RmaJDecimalField txtExtWest;
    protected RmaJDecimalField txtExtNorth;
    protected RmaJDecimalField txtExtEast;
    protected RmaJDecimalField txtExtSouth;
    JPanel panel2;
    JButton btnCoordSystem;
    ButtonCmdPanel cmdPanel;

    public GeoDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    public GeoDialog(Frame parent, boolean modal, boolean showUnitMultiplier) {
        super(parent, modal);
        this._showUnitMultiplier = showUnitMultiplier;
        this.buildControls();
    }

    protected void buildControls() {
        this.setTitle("Display Coordinate Information");
        Insets extentsLblInsets = new Insets(4, 5, 0, 5);
        Insets extentsInsets = new Insets(4, 0, 0, 2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        this.setVisible(false);
        this.panel1 = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.panel1, gbc);
        this.label1 = new JLabel("Coordinate System:");
        this.label1.setDisplayedMnemonic('C');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 5, 0, 5);
        this.panel1.add((Component)this.label1, gbc);
        this.txtCoordSystem = new RmaJTextField(" ");
        this.txtCoordSystem.setEditable(false);
        this.label1.setLabelFor(this.txtCoordSystem);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 0, 0, 5);
        gbc.ipadx = 120;
        this.panel1.add((Component)this.txtCoordSystem, gbc);
        this.btnCoordSystem = new JButton("Edit...");
        this.btnCoordSystem.setMnemonic('E');
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets = new Insets(7, 0, 0, 2);
        this.panel1.add((Component)this.btnCoordSystem, gbc);
        this.panel2 = new JPanel(new GridBagLayout()){

            @Override
            public void setEnabled(boolean b) {
                super.setEnabled(b);
                Component[] c2 = this.getComponents();
                for (int i = 0; i < c2.length; ++i) {
                    c2[i].setEnabled(b);
                }
            }
        };
        TitledBorder tb = BorderFactory.createTitledBorder("Extents:");
        tb.setTitleFont(new Font("Dialog", 0, 12));
        this.panel2.setBorder(tb);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 5, 5);
        this.getContentPane().add((Component)this.panel2, gbc);
        this.panel3 = new JPanel(new GridBagLayout());
        TitledBorder tb1 = BorderFactory.createTitledBorder("Easting:");
        tb.setTitleFont(new Font("Dialog", 0, 12));
        this.panel3.setBorder(tb1);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 5, 5);
        this.panel2.add((Component)this.panel3, gbc);
        this.label3 = new JLabel("Minimum:");
        this.label3.setDisplayedMnemonic('s');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = extentsLblInsets;
        this.panel3.add((Component)this.label3, gbc);
        this.txtExtWest = new RmaJDecimalField();
        this.label3.setLabelFor(this.txtExtWest);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = extentsInsets;
        this.panel3.add((Component)this.txtExtWest, gbc);
        this.label5 = new JLabel("Maximum:");
        this.label5.setDisplayedMnemonic('M');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = extentsLblInsets;
        this.panel3.add((Component)this.label5, gbc);
        this.txtExtEast = new RmaJDecimalField();
        this.label5.setLabelFor(this.txtExtEast);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = extentsInsets;
        this.panel3.add((Component)this.txtExtEast, gbc);
        this.panel4 = new JPanel(new GridBagLayout());
        TitledBorder tb2 = BorderFactory.createTitledBorder("Northing:");
        tb.setTitleFont(new Font("Dialog", 0, 12));
        this.panel4.setBorder(tb2);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 12;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 5, 5);
        this.panel2.add((Component)this.panel4, gbc);
        this.label6 = new JLabel("Minimum:");
        this.label6.setDisplayedMnemonic('N');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = extentsLblInsets;
        this.panel4.add((Component)this.label6, gbc);
        this.txtExtSouth = new RmaJDecimalField();
        this.label6.setLabelFor(this.txtExtSouth);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = extentsInsets;
        this.panel4.add((Component)this.txtExtSouth, gbc);
        this.label4 = new JLabel("Maximum:");
        this.label4.setDisplayedMnemonic('x');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = extentsLblInsets;
        this.panel4.add((Component)this.label4, gbc);
        this.txtExtNorth = new RmaJDecimalField();
        this.label4.setLabelFor(this.txtExtNorth);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = extentsInsets;
        this.panel4.add((Component)this.txtExtNorth, gbc);
        this.panel5 = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 5, 5);
        this.panel2.add((Component)this.panel5, gbc);
        this.chkGrowToExtents = new JCheckBox("Grow to Map Extents");
        this.chkGrowToExtents.setMnemonic('G');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weighty = 1.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 20, 5, 0);
        this.panel5.add((Component)this.chkGrowToExtents, gbc);
        this.btnSetCoordinatesToView = new JButton("Set Map Coordinates to Display");
        this.btnSetCoordinatesToView.setMnemonic('S');
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weighty = 1.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 0, 5, 5);
        this.panel5.add((Component)this.btnSetCoordinatesToView, gbc);
        this.cmdPanel = new ButtonCmdPanel(12);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 14;
        gbc.insets = new Insets(0, 5, 5, 5);
        gbc.ipadx = 200;
        this.getContentPane().add((Component)this.cmdPanel, gbc);
        this.cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        GeoDialog.this.btnOK_ActionPerformed(e);
                        break;
                    }
                    case 4: {
                        GeoDialog.this.btnCancel_ActionPerformed(e);
                    }
                }
            }
        });
        this.btnSetCoordinatesToView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AppDaddy.getWorkspace() != null) {
                    MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
                    WorldRect ext = frame.getMapPanel().getCurrentExtents();
                    GeoDialog.this.txtExtWest.setValue(ext.w);
                    GeoDialog.this.txtExtNorth.setValue(ext.n);
                    GeoDialog.this.txtExtEast.setValue(ext.e);
                    GeoDialog.this.txtExtSouth.setValue(ext.s);
                }
            }
        });
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this.btnCoordSystem.addActionListener(lSymAction);
        this.addPopupMenu();
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
        this.pack();
        Dimension dim = this.getPreferredSize();
        this.setDefaultSize(dim.width, dim.height);
        this.setLocation();
    }

    private void addPopupMenu() {
        JMenuItem copyMi = new JMenuItem("Copy Extents");
        copyMi.addActionListener(e -> this.copyExtentsToClipboard());
        final JMenuItem pasteMi = new JMenuItem("Paste Extents");
        pasteMi.addActionListener(e -> this.copyExtentsFromClipboard());
        JPopupMenu menu = new JPopupMenu(){

            @Override
            public void setVisible(boolean visible) {
                super.setVisible(visible);
                if (visible) {
                    EventQueue.invokeLater(() -> {
                        pasteMi.setEnabled(GeoDialog.this.getClipboardExtents() != null);
                        pasteMi.revalidate();
                    });
                }
            }
        };
        menu.add(copyMi);
        menu.add(pasteMi);
        this.panel2.setComponentPopupMenu(menu);
        this.panel3.setComponentPopupMenu(menu);
        this.panel4.setComponentPopupMenu(menu);
    }

    private void copyExtentsFromClipboard() {
        String[] extentsArray;
        String extents = this.getClipboardExtents();
        if (extents != null && (extentsArray = extents.split("\n")) != null && extentsArray.length == 5) {
            this.txtExtWest.setValue(RMAIO.parseInt(extentsArray[1]));
            this.txtExtNorth.setValue(RMAIO.parseInt(extentsArray[2]));
            this.txtExtEast.setValue(RMAIO.parseInt(extentsArray[3]));
            this.txtExtSouth.setValue(RMAIO.parseInt(extentsArray[4]));
            this.setModified(true);
        }
    }

    private void copyExtentsToClipboard() {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection s = null;
        StringBuffer buf = new StringBuffer();
        buf.append("Extents:(w,n,e,s)");
        buf.append("\n");
        buf.append(this.txtExtWest.getText().trim());
        buf.append("\n");
        buf.append(this.txtExtNorth.getText().trim());
        buf.append("\n");
        buf.append(this.txtExtEast.getText().trim());
        buf.append("\n");
        buf.append(this.txtExtSouth.getText().trim());
        buf.append("\n");
        s = new StringSelection(buf.toString());
        cb.setContents(s, s);
    }

    private String getClipboardExtents() {
        Clipboard cb = this.getToolkit().getSystemClipboard();
        Transferable t = cb.getContents(this);
        if (t == null) {
            return null;
        }
        String extents = null;
        try {
            extents = (String)t.getTransferData(DataFlavor.stringFlavor);
            if (extents == null || !extents.startsWith("Extents:")) {
                return null;
            }
            System.out.println("getClipboardExtents:extents=" + extents);
        }
        catch (Exception e) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(extents, "\n");
        if (tokenizer.countTokens() != 5) {
            return null;
        }
        return extents;
    }

    void GeoDialog_WindowClosing(WindowEvent event) {
        this.setVisible(false);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            Rectangle bounds = this.getParent().getBounds();
            Rectangle abounds = this.getBounds();
            this.setLocation(bounds.x + (bounds.width - abounds.width) / 2, bounds.y + (bounds.height - abounds.height) / 2);
            this.fillForm();
        }
        super.setVisible(b);
    }

    @Override
    public void clearForm() {
        this._canceled = true;
        this.txtCoordSystem.setText("");
        this.chkGrowToExtents.setSelected(false);
        this.txtExtWest.setText("");
        this.txtExtEast.setText("");
        this.txtExtNorth.setText("");
        this.txtExtSouth.setText("");
    }

    public void fillForm() {
        this.clearForm();
        if (AppDaddy.getWorkspace() == null) {
            return;
        }
        MapWorkspace workspace = (MapWorkspace)AppDaddy.getWorkspace();
        this._growToExtents = workspace.getGrowToExtents();
        CoordinateInfo coordSys = workspace.getCoordSys();
        this._extents = workspace.getExtents();
        this.txtExtWest.setText(RMAIO.toTable((int)this._extents.w));
        this.txtExtEast.setText(RMAIO.toTable((int)this._extents.e));
        this.txtExtNorth.setText(RMAIO.toTable((int)this._extents.n));
        this.txtExtSouth.setText(RMAIO.toTable((int)this._extents.s));
        this.setCoordSys(coordSys);
        this.chkGrowToExtents.setSelected(this._growToExtents);
    }

    public boolean getGrowToExtents() {
        return this._growToExtents;
    }

    public CoordinateInfo getCoordSys() {
        return this._coordSys;
    }

    public WorldRect getExtents() {
        return this._extents;
    }

    public void setGrowToExtents(boolean growToExt) {
        this._growToExtents = growToExt;
    }

    public void setCoordSys(CoordinateInfo coordSystem) {
        if (coordSystem == null) {
            this.txtCoordSystem.setText("");
        } else {
            this.txtCoordSystem.setText(coordSystem.getType());
            this.txtCoordSystem.setCaretPosition(0);
        }
        this._coordSys = coordSystem;
    }

    public void setExtents(WorldRect coordExtents) {
        this._extents = coordExtents;
    }

    void btnCoordSystem_ActionPerformed(ActionEvent event) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        CoordinateTransformDialog cfd = new CoordinateTransformDialog((Dialog)this, true, 0, this._showUnitMultiplier);
        cfd.setCoordinateInfo(this._coordSys);
        this.setCursor(Cursor.getDefaultCursor());
        cfd.setVisible(true);
        if (cfd.wasCanceled()) {
            return;
        }
        this.setCoordSys(cfd.getCoordinateInfo());
    }

    protected void btnOK_ActionPerformed(ActionEvent event) {
        this._extents.w = RMAIO.parseDouble(this.txtExtWest.getText());
        this._extents.e = RMAIO.parseDouble(this.txtExtEast.getText());
        this._extents.n = RMAIO.parseDouble(this.txtExtNorth.getText());
        this._extents.s = RMAIO.parseDouble(this.txtExtSouth.getText());
        this._growToExtents = this.chkGrowToExtents.isSelected();
        MapWorkspace workspace = (MapWorkspace)AppDaddy.getWorkspace();
        workspace.setGrowToExtents(this._growToExtents);
        workspace.setExtents(this._extents);
        workspace.setCoordSys(this._coordSys);
        this._canceled = false;
        this.setVisible(false);
    }

    void btnCancel_ActionPerformed(ActionEvent event) {
        this._canceled = true;
        this.setVisible(false);
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == GeoDialog.this) {
                GeoDialog.this.GeoDialog_WindowClosing(event);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == GeoDialog.this.btnCoordSystem) {
                GeoDialog.this.btnCoordSystem_ActionPerformed(event);
            }
        }
    }
}

