/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.appInterface.FileOpener;
import hec.io.AsciiDeserializer;
import hec.io.AsciiSerializable;
import hec.io.Identifier;
import hec.lang.Logger;
import hec.lang.NamedType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import rma.util.RMAIO;

public abstract class GlyphDataRecord
extends NamedType
implements Cloneable,
Serializable,
AsciiSerializable {
    static final long serialVersionUID = -2425705594451710611L;
    public static final String GDR_EXTENSION = ".gdr";
    boolean _showLegend = false;

    public void setMap(Collection maps) {
    }

    public boolean getShowLegend() {
        return this._showLegend;
    }

    public void setShowLegend(boolean tf) {
        this._showLegend = tf;
    }

    @Override
    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
            GlyphDataRecord glyphDataRecord = (GlyphDataRecord)clone;
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return clone;
    }

    public void read(BufferedReader input) throws IOException {
        boolean debug = Logger.canDebug("maps");
        String line = input.readLine();
        while (line != null && line.indexOf("GlyphDataRecordEnd") < 0) {
            String type = RMAIO.getType(line, "=");
            String param = RMAIO.getParam(line, "=");
            if (type.compareTo("ShowLegend") == 0) {
                this._showLegend = Boolean.valueOf(param);
            } else {
                this.read0(type, param, input);
            }
            line = input.readLine();
            if (!debug) continue;
            System.out.println(line);
        }
    }

    public void write(BufferedWriter output) throws IOException {
        String stringClass = this.getClass().getName();
        output.write("Class=" + stringClass);
        output.newLine();
        output.write("ShowLegend=" + this._showLegend);
        output.newLine();
        this.write0(output);
    }

    protected abstract void read0(String var1, String var2, BufferedReader var3) throws IOException;

    protected abstract void write0(BufferedWriter var1) throws IOException;

    public boolean useAsciiSerialization() {
        return false;
    }

    public boolean readAsciiSerialized(String mapFileFullPath, FileOpener fileOpener) {
        if (!RMAIO.isFullPath(mapFileFullPath)) {
            return false;
        }
        int dot = mapFileFullPath.lastIndexOf(46);
        if (dot < 1) {
            return false;
        }
        String gdrFileFullPath = mapFileFullPath.substring(0, dot) + GDR_EXTENSION;
        Identifier fileRequest = new Identifier(gdrFileFullPath);
        Identifier asciiSerializedId = fileOpener.openFile(fileRequest, true);
        if (asciiSerializedId == null || asciiSerializedId.getFile() == null) {
            return false;
        }
        BufferedReader in = asciiSerializedId.getFile().getBufferedReader();
        AsciiDeserializer ad = new AsciiDeserializer(in);
        ad.deserializeObject(this);
        return true;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

