/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.data.Parameter;
import hec.data.Units;
import hec.io.AsciiSerializable;
import hec.map.ElevationGlyphDataRecord;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;

public class GridGlyphDataRecord
extends ElevationGlyphDataRecord
implements Cloneable,
Serializable,
AsciiSerializable {
    private int _paramId = Parameter.PARAMID_PRECIP;
    private int _unitSys = 2;

    public GridGlyphDataRecord() {
        this._ticInterval = Double.NEGATIVE_INFINITY;
    }

    @Override
    protected void read0(String type, String param, BufferedReader input) throws IOException {
        super.read0(type, param, input);
    }

    @Override
    protected void write0(BufferedWriter output) throws IOException {
        super.write0(output);
    }

    @Override
    public int getParamId() {
        return this._paramId;
    }

    public void setParamId(int paramId) {
        this._paramId = paramId;
    }

    @Override
    public int getUnitSystem() {
        return this._unitSys;
    }

    @Override
    public void setUnits(String units) {
        super.setUnits(units);
        Parameter param = Parameter.getParameterForUnitsString(units);
        this._paramId = param != null ? param.getParameterId() : -1;
        this._unitSys = Units.getUnitSystemForUnits(units);
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

