/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.IconGlyph;
import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.MapCanvas;
import hec.map.MapMouseAdapter;
import hec.map.MapPanel;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.model.IconNode;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.List;

public abstract class IconMouseAdapter
extends MapMouseAdapter {
    protected IconGlyph _sysglyph;
    LocalPt _pt = new LocalPt();
    LocalPt _offsetPt = new LocalPt(0, 0);
    LocalPt _selectedPt = null;
    WorldPt _selectedWPt = null;
    LocalRect _lrc = new LocalRect();
    WorldRect _wrc = new WorldRect();
    boolean _editingRegion = false;
    IconNode _node = null;
    boolean _poppingUp = false;

    public IconMouseAdapter(MapPanel panel, MapCanvas canvas) {
        super(panel, canvas);
    }

    @Override
    public void init() {
        this.findSystemGlyph();
    }

    @Override
    public void abort() {
        this.findSystemGlyph();
        if (this._sysglyph != null) {
            this._sysglyph.clearSelection();
        }
        this._node = null;
    }

    protected abstract String getManagerClassname();

    boolean findSystemGlyph() {
        this._sysglyph = null;
        this._sysglyph = (IconGlyph)((Object)this._mapPanel.findGlyphOfClass(this.getManagerClassname()));
        if (this._sysglyph == null) {
            // empty if block
        }
        return this._sysglyph != null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this._poppingUp = false;
        if (e.isPopupTrigger() || IconMouseAdapter.pressedButton3(e)) {
            if (!this.findSystemGlyph()) {
                return;
            }
            this._pt.init(e.getX(), e.getY());
            boolean add = false;
            IconNode node = null;
            if (e.isShiftDown()) {
                node = this._sysglyph.selectNode(this._pt, e.isShiftDown(), false);
            } else {
                List<IconNode> v;
                node = this._sysglyph.findNode(this._pt);
                if (node != null && !(v = this._sysglyph.getSelectedObjects()).contains(node)) {
                    this._sysglyph.clearSelection();
                    this._sysglyph.selectNode(node, false, false);
                }
            }
            if (node != null) {
                this._mapPanel.waitforPaintComplete();
            }
            this._editingRegion = false;
            this._node = node;
            LocalPt pt = new LocalPt(e.getX(), e.getY());
            this._poppingUp = true;
            this._sysglyph.nodePopupMenu(pt, node);
        } else if (this._editingRegion && this._node != null) {
            System.out.println("mousePressed: editing node " + this._node.toString());
            this._pt.init(e.getX(), e.getY());
            LocalPt lpt = new LocalPt();
            WorldPt wpt = this._node.getLocation();
            this._mapPanel.scale().wp2lp(wpt, lpt);
            int[] size = this._sysglyph.getIconWidthAndHeight(this._node.getIconName(), this._sysglyph.getIconOverrideSize());
            this._lrc.init(this._pt.x - size[0] / 2, this._pt.y - size[1] / 2, this._pt.x + size[0] / 2, this._pt.y + size[1] / 2);
            if (this._lrc.contains(lpt)) {
                this._selectedPt = lpt;
                this._selectedWPt = wpt;
                this._offsetPt = lpt.offset(this._pt);
            } else {
                this._node = this._sysglyph.selectNode(this._pt, false, false);
                this._editingRegion = false;
                this._offsetPt = new LocalPt(0, 0);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this._editingRegion) {
            this._mapPanel.paintMap();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this._poppingUp) {
            return;
        }
        if (this._selectedPt != null && this._node != null && this._editingRegion) {
            this.drawNode(this._node, true);
            LocalPt pt = new LocalPt(e.getX(), e.getY());
            this._selectedPt.init(this._offsetPt.offset(pt));
            this._mapPanel.scale().lp2wp(this._selectedPt, this._selectedWPt);
            this.drawNode(this._node, true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this._poppingUp) {
            return;
        }
        if (e.isControlDown()) {
            if (!this.findSystemGlyph()) {
                return;
            }
            if (!this._sysglyph.isWriteLocked()) {
                return;
            }
            this._pt.init(e.getX(), e.getY());
            this._node = this._sysglyph.createNode(this._pt);
        } else if (e.getClickCount() == 2) {
            if (!this.findSystemGlyph()) {
                return;
            }
            this._pt.init(e.getX(), e.getY());
            IconNode node = this._sysglyph.selectNode(this._pt, false, false);
            if (node != null) {
                this._sysglyph.defaultMouseAction(node);
            }
        } else if (!this._editingRegion) {
            if (!this.findSystemGlyph()) {
                return;
            }
            this._pt.init(e.getX(), e.getY());
            boolean add = false;
            if (e.isShiftDown()) {
                add = true;
            }
            IconNode node = this._sysglyph.selectNode(this._pt, add, false);
            this._editingRegion = false;
            this._node = node;
        }
    }

    public void moveMode(String nodeName) {
        if (!this.findSystemGlyph()) {
            return;
        }
        if (!this._sysglyph.isWriteLocked()) {
            return;
        }
        IconNode node = this._sysglyph.selectNode(nodeName, false, true);
        this._editingRegion = node != null;
        this._node = node;
    }

    void drawNode(IconNode node, boolean isXOR) {
        if (this._sysglyph == null || node == null) {
            return;
        }
        Graphics g = this._mapCanvas.getGraphics();
        this._sysglyph.drawSelectedNode(g, this._mapPanel.scale(), node, isXOR, this._editingRegion);
        g.dispose();
    }
}

