/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.GlyphDataRecord;
import hec.map.JLayerSelectionParent;
import hec.map.JLayerSelectorTreePanel;
import hec.map.LayerSelectionAction;
import hec.map.MapGlyph;
import hec.map.MapIdentifier;
import hec.map.MapObjectInterface;
import hec.map.MapPanel;
import hec.map.ModelDrawingAttributeSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.function.Predicate;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import rma.util.RMAIO;

public abstract class JLayerSelection
extends JPanel
implements Observer,
ActionListener {
    public static final String NEW_GLYPH_DATA_RECORD = "NewGlyphDataRecord";
    protected static final String MOVE_TO_TOP = "Move To Top";
    protected static final String MOVE_UP = "Move Up";
    protected static final String MOVE_DOWN = "Move Down";
    protected static final String MOVE_TO_BOTTOM = "Move To Bottom";
    protected static final String MOVE_MENUITEM = "Move MenuItem";
    private static Map<Class, List<LayerSelectionAction>> _popupActions = new HashMap<Class, List<LayerSelectionAction>>();
    protected JCheckBox _layerShown;
    protected JLabel _layerName;
    protected JPanel _extraPanel;
    protected boolean _moveableInList = true;
    protected SymMouse _aSymMouse = null;
    protected SymItem _lSymItem = null;
    protected MapGlyph _glyph = null;
    protected GlyphDataRecord _copyOfData = null;
    protected MapPanel _mapPanel = null;
    protected JFrame _parentFrame = null;
    protected JLayerSelectionParent _parent = null;
    protected JPopupMenu _popupMenu = null;
    protected JMenuItem _legendMenuItem = null;
    protected JLayerSelectorTreePanel.JLayerSelectionNode _treeNode;
    protected JMenuItem _moveToTopMenu;
    protected JMenuItem _moveUpMenu;
    protected JMenuItem _moveDownMenu;
    protected JMenuItem _moveToBottomMenu;
    protected JMenuItem _expandMenuItem = null;
    protected JMenuItem _collapseMenuItem = null;
    private JMenuItem _propsMenuItem;
    Predicate<JLayerSelection> canMoveUpMenuEnabledRule = new DefaultCanMoveUpMenuEnabledRule();
    Predicate<JLayerSelection> canMoveDownMenuEnabledRule = new DefaultCanMoveDownMenuEnabledRule();

    public JLayerSelection(JLayerSelectionParent parent, JFrame parentFrame, MapPanel mapPanel, MapGlyph glyph) {
        this();
        this.setGlyph(glyph);
        this._mapPanel = mapPanel;
        this._parent = parent;
        this._parentFrame = parentFrame;
    }

    public JLayerSelection() {
        Insets insets0000 = new Insets(0, 0, 0, 0);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this._layerShown = new JCheckBox("");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = insets0000;
        this.add((Component)this._layerShown, gbc);
        this._layerName = new JLabel("Label");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = insets0000;
        this.add((Component)this._layerName, gbc);
        this._extraPanel = new JPanel(new BorderLayout(0, 0));
        this._extraPanel.setVisible(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = insets0000;
        this.add((Component)this._extraPanel, gbc);
        this._lSymItem = new SymItem();
        this._aSymMouse = new SymMouse();
        this._layerShown.addItemListener(this._lSymItem);
        this._layerName.addMouseListener(this._aSymMouse);
    }

    @Override
    public void requestFocus() {
        this._layerShown.requestFocus();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof GlyphDataRecord) {
            this.refresh();
            this._parent.setModifiedLayerSelection(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj instanceof JMenuItem) {
            JMenuItem menuitem = (JMenuItem)obj;
            if (menuitem.getText() == null) {
                return;
            }
            if (menuitem.getText().equals("Properties...")) {
                this.showOptionDialog();
            } else if (menuitem.getText().equals("Change Label")) {
                this.showLabelEditor();
            } else if (menuitem.getText().equals(MOVE_UP)) {
                this._parent.moveCurrentLayerUp();
            } else if (menuitem.getText().equals(MOVE_TO_TOP)) {
                this._parent.moveCurrentLayerTop();
            } else if (menuitem.getText().equals(MOVE_TO_BOTTOM)) {
                this._parent.moveCurrentLayerBottom();
            } else if (menuitem.getText().equals(MOVE_DOWN)) {
                this._parent.moveCurrentLayerDown();
            } else if (menuitem.getText().equals("Expand")) {
                this._parent.expand();
            } else if (menuitem.getText().equals("Collapse")) {
                this._parent.collapse();
            } else if (menuitem.getText().equals("Show Legend")) {
                this.displayLegend(true);
                this._parent.setLegendVisible(this._treeNode, true);
            } else if (menuitem.getText().equals("Hide Legend")) {
                this.displayLegend(false);
                this._parent.setLegendVisible(this._treeNode, false);
            }
            if (this._parentFrame != null) {
                this._parentFrame.repaint();
            }
            this._parent.repaint();
            this.repaint();
        }
    }

    protected void displayLegend(boolean tf) {
        if (!this.hasLegend()) {
            return;
        }
        this._extraPanel.setVisible(tf);
        if (tf) {
            this._legendMenuItem.setText("Hide Legend");
        } else {
            this._legendMenuItem.setText("Show Legend");
        }
        if (this._copyOfData != null) {
            this._copyOfData.setShowLegend(tf);
        }
    }

    public boolean canAddLayer() {
        return false;
    }

    public Object addLayer() {
        return null;
    }

    protected boolean allowScaleAdjustment() {
        return false;
    }

    public boolean hasLegend() {
        return this._extraPanel.getComponentCount() > 0;
    }

    protected boolean hasChangableLabel() {
        return true;
    }

    protected void showLabelEditor() {
        String s = (String)JOptionPane.showInputDialog(this._parentFrame, "Input New Label", "Change Label", 3, null, null, this._layerName.getText());
        if (s != null) {
            this.setName(s);
            this._parent.setModifiedLayerSelection(this);
            this._parent.nodeChanged(this);
        }
    }

    protected void addOptionsPopupMenu() {
        JMenuItem mitem;
        this._popupMenu = new JPopupMenu();
        boolean hasExpandCollapse = true;
        if (this._treeNode != null) {
            boolean bl = hasExpandCollapse = this._treeNode.getChildCount() > 0;
        }
        if (hasExpandCollapse && !Boolean.getBoolean("MapLayerNode.NoExpandCollapse")) {
            this._expandMenuItem = new JMenuItem("Expand");
            this._popupMenu.add(this._expandMenuItem);
            this._expandMenuItem.addActionListener(this);
            this._collapseMenuItem = new JMenuItem("Collapse");
            this._popupMenu.add(this._collapseMenuItem);
            this._collapseMenuItem.addActionListener(this);
            this._popupMenu.addSeparator();
        }
        this._moveToTopMenu = new JMenuItem(MOVE_TO_TOP);
        this._moveToTopMenu.setName(MOVE_MENUITEM);
        this._moveToTopMenu.addActionListener(this);
        this._moveUpMenu = new JMenuItem(MOVE_UP);
        this._moveUpMenu.setName(MOVE_MENUITEM);
        this._moveUpMenu.addActionListener(this);
        this._moveDownMenu = new JMenuItem(MOVE_DOWN);
        this._moveDownMenu.setName(MOVE_MENUITEM);
        this._moveDownMenu.addActionListener(this);
        this._moveToBottomMenu = new JMenuItem(MOVE_TO_BOTTOM);
        this._moveToBottomMenu.setName(MOVE_MENUITEM);
        this._moveToBottomMenu.addActionListener(this);
        if (this.isMovableInList()) {
            this._popupMenu.add(this._moveToTopMenu);
            this._popupMenu.add(this._moveUpMenu);
            this._popupMenu.add(this._moveDownMenu);
            this._popupMenu.add(this._moveToBottomMenu);
        }
        boolean addedSep = false;
        if (this.hasLegend()) {
            this._popupMenu.addSeparator();
            this._legendMenuItem = new JMenuItem("Show Legend");
            this._popupMenu.add(this._legendMenuItem);
            this._legendMenuItem.addActionListener(this);
            addedSep = true;
        }
        if (this.hasChangableLabel()) {
            if (!addedSep) {
                this._popupMenu.addSeparator();
                addedSep = true;
            }
            mitem = new JMenuItem("Change Label");
            this._popupMenu.add(mitem);
            mitem.addActionListener(this);
        }
        if (this.hasOptionDialog()) {
            if (!addedSep) {
                this._popupMenu.addSeparator();
                addedSep = true;
            }
            this.createPropertiesMenu(this._popupMenu);
        }
        if (this.allowScaleAdjustment()) {
            this._popupMenu.addSeparator();
            mitem = new JMenuItem("Set Scale for Zoom-in");
            this._popupMenu.add(mitem);
            mitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    double scale = JLayerSelection.this._mapPanel.viewport().computeMapScale();
                    JLayerSelection.this._glyph.setMaximumScale((int)scale);
                    System.out.println("Setting Maximum Scale " + scale);
                    JLayerSelection.this._mapPanel.paintMap();
                }
            });
            mitem = new JMenuItem("Set Scale for Zoom-out");
            this._popupMenu.add(mitem);
            mitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    double scale = JLayerSelection.this._mapPanel.viewport().computeMapScale();
                    JLayerSelection.this._glyph.setMinimumScale((int)scale);
                    System.out.println("Setting Minimum Scale " + scale);
                    JLayerSelection.this._mapPanel.paintMap();
                }
            });
            mitem = new JMenuItem("Remove Scale Factors");
            this._popupMenu.add(mitem);
            mitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JLayerSelection.this._glyph.setMaximumScale(Integer.MAX_VALUE);
                    JLayerSelection.this._glyph.setMinimumScale(Integer.MIN_VALUE);
                    JLayerSelection.this._mapPanel.paintMap();
                }
            });
        }
        this.addActionsToPopup(this._popupMenu);
        this.add(this._popupMenu);
    }

    public void cleanUp() {
    }

    protected void addActionsToPopup(JPopupMenu popupMenu) {
        if (this._glyph == null) {
            return;
        }
        MapObjectInterface mapObject = this._glyph.getMap();
        Class<?> cls = mapObject.getClass();
        do {
            List<LayerSelectionAction> actions;
            if ((actions = _popupActions.get(cls)) == null) continue;
            for (int i = 0; i < actions.size(); ++i) {
                LayerSelectionAction action = actions.get(i);
                if (action == null || (action = action.clone()) == null) continue;
                action.setJLayerSelection(this);
                popupMenu.add(action);
            }
        } while ((cls = cls.getSuperclass()) != null);
    }

    public static void addActionForClass(Class cls, LayerSelectionAction action) {
        if (cls == null || action == null) {
            return;
        }
        List<LayerSelectionAction> actionList = _popupActions.get(cls);
        if (actionList == null) {
            actionList = new ArrayList<LayerSelectionAction>();
            _popupActions.put(cls, actionList);
        }
        actionList.add(action);
    }

    protected void createPropertiesMenu(JPopupMenu menu) {
        this._propsMenuItem = new JMenuItem("Properties...");
        menu.add(this._propsMenuItem);
        this._propsMenuItem.addActionListener(this);
    }

    public JPanel getLegendPanel() {
        return this._extraPanel;
    }

    public abstract boolean hasOptionDialog();

    public abstract void showOptionDialog();

    public abstract void closeOptionDialog();

    public void updateGlyph() {
        this._glyph.setDataRecord(this._copyOfData);
        this.setGlyph(this._glyph);
    }

    public MapGlyph getGlyph() {
        return this._glyph;
    }

    public void setGlyph(MapGlyph g) {
        GlyphDataRecord data;
        this._glyph = g;
        if (this._copyOfData != null) {
            this._copyOfData.deleteObserver(this);
            this._copyOfData = null;
        }
        GlyphDataRecord glyphDataRecord = data = this._glyph != null ? this._glyph.getDataRecord() : null;
        if (data != null) {
            this._copyOfData = (GlyphDataRecord)data.clone();
            this._copyOfData.addObserver(this);
        }
    }

    public GlyphDataRecord getDataRecord() {
        return this._copyOfData;
    }

    public void setDataRecord(GlyphDataRecord data) {
        GlyphDataRecord tempData = this._copyOfData;
        this._copyOfData = data;
        this.firePropertyChange(NEW_GLYPH_DATA_RECORD, null, this._copyOfData);
    }

    public void setSelected(boolean tf) {
        if (tf) {
            this._layerShown.setForeground(Color.black);
            this._layerName.setForeground(Color.blue);
            this._parent.setCurrentLayer(this);
        } else {
            this._layerShown.setForeground(Color.black);
            this._layerName.setForeground(Color.black);
        }
    }

    public void refresh() {
        String name;
        MapObjectInterface moi;
        if (this._glyph == null) {
            return;
        }
        boolean shown = this._glyph.isShown();
        if (this._lSymItem != null) {
            this._layerShown.removeItemListener(this._lSymItem);
        }
        this.setLayerShown(shown);
        if (this._lSymItem != null) {
            this._layerShown.addItemListener(this._lSymItem);
        }
        if ((moi = this._glyph.getMap()) != null && (name = moi.getMapIdentifier().getName()) != null) {
            name = RMAIO.trimToFilename(name);
            this.setName(name);
        }
        if (this._copyOfData != null && this.hasLegend()) {
            boolean tf = this._copyOfData.getShowLegend();
            this.displayLegend(tf);
        }
        this._parent.repaint();
        this.repaint();
    }

    @Override
    public void setVisible(boolean tf) {
        super.setVisible(tf);
        this.refresh();
    }

    @Override
    public void setName(String name) {
        this._layerName.setText(name);
    }

    @Override
    public String getName() {
        return this._layerName != null ? this._layerName.getText() : "";
    }

    public void setLayerShown(boolean tf) {
        if (this._glyph.isShown() != tf) {
            this._glyph.setShown(tf);
        }
    }

    public boolean getLayerShown() {
        return this._glyph.isShown();
    }

    public int getLayerMaximumScale() {
        return this._glyph.getMaximumScale();
    }

    public int getLayerMinimumScale() {
        return this._glyph.getMinimumScale();
    }

    public JLayerSelectorTreePanel.JLayerSelectionNode getTreeNode() {
        return this._treeNode;
    }

    public void setTreeNode(JLayerSelectorTreePanel.JLayerSelectionNode node) {
        ModelDrawingAttributeSet aset;
        this._treeNode = node;
        if (this._treeNode == null) {
            return;
        }
        boolean showExpandCollapse = false;
        MapIdentifier mapId = this.getGlyph().getMap().getMapIdentifier();
        if ((mapId.isManager() || mapId.isBackground()) && (aset = this.getGlyph().getAttributeSet()) != null) {
            List<String> assetNames = aset.getAttributeNames();
            boolean bl = showExpandCollapse = assetNames != null && assetNames.size() > 0;
        }
        if (this.hasLegend()) {
            showExpandCollapse = true;
        }
        if (this._expandMenuItem != null) {
            this._expandMenuItem.setVisible(showExpandCollapse);
        }
        if (this._collapseMenuItem != null) {
            this._collapseMenuItem.setVisible(showExpandCollapse);
        }
    }

    public void mouseClicked(MouseEvent e) {
        this._aSymMouse.mouseClicked(e);
    }

    public void attributeMouseClicked(MouseEvent e, ModelDrawingAttributeSet as, String attribute) {
    }

    public void setCanMoveUpMenuEnabledRule(Predicate<JLayerSelection> rule) {
        this.canMoveUpMenuEnabledRule = rule;
    }

    public void setCanMoveDownMenuEnabledRule(Predicate<JLayerSelection> rule) {
        this.canMoveDownMenuEnabledRule = rule;
    }

    private static TreeNode getTreeNodeChildAt(TreeNode parent, int index) {
        if (parent == null || index < 0 || index >= parent.getChildCount()) {
            return null;
        }
        return parent.getChildAt(index);
    }

    public void layerShownItemStateChanged(ItemEvent event) {
        this._parent.setModifiedLayerSelection(this);
        this.setSelected(true);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void setIsMovableInList(boolean isMovable) {
        this._moveableInList = isMovable;
        this.updatePopupMenu();
    }

    public boolean isMovableInList() {
        return this._moveableInList;
    }

    public boolean isRemovable() {
        return true;
    }

    protected void updatePopupMenu() {
        if (this._popupMenu == null) {
            return;
        }
        Component[] comps = this._popupMenu.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            JMenuItem menuItem;
            if (!(comps[i] instanceof JMenuItem) || (menuItem = (JMenuItem)comps[i]).getName() == null || !menuItem.getName().equals(MOVE_MENUITEM)) continue;
            menuItem.setVisible(this._moveableInList);
        }
    }

    public class SymMouse
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            JLayerSelection.this.setSelected(true);
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() >= 2) {
                JLayerSelection.this.showOptionDialog();
            }
            if (SwingUtilities.isRightMouseButton(e) && JLayerSelection.this._popupMenu != null) {
                int x = e.getX();
                int y = e.getY();
                if (JLayerSelection.this._legendMenuItem != null) {
                    if (JLayerSelection.this._parent.isExpanded(JLayerSelection.this._treeNode)) {
                        JLayerSelection.this._legendMenuItem.setText("Hide Legend");
                    } else {
                        JLayerSelection.this._legendMenuItem.setText("Show Legend");
                    }
                }
                if (JLayerSelection.this._popupMenu.getComponentCount() > 0) {
                    boolean locked = JLayerSelection.this._parent.isConfigurationLocked();
                    if (JLayerSelection.this._moveToTopMenu != null) {
                        JLayerSelection.this._moveToTopMenu.setEnabled(locked);
                    }
                    if (JLayerSelection.this._moveUpMenu != null) {
                        JLayerSelection.this._moveUpMenu.setEnabled(locked);
                    }
                    if (JLayerSelection.this._moveDownMenu != null) {
                        JLayerSelection.this._moveDownMenu.setEnabled(locked);
                    }
                    if (JLayerSelection.this._moveToBottomMenu != null) {
                        JLayerSelection.this._moveToBottomMenu.setEnabled(locked);
                    }
                    if (JLayerSelection.this._propsMenuItem != null) {
                        JLayerSelection.this._propsMenuItem.setEnabled(JLayerSelection.this._glyph.isShown());
                        if (JLayerSelection.this._glyph.isShown()) {
                            JLayerSelection.this._propsMenuItem.setToolTipText("");
                        } else {
                            JLayerSelection.this._propsMenuItem.setToolTipText("Activate Layer to Edit its Properties");
                        }
                    }
                    if (locked && JLayerSelection.this._treeNode != null && JLayerSelection.this._treeNode.getParent() != null) {
                        boolean canMoveUp = JLayerSelection.this.canMoveUpMenuEnabledRule.test(JLayerSelection.this);
                        boolean canMoveDown = JLayerSelection.this.canMoveDownMenuEnabledRule.test(JLayerSelection.this);
                        JLayerSelection.this._moveToTopMenu.setEnabled(canMoveUp);
                        JLayerSelection.this._moveUpMenu.setEnabled(canMoveUp);
                        JLayerSelection.this._moveToBottomMenu.setEnabled(canMoveDown);
                        JLayerSelection.this._moveDownMenu.setEnabled(canMoveDown);
                    }
                    JLayerSelection.this._popupMenu.show((Component)e.getSource(), x, y);
                }
            }
        }
    }

    public class SymItem
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent event) {
            Object object = event.getSource();
            if (object instanceof JCheckBox) {
                JLayerSelection.this.layerShownItemStateChanged(event);
            }
        }
    }

    public static class DefaultCanMoveUpMenuEnabledRule
    implements Predicate<JLayerSelection> {
        @Override
        public boolean test(JLayerSelection selection) {
            int firstChildIdx;
            if (selection._treeNode == null) {
                return true;
            }
            TreeNode parentNode = selection._treeNode.getParent();
            TreeNode firstChildNode = JLayerSelection.getTreeNodeChildAt(parentNode, firstChildIdx = 0);
            return firstChildNode != selection._treeNode;
        }
    }

    public static class DefaultCanMoveDownMenuEnabledRule
    implements Predicate<JLayerSelection> {
        @Override
        public boolean test(JLayerSelection selection) {
            int lastChildIdx;
            if (selection._treeNode == null) {
                return true;
            }
            TreeNode parentNode = selection._treeNode.getParent();
            TreeNode lastChildNode = JLayerSelection.getTreeNodeChildAt(parentNode, lastChildIdx = parentNode.getChildCount() - 1);
            return lastChildNode != selection._treeNode;
        }
    }
}

