/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.appInterface.AppDaddy;
import hec.appInterface.Workspace;
import hec.map.JLayerSelectorTreePanel;
import hec.map.MapPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaJFrame;
import rma.util.RMAIO;

public class JLayerSelector
extends RmaJFrame {
    protected JLayerSelectorTreePanel _layersPanel;
    protected ButtonCmdPanel cmdPanel;
    protected boolean _onTop;

    public JLayerSelector(JFrame parent, boolean modal, MapPanel panel) {
        this(parent, modal);
        this.createLayersPanel(parent, panel);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
    }

    public JLayerSelector(JFrame parent, boolean modal) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        this.setLocation();
        this.updateTitle();
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Component c2 = SwingUtilities.findFocusOwner(JLayerSelector.this._layersPanel);
                if (c2 != null) {
                    JLayerSelector.this._layersPanel.moveSelectionUp();
                }
            }
        }, KeyStroke.getKeyStroke(38, 0, true), 1);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Component c2 = SwingUtilities.findFocusOwner(JLayerSelector.this._layersPanel);
                if (c2 != null) {
                    JLayerSelector.this._layersPanel.moveSelectionDown();
                }
            }
        }, KeyStroke.getKeyStroke(40, 0, true), 1);
        Dimension dem = new Dimension();
        this.setMinimumSize(this.getPreferredSize());
    }

    protected void writeLayersConfiguration() {
    }

    protected void setLocation(String loc) {
        int y;
        int x;
        Dimension size;
        Rectangle screenSize;
        if (loc != null && (screenSize = new Rectangle(size = Toolkit.getDefaultToolkit().getScreenSize())).contains(x = RMAIO.parseInt(RMAIO.getType(loc, ",")), y = RMAIO.parseInt(RMAIO.getParam(loc, ",")))) {
            this.setLocation(x, y);
        }
    }

    protected void setSize(String windowSize) {
        if (windowSize != null) {
            int height;
            int width;
            Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
            Rectangle screenSize = new Rectangle(size);
            if (!screenSize.contains(new Rectangle(width = (int)RMAIO.parseDouble(RMAIO.getType(windowSize, ","), -1.0), height = (int)RMAIO.parseDouble(RMAIO.getParam(windowSize, ","), -1.0)))) {
                return;
            }
            if (width > -1 && height > -1) {
                this.setSize(width, height);
            }
        }
    }

    @Override
    public void enterKeyPressed() {
        Component c2 = SwingUtilities.findFocusOwner(this._layersPanel);
        if (c2 != null) {
            this._layersPanel.ok();
        }
    }

    @Override
    public void escapeKeyPressed() {
        Component c2 = SwingUtilities.findFocusOwner(this._layersPanel);
        if (c2 != null) {
            this._layersPanel.cancel();
        }
    }

    public void cancel() {
        this._layersPanel.cancel();
    }

    public void ok() {
        this._layersPanel.ok();
    }

    protected JLayerSelectorTreePanel createTreePanel(MapPanel panel) {
        return new JLayerSelectorTreePanel(this, this, this, true, panel);
    }

    protected void createLayersPanel(JFrame parent, MapPanel panel) {
        this._layersPanel = this.createTreePanel(panel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 2.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        this.getContentPane().add((Component)this._layersPanel, gbc);
        this.cmdPanel = new ButtonCmdPanel(14);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 0);
        this.getContentPane().add((Component)this.cmdPanel, gbc);
        this.cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        JLayerSelector.this._layersPanel.ok();
                        break;
                    }
                    case 2: {
                        JLayerSelector.this._layersPanel.apply();
                        break;
                    }
                    case 4: {
                        JLayerSelector.this._layersPanel.cancel();
                    }
                }
            }
        });
    }

    public void setMapPanel(MapPanel p) {
        this._layersPanel.setMapPanel(p);
    }

    void JLayerSelector_WindowClose(WindowEvent event) {
        int opt;
        if (this.isModified() && (opt = JOptionPane.showConfirmDialog(this, "Layer settings have changed. Save Changes?", "Save Changes", 0)) == 0) {
            this._layersPanel.ok();
            return;
        }
        this._layersPanel.cancel();
    }

    public void closeChildDialogs() {
        this._layersPanel.closeChildDialogs();
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            if (!this._layersPanel.canOpen()) {
                return;
            }
            this._layersPanel.addMapListener();
            this._layersPanel.setMenuState(null);
            this._layersPanel.modeChanged();
        } else {
            this._layersPanel.closing();
            this.writeLayersConfiguration();
        }
        super.setVisible(b);
        if (b) {
            if (this._onTop) {
                this._layersPanel.setAlwaysOnTop(this._onTop);
            }
            Dimension size = this.getSize();
            this.setSize(size.width, size.height);
        }
    }

    public void modeChanged() {
        this._layersPanel.modeChanged();
    }

    public void updateTitle() {
        Workspace wksp = AppDaddy.getWorkspace();
        if (wksp != null) {
            this.setTitle("Layer Selector - " + wksp.getTitleName());
        } else {
            this.setTitle("Layer Selector");
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == JLayerSelector.this) {
                JLayerSelector.this.JLayerSelector_WindowClose(event);
            }
        }
    }
}

