/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.appInterface.AppDaddy;
import hec.appInterface.ApplicationFrame;
import hec.appInterface.ToolBarButtonManager;
import hec.event.AttributeChangedListener;
import hec.event.MapGlyphListener;
import hec.map.AttributeInfo;
import hec.map.GeoDialog;
import hec.map.JLayerSelection;
import hec.map.JLayerSelectionParent;
import hec.map.LayerSelectionEvent;
import hec.map.LayerSelectionEventListener;
import hec.map.LayerSelectionFactory;
import hec.map.MapGlyph;
import hec.map.MapIdentifier;
import hec.map.MapObjectInterface;
import hec.map.MapPanel;
import hec.map.MapPosition;
import hec.map.ModelDrawingAttributeSet;
import hec.map.ToolBarButtonEditor;
import hec.map.ToolBarButtonItem;
import hec.map.WorldRect;
import hec.map.appInterface.MapApplicationFrame;
import hec.map.appInterface.MapApplicationModule;
import hec.map.image.ImportImageAction;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import rma.lang.Modifiable;
import rma.services.units.UnitsComponent;
import rma.swing.event.ReflectListener;
import rma.swing.event.ReflectMultiListener;
import rma.swing.tree.CheckBoxTreeRenderer;
import rma.util.RMAIO;
import rma.util.RMAUtil;

public class JLayerSelectorTreePanel
extends JPanel
implements JLayerSelectionParent,
MapGlyphListener,
UnitsComponent,
PropertyChangeListener {
    private static final String REMOVE_TOOLBAR_LABEL = "Remove Toolbar Button";
    private static final String ADD_TOOLBAR_LABEL = "Add Toolbar Button ...";
    protected DefaultMutableTreeNode ROOTNODE = new DefaultMutableTreeNode("Layers");
    protected MapPanel _mapPanel = null;
    protected JFrame _parentForDialogs;
    protected Window _parentForClosing;
    protected Modifiable _modifiableParent;
    protected JLayerSelection _currentLayer = null;
    protected Map _layersHash = new HashMap();
    protected List<JLayerSelectionNode> _nodesList = new ArrayList<JLayerSelectionNode>();
    protected JTree layersTree;
    protected JPanel panelLayerButtons;
    protected AbstractButton buttonTop;
    protected AbstractButton buttonBottom;
    protected AbstractButton buttonUp;
    protected AbstractButton buttonDown;
    protected AbstractButton buttonRemove;
    protected AbstractButton buttonImportImage;
    protected AbstractButton buttonReset;
    protected AbstractButton buttonResetToolbars;
    protected AbstractButton buttonAdd;
    protected AbstractButton buttonToolbar;
    protected JMenuItem propertiesMenuItem;
    protected JLabel label1;
    protected JPanel panelButtons;
    protected AbstractButton buttonOK;
    protected AbstractButton buttonApply;
    protected AbstractButton buttonCancel;
    protected JMenuItem _collapseMenuItem;
    protected JMenuItem _expandMenuItem;
    protected JMenuItem _menuMaps;
    protected JMenu viewMenu;
    protected JMenu editMenu;
    protected JMenu mapsMenu;
    protected JCheckBoxMenuItem _onTopMenuItem;
    protected JScrollPane scrollPaneLayers;
    protected JPopupMenu _viewPopup;
    protected ReflectMultiListener _listener;
    protected GeoDialog _geoDialog;
    protected PropertyChangeSupport _propertyChangeSupport;
    List<LayerSelectionEventListener> _layerSelectionEventListeners = new ArrayList<LayerSelectionEventListener>();

    public JLayerSelectorTreePanel(JFrame parentForDialogs, Modifiable modifiableParent, Window parentForClosing, boolean okcancelEnabled, MapPanel panel, boolean addMenuToFrame) {
        this._parentForDialogs = parentForDialogs;
        this._modifiableParent = modifiableParent;
        this._parentForClosing = parentForClosing;
        this._mapPanel = panel;
        this._propertyChangeSupport = new PropertyChangeSupport(this);
        this.buildControls(okcancelEnabled, addMenuToFrame);
        if (panel != null) {
            List list = panel.cloneCombinedGlyphList();
            this.setGlyphVector(list);
            this.setCurrentLayer(null);
        } else {
            this.setGlyphVector(new ArrayList(0));
        }
    }

    public JLayerSelectorTreePanel(JFrame parentForDialogs, Modifiable modifiableParent, Window parentForClosing, boolean okcancelEnabled, MapPanel panel) {
        this(parentForDialogs, modifiableParent, parentForClosing, okcancelEnabled, panel, true);
    }

    private JLayerSelectorTreePanel(boolean okcancelEnabled) {
        this.buildControls(okcancelEnabled, true);
    }

    protected void buildControls(boolean okcancelEnabled, boolean addMenuToFrame) {
        this._listener = new ReflectMultiListener();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.layersTree = new JTree(){

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                TreePath path = JLayerSelectorTreePanel.this.layersTree.getPathForLocation((int)p.getX(), (int)p.getY());
                if (e.isAltDown() && e.isShiftDown() && e.isControlDown()) {
                    if (path != null) {
                        Object obj = path.getLastPathComponent();
                        if (obj instanceof DefaultMutableTreeNode) {
                            DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
                            obj = node.getUserObject();
                        }
                        MapGlyph glyph = null;
                        MapObjectInterface moi = null;
                        if (obj instanceof JLayerSelection) {
                            glyph = ((JLayerSelection)obj).getGlyph();
                            moi = glyph.getMap();
                        }
                        WorldRect bounds = null;
                        if (glyph != null) {
                            bounds = glyph.getBounds();
                        }
                        return "<html>TreeObject=" + (obj != null ? obj.getClass().getName() : "null") + "<br> MapGlyph=" + (glyph != null ? glyph.getClass().getName() : "null") + "<br> Map=" + (moi != null ? moi.getClass().getName() : "null") + "<br>Bounds=" + (bounds != null ? bounds.paramString() : "unknown") + "</html>";
                    }
                } else {
                    MapGlyph glyph = null;
                    if (path != null) {
                        Object obj = path.getLastPathComponent();
                        Object moi = null;
                        if (obj instanceof JLayerSelectionNode && (obj = ((JLayerSelectionNode)obj).getUserObject()) instanceof JLayerSelection && (glyph = ((JLayerSelection)obj).getGlyph()) != null) {
                            return glyph.getDescription();
                        }
                    }
                }
                return super.getToolTipText(e);
            }
        };
        this.layersTree.setRowHeight(0);
        this.layersTree.getSelectionModel().setSelectionMode(1);
        this.layersTree.setCellRenderer(new CheckBoxTreeRenderer());
        this.layersTree.addMouseListener(this.createDefaultMouseListener());
        this.layersTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                TreePath path = event.getNewLeadSelectionPath();
                System.out.println("valueChanged:path=" + path);
                if (path != null) {
                    Object obj = path.getLastPathComponent();
                    JLayerSelectorTreePanel.this.pathSelected(obj);
                }
            }
        });
        this.layersTree.setToolTipText("");
        this.scrollPaneLayers = new JScrollPane(this.layersTree);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.scrollPaneLayers, gbc);
        this.buildMenus(okcancelEnabled, addMenuToFrame);
    }

    protected MouseListener createDefaultMouseListener() {
        return new NodeSelectionListener(this.layersTree);
    }

    protected void buildMenus(boolean okcancelEnabled, boolean addMenuToFrame) {
        MapApplicationModule module;
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Layers");
        menu.setMnemonic('L');
        menuBar.add(menu);
        this.buttonApply = new JMenuItem("Apply", 65);
        this.buttonApply.setEnabled(false);
        this.buttonApply.addActionListener(this._listener.add(this, this.buttonApply, "apply"));
        this.buttonCancel = new JMenuItem("Close", 67);
        this.buttonCancel.addActionListener(this._listener.add(this, this.buttonCancel, "cancel"));
        menu.add(this.buttonCancel);
        this.editMenu = new JMenu("Edit");
        this.editMenu.setMnemonic('E');
        menuBar.add(this.editMenu);
        this.buttonTop = new JMenuItem("Move to Top", 84);
        this.buttonTop.addActionListener(this._listener.add(this, this.buttonTop, "moveCurrentLayerTop"));
        this.editMenu.add(this.buttonTop);
        this.buttonUp = new JMenuItem("Move Up", 85);
        this.buttonUp.addActionListener(this._listener.add(this, this.buttonUp, "moveCurrentLayerUp"));
        this.editMenu.add(this.buttonUp);
        this.buttonDown = new JMenuItem("Move Down", 77);
        this.buttonDown.addActionListener(this._listener.add(this, this.buttonDown, "moveCurrentLayerDown"));
        this.editMenu.add(this.buttonDown);
        this.buttonBottom = new JMenuItem("Move to Bottom", 66);
        this.buttonBottom.addActionListener(this._listener.add(this, this.buttonBottom, "moveCurrentLayerBottom"));
        this.editMenu.add(this.buttonBottom);
        this.editMenu.addSeparator();
        this.propertiesMenuItem = new JMenuItem("Properties ...", 80);
        this.propertiesMenuItem.addActionListener(this._listener.add(this, this.propertiesMenuItem, "properties"));
        this.editMenu.add(this.propertiesMenuItem);
        this.buttonReset = new JMenuItem("Reset Layer Order", 82);
        this.buttonReset.addActionListener(this._listener.add(this, this.buttonReset, "reset"));
        ApplicationFrame frame = AppDaddy.getFrame();
        if (frame != null && (module = (MapApplicationModule)frame.getCurrentModule()) != null && module.getToolBarButtonManager() != null) {
            this.editMenu.addSeparator();
            this.buttonToolbar = new JMenuItem(ADD_TOOLBAR_LABEL, 79);
            this.buttonToolbar.setEnabled(false);
            this.buttonToolbar.addActionListener(this._listener.add(this, this.buttonToolbar, "toolbarAction"));
            this.editMenu.add(this.buttonToolbar);
            this.buttonResetToolbars = new JMenuItem("Reload Default Button", 68);
            this.buttonResetToolbars.addActionListener(this._listener.add(this, this.buttonResetToolbars, "resetToolbars"));
            this.editMenu.add(this.buttonResetToolbars);
        }
        this.mapsMenu = new JMenu("Maps");
        this.mapsMenu.setMnemonic('M');
        menuBar.add(this.mapsMenu);
        this._menuMaps = new JMenuItem("Map Display Coordinates ...", 68);
        this._menuMaps.addActionListener(this._listener.add(this, this._menuMaps, "geoDialog"));
        this.mapsMenu.add(this._menuMaps);
        this.mapsMenu.addSeparator();
        this.buttonAdd = new JMenuItem("Add Map Layer ...", 65);
        this.buttonAdd.setEnabled(false);
        this.buttonAdd.addActionListener(this._listener.add(this, this.buttonAdd, "addLayer"));
        this.mapsMenu.add(this.buttonAdd);
        this.buttonRemove = new JMenuItem("Remove Map Layer", 82);
        this.buttonRemove.setEnabled(false);
        this.buttonRemove.addActionListener(this._listener.add(this, this.buttonRemove, "removeCurrentLayer"));
        this.mapsMenu.add(this.buttonRemove);
        this.buttonImportImage = new JMenuItem(this.createImportImageAction());
        this.buttonImportImage.setEnabled(false);
        this.buttonImportImage.addActionListener(this._listener.add(this, this.buttonImportImage, "importImage"));
        this.mapsMenu.add(this.buttonImportImage);
        this.viewMenu = new JMenu("View");
        this.viewMenu.setMnemonic('V');
        menuBar.add(this.viewMenu);
        this._expandMenuItem = new JMenuItem("Expand", 88);
        this._expandMenuItem.addActionListener(this._listener.add(this, this._expandMenuItem, "expand"));
        this.viewMenu.add(this._expandMenuItem);
        this._collapseMenuItem = new JMenuItem("Collapse", 67);
        this._collapseMenuItem.addActionListener(this._listener.add(this, this._collapseMenuItem, "collapse"));
        this.viewMenu.add(this._collapseMenuItem);
        if (RMAIO.getOSType() != 2) {
            this._onTopMenuItem = new JCheckBoxMenuItem("Always On Top");
            this._onTopMenuItem.setMnemonic('A');
            this._onTopMenuItem.addActionListener(this._listener.add(this, this._onTopMenuItem, "setWindowOnTop"));
            this.viewMenu.add(this._onTopMenuItem);
        }
        if (addMenuToFrame) {
            ((JFrame)this._parentForClosing).setJMenuBar(menuBar);
        }
    }

    public Action createImportImageAction() {
        ImportImageAction action = new ImportImageAction();
        action.setMapPanel(this._mapPanel);
        return action;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
    }

    public void pathSelected(Object obj) {
        if (obj instanceof JLayerSelectionNode) {
            JLayerSelectionNode node = (JLayerSelectionNode)obj;
            JLayerSelection ls = node.getLayerSelection();
            if (this.propertiesMenuItem != null) {
                this.propertiesMenuItem.setEnabled(ls.hasOptionDialog() && node.isSelected());
                if (!node.isSelected()) {
                    this.propertiesMenuItem.setToolTipText("Activate Layer to Edit its Properties");
                } else {
                    this.propertiesMenuItem.setToolTipText(null);
                }
            }
            if (ls.isMovableInList()) {
                this.setCurrentLayer(ls);
                return;
            }
        } else {
            this.setCurrentLayer(null);
            if (this.buttonRemove != null) {
                if (obj instanceof CheckBoxNode) {
                    this.buttonRemove.setEnabled(((CheckBoxNode)obj).isRemovable());
                    this.propertiesMenuItem.setEnabled(false);
                } else {
                    this.propertiesMenuItem.setEnabled(false);
                }
            }
        }
    }

    @Override
    public void update(Object o) {
    }

    public int getNumberOfGlyphs() {
        return this._nodesList.size();
    }

    @Override
    public void setLegendVisible(DefaultMutableTreeNode node, boolean show) {
        if (node == null) {
            return;
        }
        TreePath path = new TreePath(node.getPath());
        if (show) {
            this.layersTree.expandPath(path);
        } else {
            this.layersTree.collapsePath(path);
        }
    }

    @Override
    public void setModifiedLayerSelection(JLayerSelection ls) {
        if (this.buttonOK != null) {
            this.buttonOK.setEnabled(true);
        }
        if (this.isLocked()) {
            this.buttonApply.setEnabled(true);
        }
        this.buttonReset.setEnabled(true);
        this.nodeChanged(ls);
        this._modifiableParent.setModified(true);
    }

    public void setSelectedNode(DefaultMutableTreeNode node) {
        if (node == null) {
            this.layersTree.clearSelection();
            return;
        }
        Object[] nodes = node.getPath();
        nodes = ((DefaultTreeModel)this.layersTree.getModel()).getPathToRoot(node);
        TreePath path = new TreePath(nodes);
        this.layersTree.setSelectionPath(path);
    }

    @Override
    public void setCurrentLayer(JLayerSelection ls) {
        if (this._currentLayer != null && ls != null && this._currentLayer != ls) {
            this._currentLayer.setSelected(false);
        }
        this._currentLayer = ls;
        if (ls == null) {
            if (this.buttonTop != null) {
                this.buttonTop.setEnabled(false);
                this.buttonBottom.setEnabled(false);
                this.buttonUp.setEnabled(false);
                this.buttonDown.setEnabled(false);
                this.buttonRemove.setEnabled(false);
            }
            return;
        }
        if (this.isLocked()) {
            this.setMoveButtonsState();
            this.buttonRemove.setEnabled(ls.isRemovable());
        } else {
            this.buttonAdd.setEnabled(false);
        }
        this._currentLayer.requestFocus();
        this.invalidate();
    }

    private void setMoveButtonsState() {
        if (this.buttonTop == null) {
            return;
        }
        List<JLayerSelection> layers = this.getSelections();
        int size = layers.size();
        if (this.ROOTNODE.getChildCount() == 0) {
            return;
        }
        JLayerSelectionNode firstNode = (JLayerSelectionNode)this.ROOTNODE.getChildAt(0);
        JLayerSelectionNode lastNode = (JLayerSelectionNode)this.ROOTNODE.getChildAt(this.ROOTNODE.getChildCount() - 1);
        if (size > 0 && this._currentLayer == firstNode.getUserObject()) {
            this.buttonTop.setEnabled(false);
            this.buttonUp.setEnabled(false);
        } else {
            this.buttonUp.setEnabled(true);
            this.buttonTop.setEnabled(true);
        }
        if (size > 0 && this._currentLayer == lastNode.getUserObject()) {
            this.buttonDown.setEnabled(false);
            this.buttonBottom.setEnabled(false);
        } else {
            this.buttonDown.setEnabled(true);
            this.buttonBottom.setEnabled(true);
        }
    }

    public void setGlyphVector(List list) {
        JLayerSelectionNode node;
        final TreePath currentSelection = this.layersTree.getSelectionPath();
        this.removeAllSelections();
        JLayerSelection ls = null;
        this.ROOTNODE.removeAllChildren();
        for (int ii = list.size() - 1; ii >= 0; --ii) {
            MapGlyph g = (MapGlyph)list.get(ii);
            if (g == null) continue;
            ls = (JLayerSelection)LayerSelectionFactory.buildSelection(this, this._parentForDialogs, this._mapPanel, g);
            if (ls != null) {
                ls.addPropertyChangeListener(this);
            }
            node = this.addSelection(ls, this.ROOTNODE);
            if (!g.hasChildGlyphs()) continue;
            Vector<MapGlyph> childGlyphs = g.glyphVector();
            for (int jj = 0; jj < childGlyphs.size(); ++jj) {
                MapGlyph childGlyph = childGlyphs.get(jj);
                if (childGlyph == null || (ls = (JLayerSelection)LayerSelectionFactory.buildSelection(this, this._parentForDialogs, this._mapPanel, childGlyph)) == null) continue;
                ls.addPropertyChangeListener(this);
                ls.setIsMovableInList(false);
                this.addSelection(ls, node);
            }
        }
        node = (JLayerSelectionNode)this._layersHash.get(ls);
        this.layersTree.setModel(new DefaultTreeModel(this.ROOTNODE));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object obj;
                if (currentSelection != null && (obj = currentSelection.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)obj;
                    int cnt = JLayerSelectorTreePanel.this.ROOTNODE.getChildCount();
                    String nodeName = selNode.toString();
                    for (int i = 0; i < cnt; ++i) {
                        if (!JLayerSelectorTreePanel.this.ROOTNODE.getChildAt(i).toString().equals(nodeName)) continue;
                        System.out.println("run:setting node to " + JLayerSelectorTreePanel.this.ROOTNODE.getChildAt(i));
                        JLayerSelectorTreePanel.this.setSelectedNode((DefaultMutableTreeNode)JLayerSelectorTreePanel.this.ROOTNODE.getChildAt(i));
                        break;
                    }
                }
            }
        });
    }

    public JLayerSelectionNode addSelection(JLayerSelection ls, DefaultMutableTreeNode parentNode) {
        ModelDrawingAttributeSet aset;
        if (ls == null || parentNode == null) {
            return null;
        }
        JLayerSelectionNode node = new JLayerSelectionNode(ls);
        this._layersHash.put(ls, node);
        this._nodesList.add(node);
        parentNode.add(node);
        MapIdentifier mapId = ls.getGlyph().getMap().getMapIdentifier();
        if ((mapId.isManager() || mapId.isBackground()) && (aset = ls.getGlyph().getAttributeSet()) != null) {
            node.setAttributeSet(aset);
        }
        if (ls.hasLegend()) {
            JPanel legendPanel = ls.getLegendPanel();
            node.add(new DefaultMutableTreeNode(legendPanel));
        }
        return node;
    }

    public void removeSelection(JLayerSelection ls) {
        if (ls == null) {
            return;
        }
        JLayerSelectionNode panel = (JLayerSelectionNode)this._layersHash.get(ls);
        if (panel == null) {
            return;
        }
        this._nodesList.remove(panel);
        this._layersHash.remove(ls);
        ls.removePropertyChangeListener(this);
        this.setModifiedLayerSelection(ls);
    }

    protected void removeAllSelections() {
        this.removeAttributeSetListeners();
        this.layersTree.setModel(new DefaultTreeModel(this.ROOTNODE));
        for (int i = 0; i < this._nodesList.size(); ++i) {
            JLayerSelection selection;
            JLayerSelectionNode node = this._nodesList.get(i);
            if (node == null || (selection = node.getLayerSelection()) == null) continue;
            selection.removePropertyChangeListener(this);
            selection.cleanUp();
        }
        this._layersHash.clear();
        this._nodesList.clear();
    }

    protected List<JLayerSelection> getSelections() {
        int size = this._nodesList.size();
        ArrayList<JLayerSelection> selections = new ArrayList<JLayerSelection>(size);
        for (int i = 0; i < size; ++i) {
            selections.add(this._nodesList.get(i).getLayerSelection());
        }
        return selections;
    }

    public JLayerSelectionNode getSelectedLayerSelectionNode() {
        TreePath path = this.layersTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object obj = path.getLastPathComponent();
        if (obj instanceof JLayerSelectionNode) {
            JLayerSelectionNode node = (JLayerSelectionNode)obj;
            return node;
        }
        return null;
    }

    public MapPanel getMapPanel() {
        return this._mapPanel;
    }

    public void setMapPanel(MapPanel panel) {
        this.closeChildDialogs();
        ArrayList list = null;
        this._mapPanel = panel;
        list = panel != null ? panel.cloneCombinedGlyphList() : new ArrayList(0);
        this.setGlyphVector(list);
        int numglyphs = this.getNumberOfGlyphs();
        if (numglyphs < 1) {
            if (this.buttonTop != null) {
                this.buttonTop.setEnabled(false);
                this.buttonBottom.setEnabled(false);
                this.buttonUp.setEnabled(false);
                this.buttonDown.setEnabled(false);
                this.buttonRemove.setEnabled(false);
                if (this.buttonOK != null) {
                    this.buttonOK.setEnabled(false);
                }
                this.buttonApply.setEnabled(false);
                this.buttonReset.setEnabled(false);
                this.buttonCancel.setEnabled(false);
            }
        } else if (this.buttonTop != null) {
            this.buttonTop.setEnabled(true);
            this.buttonBottom.setEnabled(true);
            this.buttonUp.setEnabled(true);
            this.buttonDown.setEnabled(true);
            this.buttonRemove.setEnabled(true);
            if (this.buttonOK != null) {
                this.buttonOK.setEnabled(true);
            }
            this.buttonApply.setEnabled(false);
            this.buttonReset.setEnabled(false);
            this.buttonCancel.setEnabled(true);
        }
        this.setCurrentLayer(null);
        this.invalidate();
        this.validate();
        this.repaint();
        this._modifiableParent.setModified(false);
    }

    public void apply() {
        Vector<MapGlyph> list = new Vector<MapGlyph>();
        Vector<MapGlyph> managerList = new Vector<MapGlyph>();
        Vector<MapGlyph> backgroundList = new Vector<MapGlyph>();
        Vector<MapPosition> positionList = new Vector<MapPosition>();
        int size = this._nodesList.size();
        int loc = size - 1;
        size = this.ROOTNODE.getChildCount();
        Enumeration<TreeNode> e = this.ROOTNODE.children();
        for (int ii = 0; ii < size; ++ii) {
            JLayerSelectionNode node = (JLayerSelectionNode)e.nextElement();
            JLayerSelection ls = node.getLayerSelection();
            ls.updateGlyph();
            MapGlyph glyph = ls.getGlyph();
            if (glyph == null) continue;
            MapIdentifier mapId = glyph.getMap().getMapIdentifier();
            mapId.setName(ls.getName());
            if (glyph.isShown() != ls.getLayerShown()) {
                glyph.setShown(ls.getLayerShown());
            }
            if (glyph.getMaximumScale() != ls.getLayerMaximumScale()) {
                glyph.setMaximumScale(ls.getLayerMaximumScale());
            }
            if (glyph.getMinimumScale() != ls.getLayerMinimumScale()) {
                glyph.setMinimumScale(ls.getLayerMinimumScale());
            }
            if (mapId.isManager()) {
                managerList.insertElementAt(glyph, 0);
                positionList.insertElementAt(new MapPosition(loc - ii, glyph.getClass().getName()), 0);
                continue;
            }
            if (mapId.isBackground()) {
                backgroundList.insertElementAt(glyph, 0);
                positionList.insertElementAt(new MapPosition(loc - ii, glyph.getClass().getName()), 0);
                continue;
            }
            list.insertElementAt(glyph, 0);
        }
        this._mapPanel.setGlyphList(list);
        this._mapPanel.setManagerGlyphList(managerList);
        this._mapPanel.setBackgroundGlyphList(backgroundList);
        this._mapPanel.setManagerOrder(positionList);
        this._mapPanel.paintMap();
        this.buttonApply.setEnabled(false);
        this.buttonReset.setEnabled(false);
        this._modifiableParent.setModified(false);
        if (AppDaddy.getWorkspace() != null) {
            AppDaddy.getWorkspace().setModified(true);
        }
    }

    public void moveSelectionUp() {
        if (this._currentLayer == null) {
            return;
        }
        JLayerSelectionNode curPanel = (JLayerSelectionNode)this._layersHash.get(this._currentLayer);
        int curidx = this._nodesList.indexOf(curPanel);
        if (curidx < 1) {
            return;
        }
        JLayerSelectionNode upPanel = this._nodesList.get(curidx - 1);
        JLayerSelection upLayer = upPanel.getLayerSelection();
        upLayer.setSelected(true);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void moveSelectionDown() {
    }

    @Override
    public void moveCurrentLayerTop() {
        TreePath path = this.layersTree.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (curNode == null) {
            return;
        }
        int curidx = this._nodesList.indexOf(curNode);
        if (curidx < 1) {
            return;
        }
        Object upNode = null;
        Object upLayer = null;
        MutableTreeNode PARENT_NODE = (MutableTreeNode)curNode.getParent();
        if (PARENT_NODE == null) {
            return;
        }
        ((DefaultTreeModel)this.layersTree.getModel()).removeNodeFromParent(curNode);
        PARENT_NODE.insert(curNode, 0);
        ((DefaultTreeModel)this.layersTree.getModel()).nodeStructureChanged(PARENT_NODE);
        JLayerSelectionNode obj = this._nodesList.remove(curidx);
        this._nodesList.add(0, obj);
        this.setSelectedNode(curNode);
        if (this.buttonOK != null) {
            this.buttonOK.setEnabled(true);
        }
        this.buttonApply.setEnabled(true);
        this.buttonReset.setEnabled(true);
        this._modifiableParent.setModified(true);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    @Override
    public void moveCurrentLayerBottom() {
        int maxidx;
        TreePath path = this.layersTree.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (curNode == null) {
            return;
        }
        int curidx = this._nodesList.indexOf(curNode);
        if (curidx >= (maxidx = this._nodesList.size() - 1)) {
            return;
        }
        MutableTreeNode PARENT_NODE = (MutableTreeNode)curNode.getParent();
        ((DefaultTreeModel)this.layersTree.getModel()).removeNodeFromParent(curNode);
        if (PARENT_NODE == null) {
            return;
        }
        PARENT_NODE.insert(curNode, PARENT_NODE.getChildCount());
        ((DefaultTreeModel)this.layersTree.getModel()).nodeStructureChanged(PARENT_NODE);
        if (curidx > -1 && curidx < this._nodesList.size()) {
            JLayerSelectionNode obj = this._nodesList.remove(curidx);
            this._nodesList.add(obj);
        }
        this.setSelectedNode(curNode);
        if (this.buttonOK != null) {
            this.buttonOK.setEnabled(true);
        }
        this.buttonApply.setEnabled(true);
        this.buttonReset.setEnabled(true);
        this._modifiableParent.setModified(true);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    @Override
    public void moveCurrentLayerUp() {
        TreePath path = this.layersTree.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (curNode == null) {
            return;
        }
        MutableTreeNode PARENT_NODE = (MutableTreeNode)curNode.getParent();
        if (PARENT_NODE == null) {
            return;
        }
        int curidx = PARENT_NODE.getIndex(curNode);
        if (curidx < 1) {
            return;
        }
        List<JLayerSelection> layers = this.getSelections();
        if (layers != null && layers.size() > 0 && curNode.getUserObject() == layers.get(0)) {
            return;
        }
        ((DefaultTreeModel)this.layersTree.getModel()).removeNodeFromParent(curNode);
        PARENT_NODE.insert(curNode, curidx - 1);
        ((DefaultTreeModel)this.layersTree.getModel()).nodeStructureChanged(PARENT_NODE);
        this.setSelectedNode(curNode);
        if (this.buttonOK != null) {
            this.buttonOK.setEnabled(true);
        }
        this.buttonApply.setEnabled(true);
        this.buttonReset.setEnabled(true);
        this._modifiableParent.setModified(true);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    @Override
    public void moveCurrentLayerDown() {
        int maxidx;
        TreePath path = this.layersTree.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (curNode == null) {
            return;
        }
        MutableTreeNode PARENT_NODE = (MutableTreeNode)curNode.getParent();
        if (PARENT_NODE == null) {
            return;
        }
        int curidx = PARENT_NODE.getIndex(curNode);
        if (curidx >= (maxidx = PARENT_NODE.getChildCount() - 1)) {
            return;
        }
        ((DefaultTreeModel)this.layersTree.getModel()).removeNodeFromParent(curNode);
        PARENT_NODE.insert(curNode, curidx + 1);
        ((DefaultTreeModel)this.layersTree.getModel()).nodeStructureChanged(PARENT_NODE);
        JLayerSelectionNode obj = this._nodesList.remove(curidx);
        this._nodesList.add(curidx + 1, obj);
        this.setSelectedNode(curNode);
        if (this.buttonOK != null) {
            this.buttonOK.setEnabled(true);
        }
        this.buttonApply.setEnabled(true);
        this.buttonReset.setEnabled(true);
        this._modifiableParent.setModified(true);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void addLayer() {
        MapApplicationFrame frame;
        if (this._parentForClosing != null) {
            for (int ii = 0; ii < this._nodesList.size(); ++ii) {
                JLayerSelectionNode panel = this._nodesList.get(ii);
                JLayerSelection layersel = panel.getLayerSelection();
                layersel.closeOptionDialog();
            }
        }
        if ((frame = (MapApplicationFrame)AppDaddy.getFrame()).addMap(this._parentForDialogs)) {
            this.setMapPanel(this._mapPanel);
        }
        this.repaint();
    }

    public void importImage() {
    }

    public void removeCurrentLayer() {
        JLayerSelection ls;
        MapIdentifier id;
        TreePath path = this.layersTree.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        int opt = JOptionPane.showConfirmDialog(this, "Confirm removal of Layer " + node.toString(), "Confirm Deletion", 0);
        if (opt == 1) {
            return;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        node.removeFromParent();
        ToolBarButtonItem item = new ToolBarButtonItem();
        this.setToolBarButtonItem(item, path);
        ToolBarButtonManager tbbm = null;
        if (AppDaddy.getFrame() != null) {
            tbbm = AppDaddy.getFrame().getCurrentModule().getToolBarButtonManager();
        }
        if (tbbm != null) {
            tbbm.removeToolBarButton(item);
        }
        ((DefaultTreeModel)this.layersTree.getModel()).nodeStructureChanged(parent);
        if (node instanceof CheckBoxNode) {
            ((CheckBoxNode)node).hasBeenRemoved();
        }
        if (!(node instanceof JLayerSelectionNode) || !(id = (ls = ((JLayerSelectionNode)node).getLayerSelection()).getGlyph().getMap().getMapIdentifier()).isMap()) {
            // empty if block
        }
        if (this._currentLayer == null) {
            return;
        }
        this.removeSelection(this._currentLayer);
        this._currentLayer = null;
        this.setCurrentLayer(this._currentLayer);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void resetToolbars() {
        ToolBarButtonManager tbbm = null;
        if (AppDaddy.getFrame() != null) {
            tbbm = AppDaddy.getFrame().getCurrentModule().getToolBarButtonManager();
        }
        if (tbbm != null) {
            tbbm.resetDefaultToolbars();
        }
    }

    public void reset() {
        this.setMapPanel(this._mapPanel);
    }

    public void properties() {
        JLayerSelectionNode node;
        JLayerSelection ls;
        TreePath path = this.layersTree.getSelectionPath();
        if (path == null) {
            return;
        }
        Object obj = path.getLastPathComponent();
        if (obj instanceof JLayerSelectionNode && (ls = (node = (JLayerSelectionNode)obj).getLayerSelection()).hasOptionDialog()) {
            ls.showOptionDialog();
            return;
        }
        this.propertiesMenuItem.setEnabled(false);
    }

    public void toolbarAction() {
        TreePath path = this.layersTree.getSelectionPath();
        if (path == null || path.getPathCount() == 1) {
            System.out.println("toolbarAction: no path selected");
            return;
        }
        ToolBarButtonManager tbbm = null;
        if (AppDaddy.getFrame() != null) {
            tbbm = AppDaddy.getFrame().getCurrentModule().getToolBarButtonManager();
        }
        if (this.buttonToolbar.getText().equals(ADD_TOOLBAR_LABEL)) {
            ToolBarButtonEditor buttonEditor = new ToolBarButtonEditor((Frame)this._parentForDialogs, true);
            buttonEditor.setToolTipText(path.getLastPathComponent().toString());
            buttonEditor.setVisible(true);
            if (buttonEditor.isCanceled()) {
                return;
            }
            ToolBarButtonItem item = buttonEditor.getButtonItem();
            if (item == null || item.getSelectedIconName() == "") {
                return;
            }
            this.setToolBarButtonItem(item, path);
            tbbm.addToolBarButton(item);
            this.buttonToolbar.setText(REMOVE_TOOLBAR_LABEL);
        } else if (this.buttonToolbar.getText().equals(REMOVE_TOOLBAR_LABEL)) {
            ToolBarButtonItem item = new ToolBarButtonItem();
            this.setToolBarButtonItem(item, path);
            tbbm.removeToolBarButton(item);
            this.buttonToolbar.setText(ADD_TOOLBAR_LABEL);
        }
    }

    private void setToolBarButtonItem(ToolBarButtonItem item, TreePath path) {
        Object obj = path.getPathComponent(1);
        if (obj instanceof JLayerSelectionNode) {
            JLayerSelectionNode node = (JLayerSelectionNode)obj;
            MapIdentifier id = this.getMapIdentifier(node);
            item.setGlyphId(id);
        }
        obj = path.getLastPathComponent();
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)obj;
        if (obj instanceof CheckBoxNode) {
            item.setAttributeName(obj.toString());
            treeNode = (DefaultMutableTreeNode)treeNode.getParent();
        } else {
            item.setAttributeName("shown");
        }
        if (treeNode == this.ROOTNODE || treeNode == null) {
            item.setName(obj.toString());
        } else {
            item.setName(treeNode.toString());
        }
    }

    private MapIdentifier getMapIdentifier(JLayerSelectionNode node) {
        JLayerSelection ls = node.getLayerSelection();
        MapIdentifier id = new MapIdentifier();
        id.setName(node.toString());
        id.setClassName(ls.getGlyph().getClass().getName());
        return id;
    }

    @Override
    public void collapse() {
        TreePath path = this.layersTree.getSelectionPath();
        this.layersTree.collapsePath(path);
        this.setMenuState(path);
    }

    @Override
    public void expand() {
        TreePath path = this.layersTree.getSelectionPath();
        if (path == null) {
            return;
        }
        this.layersTree.expandPath(path);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        this.expandNode(node);
        this.setMenuState(path);
    }

    public void setAlwaysOnTop(boolean b) {
        if (this._onTopMenuItem != null && this._onTopMenuItem.isSelected() != b) {
            this._onTopMenuItem.doClick();
        }
    }

    public boolean isOnTop() {
        return this._onTopMenuItem != null ? this._onTopMenuItem.isSelected() : false;
    }

    public void setWindowOnTop() {
        RMAUtil.setWindowAlwaysOnTop(SwingUtilities.windowForComponent(this), this._onTopMenuItem.isSelected());
    }

    private void expandNode(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        Enumeration<TreeNode> e = node.children();
        Object[] nodes = node.getPath();
        TreePath path = new TreePath(nodes);
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)e.nextElement();
            nodes = childNode.getPath();
            path = new TreePath(nodes);
            this.layersTree.expandPath(path);
            if (childNode.getChildCount() <= 0) continue;
            this.expandNode(childNode);
        }
    }

    protected void setMenuState(TreePath path) {
        if (path == null) {
            this._expandMenuItem.setVisible(false);
            this._collapseMenuItem.setVisible(false);
            this.propertiesMenuItem.setEnabled(false);
            return;
        }
        if (this.layersTree.isExpanded(path)) {
            this._expandMenuItem.setVisible(false);
            this._collapseMenuItem.setVisible(true);
        } else {
            this._expandMenuItem.setVisible(true);
            this._collapseMenuItem.setVisible(false);
        }
        Object obj = path.getLastPathComponent();
        if (obj instanceof JLayerSelectionNode) {
            JLayerSelectionNode selNode = (JLayerSelectionNode)obj;
            this.propertiesMenuItem.setEnabled(selNode.isSelected());
            if (selNode.isSelected()) {
                this.propertiesMenuItem.setToolTipText(null);
            } else {
                this.propertiesMenuItem.setToolTipText("Activate Layer to Edit its Properties");
            }
        }
    }

    protected void removeAttributeSetListeners() {
        int size = this._nodesList.size();
        if (size < 1) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            JLayerSelectionNode node = this._nodesList.get(i);
            ModelDrawingAttributeSet aset = node.getLayerSelection().getGlyph().getAttributeSet();
            if (aset == null) continue;
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode obj = e.nextElement();
                if (!(obj instanceof AttributeChangedListener)) continue;
                aset.removeAttributeChangeListener((AttributeChangedListener)((Object)obj));
            }
        }
    }

    @Override
    public boolean isExpanded(DefaultMutableTreeNode node) {
        if (node == null) {
            return false;
        }
        TreePath path = new TreePath(node.getPath());
        return this.layersTree.isExpanded(path);
    }

    @Override
    public void nodeChanged(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        ((DefaultTreeModel)this.layersTree.getModel()).nodeChanged(node);
    }

    @Override
    public void nodeChanged(JLayerSelection ls) {
        DefaultMutableTreeNode node;
        if (ls == null) {
            return;
        }
        int size = this._nodesList.size();
        int idx = -1;
        for (int i = 0; i < size; ++i) {
            node = this._nodesList.get(i);
            if (node.getUserObject() != ls) continue;
            idx = i;
            break;
        }
        if (idx > -1) {
            node = this._nodesList.get(idx);
            ((DefaultTreeModel)this.layersTree.getModel()).nodeChanged(node);
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)e.nextElement();
                ((DefaultTreeModel)this.layersTree.getModel()).nodeChanged(childNode);
            }
            return;
        }
        for (int i = 0; i < size; ++i) {
            Enumeration<TreeNode> e = ((DefaultMutableTreeNode)this._nodesList.get(i)).children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)e.nextElement();
                if (childNode.getUserObject() != ls) continue;
                ((DefaultTreeModel)this.layersTree.getModel()).nodeChanged(childNode);
                return;
            }
        }
    }

    public void cancel() {
        this.buttonApply.setEnabled(false);
        this.buttonReset.setEnabled(false);
        this._modifiableParent.setModified(false);
        if (this._parentForClosing != null) {
            this.closeChildDialogs();
            for (int ii = 0; ii < this._nodesList.size(); ++ii) {
                JLayerSelectionNode panel = this._nodesList.get(ii);
                JLayerSelection layersel = panel.getLayerSelection();
                layersel.closeOptionDialog();
            }
            this._parentForClosing.setVisible(false);
        }
        this.removeAttributeSetListeners();
    }

    public void ok() {
        this.apply();
        if (this._parentForClosing != null) {
            this.closeChildDialogs();
            this._parentForClosing.setVisible(false);
        }
        this.removeAttributeSetListeners();
    }

    protected void closeChildDialogs() {
        for (int ii = 0; ii < this._nodesList.size(); ++ii) {
            JLayerSelectionNode panel = this._nodesList.get(ii);
            JLayerSelection layersel = panel.getLayerSelection();
            layersel.closeOptionDialog();
        }
    }

    protected boolean isLocked() {
        return true;
    }

    protected void displayViewPopup(MouseEvent e) {
        if (e == null) {
            return;
        }
        if (this._viewPopup == null) {
            this._viewPopup = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("Expand");
            menuItem.addActionListener(new ReflectListener(this, "expand"));
            this._viewPopup.add(menuItem);
            menuItem = new JMenuItem("Collapse");
            menuItem.addActionListener(new ReflectListener(this, "collapse"));
            this._viewPopup.add(menuItem);
        }
        this._viewPopup.show(this, e.getX(), e.getY());
    }

    public void setRootnodeText(String text) {
        this.ROOTNODE.setUserObject(text);
    }

    protected void fireNodeToggleEvent(rma.swing.tree.CheckBoxNode node) {
        this.fireLayerSelectionPanelEvent(new LayerSelectionEvent(node, 0));
    }

    protected void paintMap() {
        if (AppDaddy.getFrame() != null) {
            MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
            frame.getMapPanel().paintMap();
        }
    }

    protected void fireLayerSelectionPanelEvent(LayerSelectionEvent e) {
        for (int i = 0; i < this._layerSelectionEventListeners.size(); ++i) {
            this._layerSelectionEventListeners.get(i).layerSelectionPanelChanged(e);
        }
    }

    public void removeLayerSelectionEventListener(LayerSelectionEventListener listener) {
        if (listener != null) {
            return;
        }
        this._layerSelectionEventListeners.remove(listener);
    }

    public void addLayerSelectionEventListener(LayerSelectionEventListener listener) {
        if (listener != null && this._layerSelectionEventListeners.contains(listener)) {
            return;
        }
        this._layerSelectionEventListeners.add(listener);
    }

    @Override
    public boolean isConfigurationLocked() {
        return true;
    }

    public boolean canOpen() {
        return true;
    }

    public void closing() {
        if (this._mapPanel != null) {
            this._mapPanel.removeMapGlyphListener(this);
        }
    }

    void addMapListener() {
        if (this._mapPanel != null) {
            this._mapPanel.addMapGlyphListener(this);
        }
    }

    @Override
    public void mapGlyphsChanged() {
        this.setMapPanel(this._mapPanel);
        DefaultTreeModel model = (DefaultTreeModel)this.layersTree.getModel();
        model.nodeStructureChanged((TreeNode)model.getRoot());
    }

    public void geoDialog() {
        if (AppDaddy.getWorkspace() == null) {
            return;
        }
        if (this._geoDialog == null) {
            this._geoDialog = new GeoDialog((Frame)this._parentForDialogs, true);
        }
        this._geoDialog.setVisible(true);
        if (!this._geoDialog.isCanceled()) {
            this._mapPanel.updateExtents();
        }
    }

    public void modeChanged() {
    }

    @Override
    public String getDisplayUnitsString(int unitSystem) {
        return "";
    }

    @Override
    public void setDisplayUnitsSystem(int unitSystem) {
        if (this.ROOTNODE == null) {
            return;
        }
        int childCount = this.ROOTNODE.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Object obj;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.ROOTNODE.getChildAt(i);
            if (node.getChildCount() > 0) {
                node = (DefaultMutableTreeNode)node.getChildAt(0);
            }
            if (!((obj = node.getUserObject()) instanceof UnitsComponent)) continue;
            ((UnitsComponent)obj).setDisplayUnitsSystem(unitSystem);
            ((DefaultTreeModel)this.layersTree.getModel()).nodeChanged(node);
        }
    }

    @Override
    public void setDisplayScaleFactor(int paramId, double scale) {
    }

    @Override
    public boolean isFirstNode(JLayerSelection layerSelection) {
        List<JLayerSelection> layers = this.getSelections();
        int size = layers.size();
        JLayerSelectionNode firstNode = (JLayerSelectionNode)this.ROOTNODE.getChildAt(0);
        return size <= 0 || layerSelection != firstNode.getUserObject();
    }

    @Override
    public boolean isLastNode(JLayerSelection layerSelection) {
        List<JLayerSelection> layers = this.getSelections();
        int size = layers.size();
        JLayerSelectionNode lastNode = (JLayerSelectionNode)this.ROOTNODE.getChildAt(this.ROOTNODE.getChildCount() - 1);
        return size <= 0 || layerSelection != lastNode.getUserObject();
    }

    @Override
    public JLayerSelectionNode getSelectionNodeFor(JLayerSelection selection) {
        if (selection == null) {
            return null;
        }
        JLayerSelectionNode layerNode = this.getSelectionNodeFor(this.ROOTNODE, selection);
        return layerNode;
    }

    protected JLayerSelectionNode getSelectionNodeFor(DefaultMutableTreeNode parent, JLayerSelection selection) {
        int cnt = parent.getChildCount();
        for (int i = 0; i < cnt; ++i) {
            TreeNode node = parent.getChildAt(i);
            if (!(node instanceof JLayerSelectionNode)) continue;
            JLayerSelectionNode layerNode = (JLayerSelectionNode)node;
            if (layerNode.getUserObject() == selection) {
                return layerNode;
            }
            if (layerNode.getChildCount() <= 0) continue;
            for (int j = 0; j < layerNode.getChildCount(); ++j) {
                JLayerSelectionNode wantedNode;
                node = layerNode.getChildAt(j);
                if (!(node instanceof JLayerSelectionNode) || (wantedNode = this.getSelectionNodeFor((DefaultMutableTreeNode)node, selection)) == null) continue;
                return wantedNode;
            }
        }
        return null;
    }

    public void setParentForDialogs(JFrame parentFrame) {
        this._parentForDialogs = parentFrame;
    }

    class NodeSelectionListener
    extends MouseAdapter {
        JTree _tree;
        Rectangle _iconRect;

        NodeSelectionListener(JTree tree) {
            this._tree = tree;
            Icon icon = UIManager.getIcon("CheckBox.icon");
            this._iconRect = new Rectangle(0, 0, icon.getIconWidth(), icon.getIconHeight());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            MapApplicationModule module = AppDaddy.getFrame() != null ? (MapApplicationModule)AppDaddy.getFrame().getCurrentModule() : null;
            ToolBarButtonManager tbbm = null;
            if (module != null) {
                tbbm = module.getToolBarButtonManager();
            }
            int x = e.getX();
            int y = e.getY();
            int row = this._tree.getRowForLocation(x, y);
            TreePath path = this._tree.getPathForRow(row);
            boolean toggle = false;
            if (path != null) {
                if (tbbm != null) {
                    ToolBarButtonItem item = new ToolBarButtonItem();
                    if (path.getPathCount() > 1) {
                        JLayerSelectorTreePanel.this.setToolBarButtonItem(item, path);
                        if (JLayerSelectorTreePanel.this.buttonToolbar != null) {
                            JLayerSelectorTreePanel.this.buttonToolbar.setEnabled(true);
                            if (tbbm.contains(item)) {
                                JLayerSelectorTreePanel.this.buttonToolbar.setText(JLayerSelectorTreePanel.REMOVE_TOOLBAR_LABEL);
                            } else {
                                JLayerSelectorTreePanel.this.buttonToolbar.setText(JLayerSelectorTreePanel.ADD_TOOLBAR_LABEL);
                            }
                        }
                    } else if (JLayerSelectorTreePanel.this.buttonToolbar != null) {
                        JLayerSelectorTreePanel.this.buttonToolbar.setEnabled(false);
                    }
                }
                JLayerSelectorTreePanel.this.setMenuState(path);
                Rectangle r = this._tree.getRowBounds(row);
                Object obj = path.getLastPathComponent();
                if (x > r.x && x < r.x + this._iconRect.width) {
                    toggle = true;
                } else if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e) || e.getClickCount() >= 2) {
                    if (obj instanceof JLayerSelectionNode) {
                        this._tree.setSelectionPath(path);
                        ((JLayerSelectionNode)obj).getLayerSelection().mouseClicked(e);
                    } else if (obj instanceof CheckBoxNode && path.getPathCount() > 2) {
                        this._tree.setSelectionPath(path);
                        ModelDrawingAttributeSet mdas = ((CheckBoxNode)obj).getAttributeSet();
                        String attributeName = ((CheckBoxNode)obj).getAttributeName();
                        ((JLayerSelectionNode)((CheckBoxNode)obj).getParent()).getLayerSelection().attributeMouseClicked(e, mdas, attributeName);
                    }
                    return;
                }
                if (obj instanceof rma.swing.tree.CheckBoxNode && toggle) {
                    rma.swing.tree.CheckBoxNode node = (rma.swing.tree.CheckBoxNode)obj;
                    boolean isSelected = !node.isSelected();
                    node.setSelected(isSelected);
                    JLayerSelectorTreePanel.this.paintMap();
                    ((DefaultTreeModel)this._tree.getModel()).nodeChanged((TreeNode)((Object)node));
                    if (row == 0) {
                        this._tree.revalidate();
                        this._tree.repaint();
                    }
                    JLayerSelectorTreePanel.this.setMenuState(path);
                    JLayerSelectorTreePanel.this.fireNodeToggleEvent(node);
                }
            }
        }
    }

    public class JLayerSelectionNode
    extends DefaultMutableTreeNode
    implements rma.swing.tree.CheckBoxNode,
    AttributeChangedListener {
        private boolean _selected;
        private boolean _ignoreEvents;
        ModelDrawingAttributeSet _aset;

        public JLayerSelectionNode(JLayerSelection ls) {
            super(ls);
            this._selected = false;
            this._ignoreEvents = false;
            this._aset = null;
            ls.setTreeNode(this);
        }

        public void setLayerSelection(JLayerSelection ls) {
            this.setUserObject(ls);
            ls.setTreeNode(this);
        }

        public JLayerSelection getLayerSelection() {
            return (JLayerSelection)this.getUserObject();
        }

        @Override
        public String toString() {
            return this.getUserObject().toString();
        }

        @Override
        public boolean isSelected() {
            if (this._aset != null) {
                return this._aset.isShown();
            }
            return this.getLayerSelection().getLayerShown();
        }

        @Override
        public void setSelected(boolean b) {
            try {
                JLayerSelectorTreePanel.this.setCursor(Cursor.getPredefinedCursor(3));
                if (this._aset != null) {
                    this._ignoreEvents = true;
                    this._aset.setShown(b);
                    this._ignoreEvents = false;
                } else {
                    this.getLayerSelection().setLayerShown(b);
                }
            }
            finally {
                JLayerSelectorTreePanel.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public int getSelectionMode() {
            return 0;
        }

        public boolean canAddLayer() {
            return this.getLayerSelection().canAddLayer();
        }

        public void addLayer() {
            Object obj = this.getLayerSelection().addLayer();
            if (obj == null) {
                return;
            }
            if (obj instanceof JLayerSelection) {
                // empty if block
            }
        }

        public void setAttributeSet(ModelDrawingAttributeSet aset) {
            this.removeAllChildren();
            if (this._aset != null) {
                this._aset.removeAttributeChangeListener(this);
            }
            this._aset = aset;
            if (this._aset != null) {
                int size;
                this._aset.addAttributeChangedListener(this);
                List<String> v = aset.getAttributeNames();
                if (v == null || (size = v.size()) < 1) {
                    return;
                }
                boolean removable = !aset.hasFixedAttributes();
                for (int i = 0; i < size; ++i) {
                    String attrName = v.get(i);
                    Object obj = aset.getAttributeValue(attrName);
                    if (obj instanceof String) continue;
                    CheckBoxNode cbNode = new CheckBoxNode(aset, attrName);
                    cbNode.setIsRemovable(removable);
                    aset.addAttributeChangedListener(cbNode);
                    this.add(cbNode);
                    List<AttributeInfo> aInfoList = aset.getAttributeInfo(attrName);
                    if (aInfoList != null && aInfoList.size() > 0) {
                        for (int a = 0; a < aInfoList.size(); ++a) {
                            AttributeInfo aInfo = aInfoList.get(a);
                            DefaultMutableTreeNode node = new DefaultMutableTreeNode(aInfo);
                            cbNode.add(node);
                        }
                        continue;
                    }
                    Icon icon = aset.getIcon(attrName);
                    if (icon == null) continue;
                    cbNode.add(new DefaultMutableTreeNode(icon));
                }
            }
            ((DefaultTreeModel)JLayerSelectorTreePanel.this.layersTree.getModel()).nodeStructureChanged(this);
        }

        @Override
        public void attributeChanged(String name, String attrname, boolean shown) {
            if (this._ignoreEvents) {
                return;
            }
            if (!attrname.equals("shown")) {
                return;
            }
            if (this._aset == null) {
                this.setSelected(shown);
            }
            ((DefaultTreeModel)JLayerSelectorTreePanel.this.layersTree.getModel()).nodeChanged(this);
        }
    }

    public class CheckBoxNode
    extends DefaultMutableTreeNode
    implements rma.swing.tree.CheckBoxNode,
    AttributeChangedListener {
        private boolean _selected;
        String _name;
        private boolean _removable;

        public CheckBoxNode(ModelDrawingAttributeSet aset, String name) {
            super(aset);
            this._selected = false;
            this._name = "";
            this._removable = false;
            this._name = name;
        }

        @Override
        public boolean isSelected() {
            ModelDrawingAttributeSet aset = this.getAttributeSet();
            return aset.isAttributeShown(this._name);
        }

        @Override
        public void setSelected(boolean b) {
            ModelDrawingAttributeSet aset = this.getAttributeSet();
            aset.setAttribute(this._name, b);
        }

        public ModelDrawingAttributeSet getAttributeSet() {
            return (ModelDrawingAttributeSet)this.getUserObject();
        }

        @Override
        public int getSelectionMode() {
            return 0;
        }

        @Override
        public String toString() {
            return this._name;
        }

        @Override
        public void attributeChanged(String name, String attrname, boolean shown) {
            if (!attrname.equals(this._name)) {
                return;
            }
            ((DefaultTreeModel)JLayerSelectorTreePanel.this.layersTree.getModel()).nodeChanged(this);
        }

        public void setIsRemovable(boolean b) {
            this._removable = b;
        }

        public boolean isRemovable() {
            return this._removable;
        }

        public void hasBeenRemoved() {
            ModelDrawingAttributeSet aset = this.getAttributeSet();
            aset.removeAttribute(this._name);
        }

        public String getAttributeName() {
            return this._name;
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == JLayerSelectorTreePanel.this.buttonUp) {
                JLayerSelectorTreePanel.this.moveCurrentLayerUp();
            } else if (object == JLayerSelectorTreePanel.this.buttonTop) {
                JLayerSelectorTreePanel.this.moveCurrentLayerTop();
            } else if (object == JLayerSelectorTreePanel.this.buttonBottom) {
                JLayerSelectorTreePanel.this.moveCurrentLayerBottom();
            } else if (object == JLayerSelectorTreePanel.this.buttonDown) {
                JLayerSelectorTreePanel.this.moveCurrentLayerDown();
            } else if (object == JLayerSelectorTreePanel.this.buttonCancel) {
                JLayerSelectorTreePanel.this.cancel();
            } else if (object == JLayerSelectorTreePanel.this.buttonApply) {
                JLayerSelectorTreePanel.this.apply();
            } else if (object == JLayerSelectorTreePanel.this.buttonReset) {
                JLayerSelectorTreePanel.this.reset();
            } else if (object == JLayerSelectorTreePanel.this.buttonOK) {
                JLayerSelectorTreePanel.this.ok();
            } else if (object == JLayerSelectorTreePanel.this.buttonAdd) {
                JLayerSelectorTreePanel.this.addLayer();
            } else if (object == JLayerSelectorTreePanel.this.buttonRemove) {
                JLayerSelectorTreePanel.this.removeCurrentLayer();
            }
        }
    }
}

