/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.DefaultJLayerSelection;
import hec.map.JLayerSelection;
import hec.map.JLayerSelectionParent;
import hec.map.MapGlyph;
import hec.map.MapPanel;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;

public class LayerSelectionFactory {
    private static final Class[] CLASS_ARGS = new Class[]{JLayerSelectionParent.class, JFrame.class, MapPanel.class, MapGlyph.class};
    private static Hashtable _glyphToSelection = new Hashtable();
    private static Logger LOGGER = Logger.getLogger(LayerSelectionFactory.class.getName());

    public static void addMapping(String mapGlyphClass, String glyphSelectionClass) {
        if (glyphSelectionClass == null || mapGlyphClass == null) {
            return;
        }
        _glyphToSelection.put(mapGlyphClass, glyphSelectionClass);
    }

    public static Component buildSelection(JLayerSelectionParent parent, JFrame parentFrame, MapPanel panel, MapGlyph g) {
        JLayerSelection ls = null;
        if (g == null) {
            return null;
        }
        String glyphClassName = g.getClass().getName();
        String selectionClassName = (String)_glyphToSelection.get(glyphClassName);
        if (selectionClassName == null) {
            LOGGER.log(Level.FINE, "buildSelection: failed to find LayerSelection for {0}", glyphClassName);
            return new DefaultJLayerSelection(parent, parentFrame, panel, g);
        }
        Class<?> selectionClass = null;
        try {
            selectionClass = Thread.currentThread().getContextClassLoader().loadClass(selectionClassName);
        }
        catch (ClassNotFoundException cfe) {
            LOGGER.log(Level.FINE, "buildSelection: failed to load Class for {0}", selectionClassName);
            return null;
        }
        try {
            Constructor<?> c2 = selectionClass.getDeclaredConstructor(CLASS_ARGS);
            ls = (JLayerSelection)c2.newInstance(parent, parentFrame, panel, g);
            return ls;
        }
        catch (InvocationTargetException ite) {
            LOGGER.fine("buildSelection: failed to create LayerSelection for " + selectionClassName + " glyph " + glyphClassName + " Error:" + ite.getTargetException());
            ite.getTargetException().printStackTrace();
        }
        catch (Exception e) {
            LOGGER.fine("buildSelection: failed to create LayerSelection for " + selectionClassName + " glyph " + glyphClassName + " Error:" + e);
        }
        return null;
    }

    static {
        _glyphToSelection.put("hec.map.dlg.DlgGlyph", "hec.map.dlg.DlgLayerSelection");
        _glyphToSelection.put("hec.map.tin.TinGlyph", "hec.map.tin.TinLayerSelection");
        _glyphToSelection.put("hec.map.aishape.AiShapeGlyph", "hec.map.aishape.AiShapeLayerSelection");
        _glyphToSelection.put("hec.map.image.ImageGlyphProxy", "hec.map.image.ImageLayerSelection");
        _glyphToSelection.put("hec.map.mrsid.MrSidMapGlyph", "hec.map.mrsid.MrSidLayerSelection");
        _glyphToSelection.put("hec.map.dxf.DxfGlyph", "hec.map.dxf.DxfLayerSelection");
        _glyphToSelection.put("hec.fia.client.FiaSystemGlyph", "hec.fia.client.FiaSystemLayerSelection");
        _glyphToSelection.put("hec.map.dem.DemGlyph", "hec.map.dem.DemLayerSelection");
        _glyphToSelection.put("hec.map.aidem.AiDemGlyph", "hec.map.aidem.AiDemLayerSelection");
        _glyphToSelection.put("hec.map.nettin.NetTinGlyph", "hec.map.nettin.NetTinLayerSelection");
        _glyphToSelection.put("hec.map.inundation.InundationGroupGlyph", "hec.map.inundation.InundationGroupSelection");
        _glyphToSelection.put("hec.map.raster.RasterGlyph", "hec.map.raster.RasterLayerSelection");
        _glyphToSelection.put("hec.watershed.map.raster.dbf.RasterDbfGlyph", "hec.watershed.map.raster.dbf.RasterDbfLayerSelection");
        _glyphToSelection.put("hec.map.flo2d.Flo2dDepthGlyph", "hec.map.flo2d.Flo2dDepthLayerSelection");
        _glyphToSelection.put("hec.map.tms.TmsMapGlyph", "hec.map.tms.TmsLayerSelection");
        _glyphToSelection.put("wcds.cavi.client.ForecastAltGlyph", "wcds.cavi.client.ForecastAltGlyphSelection");
        _glyphToSelection.put("hec.gridUtil.client.GridDataManagerGlyph", "hec.gridUtil.client.GridGlyphSelection");
        _glyphToSelection.put("hec.gridUtil.client.SingleGridManagerGlyph", "hec.gridUtil.client.SingleGridGlyphSelection");
        _glyphToSelection.put("hec.map.streamAlignment.StreamAlignmentGlyph", "hec.map.StreamAlignmentGlyphSelection");
        _glyphToSelection.put("hec.dssmapgui.client.DmgTSLocationGlyph", "hec.dssmapgui.client.DmgTSLocationGlyphSelection");
        _glyphToSelection.put("hec.clientapp.client.StudySystemGlyph", "hec.clientapp.client.StudySystemGlyphSelection");
        _glyphToSelection.put("hec.rss.client.RssSystemGlyph", "hec.rss.client.RssSystemGlyphSelection");
        _glyphToSelection.put("hec.ras.client.RasSystemGlyph", "hec.ras.client.RasSystemGlyphSelection");
        _glyphToSelection.put("hec.fia.client.FiaSystemGlyph", "hec.fia.client.FiaSystemGlyphSelection");
        _glyphToSelection.put("hec.client.SimulationRunGlyph", "hec.client.SimulationRunGlyphSelection");
        _glyphToSelection.put("hec.rss.client.RssSimRunGlyph", "hec.client.SimulationRunGlyphSelection");
        _glyphToSelection.put("hec.rss.client.FiaSimRunGlyph", "hec.client.SimulationRunGlyphSelection");
        _glyphToSelection.put("hec.resprm.client.PrmSimRunGlyph", "hec.client.SimulationRunGlyphSelection");
        _glyphToSelection.put("hec.fda.client.InventoryGlyph", "hec.map.DefaultLayerSelection");
        _glyphToSelection.put("hec.resprm.client.ResPrmNetworkGlyph", "hec.res.client.ResNetworkGlyphSelection");
        _glyphToSelection.put("gov.ca.water.dwr.map.EventManagerGlyph", "gov.ca.water.dwr.map.EventMapGlyphSelection");
    }
}

