/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.streamAlignment.StreamAlignmentDrwPro;
import hec.map.streamAlignment.StreamAlignmentProps;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;

public class LayerSymbol {
    public static final int STREAM_REACH_SYMBOL = 0;
    public static final int STREAM_JUNCTION_SYMBOL = 1;
    public static final int STREAM_NODE_SYMBOL = 2;
    protected static final LayerSymbol _theSymbol = new LayerSymbol();
    protected static List<LayerSymbolItem> _shapeList = new ArrayList<LayerSymbolItem>();
    protected StreamAlignmentProps _streamDrawProp = StreamAlignmentDrwPro.getInstance();

    public static int numSymbols() {
        return _shapeList.size();
    }

    public static void draw(Graphics g, int x, int y, int type, Color lineclr, Color fillclr, float size) {
        int mtype = Math.abs(type % _shapeList.size());
        LayerSymbolItem item = _shapeList.get(mtype);
        if (item != null) {
            item.shape.draw(g, x, mtype, size, fillclr, fillclr);
        }
    }

    public static void draw2(Graphics g, int x, int y, int type, Color lineclr, Color fillclr, float size) {
        LayerSymbolShape shape = LayerSymbol.findLayerSymbolShape(type);
        if (shape != null) {
            shape.draw(g, x, y, size, fillclr, fillclr);
        }
    }

    public static void draw2(Graphics g, int x, int y, int type, Color lineclr, Color fillclr, float size, boolean drawName) {
        LayerSymbolShape shape = LayerSymbol.findLayerSymbolShape(type);
        if (shape != null) {
            shape.draw(g, x, y, size, fillclr, fillclr, drawName);
        }
    }

    private static LayerSymbolShape findLayerSymbolShape(int type) {
        int cnt = _shapeList.size();
        for (int i = 0; i < cnt; ++i) {
            LayerSymbolItem item = _shapeList.get(i);
            if (item.type != type) continue;
            return item.shape;
        }
        return null;
    }

    public static void addLayerSymbol(int type, LayerSymbolShape shape) {
        if (type < 0 || shape == null) {
            return;
        }
        LayerSymbolItem item = new LayerSymbolItem(type, shape);
        _shapeList.add(item);
    }

    static {
        LayerSymbol.addLayerSymbol(0, _theSymbol.new StreamReachSymbol());
        LayerSymbol.addLayerSymbol(1, _theSymbol.new StreamJunctionSymbol());
        LayerSymbol.addLayerSymbol(2, _theSymbol.new StreamNodeSymbol());
    }

    protected static class LayerSymbolItem {
        public int type;
        public LayerSymbolShape shape;

        public LayerSymbolItem(int type, LayerSymbolShape shape) {
            this.type = type;
            this.shape = shape;
        }
    }

    public static class LayerSymbolShape {
        protected static int[] xcoord = new int[8];
        protected static int[] ycoord = new int[8];

        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
        }

        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc, boolean drawName) {
            this.draw(g, x, y, size, lc, fc);
        }
    }

    public class StreamReachSymbol
    extends LayerSymbolShape {
        @Override
        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            StreamReachSymbol.xcoord[0] = x + 0;
            StreamReachSymbol.ycoord[0] = y + 0;
            StreamReachSymbol.xcoord[1] = x + 20;
            StreamReachSymbol.ycoord[1] = y + 0;
            StreamReachSymbol.xcoord[2] = x + 20;
            StreamReachSymbol.ycoord[2] = y + 4;
            StreamReachSymbol.xcoord[3] = x + 0;
            StreamReachSymbol.ycoord[3] = y + 4;
            LayerSymbol.this._streamDrawProp.getDrawingProperties().getStreamColor();
            g.fillPolygon(xcoord, ycoord, 4);
        }
    }

    public class StreamJunctionSymbol
    extends LayerSymbolShape {
        @Override
        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            g.setColor(Color.green);
            g.fillOval(x, y, 11, 11);
        }
    }

    public class StreamNodeSymbol
    extends LayerSymbolShape {
        @Override
        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            g.setColor(new Color(0, 128, 0));
            g.fillOval(x - 2, y - 2, 7, 7);
            g.setColor(new Color(0, 64, 0));
            g.drawOval(x - 2, y - 2, 7, 7);
        }
    }

    protected class SymbolType {
        LayerSymbolShape _outlineAndFillShape = null;
        LayerSymbolShape _lineShape = null;
        boolean _fill = false;

        public SymbolType(LayerSymbolShape ofshape, LayerSymbolShape lshape, boolean fill) {
            this._outlineAndFillShape = ofshape;
            this._lineShape = lshape;
            this._fill = fill;
        }

        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            if (!this._fill) {
                fc = null;
            }
            if (this._outlineAndFillShape != null) {
                this._outlineAndFillShape.draw(g, x, y, size, lc, fc);
            }
            if (this._lineShape != null) {
                this._lineShape.draw(g, x, y, size, lc, fc);
            }
        }
    }

    public static class DiversionSymbol
    extends LayerSymbolShape {
        @Override
        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            DiversionSymbol.xcoord[0] = 0;
            DiversionSymbol.ycoord[0] = 6;
            DiversionSymbol.xcoord[1] = 10;
            DiversionSymbol.ycoord[1] = 6;
            DiversionSymbol.xcoord[2] = 10;
            DiversionSymbol.ycoord[2] = 9;
            DiversionSymbol.xcoord[3] = 0;
            DiversionSymbol.ycoord[3] = 9;
            g.setColor(lc);
            g.fillPolygon(xcoord, ycoord, 4);
            g.setColor(fc);
            g.drawPolygon(xcoord, ycoord, 4);
            DiversionSymbol.xcoord[0] = 10;
            DiversionSymbol.xcoord[1] = 10;
            DiversionSymbol.xcoord[2] = 15;
            DiversionSymbol.ycoord[0] = 3;
            DiversionSymbol.ycoord[1] = 12;
            DiversionSymbol.ycoord[2] = 8;
            g.setColor(lc);
            g.fillPolygon(xcoord, ycoord, 3);
            g.setColor(fc);
            g.drawPolygon(xcoord, ycoord, 3);
        }
    }

    public static class Triangle1Symbol
    extends LayerSymbolShape {
        @Override
        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            Triangle1Symbol.xcoord[0] = x;
            Triangle1Symbol.xcoord[1] = x - (int)(size / 2.0f);
            Triangle1Symbol.xcoord[2] = xcoord[1] + (int)size;
            Triangle1Symbol.ycoord[0] = y - (int)(size / 2.0f);
            Triangle1Symbol.ycoord[1] = ycoord[0] + (int)size;
            Triangle1Symbol.ycoord[2] = ycoord[1];
            if (fc != null) {
                g.setColor(fc);
                g.fillPolygon(xcoord, ycoord, 3);
            }
            if (lc != null) {
                g.setColor(lc);
                g.drawPolygon(xcoord, ycoord, 3);
            }
        }
    }
}

