/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.WorldPt;
import java.io.Serializable;

public class LocalPt
implements Serializable {
    public int x;
    public int y;

    public LocalPt() {
    }

    public LocalPt(int px, int py) {
        this.x = px;
        this.y = py;
    }

    public LocalPt(LocalPt p) {
        this.x = p.x;
        this.y = p.y;
    }

    public void init(int px, int py) {
        this.x = px;
        this.y = py;
    }

    public void init(LocalPt p) {
        this.x = p.x;
        this.y = p.y;
    }

    public LocalPt offset(LocalPt p) {
        LocalPt lpt = new LocalPt(p.x - this.x, p.y - this.y);
        return lpt;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public WorldPt getNormal() {
        double len = Math.sqrt(this.x * this.x + this.y * this.y);
        WorldPt p = new WorldPt();
        if (len == 0.0) {
            p.init(this.x, this.y);
        } else {
            p.init((double)this.x / len, (double)this.y / len);
        }
        return p;
    }

    public boolean isValid() {
        return this.x != Integer.MIN_VALUE && this.y != Integer.MIN_VALUE;
    }

    public void setInvalid() {
        this.y = Integer.MIN_VALUE;
        this.x = Integer.MIN_VALUE;
    }

    public boolean equals(LocalPt p) {
        return this.x == p.x && this.y == p.y;
    }
}

