/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.LocalPt;

public class LocalRect {
    public int l = Integer.MIN_VALUE;
    public int t = Integer.MIN_VALUE;
    public int r = Integer.MIN_VALUE;
    public int b = Integer.MIN_VALUE;

    public LocalRect() {
    }

    public LocalRect(int rl, int rt, int rr, int rb) {
        this.l = rl;
        this.t = rt;
        this.r = rr;
        this.b = rb;
        this.justify();
    }

    public LocalRect(LocalPt tl, LocalPt br) {
        this.l = tl.x;
        this.t = tl.y;
        this.r = br.x;
        this.b = br.y;
        this.justify();
    }

    public LocalRect(LocalRect rc) {
        this.r = rc.r;
        this.l = rc.l;
        this.t = rc.t;
        this.b = rc.b;
        this.justify();
    }

    public boolean equals(LocalRect rc) {
        return this.r == rc.r && this.l == rc.l && this.t == rc.t && this.b == rc.b;
    }

    public int width() {
        return this.r - this.l;
    }

    public int height() {
        return this.b - this.t;
    }

    public int area() {
        return (this.r - this.l) * (this.b - this.t);
    }

    public void copy(LocalRect rc) {
        this.r = rc.r;
        this.l = rc.l;
        this.t = rc.t;
        this.b = rc.b;
        this.justify();
    }

    public void init(int rl, int rt, int rr, int rb) {
        this.l = rl;
        this.t = rt;
        this.r = rr;
        this.b = rb;
        this.justify();
    }

    public void init(LocalPt tl, LocalPt br) {
        this.l = tl.x;
        this.t = tl.y;
        this.r = br.x;
        this.b = br.y;
        this.justify();
    }

    public void init(LocalRect rc) {
        this.r = rc.r;
        this.l = rc.l;
        this.t = rc.t;
        this.b = rc.b;
        this.justify();
    }

    public void initToPoint(LocalPt p) {
        this.r = this.l = p.x;
        this.t = this.b = p.y;
    }

    public void growToPoint(LocalPt p) {
        if (this.l == Integer.MIN_VALUE) {
            this.l = p.x;
        }
        if (this.b == Integer.MIN_VALUE) {
            this.b = p.y;
        }
        if (p.x != Integer.MIN_VALUE && this.r < p.x) {
            this.r = p.x;
        }
        if (p.x != Integer.MIN_VALUE && this.l > p.x) {
            this.l = p.x;
        }
        if (p.y != Integer.MIN_VALUE && this.t > p.y) {
            this.t = p.y;
        }
        if (p.y != Integer.MIN_VALUE && this.b < p.y) {
            this.b = p.y;
        }
    }

    public void growToRect(LocalRect rc) {
        if (this.l == Integer.MIN_VALUE) {
            this.l = rc.l;
        }
        if (this.b == Integer.MIN_VALUE) {
            this.b = rc.b;
        }
        if (rc.r != Integer.MIN_VALUE && this.r < rc.r) {
            this.r = rc.r;
        }
        if (rc.l != Integer.MIN_VALUE && this.r < rc.l) {
            this.r = rc.l;
        }
        if (rc.l != Integer.MIN_VALUE && this.l > rc.l) {
            this.l = rc.l;
        }
        if (rc.r != Integer.MIN_VALUE && this.l > rc.r) {
            this.l = rc.r;
        }
        if (rc.t != Integer.MIN_VALUE && this.t > rc.t) {
            this.t = rc.t;
        }
        if (rc.b != Integer.MIN_VALUE && this.t > rc.b) {
            this.t = rc.b;
        }
        if (rc.b != Integer.MIN_VALUE && this.b < rc.b) {
            this.b = rc.b;
        }
        if (rc.t != Integer.MIN_VALUE && this.b < rc.t) {
            this.b = rc.t;
        }
    }

    public void justify() {
        int tmp;
        if (this.l > this.r) {
            tmp = this.r;
            this.r = this.l;
            this.l = tmp;
        }
        if (this.b < this.t) {
            tmp = this.t;
            this.t = this.b;
            this.b = tmp;
        }
    }

    public boolean isValid() {
        if (this.l == Integer.MIN_VALUE || this.t == Integer.MIN_VALUE || this.r == Integer.MIN_VALUE || this.b == Integer.MIN_VALUE) {
            return false;
        }
        if ((double)this.area() == 0.0) {
            return false;
        }
        this.justify();
        return true;
    }

    public boolean contains(int ptx, int pty) {
        return ptx >= this.l && ptx <= this.r && pty >= this.t && pty <= this.b;
    }

    public boolean contains(LocalPt pt) {
        return pt.x >= this.l && pt.x <= this.r && pt.y >= this.t && pt.y <= this.b;
    }

    public boolean contains(LocalRect rect) {
        if (rect == null) {
            return false;
        }
        return rect.l >= this.l && rect.t <= this.t && rect.r <= this.r && rect.b >= this.b;
    }

    public boolean intersects(LocalRect rc) {
        if (rc.r < this.l) {
            return false;
        }
        if (rc.l > this.r) {
            return false;
        }
        if (rc.t > this.b) {
            return false;
        }
        return rc.b >= this.t;
    }

    public LocalRect getIntersection(LocalRect rc) {
        if (!this.intersects(rc)) {
            return null;
        }
        LocalRect irc = new LocalRect(this);
        if (rc.l > this.l) {
            irc.l = rc.l;
        }
        if (rc.r < this.r) {
            irc.r = rc.r;
        }
        if (rc.t < this.t) {
            irc.t = rc.t;
        }
        if (rc.b > this.b) {
            irc.b = rc.b;
        }
        return irc;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.l);
        sb.append(",");
        sb.append(this.r);
        sb.append(",");
        sb.append(this.t);
        sb.append(",");
        sb.append(this.b);
        return sb.toString();
    }
}

