/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.event.AttributeChangedListener;
import hec.map.JLayerSelection;
import hec.map.JLayerSelectionParent;
import hec.map.MapGlyph;
import hec.map.MapPanel;
import hec.map.ModelDrawingAttributeSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class ManagerGlyphSelection
extends JLayerSelection
implements AttributeChangedListener {
    private static final int WIDTH = 16;
    private static final int HEIGHT = 16;
    JLabel _layerSquare = new JLabel();
    protected Color _color = null;
    protected ModelDrawingAttributeSet _modelDas;
    String _attributeName;

    public ManagerGlyphSelection(JLayerSelectionParent parent, JFrame parentFrame, MapPanel mapPanel, MapGlyph glyph, String attributeName) {
        super(parent, parentFrame, mapPanel, glyph);
        this._layerSquare.setBounds(35, 35, 16, 16);
        this._extraPanel.add((Component)this._layerSquare, "West");
        this.setLayerColor(Color.gray);
        this._layerSquare.addMouseListener(this._aSymMouse);
        this._attributeName = attributeName;
        this.addOptionsPopupMenu();
        this.refresh();
    }

    public void setLayerColor(Color color) {
        this._color = color;
        if (this._layerSquare == null) {
            return;
        }
        ImageIcon icon = new ImageIcon();
        Image image = icon.getImage();
        if (image == null) {
            image = new BufferedImage(16, 16, 1);
            icon.setImage(image);
        }
        Graphics g = image.getGraphics();
        g.setColor(color);
        g.fillRect(0, 0, 16, 16);
        g.setColor(Color.black);
        g.drawRect(0, 0, 16, 16);
        this._layerSquare.setIcon(icon);
    }

    public Color getLayerColor() {
        return this._color;
    }

    @Override
    public boolean hasOptionDialog() {
        ModelDrawingAttributeSet aset = this._glyph.getAttributeSet();
        boolean rv = aset != null && aset.getDrawPropDialogClassname() != null;
        return rv;
    }

    @Override
    public void showOptionDialog() {
        if (this._modelDas == null) {
            return;
        }
        this._modelDas.displayDrawPropDialogClass(this._parentFrame, false);
    }

    @Override
    public void closeOptionDialog() {
        if (this._modelDas == null) {
            return;
        }
        this._modelDas.closeDrawPropDialog();
    }

    @Override
    public boolean isRemovable() {
        return false;
    }

    @Override
    protected boolean hasChangableLabel() {
        return false;
    }

    @Override
    public boolean hasLegend() {
        return false;
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this._modelDas != null && this._modelDas.isShown() != this._layerShown.isSelected()) {
            this._layerShown.doClick();
        }
        if (this._copyOfData == null) {
            return;
        }
    }

    @Override
    public void attributeChanged(String model, String attrName, boolean shown) {
        if (!model.equals(this._attributeName)) {
            return;
        }
        if (attrName.equals("shown") && shown != this._layerShown.isSelected()) {
            this._layerShown.doClick();
        }
    }
}

