/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.appInterface.AppDaddy;
import hec.lang.Logger;
import hec.map.LegendItem;
import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.MapGlyph;
import hec.map.MapLabelItem;
import hec.map.MapMouseAdapter;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.MapTextObject;
import hec.map.ThreadedCanvasRenderer;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.appInterface.MapWorkspace;
import hec.map.renderer.CanvasRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.awt.image.VolatileImage;
import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import rma.util.RMAConst;

public class MapCanvas
extends JPanel
implements ImageObserver,
ComponentListener,
Runnable {
    private static final java.util.logging.Logger logger = java.util.logging.Logger.getLogger(MapCanvas.class.getName());
    protected MessageFormat MAP_SCALE_FORMAT = new MessageFormat("1:{0}");
    protected String m_mapScaleInformation = "1:?";
    MapPanel _mapPanel;
    WorldPt _oldOrigin = null;
    Image _imageBuffer = null;
    MapMouseAdapter _mouseAdapter = null;
    Dimension _dim = new Dimension();
    LocalRect _lrc = new LocalRect();
    boolean _paintImageOnly = false;
    List<MapTextObject> _labelVec = new Vector<MapTextObject>();
    List<LegendItem> _legendItemList = new Vector<LegendItem>();
    protected Color _backgroundColor = Color.white;
    protected boolean _drawGrids = true;
    private transient int _paintCnt = 0;
    private boolean _createRegularImage;
    private CanvasRenderer renderer = null;
    public static String USE_RENDER = "MapPanel.UseRender";
    protected boolean useRenderer = Boolean.getBoolean(USE_RENDER);

    public MapCanvas(MapPanel parent) {
        this.setToolTipText("");
        this._mapPanel = parent;
        this.setBackground(this._backgroundColor);
        this.setDoubleBuffered(false);
        this.setFocusable(true);
        this.addComponentListener(this);
        this._createRegularImage = Boolean.getBoolean("MapPanel.NoVolatileImage");
        if (this.useRenderer) {
            ExecutorService executorService = Executors.newFixedThreadPool(5);
            this.renderer = new ThreadedCanvasRenderer(executorService);
        }
    }

    private Component findEnclosingFrame() {
        for (Container parent = this._mapPanel.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JInternalFrame) && !(parent instanceof JFrame)) continue;
            return parent;
        }
        return null;
    }

    public MapMouseAdapter setMouseAdapter(MapMouseAdapter adapter) {
        Component frame = this.findEnclosingFrame();
        if (this._mouseAdapter != null) {
            this._mouseAdapter.abort();
            this.removeMouseListener(this._mouseAdapter);
            this.removeMouseMotionListener(this._mouseAdapter);
            if (this._mouseAdapter instanceof KeyListener && frame instanceof Component) {
                this.removeKeyListener((KeyListener)((Object)this._mouseAdapter));
                this._mapPanel.removeKeyListener((KeyListener)((Object)this._mouseAdapter));
            }
        }
        if (adapter != null) {
            adapter.init();
            this.addMouseListener(adapter);
            this.addMouseMotionListener(adapter);
            if (adapter instanceof KeyListener && frame instanceof Component) {
                this.addKeyListener((KeyListener)((Object)adapter));
                this._mapPanel.addKeyListener((KeyListener)((Object)adapter));
            }
            this.setCursor(adapter.getCursor());
        }
        MapMouseAdapter oldadapter = this._mouseAdapter;
        this._mouseAdapter = adapter;
        return oldadapter;
    }

    @Override
    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        this._mapPanel.getGlassPane().setCursor(cursor);
    }

    public MapMouseAdapter getMouseAdapter() {
        return this._mouseAdapter;
    }

    public Image getImageBuffer() {
        return this._imageBuffer;
    }

    public Graphics getBufferedGraphics() {
        if (this._imageBuffer == null) {
            return null;
        }
        return this._imageBuffer.getGraphics();
    }

    public MapMouseAdapter getMapMouseAdapter() {
        return this._mouseAdapter;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Object tip = this.getToolTipText(e, this._mapPanel.managerGlyphList());
        if (tip != null && !((String)tip).isEmpty()) {
            return tip;
        }
        tip = this.getToolTipText(e, this._mapPanel.backGroundGlyphList());
        if (tip != null && !((String)tip).isEmpty()) {
            return tip;
        }
        tip = this.getToolTipText(e, this._mapPanel.glyphList());
        if (tip != null && !((String)tip).isEmpty()) {
            return tip;
        }
        if (e.isAltDown() && e.isControlDown() && e.isShiftDown()) {
            int scale = (int)this.computeMapScale();
            List glyphList = this._mapPanel.getCombinedGlyphList();
            tip = "<html><b>Current Scale is</b> 1:" + scale;
            tip = ((String)tip).concat("<br><b>Current View is</b>" + this._mapPanel.scale().getWorldRect());
            for (int i = 0; i < glyphList.size(); ++i) {
                Vector<MapGlyph> childGlyphs;
                MapGlyph glyph = (MapGlyph)glyphList.get(i);
                tip = (String)tip + "<br><b>Glyph:</b>" + glyph.getName() + " <b>Class:</b>" + glyph.getClass().getName() + "<b>Shown:</b>" + glyph.isShown();
                if (!glyph.hasChildGlyphs() || (childGlyphs = glyph.glyphVector()) == null) continue;
                for (int j = 0; j < childGlyphs.size(); ++j) {
                    glyph = (MapGlyph)childGlyphs.get(j);
                    tip = (String)tip + "<br><b>-Glyph:</b>" + glyph.getName() + " <b>Class:</b>" + glyph.getClass().getName();
                }
            }
            tip = (String)tip + "</html>";
            return tip;
        }
        return null;
    }

    private String getToolTipText(MouseEvent e, List glyphList) {
        int size;
        LocalPt lpt = new LocalPt(e.getX(), e.getY());
        for (int i = size = glyphList.size() - 1; i >= 0; --i) {
            MapGlyph glyph = (MapGlyph)glyphList.get(i);
            if (glyph == null || !glyph.isShown()) continue;
            MapScale scale = this._mapPanel.scale();
            WorldPt toolTipWpt = scale.lp2wp(lpt);
            WorldRect bounds = glyph.getBounds();
            String tip = null;
            if (bounds == null || !bounds.isValid()) {
                tip = glyph.getToolTipText(toolTipWpt, e);
            } else if (bounds.isValid() && bounds.contains(toolTipWpt)) {
                tip = glyph.getToolTipText(toolTipWpt, e);
            }
            if (tip == null) continue;
            return tip;
        }
        return null;
    }

    public void addMapLegendItem(LegendItem item) {
        if (item == null) {
            return;
        }
        this._legendItemList.add(item);
    }

    public boolean removeMapLegendItem(LegendItem item) {
        return this._legendItemList.remove(item);
    }

    public void addMapTextObject(MapTextObject textobj) {
        if (textobj == null) {
            return;
        }
        int idx = -1;
        int imax = this._labelVec.size();
        for (int i = 0; i < imax; ++i) {
            MapTextObject label = this._labelVec.get(i);
            if (label == null) {
                if (idx >= 0) continue;
                idx = i;
                continue;
            }
            if (!textobj.intersects(label)) continue;
            if (textobj._priority >= 0.0f && textobj._priority > label._priority) {
                return;
            }
            if (label._priority < 0.0f) continue;
            this._labelVec.set(i, null);
            if (idx >= 0) continue;
            idx = i;
        }
        if (idx >= 0) {
            this._labelVec.set(idx, textobj);
        } else {
            this._labelVec.add(textobj);
        }
    }

    public void addMapLabelItem(MapLabelItem newlabel) {
        this.addMapTextObject(newlabel);
    }

    @Override
    public void run() {
        Graphics g = this.getGraphics();
        this.paintMap(g);
        this._mapPanel.paintComplete();
    }

    public void redrawMaps() {
        this._paintImageOnly = false;
    }

    protected void validateImage() {
        if (this._imageBuffer instanceof VolatileImage) {
            VolatileImage vImg = (VolatileImage)this._imageBuffer;
            boolean debug = Logger.canDebug("maps");
            if (vImg.contentsLost()) {
                if (debug) {
                    System.out.println("validateImage:image contents lost");
                }
                this._imageBuffer = this.createImageBuffer();
                this.paintMap(this.getGraphics());
                return;
            }
            int returnCode = vImg.validate(this.getGraphicsConfiguration());
            if (returnCode == 1) {
                if (debug) {
                    System.out.println("validateImage:image restored");
                }
            } else if (returnCode == 2) {
                if (debug) {
                    System.out.println("validateImage:image incompatible");
                }
                this._imageBuffer = this.createImageBuffer();
                this.paintMap(this.getGraphics());
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.useRenderer) {
            this.paintComponentThreaded(g);
        } else {
            this.paintComponentDefault(g);
        }
    }

    public void paintComponentDefault(Graphics g) {
        boolean debug = Logger.canDebug("maps");
        MapScale scale = new MapScale(this._mapPanel.scale());
        WorldPt currentOrigin = scale.getOrigin();
        if (debug) {
            System.out.println("MapCanvas.paintComponent:imgbuf=" + this._imageBuffer + " paintImageOnly=" + this._paintImageOnly + " oldOrigin=" + this._oldOrigin + " PaintOk=" + MapGlyph.isPaintOk());
        }
        this.validateImage();
        if (this._imageBuffer != null) {
            if (this._paintImageOnly && this._oldOrigin != null) {
                MapGlyph.setPaintOk(true);
                g.setColor(Color.white);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(this._backgroundColor);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (!MapGlyph.isPaintOk()) {
                    return;
                }
                LocalPt oldPt = scale.wp2lp(this._oldOrigin);
                LocalPt curPt = scale.wp2lp(currentOrigin);
                int x = oldPt.x - curPt.x;
                int y = oldPt.y - curPt.y;
                if (x > this.getWidth() || y > this.getHeight() || x + this._imageBuffer.getWidth(this) < 0 || y + this._imageBuffer.getHeight(this) < 0) {
                    this.paintMap(g);
                    this._paintImageOnly = true;
                    this._oldOrigin = currentOrigin;
                } else {
                    if (debug) {
                        System.out.println("MapCanvas.paintComponent: drawing Image...");
                    }
                    g.drawImage(this._imageBuffer, x, y, this);
                }
            } else {
                this.paintMap(g);
                this._paintImageOnly = true;
                this._oldOrigin = currentOrigin;
            }
        }
        this.drawLegendItems(g, scale);
    }

    public void drawLegendItems(Graphics g, MapScale scale) {
        for (int i = 0; i < this._legendItemList.size(); ++i) {
            int height;
            int width;
            LegendItem li = this._legendItemList.get(i);
            if (li == null) continue;
            ((JComponent)((Object)li)).setFont(this.getFont());
            Dimension prefSize = li.getPreferredSize();
            if (prefSize == null) {
                width = 75;
                height = this._mapPanel.getSize().height / 2;
            } else {
                width = prefSize.width;
                height = prefSize.height;
            }
            if (LegendItem.LegendLocation.LowerLeft.equals((Object)li.getPreferredLocation())) {
                li.setBounds(new Rectangle(10, this.getSize().height - (height + 10), width, height));
            } else if (LegendItem.LegendLocation.UpperRight.equals((Object)li.getPreferredLocation())) {
                li.setBounds(new Rectangle(this.getSize().width - (width + 10), 10, width, height));
            } else if (LegendItem.LegendLocation.LowerRight.equals((Object)li.getPreferredLocation())) {
                li.setBounds(new Rectangle(this.getSize().width - (width + 10), this.getSize().height - (height + 10), width, height));
            } else {
                li.setBounds(new Rectangle(10, 10, width, height));
            }
            li.draw(g, scale);
        }
    }

    public void paintComponentThreaded(Graphics g) {
        super.paintComponent(g);
        this._labelVec.clear();
        this._legendItemList.clear();
        if (this._imageBuffer == null) {
            this._imageBuffer = this.createImageBuffer();
        }
        this._lrc.init(0, 0, this._imageBuffer.getWidth(this), this._imageBuffer.getHeight(this));
        this._mapPanel.scale().setViewRect(this._lrc);
        MapScale updatedScale = new MapScale(this._mapPanel.scale());
        this.renderer.renderToImage(this._imageBuffer, updatedScale, this);
        g.drawImage(this._imageBuffer, 0, 0, null);
    }

    public double computeMapScale() {
        int localWidth = this.getSize().width;
        double worldViewWidth = this._mapPanel.scale().getWorldRect().width();
        double scale = MapCanvas.computeMapScale(localWidth, worldViewWidth);
        this.m_mapScaleInformation = this.MAP_SCALE_FORMAT.format(new String[]{Integer.toString((int)scale)});
        return scale;
    }

    public static double computeMapScale(int localWidth, double worldViewWidth) {
        boolean debug = Logger.canDebug("maps");
        if (RMAConst.isUndefinedValue(worldViewWidth)) {
            if (debug) {
                System.out.println("computeMapScale:worldViewWidth undefined");
            }
            return -1.0;
        }
        int pixelsPerInch = Toolkit.getDefaultToolkit().getScreenResolution();
        MapWorkspace workspace = (MapWorkspace)AppDaddy.getWorkspace();
        if (workspace == null || workspace.getCoordSys() == null) {
            if (debug) {
                if (AppDaddy.getWorkspace() == null) {
                    System.out.println("computeMapScale:workspace " + AppDaddy.getWorkspace() + " is null");
                } else {
                    System.out.println("computeMapScale:coordinate system is null");
                }
            }
            return -1.0;
        }
        String coordinateUnits = workspace.getCoordSys().getUnits();
        if (coordinateUnits == null) {
            if (debug) {
                System.out.println("computeMapScale:no coordinates units");
            }
            return -1.0;
        }
        double conversionFactor = coordinateUnits.equals("U.S. Feet") ? 1.0 : 3.28083;
        double canvasWidthInInches = localWidth / pixelsPerInch;
        double scale = worldViewWidth * 12.0 * conversionFactor / canvasWidthInInches;
        return scale;
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        boolean bl;
        if ((infoflags & 0x80) != 0) {
            bl = true;
        }
        if ((infoflags & 0x20) != 0) {
            bl = true;
        }
        if ((infoflags & 0x40) != 0) {
            bl = true;
        }
        if ((infoflags & 0x10) != 0) {
            bl = true;
        }
        if ((infoflags & 2) != 0) {
            bl = true;
        }
        if ((infoflags & 1) != 0) {
            bl = true;
        }
        if ((infoflags & 4) != 0) {
            bl = true;
        }
        if ((infoflags & 8) != 0) {
            bl = true;
        }
        return false;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this._imageBuffer = this.createImageBuffer();
        this.redrawMaps();
    }

    public Image createImageBuffer() {
        Image retval = null;
        Dimension d = this.getSize();
        if (d.width > 0 && d.height > 0) {
            retval = this._createRegularImage ? this.createImage(d.width, d.height) : this.createVolatileImage(d.width, d.height);
        }
        return retval;
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    public void paintCoordinateGrid(Graphics bg, MapScale scale) {
        int y;
        int x;
        int ylog10;
        WorldRect rc = scale.getWorldRect();
        WorldRect ext = scale.getRegionExtents();
        int xlog10 = (int)(0.4342944819 * Math.log(ext.width()) + 0.5) - 1;
        int log10 = xlog10 < (ylog10 = (int)(0.4342944819 * Math.log(ext.height()) + 0.5) - 1) ? xlog10 : ylog10;
        double interval = Math.pow(10.0, log10);
        if (rc.w < ext.w) {
            rc.w = ext.w;
        }
        if (rc.e > ext.e) {
            rc.e = ext.e;
        }
        if (rc.s < ext.s) {
            rc.s = ext.s;
        }
        if (rc.n > ext.n) {
            rc.n = ext.n;
        }
        bg.setColor(Color.lightGray);
        int istart = (int)(rc.w / interval);
        double start = (double)istart * interval;
        if (start < rc.w) {
            start += interval;
        }
        int y0 = scale.n2y(rc.n);
        int y1 = scale.n2y(rc.s);
        for (double e = start; e <= rc.e; e += interval) {
            x = scale.e2x(e);
            bg.drawLine(x, y0, x, y1);
        }
        bg.setColor(Color.darkGray);
        if (rc.w == ext.w) {
            x = scale.e2x(rc.w);
            bg.drawLine(x, y0, x, y1);
        }
        if (rc.e == ext.e) {
            x = scale.e2x(rc.e);
            bg.drawLine(x, y0, x, y1);
        }
        if ((start = (double)(istart = (int)(rc.s / interval)) * interval) < rc.s) {
            start += interval;
        }
        int x0 = scale.e2x(rc.w);
        int x1 = scale.e2x(rc.e);
        bg.setColor(Color.lightGray);
        for (double n = start; n <= rc.n; n += interval) {
            y = scale.n2y(n);
            bg.drawLine(x0, y, x1, y);
        }
        bg.setColor(Color.darkGray);
        if (rc.n == ext.n) {
            y = scale.n2y(rc.n);
            bg.drawLine(x0, y, x1, y);
        }
        if (rc.s == ext.s) {
            y = scale.n2y(rc.s);
            bg.drawLine(x0, y, x1, y);
        }
    }

    public synchronized void stop() {
        MapGlyph.setPaintOk(false);
    }

    protected synchronized void paintMap(Graphics g) {
        if (this.useRenderer) {
            this.repaint();
        } else {
            this.paintMapDefault(g);
        }
    }

    @Override
    public void repaint() {
        super.repaint();
    }

    protected synchronized void paintMapDefault(Graphics g) {
        boolean debug = Logger.canDebug("maps");
        MapGlyph.setPaintOk(true);
        if (this._imageBuffer == null) {
            return;
        }
        if (debug) {
            System.out.println("paintMap:begin paint " + this._paintCnt);
        }
        this._dim.width = this._imageBuffer.getWidth(this);
        this._dim.height = this._imageBuffer.getHeight(this);
        if (this._dim.width == -1 || this._dim.height == -1) {
            return;
        }
        this._lrc.init(0, 0, this._dim.width, this._dim.height);
        this._mapPanel.scale().setViewRect(this._lrc);
        this.paintGlyphs(g, this._imageBuffer);
        this.notifyAll();
        if (debug) {
            System.out.println("paintMap:end paint " + this._paintCnt++);
        }
    }

    public void paintGlyphs(Graphics g, Image imageBuffer) {
        boolean debug = Logger.canDebug("maps");
        Graphics bg = imageBuffer.getGraphics();
        if (bg != null && bg instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)bg;
            g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        Color saveColor = bg.getColor();
        bg.setColor(Color.white);
        bg.fillRect(0, 0, this._dim.width, this._dim.height);
        bg.setColor(this._backgroundColor);
        bg.fillRect(0, 0, this._dim.width, this._dim.height);
        bg.setColor(saveColor);
        this._lrc.init(0, 0, this._dim.width, this._dim.height);
        this._mapPanel.scale().setViewRect(this._lrc);
        MapScale scale = new MapScale(this._mapPanel.scale());
        if (MapGlyph.isPaintOk()) {
            this._labelVec.clear();
            this._legendItemList.clear();
            int mapScale = (int)this.computeMapScale();
            if (this._drawGrids) {
                this.paintCoordinateGrid(bg, scale);
            }
            List glyphList = this._mapPanel.getCombinedGlyphList();
            int size = glyphList.size();
            if (debug) {
                System.out.println("paintMap:have " + size + " glyphs to possibly draw. MapScale=" + mapScale);
            }
            for (int i = 0; MapGlyph.isPaintOk() && i < size; ++i) {
                MapGlyph glyph = (MapGlyph)glyphList.get(i);
                this.paintGlyph(glyph, i, mapScale, bg, scale);
            }
            this.drawMapLabels(bg);
            if (MapGlyph.isPaintOk()) {
                g.drawImage(imageBuffer, 0, 0, this);
            }
        }
        bg.dispose();
    }

    public void paintGlyph(MapGlyph glyph, int i, int mapScale, Graphics bg, MapScale scale) {
        block12: {
            boolean debug = Logger.canDebug("maps");
            long t1 = 0L;
            if (glyph == null || !glyph.isShown()) {
                if (debug) {
                    System.out.println("paintMap: glyph (" + i + ") " + glyph + " isn't shown");
                }
            } else {
                int maximumScale = glyph.getMaximumScale();
                int minimumScale = glyph.getMinimumScale();
                if (mapScale == -1 && AppDaddy.getWorkspace() != null || minimumScale > mapScale || maximumScale < mapScale) {
                    if (debug) {
                        System.out.println("paintMap: (" + i + ") glyph " + glyph + "'s scale invalid ");
                        System.out.println("paintMap: (" + i + ") mapScale=" + mapScale + " minScale=" + minimumScale + " maxScale=" + maximumScale);
                    }
                } else {
                    if (debug) {
                        System.out.println("paintMap: (" + i + ") drawing Glyph " + glyph.getName() + " class:" + glyph.getClass());
                        System.out.println("paintMap: (" + i + ") minScale=" + minimumScale + " maxScale=" + maximumScale);
                    }
                    try {
                        boolean paintMapBorders;
                        glyph.setGlyphLevel(this._mapPanel.getGlyphLevel(glyph));
                        if (debug) {
                            t1 = System.currentTimeMillis();
                        }
                        glyph.draw(bg, scale);
                        if (debug) {
                            long t2 = System.currentTimeMillis();
                            System.out.println("paintMap:(" + i + ") time to draw=" + (t2 - t1) + " ms");
                        }
                        if (paintMapBorders = Boolean.getBoolean("MapPanel.PaintMapBorders")) {
                            this.paintMapBorders(glyph, scale, bg);
                        }
                    }
                    catch (Exception e) {
                        System.out.println("paintMap: (" + i + ") Error drawing glyph " + glyph.getName() + " Error:" + e);
                        if (!Logger.canDebug("maps")) break block12;
                        e.printStackTrace(System.out);
                    }
                }
            }
        }
    }

    public void paintMapBorders(MapGlyph glyph, MapScale scale, Graphics bg) {
        WorldRect bounds = glyph.getBounds();
        if (bounds != null) {
            LocalRect rect = scale.wr2lr(bounds);
            Color old = bg.getColor();
            bg.setColor(Color.BLACK);
            bg.drawRect(rect.l, rect.t, rect.width(), rect.height());
            bg.setColor(old);
        }
    }

    public void drawMapLabels(Graphics bg) {
        int size = this._labelVec.size();
        long[] nextCheck = new long[]{-1L};
        for (int i = 0; i < size; ++i) {
            if (MapGlyph.shouldReturn(nextCheck)) {
                return;
            }
            MapTextObject label = this._labelVec.get(i);
            if (label == null) continue;
            try {
                label.draw(bg);
                continue;
            }
            catch (Exception e) {
                System.out.println("paintMap: (" + i + ") Error drawing Label " + label._text + " Error:" + e);
                if (!Logger.canDebug("maps")) continue;
                e.printStackTrace(System.out);
            }
        }
    }

    public void setBackgroundColor(Color color) {
        if (color != null) {
            this._backgroundColor = color;
        }
    }

    public Color getBackgroundColor() {
        return this._backgroundColor;
    }

    public void setDrawGrids(boolean drawGrids) {
        this._drawGrids = drawGrids;
    }

    public boolean getDrawGrids() {
        return this._drawGrids;
    }
}

