/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.appInterface.AppDaddy;
import hec.appInterface.FileOpener;
import hec.event.GlyphSelectionEvent;
import hec.event.GlyphSelectionListener;
import hec.io.Identifier;
import hec.lang.NamedType;
import hec.lang.annotation.Scriptable;
import hec.map.ConformingMapText;
import hec.map.DisplayCoordinateReferenceSystem;
import hec.map.GlyphDataRecord;
import hec.map.GlyphDataRecordSerializable;
import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.MapIdentifier;
import hec.map.MapObject;
import hec.map.MapObjectInterface;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.ModelDrawingAttributeSet;
import hec.map.RotatedMapText;
import hec.map.TransformCache;
import hec.map.WorldLine;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.WorldRegion;
import hec.map.appInterface.MapApplicationModule;
import hec.map.crs.CRS;
import hec.map.crs.CRSException;
import hec.map.crs.CoordinateReferenceSystem;
import hec.map.crs.Transform;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import rma.lang.RmaMath;
import rma.util.RMAIO;

public abstract class MapGlyph
implements Comparable<MapGlyph> {
    private static final Logger LOGGER = Logger.getLogger(MapGlyph.class.getName());
    protected float _glyphLevel = 0.0f;
    protected MapPanel _mapPanel = null;
    protected MapObjectInterface _map = null;
    protected MapIdentifier _mapIdentifier = null;
    protected EventListenerList _listenerList = new EventListenerList();
    protected transient ChangeEvent _changeEvent;
    protected static boolean _paintOk = true;
    protected static Color XOR_COLOR = new Color(255, 255, 255);
    protected static int maxPtArraySz = 10000;
    protected static int[] xarray = new int[maxPtArraySz];
    protected static int[] yarray = new int[maxPtArraySz];
    private static int[] _xpt = new int[4];
    private static int[] _ypt = new int[4];
    protected MapGlyph _parentGlyph;
    double[] transformXPts = null;
    double[] transformYPts = null;
    double[] outputtransformXPts = null;
    double[] outputtransformYPts = null;
    static final Long lock = System.currentTimeMillis();
    static TransformCache mTransformCache = new TransformCache();
    protected boolean needsRepaint = true;

    public MapGlyph() {
    }

    public MapGlyph(MapPanel panel, MapObjectInterface map) {
        this();
        this.setMapPanel(panel);
        this.setMap(map);
    }

    public void setMaximumScale(int maxScale) {
        if (this._mapIdentifier == null) {
            return;
        }
        this._mapIdentifier.setMaximumScale(maxScale);
    }

    public void setMinimumScale(int minScale) {
        if (this._mapIdentifier == null) {
            return;
        }
        this._mapIdentifier.setMinimumScale(minScale);
    }

    public void setGlyphLevel(float glyphLevel) {
        this._glyphLevel = glyphLevel;
    }

    public float getGlyphLevel() {
        return this._glyphLevel;
    }

    public void setMapPanel(MapPanel panel) {
        this._mapPanel = panel;
        if (this._map != null && this.getBounds() != null) {
            this._mapPanel.growRegionExtents(this.getBounds());
        }
        this.init();
    }

    public void setMap(MapObjectInterface map) {
        if (map == null) {
            return;
        }
        this._map = map;
        GlyphDataRecord gdr = null;
        if (this._mapIdentifier != null) {
            gdr = this._mapIdentifier.getGlyphDataRecord();
        }
        this._mapIdentifier = this._map.getMapIdentifier();
        if (gdr != null) {
            this._mapIdentifier.setGlyphDataRecord(gdr);
        }
        WorldRect bounds = this.getBounds();
        if (this._mapPanel != null && bounds != null) {
            this._mapPanel.growRegionExtents(bounds);
        }
        this.fillMap(this._mapIdentifier.getMapShown(this));
        this.init();
    }

    public void setDataRecord(GlyphDataRecord rec) {
        if (this._mapIdentifier == null) {
            return;
        }
        this._mapIdentifier.setGlyphDataRecord(rec);
    }

    public void setShown(boolean shown) {
        boolean wasShown = this.isShown();
        if (wasShown != shown) {
            this.setRepaintNeeded(true);
        }
        if (this._mapIdentifier != null) {
            this._mapIdentifier.setMapShown(shown, this);
            try {
                if (!shown) {
                    this._map.unload();
                }
                this.fillMap(shown);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fireStateChanged();
        } else {
            System.out.println("MapGlyph:  _mapIdentifier is null");
        }
    }

    public int getMaximumScale() {
        if (this._mapIdentifier == null) {
            return Integer.MAX_VALUE;
        }
        return this._mapIdentifier.getMaximumScale();
    }

    public int getMinimumScale() {
        if (this._mapIdentifier == null) {
            return Integer.MIN_VALUE;
        }
        return this._mapIdentifier.getMinimumScale();
    }

    public GlyphDataRecord getDefaultDataRecord() {
        return null;
    }

    @Scriptable
    public MapPanel getMapPanel() {
        return this._mapPanel;
    }

    @Scriptable
    public MapObjectInterface getMap() {
        return this._map;
    }

    @Scriptable
    public GlyphDataRecord getDataRecord() {
        GlyphDataRecord data = null;
        if (this._mapIdentifier != null && (data = this._mapIdentifier.getGlyphDataRecord()) == null && (data = this.getDefaultDataRecord()) != null) {
            MapObjectInterface obj;
            if (data instanceof GlyphDataRecordSerializable && (obj = this.getMap()) instanceof MapObject) {
                int dot;
                MapObject map = (MapObject)obj;
                FileOpener fo = map.getFileOpener();
                String mapFileFullPath = map.getMapIdentifier().getPath();
                if (RMAIO.isFullPath(mapFileFullPath) && (dot = mapFileFullPath.lastIndexOf(46)) >= 1) {
                    String gdrFileFullPath = mapFileFullPath.substring(0, dot) + ".gdr";
                    Identifier fileRequest = new Identifier(gdrFileFullPath);
                    Identifier serializedId = fo.openFile(fileRequest, true);
                    if (serializedId != null && serializedId.getFile() != null && serializedId.getFile().exists()) {
                        BufferedReader in = serializedId.getFile().getBufferedReader();
                        try {
                            ((GlyphDataRecordSerializable)((Object)data)).deserialize(in);
                        }
                        catch (Exception e) {
                            System.out.println(e.getMessage());
                            e.printStackTrace();
                        }
                    } else {
                        Identifier fileRequest1 = fo.createFile(fileRequest);
                        if (fileRequest1.getFile().canWrite()) {
                            BufferedWriter out = fileRequest1.getFile().getBufferedWriter();
                            try {
                                ((GlyphDataRecordSerializable)((Object)data)).serialize(out);
                                out.flush();
                                out.close();
                            }
                            catch (Exception e) {
                                System.out.println(e.getMessage());
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
            this.setDataRecord(data);
        }
        return data;
    }

    @Scriptable
    public String getName() {
        if (this._map != null) {
            return this._map.getName();
        }
        return null;
    }

    @Scriptable
    public String getDescription() {
        if (this._map != null) {
            return this._map.getName();
        }
        return null;
    }

    @Scriptable
    public boolean isShown() {
        if (this._mapIdentifier == null) {
            return false;
        }
        return this._mapIdentifier.getMapShown(this);
    }

    @Scriptable
    public WorldRect getBounds() {
        return this.transformRect(this._map.getExtent());
    }

    protected LocalRect transformRectToLocal(WorldRect bounds) {
        CoordinateReferenceSystem dataCrs = this._map.getCoordinateReferenceSystem();
        CoordinateReferenceSystem viewCrs = DisplayCoordinateReferenceSystem.getDefault().getCoordinateRefereceSystem();
        WorldRect wr = this.transformRect(bounds, dataCrs, viewCrs);
        return this._mapPanel.scale().wr2lr(wr);
    }

    protected WorldRect transformRect(WorldRect bounds) {
        CoordinateReferenceSystem dataCrs = this._map.getCoordinateReferenceSystem();
        CoordinateReferenceSystem viewCrs = DisplayCoordinateReferenceSystem.getDefault().getCoordinateRefereceSystem();
        return this.transformRect(bounds, dataCrs, viewCrs);
    }

    protected LocalPt transformPointToLocal(WorldPt pt) throws CRSException {
        CoordinateReferenceSystem fromCrs = this._map.getCoordinateReferenceSystem();
        CoordinateReferenceSystem toCrs = DisplayCoordinateReferenceSystem.getDefault().getCoordinateRefereceSystem();
        WorldPt xformPt = this.transformPoint(pt, fromCrs, toCrs);
        return this._mapPanel._scale.wp2lp(xformPt);
    }

    protected WorldPt transformPointToWorld(LocalPt pt) throws CRSException {
        CoordinateReferenceSystem fromCrs = DisplayCoordinateReferenceSystem.getDefault().getCoordinateRefereceSystem();
        CoordinateReferenceSystem toCrs = this._map.getCoordinateReferenceSystem();
        WorldPt lp2wp = this._mapPanel._scale.lp2wp(pt);
        return this.transformPoint(lp2wp, fromCrs, toCrs);
    }

    protected WorldPt transformPoint(WorldPt pt, CoordinateReferenceSystem fromCrs, CoordinateReferenceSystem toCrs) throws CRSException {
        if (this.transformXPts == null) {
            this.transformXPts = new double[4];
            this.transformYPts = new double[4];
            this.outputtransformXPts = new double[4];
            this.outputtransformYPts = new double[4];
        }
        this.transformXPts[0] = pt.e;
        this.transformYPts[0] = pt.n;
        this.transformArrays(this.transformXPts, this.transformYPts, this.outputtransformXPts, this.outputtransformYPts, 0, 1, fromCrs, toCrs);
        return new WorldPt(this.outputtransformXPts[0], this.outputtransformYPts[0]);
    }

    protected void transformWorldToLocalArrays(double[] xarray, double[] yarray, double[] outxarray, double[] outyarray, int offset, int numPoints) throws CRSException {
        this.transformArrays(xarray, yarray, outxarray, outyarray, offset, numPoints, this._map.getCoordinateReferenceSystem(), DisplayCoordinateReferenceSystem.getDefault().getCoordinateRefereceSystem());
        WorldPt wpt = new WorldPt();
        MapScale scl = this._mapPanel.scale();
        for (int i = offset; i < numPoints; ++i) {
            wpt.init(xarray[i], yarray[i]);
            outxarray[i] = scl.e2x(xarray[i]);
            outyarray[i] = scl.n2y(yarray[i]);
        }
    }

    protected void transformLocalToWorldArrays(double[] xarray, double[] yarray, double[] outxarray, double[] outyarray, int offset, int numPoints) throws CRSException {
        WorldPt wpt = new WorldPt();
        LocalPt lpt = new LocalPt();
        MapScale scl = this._mapPanel.scale(this);
        for (int i = offset; i < numPoints; ++i) {
            lpt.init((int)xarray[i], (int)yarray[i]);
            scl.lp2wp(lpt, wpt);
            outxarray[i] = wpt.e;
            outyarray[i] = wpt.n;
        }
    }

    protected void transformArrays(double[] xarray, double[] yarray, double[] outxarray, double[] outyarray, int offset, int numPoints, CoordinateReferenceSystem fromCrs, CoordinateReferenceSystem toCrs) throws CRSException {
        Transform transform = this.transformLookup(fromCrs, toCrs);
        if (transform == null) {
            return;
        }
        transform.transform(xarray, yarray, offset, outxarray, outyarray, offset, numPoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WorldRect transformRect(WorldRect bounds, CoordinateReferenceSystem fromCrs, CoordinateReferenceSystem toCrs) {
        Transform transform;
        if (bounds == null || !bounds.isValid()) {
            LOGGER.log(Level.FINE, "MapGlph.transformRect() : NULL or Invalid rectangle passed in as a parameter. Returning");
            return bounds;
        }
        if (this.transformXPts == null) {
            this.transformXPts = new double[4];
            this.transformYPts = new double[4];
            this.outputtransformXPts = new double[4];
            this.outputtransformYPts = new double[4];
        }
        if ((transform = this.transformLookup(fromCrs, toCrs)) == null) {
            return bounds;
        }
        this.transformXPts[0] = bounds.e;
        this.transformYPts[0] = bounds.n;
        this.transformXPts[1] = bounds.w;
        this.transformYPts[1] = bounds.n;
        this.transformXPts[2] = bounds.w;
        this.transformYPts[2] = bounds.s;
        this.transformXPts[3] = bounds.e;
        this.transformYPts[3] = bounds.s;
        try {
            Long l = lock;
            synchronized (l) {
                transform.transform(this.transformXPts, this.transformYPts, 0, this.outputtransformXPts, this.outputtransformYPts, 0, 4);
            }
        }
        catch (CRSException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            return bounds;
        }
        WorldRect wr = new WorldRect();
        WorldPt pt = new WorldPt();
        pt.e = this.outputtransformXPts[0];
        pt.n = this.outputtransformYPts[0];
        wr.grow(pt);
        pt.e = this.outputtransformXPts[1];
        pt.n = this.outputtransformYPts[1];
        wr.grow(pt);
        pt.e = this.outputtransformXPts[2];
        pt.n = this.outputtransformYPts[2];
        wr.grow(pt);
        pt.e = this.outputtransformXPts[3];
        pt.n = this.outputtransformYPts[3];
        wr.grow(pt);
        return wr;
    }

    protected Transform transformLookup(CoordinateReferenceSystem srcCrs, CoordinateReferenceSystem targetCrs) {
        Transform transform = mTransformCache.get(srcCrs, targetCrs);
        if (transform == null) {
            try {
                transform = CRS.getDefault().findTransform(srcCrs, targetCrs, true);
                mTransformCache.put(srcCrs, targetCrs, transform);
            }
            catch (CRSException ex) {
                Logger.getLogger(MapGlyph.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return transform;
    }

    @Scriptable
    public String getToolTipText(WorldPt wpt, MouseEvent e) {
        return null;
    }

    public boolean isAttributeAvailable(String s) {
        return true;
    }

    public boolean isWriteLocked() {
        MapApplicationModule module = (MapApplicationModule)AppDaddy.getFrame().getCurrentModule();
        return module.hasWriteLock(this);
    }

    public ModelDrawingAttributeSet getAttributeSet() {
        return null;
    }

    @Scriptable
    public NamedType getSelectedObject() {
        return null;
    }

    @Scriptable
    public NamedType[] getSelections() {
        NamedType nt = this.getSelectedObject();
        if (nt == null) {
            return new NamedType[0];
        }
        return new NamedType[]{nt};
    }

    public String toString() {
        return this.getMap().getMapIdentifier().getName();
    }

    @Scriptable
    public NamedType findObject(LocalPt pt) {
        return null;
    }

    public boolean hasMap() {
        boolean tf = this._map != null;
        return tf;
    }

    public void showMapElement(String glyphName, String glyphElement, boolean show) {
        if (glyphElement.equals("shown")) {
            this.setShown(show);
        }
    }

    public void fillMap(boolean load) {
        if (load) {
            try {
                this._map.load();
                if (this._mapPanel != null) {
                    this._mapPanel.growRegionExtents(this.getBounds());
                }
            }
            catch (Exception e) {
                System.out.println("Error loading map " + this._map.getName() + " from Map Panel  " + e);
                e.printStackTrace();
            }
        } else if (!MapIdentifier._useEachGlyphShownState) {
            this._map.unload();
        }
    }

    @Scriptable
    public boolean objectPopupMenu(LocalPt pt, int modifiers) {
        return false;
    }

    @Scriptable
    public NamedType objectSelect(LocalPt pt, int modifiers) {
        return null;
    }

    @Scriptable
    public boolean objectDoubleClick(LocalPt pt, int modifiers) {
        return false;
    }

    public abstract void draw(Graphics var1, MapScale var2);

    public void drawConformingString(Graphics g, MapScale scl, WorldLine line, String str, double coord, int baseoffset, Font font, Color color, int bank, float priority) {
        int[] ya;
        int[] xa;
        double fac;
        double len2;
        WorldPt pt;
        int i;
        Font f;
        if (bank != 1 && bank != -1) {
            bank = 1;
        }
        if ((f = g.getFont()) != font) {
            g.setFont(font);
        }
        FontMetrics metrics = g.getFontMetrics();
        int strwidth = metrics.stringWidth(str);
        int h = metrics.getHeight();
        int ascent = metrics.getAscent();
        int descent = metrics.getDescent();
        int hoff = (int)((double)h / 2.0 + 0.5) - ascent;
        int w = metrics.getMaxAdvance();
        int numchar = str.length();
        int icenter = line.getPtIndexBeforeCoord(coord);
        if (icenter < 0) {
            return;
        }
        int npts = line.pts.size();
        LocalPt lpt = new LocalPt();
        WorldPt cpt = line.getLocationByCoord(coord);
        int[] locxarray = new int[npts + 1];
        int[] locyarray = new int[npts + 1];
        scl.wp2lp(cpt, lpt);
        locxarray[icenter + 1] = lpt.x;
        locyarray[icenter + 1] = lpt.y;
        double len = 0.0;
        int istart = 0;
        int iend = npts;
        for (i = icenter; i >= 0; --i) {
            pt = (WorldPt)line.pts.get(i);
            scl.wp2lp(pt, lpt);
            locxarray[i] = lpt.x;
            locyarray[i] = lpt.y;
            len2 = Math.sqrt((locxarray[icenter + 1] - locxarray[i]) * (locxarray[icenter + 1] - locxarray[i]) + (locyarray[icenter + 1] - locyarray[i]) * (locyarray[icenter + 1] - locyarray[i]));
            if (len2 >= (double)strwidth * 0.6) {
                fac = ((double)strwidth * 0.6 - len) / (len2 - len);
                locxarray[i] = locxarray[i + 1] + (int)((double)(locxarray[i] - locxarray[i + 1]) * fac);
                locyarray[i] = locyarray[i + 1] + (int)((double)(locyarray[i] - locyarray[i + 1]) * fac);
                len = (double)strwidth * 0.6;
                istart = i;
                break;
            }
            len = len2;
        }
        for (i = icenter + 1; i < npts; ++i) {
            pt = (WorldPt)line.pts.get(i);
            scl.wp2lp(pt, lpt);
            locxarray[i + 1] = lpt.x;
            locyarray[i + 1] = lpt.y;
            len2 = Math.sqrt((locxarray[i + 1] - locxarray[istart]) * (locxarray[i + 1] - locxarray[istart]) + (locyarray[i + 1] - locyarray[istart]) * (locyarray[i + 1] - locyarray[istart]));
            if (len2 >= (double)strwidth * 1.2) {
                fac = ((double)strwidth * 1.2 - len) / (len2 - len);
                locxarray[i + 1] = locxarray[i] + (int)((double)(locxarray[i + 1] - locxarray[i]) * fac);
                locyarray[i + 1] = locyarray[i] + (int)((double)(locyarray[i + 1] - locyarray[i]) * fac);
                len = (double)strwidth * 1.2;
                iend = i + 1;
                break;
            }
            len = len2;
        }
        if (len < (double)strwidth && istart == 0) {
            return;
        }
        int xmin = Integer.MAX_VALUE;
        int xmax = Integer.MIN_VALUE;
        int ymin = Integer.MAX_VALUE;
        int ymax = Integer.MIN_VALUE;
        for (i = istart; i <= iend; ++i) {
            if (xmin > locxarray[i]) {
                xmin = locxarray[i];
            }
            if (xmax < locxarray[i]) {
                xmax = locxarray[i];
            }
            if (ymin > locyarray[i]) {
                ymin = locyarray[i];
            }
            if (ymax >= locyarray[i]) continue;
            ymax = locyarray[i];
        }
        if (xmax - xmin >= ymax - ymin) {
            xa = locxarray;
            ya = locyarray;
        } else {
            ya = locxarray;
            xa = locyarray;
        }
        double[] mb = RmaMath.bestFitLinear(xa, ya, iend - istart + 1, istart);
        double ang = 1.5707963267948966;
        if (xmax - xmin < ymax - ymin) {
            ang = 0.0;
        }
        if (mb[0] != Double.NEGATIVE_INFINITY) {
            ang = xmax - xmin >= ymax - ymin ? Math.atan(mb[0]) : (mb[0] != 0.0 ? Math.atan(1.0 / mb[0]) : 1.5707963267948966);
        }
        double ca = Math.cos(-ang);
        double sa = Math.sin(-ang);
        double ytmax = -999999.0;
        double ytmin = 999999.0;
        for (i = istart; i <= iend; ++i) {
            double yt = sa * (double)(locxarray[i] - locxarray[icenter + 1]) + ca * (double)(locyarray[i] - locyarray[icenter + 1]);
            if (ytmax < yt) {
                ytmax = yt;
            }
            if (!(ytmin > yt)) continue;
            ytmin = yt;
        }
        double xt0 = ca * (double)(locxarray[istart] - locxarray[icenter + 1]) - sa * (double)(locyarray[istart] - locyarray[icenter + 1]);
        if (xt0 > 0.0) {
            bank *= -1;
        }
        int ioff = bank <= 0 ? baseoffset + ascent + (int)ytmax : (int)ytmin - descent - baseoffset;
        this._mapPanel.viewport().addMapTextObject(new RotatedMapText(str, locxarray[icenter + 1], locyarray[icenter + 1], ang, ioff, priority, font, color, null, g));
        if (f != font) {
            g.setFont(f);
        }
    }

    public void drawConformingString2(Graphics g, MapScale scl, WorldLine line, String str, double coord, Font font, Color color, int bank) {
        double coord1;
        if (bank != 1 && bank != -1) {
            bank = 1;
        }
        double strmlen = line.getLength();
        WorldPt pt = (WorldPt)line.pts.elementAt(0);
        double strmlenLocal = scl.wp2lp((WorldPt)new WorldPt((double)(pt.e + strmlen), (double)pt.n)).x - scl.wp2lp((WorldPt)pt).x;
        double localScl = strmlenLocal / strmlen;
        double coordScl = 1.0 / strmlenLocal;
        FontMetrics metrics = g.getFontMetrics();
        int strwidth = metrics.stringWidth(str);
        int h = metrics.getHeight();
        int ascent = metrics.getAscent();
        int descent = metrics.getDescent();
        int hoff = (int)((double)h / 2.0 + 0.5) - ascent;
        int w = metrics.getMaxAdvance();
        int numchar = str.length();
        double strCoordLen = (double)strwidth * coordScl;
        double offset = scl.lp2wp((LocalPt)new LocalPt((int)((int)((double)(descent + h) + 0.5)), (int)0)).e - scl.lp2wp((LocalPt)new LocalPt((int)0, (int)0)).e;
        double offset2 = scl.lp2wp((LocalPt)new LocalPt((int)(h / 2), (int)0)).e - scl.lp2wp((LocalPt)new LocalPt((int)0, (int)0)).e;
        double coord0 = coord - strCoordLen * 0.65;
        if (coord0 < 0.0) {
            coord0 = 0.0;
        }
        if ((coord1 = coord0 + strCoordLen * 1.3) > 1.0 && (coord0 = (coord1 = 1.0) - strCoordLen * 1.3) < 0.0) {
            return;
        }
        WorldLine offline = line.createOffsetLine(coord0, coord1, offset, bank);
        if (offline == null) {
            return;
        }
        offline = offline.createOffsetLine(0.0, 1.0, offset2, -1 * bank);
        this._mapPanel.viewport().addMapTextObject(new ConformingMapText(str, offline, scl, 0.1f, font, color, null, g));
    }

    @Scriptable
    public void clearSelection() {
    }

    public void clearSelection(String name) {
    }

    public void addGlyphSelectionListener(GlyphSelectionListener msl) {
        if (msl == null) {
            return;
        }
        this._listenerList.add(GlyphSelectionListener.class, msl);
    }

    public void removeGlyphSelectionListener(GlyphSelectionListener msl) {
        if (msl == null) {
            return;
        }
        this._listenerList.remove(GlyphSelectionListener.class, msl);
    }

    public void addChangeListener(ChangeListener cl) {
        if (cl == null) {
            return;
        }
        this._listenerList.add(ChangeListener.class, cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        if (cl == null) {
            return;
        }
        this._listenerList.remove(ChangeListener.class, cl);
    }

    public void close() {
    }

    @Scriptable
    public boolean hasChildGlyphs() {
        return false;
    }

    @Scriptable
    public Vector<MapGlyph> glyphVector() {
        return null;
    }

    @Scriptable
    public MapGlyph findGlyphOfClass(String classname) {
        return null;
    }

    protected void init() {
    }

    public void reInit() {
        this.init();
    }

    public boolean intersects(Graphics2D graphics, MapScale scl, int[] xarray, int[] yarray, int numpts) {
        if (scl == null || xarray == null || yarray == null || numpts == 0) {
            return false;
        }
        Rectangle rect = new Rectangle();
        LocalRect lrect = scl.getViewRect();
        rect.add(lrect.l, lrect.t);
        rect.add(lrect.r, lrect.b);
        for (int i = 0; i < numpts - 1; ++i) {
            if (!rect.intersectsLine(xarray[i], yarray[i], xarray[i + 1], yarray[i + 1])) continue;
            return true;
        }
        return false;
    }

    protected void fireStateChanged() {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this._changeEvent == null) {
                this._changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this._changeEvent);
        }
    }

    protected void fireGlyphSelectionChanged(NamedType selectedObj) {
        Object[] listeners = this._listenerList.getListenerList();
        GlyphSelectionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GlyphSelectionListener.class) continue;
            if (e == null) {
                e = new GlyphSelectionEvent(this, selectedObj);
            }
            ((GlyphSelectionListener)listeners[i + 1]).glyphSelectionChanged(e);
        }
    }

    public void drawLine(Graphics g, WorldLine line, MapScale scl, double halfwidth, Color fillColor, Color outlineColor) {
        this.drawLine(g, line, scl, halfwidth, fillColor, outlineColor, false, null, 0);
    }

    public void drawLine(Graphics g, WorldLine line, MapScale scl, double halfwidth, Color fillColor, Color outlineColor, boolean drawPoints, Color pointColor, int halfPointSize) {
        if (Boolean.getBoolean("noDrawLines2d") || !(g instanceof Graphics2D)) {
            this.drawLine(g, line, scl, halfwidth, fillColor, outlineColor, drawPoints, pointColor, halfPointSize, false);
        } else {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.drawLine2D(g, line, scl, halfwidth, fillColor, outlineColor, drawPoints, pointColor, halfPointSize, false);
        }
    }

    public void drawLine(Graphics g, WorldLine line, MapScale scl, double halfwidth, Color fillColor, Color outlineColor, boolean drawPoints, Color pointColor, int halfPointSize, boolean isXOR) {
        if (isXOR) {
            this.drawLine(g, line, scl, halfwidth, fillColor, outlineColor, drawPoints, pointColor, halfPointSize, isXOR, -1.0f);
        } else {
            this.drawLine2D(g, line, scl, halfwidth, fillColor, outlineColor, drawPoints, pointColor, halfPointSize, false);
        }
    }

    public void drawLine(Graphics g, WorldLine line, MapScale scl, double halfwidth, Color fillColor, Color outlineColor, boolean drawPoints, Color pointColor, int halfPointSize, boolean isXOR, float alpha) {
        int ilength;
        if (g == null || line == null || scl == null) {
            return;
        }
        Color oldClr = g.getColor();
        int offset = 0;
        if (!isXOR) {
            g.setPaintMode();
        } else {
            g.setXORMode(XOR_COLOR);
        }
        double[] xformXarray = null;
        double[] xformYarray = null;
        int[] locxarray = new int[maxPtArraySz];
        int[] locyarray = new int[maxPtArraySz];
        int[] xpt = new int[4];
        int[] ypt = new int[4];
        do {
            if ((ilength = line.pts.size() - offset) * 2 - 1 > locxarray.length) {
                ilength = (locxarray.length - 1) / 2;
            }
            Vector pts = line.pts;
            if (xformXarray == null || xformXarray.length < ilength) {
                xformXarray = new double[ilength];
                xformYarray = new double[ilength];
            }
            int idx = 0;
            int z = offset;
            while (z < ilength) {
                xformXarray[idx] = ((WorldPt)pts.get((int)z)).e;
                xformYarray[idx] = ((WorldPt)pts.get((int)z)).n;
                ++z;
                ++idx;
            }
            try {
                this.transformWorldToLocalArrays(xformXarray, xformYarray, xformXarray, xformYarray, 0, ilength);
                for (z = 0; z < ilength; ++z) {
                    locxarray[z] = (int)xformXarray[z];
                    locyarray[z] = (int)xformYarray[z];
                }
            }
            catch (CRSException ex) {
                Logger.getLogger(MapGlyph.class.getName()).log(Level.SEVERE, null, ex);
                return;
            }
            int icnt = ilength;
            if (icnt <= 0) continue;
            if (fillColor != null) {
                g.setColor(fillColor);
                if (alpha >= 0.0f && alpha <= 1.0f) {
                    if (g instanceof Graphics2D) {
                        Graphics2D g2 = (Graphics2D)g;
                        Composite oldac = g2.getComposite();
                        AlphaComposite ac = AlphaComposite.getInstance(3, alpha);
                        g2.setComposite(ac);
                        try {
                            g.fillPolygon(locxarray, locyarray, icnt);
                        }
                        catch (InternalError ie) {
                            g.fillPolygon(locxarray, locyarray, icnt);
                        }
                        if (oldac != null) {
                            g2.setComposite(oldac);
                        }
                    }
                } else {
                    try {
                        g.fillPolygon(locxarray, locyarray, icnt);
                    }
                    catch (InternalError ie) {
                        g.fillPolygon(locxarray, locyarray, icnt);
                    }
                }
            }
            if (outlineColor != null) {
                g.setColor(outlineColor);
                g.drawPolygon(locxarray, locyarray, icnt);
            }
            if (!drawPoints || pointColor == null || halfPointSize <= 0) continue;
            g.setColor(pointColor);
            for (int i = 0; i < icnt; ++i) {
                xpt[0] = locxarray[i] - halfPointSize;
                ypt[0] = locyarray[i];
                xpt[1] = locxarray[i];
                ypt[1] = locyarray[i] + halfPointSize;
                xpt[2] = locxarray[i] + halfPointSize;
                ypt[2] = locyarray[i];
                xpt[3] = locxarray[i];
                ypt[3] = locyarray[i] - halfPointSize;
                try {
                    g.fillPolygon(xpt, ypt, 4);
                    continue;
                }
                catch (InternalError ie) {
                    g.fillPolygon(xpt, ypt, 4);
                }
            }
        } while ((offset += ilength) < line.pts.size() && --offset < line.pts.size());
        g.setColor(oldClr);
        if (isXOR) {
            g.setPaintMode();
        }
    }

    public void drawLine2D(Graphics g, WorldLine line, MapScale scl, double halfwidth, Color fillColor, Color outlineColor, boolean drawPoints, Color pointColor, int halfPointSize, boolean isXOR) {
        if (g == null || line == null || scl == null) {
            return;
        }
        long[] nextCheck = new long[]{-1L};
        if (MapGlyph.shouldReturn(nextCheck)) {
            return;
        }
        int offset = 0;
        if (!isXOR) {
            g.setPaintMode();
        }
        Graphics2D g2 = (Graphics2D)g;
        Stroke oldStroke = g2.getStroke();
        BasicStroke fillStroke = null;
        if (fillColor != null) {
            fillStroke = new BasicStroke((float)halfwidth, 2, 2);
        }
        BasicStroke outlineStroke = null;
        if (outlineColor != null) {
            outlineStroke = new BasicStroke((float)(2.0 + halfwidth));
        }
        GeneralPath polyline = new GeneralPath(1, 1000);
        double[] xformXarray = null;
        double[] xformYarray = null;
        int[] locxarray = new int[maxPtArraySz];
        int[] locyarray = new int[maxPtArraySz];
        int[] xpt = new int[4];
        int[] ypt = new int[4];
        while (offset < line.pts.size()) {
            if (MapGlyph.shouldReturn(nextCheck)) {
                return;
            }
            int ilength = line.pts.size() - offset;
            if (ilength * 2 - 1 > locxarray.length) {
                ilength = (locxarray.length - 1) / 2;
            }
            if (xformXarray == null || xformXarray.length < ilength) {
                xformXarray = new double[ilength];
                xformYarray = new double[ilength];
            }
            int idx = 0;
            int z = offset;
            while (z < offset + ilength) {
                WorldPt wpt = (WorldPt)line.pts.get(z);
                xformXarray[idx] = wpt.e;
                xformYarray[idx] = wpt.n;
                ++z;
                ++idx;
            }
            try {
                this.transformWorldToLocalArrays(xformXarray, xformYarray, xformXarray, xformYarray, 0, ilength);
                idx = 0;
                z = 0;
                while (z < ilength) {
                    locxarray[z] = (int)xformXarray[idx];
                    locyarray[z] = (int)xformYarray[idx];
                    ++z;
                    ++idx;
                }
            }
            catch (CRSException ex) {
                Logger.getLogger(MapGlyph.class.getName()).log(Level.SEVERE, null, ex);
                return;
            }
            int icnt = ilength;
            if (icnt <= 0) break;
            if (this.intersects(g2, scl, locxarray, locyarray, icnt)) {
                polyline.moveTo(locxarray[0], locyarray[0]);
                for (int index = 1; index < icnt; ++index) {
                    if (MapGlyph.shouldReturn(nextCheck)) {
                        return;
                    }
                    polyline.lineTo(locxarray[index], locyarray[index]);
                }
                if (outlineColor != null) {
                    g2.setPaint(outlineColor);
                    g2.setStroke(outlineStroke);
                    g2.draw(polyline);
                }
                if (fillColor != null) {
                    g2.setPaint(fillColor);
                    g2.setStroke(fillStroke);
                    g2.draw(polyline);
                }
                if (drawPoints && pointColor != null && halfPointSize > 0) {
                    g.setColor(pointColor);
                    for (int i = 0; i < icnt; ++i) {
                        if (MapGlyph.shouldReturn(nextCheck)) {
                            return;
                        }
                        xpt[0] = locxarray[i] - halfPointSize;
                        ypt[0] = locyarray[i];
                        xpt[1] = locxarray[i];
                        ypt[1] = locyarray[i] + halfPointSize;
                        xpt[2] = locxarray[i] + halfPointSize;
                        ypt[2] = locyarray[i];
                        xpt[3] = locxarray[i];
                        ypt[3] = locyarray[i] - halfPointSize;
                        try {
                            g.fillPolygon(xpt, ypt, 4);
                            continue;
                        }
                        catch (InternalError ie) {
                            g.fillPolygon(xpt, ypt, 4);
                        }
                    }
                }
                polyline.reset();
            }
            if ((offset += icnt) >= line.pts.size()) break;
            --offset;
        }
        g2.setStroke(oldStroke);
    }

    public void drawRegion(Graphics g, MapScale scl, WorldRegion region, boolean drawPts, Color outline, Color fill) {
        this.drawRegion(g, scl, region, drawPts, outline, fill, 0.6f);
    }

    public void drawRegion(Graphics g, MapScale scl, WorldRegion region, boolean drawPts, Color outline, Color fill, float alpha) {
        WorldPt pt;
        int i;
        if (g == null || scl == null || region == null) {
            return;
        }
        int size = region.pts.size();
        int[] locxarray = new int[size];
        int[] locyarray = new int[size];
        int[] xpt = new int[4];
        int[] ypt = new int[4];
        int icnt = 0;
        LocalPt lpt = new LocalPt();
        for (i = 0; i < size && (pt = (WorldPt)region.pts.elementAt(i)) != null; ++i) {
            scl.wp2lp(pt, lpt);
            locxarray[i] = lpt.x;
            locyarray[i] = lpt.y;
            ++icnt;
        }
        Graphics2D g2 = null;
        Composite oldac = null;
        AlphaComposite ac = null;
        if (g instanceof Graphics2D) {
            g2 = (Graphics2D)g;
            oldac = g2.getComposite();
            ac = AlphaComposite.getInstance(3, alpha);
        }
        if (i > 0) {
            if (fill != null) {
                g.setColor(fill);
                if (g2 != null) {
                    g2.setComposite(ac);
                    try {
                        g2.fillPolygon(locxarray, locyarray, i);
                    }
                    catch (InternalError ie) {
                        g2.fillPolygon(locxarray, locyarray, i);
                    }
                    if (oldac != null) {
                        g2.setComposite(oldac);
                    }
                } else {
                    g.setXORMode(XOR_COLOR);
                    try {
                        g.fillPolygon(locxarray, locyarray, i);
                    }
                    catch (InternalError ie) {
                        g2.fillPolygon(locxarray, locyarray, i);
                    }
                    g.setPaintMode();
                }
            }
            if (outline != null) {
                g.setColor(outline);
                g.drawPolygon(locxarray, locyarray, i);
            }
        }
        if (drawPts) {
            for (i = 0; i < icnt; ++i) {
                xpt[0] = locxarray[i] - 3;
                ypt[0] = locyarray[i];
                xpt[1] = locxarray[i];
                ypt[1] = locyarray[i] + 3;
                xpt[2] = locxarray[i] + 3;
                ypt[2] = locyarray[i];
                xpt[3] = locxarray[i];
                ypt[3] = locyarray[i] - 3;
                try {
                    g.fillPolygon(xpt, ypt, 4);
                    continue;
                }
                catch (InternalError ie) {
                    g.fillPolygon(xpt, ypt, 4);
                }
            }
        }
    }

    public static void setPaintOk(boolean b) {
        _paintOk = b;
    }

    public static boolean isPaintOk() {
        return _paintOk;
    }

    @Scriptable
    public static boolean isShiftDown(int modifiers) {
        return (modifiers & 1) != 0;
    }

    @Scriptable
    public static boolean isControlDown(int modifiers) {
        return (modifiers & 2) != 0;
    }

    @Scriptable
    public static boolean isMetaDown(int modifiers) {
        return (modifiers & 4) != 0;
    }

    @Scriptable
    public static boolean isAltDown(int modifiers) {
        return (modifiers & 8) != 0;
    }

    public static void checkXYArraySize(int size) {
        if (size <= maxPtArraySz) {
            return;
        }
        maxPtArraySz = size + 1;
        xarray = new int[maxPtArraySz];
        yarray = new int[maxPtArraySz];
    }

    public boolean containsSelection(Object object) {
        System.out.println("MapGlyph.containsSelection TODO implement me");
        return false;
    }

    public void setParentGlyph(MapGlyph glyph) {
        this._parentGlyph = glyph;
    }

    @Scriptable
    public MapGlyph getParentGlyph() {
        return this._parentGlyph;
    }

    @Override
    public int compareTo(MapGlyph o) {
        if (o == null) {
            return 0;
        }
        if (o.getGlyphLevel() > this.getGlyphLevel()) {
            return -1;
        }
        if (o.getGlyphLevel() < this.getGlyphLevel()) {
            return 1;
        }
        return 0;
    }

    public boolean isRepaintNeeded() {
        return this.needsRepaint;
    }

    public void setRepaintNeeded(boolean isDirty) {
        this.needsRepaint = isDirty;
    }

    public static boolean shouldReturn(long[] nextCheck) {
        boolean okToAccessArray;
        boolean retval = false;
        long MILLIS_BETWEEN_CHECKS = 25L;
        boolean bl = okToAccessArray = nextCheck != null && nextCheck.length >= 1;
        if (!okToAccessArray || nextCheck[0] < System.currentTimeMillis()) {
            if (okToAccessArray) {
                nextCheck[0] = System.currentTimeMillis() + MILLIS_BETWEEN_CHECKS;
            }
            if (Thread.currentThread().isInterrupted()) {
                retval = true;
            }
        } else if (!MapGlyph.isPaintOk()) {
            retval = true;
        }
        return retval;
    }

    public class Selection {
        public Object object = null;
        public boolean editing = false;

        public Selection(Object obj, boolean ed) {
            this.object = obj;
            this.editing = ed;
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that instanceof Selection) {
                return this.object.equals(((Selection)that).object);
            }
            return false;
        }

        public int hashCode() {
            if (this.object == null) {
                return super.hashCode();
            }
            return this.object.hashCode();
        }
    }
}

