/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.MapGlyph;
import hec.map.MapObjectInterface;
import hec.map.MapPanel;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import rma.util.lookup.Lookup;

public class MapGlyphFactory {
    public static Map mapGlyphMapping;
    private static final Map<String, Object> _mapGlyphMapping;

    public static void addMapping(String mapObjectInterfaceClass, String mapGlyphClass) {
        if (mapObjectInterfaceClass == null || mapGlyphClass == null) {
            return;
        }
        _mapGlyphMapping.put(mapObjectInterfaceClass, mapGlyphClass);
    }

    public static MapGlyph newMapGlyph(MapPanel panel, MapObjectInterface map) {
        if (map == null) {
            return null;
        }
        Class[] classes = MapGlyphFactory.getClassesForInstantiation(map.getClass());
        MapGlyph glyph = MapGlyphFactory.instantiateDefaultGlyph(classes[0]);
        if (glyph != null) {
            glyph.setMapPanel(panel);
            glyph.setMap(map);
        } else {
            glyph = MapGlyphFactory.instantiateGlyph(classes, panel, map);
            if (glyph == null) {
                System.out.println("MapGlyphFactory.newMapGlyph: Could not find a MapGlyph matching the map class: " + map.getClass().getName());
                return null;
            }
        }
        return glyph;
    }

    public static MapGlyph newMapGlyph(Class mapclass) {
        Class[] classes = MapGlyphFactory.getClassesForInstantiation(mapclass);
        return MapGlyphFactory.instantiateDefaultGlyph(classes[0]);
    }

    private static MapGlyph instantiateDefaultGlyph(Class glyphClass) {
        try {
            return (MapGlyph)glyphClass.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static MapGlyph instantiateGlyph(Class[] classes, MapPanel panel, MapObjectInterface map) {
        Class glyphClass = classes[0];
        Class mapClass = classes[1];
        if (glyphClass == null) {
            System.out.println("MapGlyphFactory.instantiateGlyph: Could not find a MapGlyph matching the map class: " + mapClass.getName());
            return null;
        }
        try {
            Class[] classargs = new Class[]{MapPanel.class, mapClass};
            Constructor constructor = glyphClass.getConstructor(classargs);
            if (constructor != null) {
                Object[] objargs = new Object[]{panel, map};
                return (MapGlyph)constructor.newInstance(objargs);
            }
        }
        catch (InvocationTargetException ite) {
            System.out.println("MapGlyphFactory.instantiateGlyph: Could not find a MapGlyph matching the map class: " + mapClass.getName());
            System.out.println("MapGlyphFactory: " + ite.toString());
            ite.getTargetException().printStackTrace();
        }
        catch (Exception ee) {
            System.out.println("MapGlyphFactory.instantiateGlyph: Couldn't find a MapGlyph matching the map class: " + mapClass.getName());
            System.out.println("MapGlyphFactory: " + ee.toString());
            ee.printStackTrace();
        }
        return null;
    }

    private static Class[] getClassesForInstantiation(Class mapClass) {
        String strMapClass = mapClass.getName();
        Class[] classes = new Class[2];
        classes[1] = mapClass;
        Object o = _mapGlyphMapping.get(strMapClass);
        if (o instanceof String) {
            try {
                classes[0] = Thread.currentThread().getContextClassLoader().loadClass((String)o);
                _mapGlyphMapping.put(strMapClass, classes[0]);
            }
            catch (Exception e) {
                System.out.println("Unable to instantiate class for Map: " + strMapClass + "  " + e);
                _mapGlyphMapping.put(strMapClass, o);
            }
        } else if (o instanceof Class) {
            classes[0] = (Class)o;
        }
        if (classes[0] == null) {
            Class cls = classes[1];
            do {
                Class<?>[] mapclassifcs = cls.getInterfaces();
                for (int ii = 0; mapclassifcs != null && ii < mapclassifcs.length; ++ii) {
                    Class<?> tMapclass = mapclassifcs[ii];
                    strMapClass = tMapclass.getName();
                    o = _mapGlyphMapping.get(strMapClass);
                    if (o instanceof String) {
                        try {
                            classes[0] = Thread.currentThread().getContextClassLoader().loadClass((String)o);
                            _mapGlyphMapping.put(strMapClass, classes[0]);
                        }
                        catch (Exception e) {
                            System.out.println("Unable to instantiate class for Map Interface: " + strMapClass + "  " + e);
                            _mapGlyphMapping.put(strMapClass, o);
                        }
                    } else if (o instanceof Class) {
                        classes[0] = (Class)o;
                    }
                    if (classes[0] == null) continue;
                    classes[1] = tMapclass;
                    break;
                }
                cls = cls.getSuperclass();
            } while (classes[0] == null && cls != null);
            for (Class superClass = classes[1].getSuperclass(); superClass != null && classes[0] == null; superClass = superClass.getSuperclass()) {
                strMapClass = superClass.getName();
                o = _mapGlyphMapping.get(strMapClass);
                if (o instanceof String) {
                    try {
                        classes[0] = Thread.currentThread().getContextClassLoader().loadClass((String)o);
                        _mapGlyphMapping.put(strMapClass, classes[0]);
                    }
                    catch (Exception e) {
                        System.out.println("Unable to instantiate class for Map Interface: " + strMapClass + "  " + e);
                        _mapGlyphMapping.put(strMapClass, o);
                    }
                } else if (o instanceof Class) {
                    classes[0] = (Class)o;
                }
                if (classes[0] == null) continue;
                classes[1] = superClass;
                break;
            }
        }
        return classes;
    }

    public static Class getGlyphClassFor(MapObjectInterface map) {
        if (map == null) {
            return null;
        }
        return MapGlyphFactory.getGlyphClassFor(map.getClass());
    }

    public static Class getGlyphClassFor(Class mapClass) {
        if (mapClass == null) {
            return null;
        }
        Class[] clsInfo = MapGlyphFactory.getClassesForInstantiation(mapClass);
        if (clsInfo != null) {
            return clsInfo[0];
        }
        return null;
    }

    static {
        _mapGlyphMapping = new HashMap<String, Object>();
        _mapGlyphMapping.put("hec.map.dlg.DlgMap", "hec.map.dlg.DlgGlyph");
        _mapGlyphMapping.put("hec.map.dxf.DxfMap", "hec.map.dxf.DxfGlyph");
        _mapGlyphMapping.put("hec.map.image.ImageMap", "hec.map.image.ImageGlyphProxy");
        _mapGlyphMapping.put("hec.map.tin.TinMap", "hec.map.tin.TinGlyph");
        _mapGlyphMapping.put("hec.map.aishape.AiShapeMap", "hec.map.aishape.AiShapeGlyph");
        _mapGlyphMapping.put("hec.map.streamAlignment.StreamAlignmentIfc", "hec.map.streamAlignment.StreamAlignmentGlyph");
        _mapGlyphMapping.put("hec.fia.model.FiaSystem", "hec.fia.client.FiaSystemGlyph");
        _mapGlyphMapping.put("hec.rss.model.RssSystem", "hec.rss.client.RssSystemGlyph");
        _mapGlyphMapping.put("hec.map.dem.DemMap", "hec.map.dem.DemGlyph");
        _mapGlyphMapping.put("hec.map.aidem.AiDemMap", "hec.map.aidem.AiDemGlyph");
        _mapGlyphMapping.put("hec.map.aidem.AiDemFltMap", "hec.map.aidem.AiDemGlyph");
        _mapGlyphMapping.put("hec.map.nettin.NetTinMap", "hec.map.nettin.NetTinGlyph");
        _mapGlyphMapping.put("hec.map.inundation.InundationGroup", "hec.map.inundation.InundationGroupGlyph");
        _mapGlyphMapping.put("hec.gridUtil.model.GridDataManager", "hec.gridUtil.client.GridDataManagerGlyph");
        _mapGlyphMapping.put("hec.gridUtil.model.SingleGridManager", "hec.gridUtil.client.SingleGridManagerGlyph");
        _mapGlyphMapping.put("hec.dssgui.SingleGrid", "hec.dssgui.SingleGridGlyph");
        _mapGlyphMapping.put("hec.ras.model.Geometry", "hec.ras.client.RasSystemGlyph");
        _mapGlyphMapping.put("hec.watershed.model.Study", "hec.watershed.client.StudySystemGlyph");
        _mapGlyphMapping.put("hec.map.raster.RasterMap", "hec.map.raster.RasterGlyph");
        _mapGlyphMapping.put("hec.fda.model.Inventory", "hec.fda.client.InventoryGlyph");
        _mapGlyphMapping.put("hec.fda.model.structDamComp.StructDamageDataList", "hec.fda.client.StructureDamageGlyph");
        _mapGlyphMapping.put("hec.rss.model.RssSimulationRun", "hec.rss.client.RssSimRunGlyph");
        _mapGlyphMapping.put("hec.fia.model.FiaSimulationRun", "hec.fia.client.FiaSimRunGlyph");
        _mapGlyphMapping.put("hec.resprm.model.PrmSimulationRun", "hec.resprm.client.PrmSimRunGlyph");
        _mapGlyphMapping.put("hec.model.SimulationRun", "hec.client.SimulationRunGlyph");
        _mapGlyphMapping.put("hec.watershed.map.raster.dbf.RasterDbfMap", "hec.watershed.map.raster.dbf.RasterDbfGlyph");
        _mapGlyphMapping.put("hec.glm.model.GlmSystem", "hec.glm.client.GlmLocationGlyph");
        _mapGlyphMapping.put("hec.watershed.res.model.ResNetwork", "hec.res.client.ResNetworkGlyph");
        _mapGlyphMapping.put("hec.resprm.model.ResPrmNetwork", "hec.resprm.client.ResPrmNetworkGlyph");
        _mapGlyphMapping.put("hec.map.mrsid.MrSidMap", "hec.map.mrsid.MrSidMapGlyph");
        _mapGlyphMapping.put("hec.map.tms.TmsMap", "hec.map.tms.TmsMapGlyph");
        _mapGlyphMapping.put("gov.ca.water.dwr.model.Event", "gov.ca.water.dwr.map.EventManagerGlyph");
        Collection lookup = Lookup.getDefault().lookupAll(MapGlyphMappingProvider.class);
        for (MapGlyphMappingProvider provider : lookup) {
            _mapGlyphMapping.put(provider.getMapObjectInterfaceClass(), provider.getMapGlyphClass());
        }
        mapGlyphMapping = Collections.unmodifiableMap(_mapGlyphMapping);
    }

    public static interface MapGlyphMappingProvider {
        public String getMapObjectInterfaceClass();

        public String getMapGlyphClass();
    }
}

