/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.io.HecFile;
import hec.io.Identifier;
import hec.io.SimpleHecFileImpl;
import hec.map.GlyphDataRecord;
import hec.map.MapGlyph;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class MapIdentifier
extends Identifier
implements Serializable {
    static final long serialVersionUID = -1990643844371264838L;
    private transient Map _glyphShownMap = new HashMap();
    static boolean _useEachGlyphShownState = false;
    protected int m_maximumScale = Integer.MAX_VALUE;
    protected int m_minimumScale = Integer.MIN_VALUE;
    protected long m_modifiedTime = Long.MIN_VALUE;
    protected boolean _mapShown = false;
    protected GlyphDataRecord _glyphDataRec = null;
    protected String _stringClass = null;
    protected boolean _isManager = false;
    protected boolean _isBackground = false;
    protected boolean _isDefaultMap = true;

    public MapIdentifier() {
    }

    public MapIdentifier(String path, HecFile file) {
        this();
        this.setPath(path);
        this.setFile(file);
    }

    public MapIdentifier(String path) {
        this();
        this.setPath(path);
        this.setFile(new SimpleHecFileImpl(path));
    }

    public MapIdentifier(Identifier id) {
        super(id);
    }

    public MapIdentifier(MapIdentifier id) {
        super(id);
        this._mapShown = id.getMapShown();
        this._glyphDataRec = id.getGlyphDataRecord();
        this._stringClass = id.getClassName();
        this.m_maximumScale = id.getMaximumScale();
        this.m_minimumScale = id.getMinimumScale();
        this.m_modifiedTime = id.getModifiedTime();
    }

    public void setIdentifier(Identifier id) {
        this.copy(id);
    }

    public void setIdentifier(MapIdentifier id) {
        this.copy(id);
        this._mapShown = id.getMapShown();
        this._glyphDataRec = id.getGlyphDataRecord();
        this._stringClass = id.getClassName();
    }

    public int getMaximumScale() {
        return this.m_maximumScale;
    }

    public int getMinimumScale() {
        return this.m_minimumScale;
    }

    public void setMaximumScale(int maxScale) {
        this.m_maximumScale = maxScale;
    }

    public void setMinimumScale(int minScale) {
        this.m_minimumScale = minScale;
    }

    public void setModifiedTime(long modifiedTime) {
        this.m_modifiedTime = modifiedTime;
    }

    public long getModifiedTime() {
        return this.m_modifiedTime;
    }

    public void setMapShown(boolean tf) {
        this._mapShown = tf;
    }

    public boolean getMapShown() {
        return this._mapShown;
    }

    public void setMapShown(boolean shown, MapGlyph glyph) {
        if (_useEachGlyphShownState) {
            if (glyph == null) {
                this.setMapShown(shown);
                return;
            }
            this._glyphShownMap.put(new Long(glyph.hashCode()), shown);
            return;
        }
        this.setMapShown(shown);
    }

    public boolean getMapShown(MapGlyph glyph) {
        if (_useEachGlyphShownState) {
            if (glyph == null) {
                return this.getMapShown();
            }
            Long hash = new Long(glyph.hashCode());
            Object obj = this._glyphShownMap.get(hash);
            if (obj == null || !(obj instanceof Boolean)) {
                obj = this.getMapShown();
                this._glyphShownMap.put(hash, obj);
            }
            return (Boolean)obj;
        }
        return this._mapShown;
    }

    public GlyphDataRecord getGlyphDataRecord() {
        return this._glyphDataRec;
    }

    public void setGlyphDataRecord(GlyphDataRecord rec) {
        this._glyphDataRec = rec;
    }

    @Override
    public void setClassName(String str) {
        this._stringClass = str;
    }

    @Override
    public String getClassName() {
        return this._stringClass;
    }

    public void setIsManager(boolean b) {
        this._isManager = b;
        if (b) {
            this._isBackground = false;
        }
    }

    public boolean isManager() {
        return this._isManager;
    }

    public void setIsBackground(boolean b) {
        this._isBackground = b;
        if (b) {
            this._isManager = false;
        }
    }

    public boolean isBackground() {
        return this._isBackground;
    }

    public boolean isMap() {
        return !this._isBackground && !this._isManager;
    }

    public boolean isDefaultMap() {
        return this._isDefaultMap;
    }

    public void setDefaultMap(boolean defaultMap) {
        this._isDefaultMap = defaultMap;
    }

    public void clearGlyphShownFlags() {
        if (this._glyphShownMap != null) {
            this._glyphShownMap.clear();
        }
    }

    static {
        _useEachGlyphShownState = Boolean.getBoolean("MapGlyph.IndividualShownState");
    }
}

