/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.LocalRect;
import hec.map.MapTextObject;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class MapLabelItem
extends MapTextObject {
    public static final int EAST = 0;
    public static final int NORTHEAST = 1;
    public static final int NORTH = 2;
    public static final int NORTHWEST = 3;
    public static final int WEST = 4;
    public static final int SOUTHWEST = 5;
    public static final int SOUTH = 6;
    public static final int SOUTHEAST = 7;
    private static final double[] _angle = new double[]{0.0, 0.7853981633974483, 1.5707963267948966, 2.356194490192345, Math.PI, 3.9269908169872414, 4.71238898038469, 5.497787143782138, Math.PI};
    public static final String[] POSITION_STRINGS = new String[]{"EAST", "NORTHEAST", "NORTH", "NORTHWEST", "WEST", "SOUTHWEST", "SOUTH", "SOUTHEAST"};
    int _x;
    int _y;
    int _iconHeight;
    int _iconWidth;
    int _position = 0;
    boolean _drawBorder = false;

    public MapLabelItem(String txt, int x, int y, int pos, int iconWidth, int iconHeight, float priority, Font font, Color fg, Color bg, boolean drawBorder, Graphics g) {
        super(txt, priority, font, fg, bg, g);
        this._x = x;
        this._y = y;
        this._iconWidth = iconWidth;
        this._iconHeight = iconHeight;
        this._position = pos;
        if (this._position < 0 || this._position > 7) {
            this._position = 0;
        }
        this._drawBorder = drawBorder;
    }

    public MapLabelItem(String txt, int x, int y, int pos, int size, float priority, Font font, Color fg, Color bg, Graphics g) {
        super(txt, priority, font, fg, bg, g);
        this._x = x;
        this._y = y;
        this._iconHeight = size * 2;
        this._iconWidth = size * 2;
        this._position = pos;
        if (this._position < 0 || this._position > 7) {
            this._position = 0;
        }
    }

    public MapLabelItem(String txt, int x, int y, float priority, Font font, Color fg, Color bg, Graphics g) {
        super(txt, priority, font, fg, bg, g);
        this._x = x;
        this._y = y;
        this._position = 0;
        this._iconHeight = 0;
        this._iconWidth = 0;
    }

    public MapLabelItem(String txt, int x, int y, int pos, int offset, float priority, Font font, Color fg, Color bg, boolean drawBorder, Graphics g) {
        this(txt, x, y, pos, offset * 2, offset * 2, priority, font, fg, bg, false, g);
        this._drawBorder = drawBorder;
    }

    @Override
    public boolean intersects(MapTextObject obj) {
        if (obj == null) {
            return false;
        }
        if (this._bounds == null) {
            this.getBounds();
        }
        if (obj instanceof MapLabelItem) {
            return this._bounds.intersects(obj.getBounds());
        }
        return obj.intersects(this);
    }

    @Override
    public LocalRect getBounds() {
        if (this._bounds == null) {
            double ca = Math.cos(_angle[this._position]);
            int yoff = this._position == 0 || this._position == 4 ? (int)(0.5 - (double)(this._h / 2)) : (this._position == 1 || this._position == 3 || this._position == 2 ? -this._iconHeight / 2 - this._h - 1 : this._iconHeight / 2 + 2);
            int xoff = this._position == 0 || this._position == 1 || this._position == 7 ? 0 : (this._position == 2 || this._position == 6 ? -this._w / 2 : -this._w);
            int l = (int)((double)this._x + (double)(this._iconWidth / 2 + 3) * ca + (double)xoff);
            int r = l + this._w;
            int t = this._y + yoff;
            int b = t + this._h;
            this._bounds = new LocalRect(l, t, r, b);
        }
        return this._bounds;
    }

    public LocalRect getLocalRect() {
        return this.getBounds();
    }

    public LocalRect getLocalRect(LocalRect rc) {
        LocalRect rcb = this.getBounds();
        rc.init(rcb.l, rcb.t, rcb.r, rcb.b);
        return rc;
    }

    @Override
    public void draw(Graphics g) {
        Font f = g.getFont();
        g.setFont(this._font);
        LocalRect rcb = this.getBounds();
        if (this._bgcolor != null) {
            FontMetrics metrics = g.getFontMetrics();
            g.setColor(this._bgcolor);
            g.fillRect(rcb.l - 1, rcb.t, rcb.width() + 2, rcb.height());
        } else {
            g.setColor(this._fgcolor);
        }
        if (this._drawBorder) {
            g.setColor(this._fgcolor);
            g.drawRect(rcb.l - 1, rcb.t, rcb.width() + 2, rcb.height());
        } else {
            g.setColor(this._fgcolor);
        }
        g.drawString(this._text, rcb.l, rcb.t + this._a);
        g.setFont(f);
    }

    public String getText() {
        return this._text;
    }
}

