/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.ButtonGifStrings;
import hec.map.MapCanvas;
import hec.map.MapPanel;
import hec.map.WorldPt;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class MapMouseAdapter
implements MouseListener,
MouseMotionListener {
    protected MapCanvas _mapCanvas = null;
    protected MapPanel _mapPanel = null;
    protected StringBuffer _strbuf = new StringBuffer(256);

    public MapMouseAdapter(MapPanel panel, MapCanvas canvas) {
        this._mapPanel = panel;
        this._mapCanvas = canvas;
    }

    public static ButtonGifStrings buildDefaultButtonGifStrings() {
        return new ButtonGifStrings();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this._strbuf.setLength(0);
        if (e.isAltDown() && e.isControlDown() && e.isShiftDown()) {
            this._strbuf.append("Local coordinates: ");
            this._strbuf.append(e.getX());
            this._strbuf.append(" X, ");
            this._strbuf.append(e.getY());
            this._strbuf.append(" Y");
            this._mapPanel.printStatus(this._strbuf.toString());
            return;
        }
        this._strbuf.append("Coordinates: ");
        this._strbuf.append((int)this._mapPanel.scale().x2e(e.getX()));
        this._strbuf.append(" east, ");
        this._strbuf.append((int)this._mapPanel.scale().y2n(e.getY()));
        this._strbuf.append(" north");
        this._mapPanel.printStatus(this._strbuf.toString());
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public void init() {
    }

    public void abort() {
    }

    public static boolean pressedButton1(MouseEvent e) {
        return e.getModifiers() == 0 || (e.getModifiers() & 0x10) != 0;
    }

    public static boolean pressedButton2(MouseEvent e) {
        return (e.getModifiers() & 8) != 0;
    }

    public static boolean pressedButton3(MouseEvent e) {
        return (e.getModifiers() & 4) != 0;
    }

    public Cursor getCursor() {
        return Cursor.getDefaultCursor();
    }

    public WorldPt getWorldPt(Point point) {
        if (point == null || this._mapPanel == null) {
            return new WorldPt();
        }
        double e = this._mapPanel.scale().x2e((int)point.getX());
        double n = this._mapPanel.scale().y2n((int)point.getY());
        return new WorldPt(e, n);
    }

    public WorldPt getWorldPt(Point point, WorldPt wpt) {
        if (point == null || this._mapPanel == null) {
            return new WorldPt();
        }
        double e = this._mapPanel.scale().x2e((int)point.getX());
        double n = this._mapPanel.scale().y2n((int)point.getY());
        if (wpt == null) {
            return new WorldPt(e, n);
        }
        wpt.init(e, n);
        return wpt;
    }
}

