/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.appInterface.AppDaddy;
import hec.appInterface.FileOpener;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.io.SimpleHecFileImpl;
import hec.lang.Logger;
import hec.map.MapIdentifier;
import hec.map.MapObjectInterface;
import hec.map.WorldRect;
import hec.map.crs.CRS;
import hec.map.crs.CRSException;
import hec.map.crs.CoordinateReferenceSystem;
import hec.map.transform.CoordinateInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public abstract class MapObject
implements Serializable,
MapObjectInterface {
    private static final String utf8Bom = new String(new byte[]{-17, -69, -65});
    protected transient MapIdentifier _mapId = null;
    protected WorldRect _extent = new WorldRect();
    protected boolean _loaded = false;
    protected boolean _debug = Logger.canDebug("maps");
    protected transient FileOpener _fileOpener;
    protected CoordinateReferenceSystem mCoordinateReferencySystem = null;

    public MapObject(String path) {
        this();
        this._mapId = new MapIdentifier(path);
    }

    public MapObject(MapIdentifier id) {
        this();
        this.setMapIdentifier(id);
    }

    public MapObject() {
    }

    public boolean equals(MapObject mo) {
        if (this._mapId != null && mo.getMapIdentifier() != null) {
            return this._mapId.equals(mo.getMapIdentifier());
        }
        return super.equals(mo);
    }

    public void setFileOpener(FileOpener fileOpener) {
        this._fileOpener = fileOpener;
    }

    public FileOpener getFileOpener() {
        return this._fileOpener;
    }

    protected Identifier newFile(Identifier pathId) {
        if (AppDaddy.getWorkspace() != null) {
            Identifier idOut = AppDaddy.getWorkspace().createFile(new Identifier(pathId));
            return idOut;
        }
        if (this._fileOpener != null) {
            try {
                Identifier idOut = this._fileOpener.createFile(pathId);
                return idOut;
            }
            catch (Exception e) {
                System.out.println("Error creating new file on Remote Workspace. " + e);
            }
        }
        return null;
    }

    public Identifier openFile(Identifier pathId) {
        if (AppDaddy.getWorkspace() != null) {
            Identifier idOut = AppDaddy.getWorkspace().openFile(pathId, true);
            if (idOut != null && idOut.getFile() == null) {
                System.out.println("openFile:WARNING failed to get file for " + pathId.getPath());
            }
            return idOut;
        }
        if (this._fileOpener != null) {
            try {
                Identifier idOut = this._fileOpener.openFile(pathId, false);
                if (idOut != null && idOut.getFile() == null) {
                    System.out.println("openFile:WARNING failed to get file for " + pathId.getPath());
                }
                return idOut;
            }
            catch (Exception e) {
                System.out.println("Error creating new file on FileOpener. " + e);
            }
        }
        return new Identifier(pathId.getPath(), new SimpleHecFileImpl(pathId.getPath()));
    }

    protected Identifier newThenOpenFile(Identifier pathId) {
        if (AppDaddy.getWorkspace() != null) {
            Identifier idOut = AppDaddy.getWorkspace().createFile(pathId);
            if (idOut == null) {
                idOut = AppDaddy.getWorkspace().openFile(pathId, true);
            }
            return idOut;
        }
        if (this._fileOpener != null) {
            try {
                Identifier idOut = this._fileOpener.createFile(pathId);
                if (idOut == null) {
                    idOut = this._fileOpener.openFile(pathId, false);
                }
                return idOut;
            }
            catch (Exception e) {
                System.out.println("Error accessing file on FileOpener. " + e);
            }
        }
        return null;
    }

    @Override
    public void setMapIdentifier(MapIdentifier id) {
        this._mapId = id;
    }

    @Override
    public MapIdentifier getMapIdentifier() {
        return this._mapId;
    }

    @Override
    public String getName() {
        return this._mapId.getPath();
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.mCoordinateReferencySystem;
    }

    @Deprecated
    public CoordinateInfo getCoordinateInfo() {
        return null;
    }

    @Override
    public void setExtent(WorldRect rc) {
        this._extent.init(rc);
    }

    @Override
    public WorldRect getExtent() {
        return this._extent;
    }

    @Override
    public abstract void load() throws IOException;

    @Override
    public abstract void unload();

    public List getFilenames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this._mapId.getPath());
        return l;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public String toString() {
        MapIdentifier mapId = this.getMapIdentifier();
        if (mapId != null) {
            return mapId.toString();
        }
        return this.getName();
    }

    public boolean mapIdentifierEquals(MapIdentifier mapid) {
        return this.getMapIdentifier().equals(mapid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readProjection(Identifier prjId) {
        if (prjId == null) {
            return false;
        }
        HecFile file = prjId.getFile();
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            BufferedReader bufferedReader = null;
            StringBuilder builder = new StringBuilder();
            try {
                bufferedReader = file.getBufferedReader();
                String line = bufferedReader.readLine();
                while (line != null) {
                    if (line.length() == 0) {
                        break;
                    }
                    builder.append(line);
                    line = bufferedReader.readLine();
                }
            }
            catch (IOException e) {
                java.util.logging.Logger.getLogger(MapObject.class.getName()).log(Level.SEVERE, e.getMessage(), e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException ex) {
                        java.util.logging.Logger.getLogger(MapObject.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                        return false;
                    }
                }
            }
            try {
                if (builder.indexOf(utf8Bom) >= 0) {
                    builder.delete(0, utf8Bom.length());
                }
                String wkt = builder.toString();
                this.mCoordinateReferencySystem = CRS.getDefault().parseWkt(wkt);
            }
            catch (CRSException ex) {
                java.util.logging.Logger.getLogger(MapObject.class.getName()).log(Level.FINE, null, ex);
                return false;
            }
        }
        return true;
    }
}

