/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.appInterface.FileOpener;
import hec.io.Identifier;
import hec.lang.Logger;
import hec.map.MapIdentifier;
import hec.map.MapObject;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public class MapObjectFactory {
    private static final Map<String, String> _extToClsName = new HashMap<String, String>();

    public static MapObject newMapObject(FileOpener fileOpener, String path) {
        if (path == null) {
            return null;
        }
        return MapObjectFactory.getMapByExtension(fileOpener, path);
    }

    public static MapObject newMapObject(FileOpener fileOpener, Identifier id) {
        if (id == null) {
            return null;
        }
        boolean debug = Logger.canDebug("maps");
        MapObject map = null;
        if (id instanceof MapIdentifier) {
            MapIdentifier mapId = (MapIdentifier)id;
            if (mapId.getClassName() != null && !mapId.getClassName().equals("") && !mapId.getClassName().equalsIgnoreCase("null")) {
                String className = mapId.getClassName();
                if (debug) {
                    System.out.println("newMapObject:Creating map class " + className);
                }
                Object obj = null;
                try {
                    Class<?> mapClass = Thread.currentThread().getContextClassLoader().loadClass(className);
                    obj = mapClass.newInstance();
                }
                catch (ClassNotFoundException cnfe) {
                    obj = null;
                    map = MapObjectFactory.getMapByExtension(fileOpener, mapId);
                    if (map != null) {
                        className = map.getClass().getName();
                        mapId.setClassName(className);
                    }
                }
                catch (InstantiationException ie) {
                    System.out.println("Instantiation Exception with MapObject " + className + "  " + ie);
                    ie.printStackTrace();
                }
                catch (IllegalAccessException iae) {
                    System.out.println("IllegalAccess Exception with " + className + "  " + iae);
                    iae.printStackTrace();
                }
                if (obj instanceof MapObject) {
                    map = obj;
                    map.setMapIdentifier(mapId);
                    map.setFileOpener(fileOpener);
                }
            } else {
                map = MapObjectFactory.getMapByExtension(fileOpener, mapId);
                if (map != null) {
                    String className = map.getClass().getName();
                    mapId.setClassName(className);
                }
            }
        } else {
            MapIdentifier mapId = new MapIdentifier(id);
            map = MapObjectFactory.newMapObject(fileOpener, mapId);
        }
        if (debug) {
            System.out.println("newMapObject:returning " + map + " for " + id);
        }
        return map;
    }

    private static MapObject getMapByExtension(FileOpener fileOpener, Object mapId) {
        boolean debug = Logger.canDebug("maps");
        MapObject map = null;
        String path = null;
        if (mapId instanceof MapIdentifier) {
            path = ((MapIdentifier)mapId).getPath();
        } else if (mapId instanceof String) {
            path = (String)mapId;
        }
        if (path == null) {
            return null;
        }
        Class mapClass = MapObjectFactory.getClassForUrl(path);
        if (debug) {
            System.out.println("getMapByExtension:got " + mapClass + " for " + path);
        }
        Object[] args = new Object[]{mapId};
        if (mapClass != null) {
            try {
                Constructor<?>[] ctors = mapClass.getDeclaredConstructors();
                for (int i = 0; i < ctors.length; ++i) {
                    Class<?>[] c2 = ctors[i].getParameterTypes();
                    if (c2.length != 1 || !c2[0].equals(mapId.getClass())) continue;
                    map = (MapObject)ctors[i].newInstance(args);
                    map.setFileOpener(fileOpener);
                    return map;
                }
                System.out.println("ERROR:Failed to find Map Contructor for " + mapClass.getName() + " using " + mapId.getClass());
            }
            catch (SecurityException se) {
                System.out.println("ERROR:Security Exception on 'getDeclaredConstructors()'. Please update your java.policy file. " + se);
                return null;
            }
            catch (Exception e) {
                System.out.println("ERROR:Failed to create Map " + mapClass.getName() + " " + e);
                e.printStackTrace();
                return null;
            }
        } else {
            System.out.println("ERROR:Unknown Map type for URL: '" + path + "'");
        }
        return map;
    }

    public static Class getClassForUrl(String path) {
        if (path == null) {
            return null;
        }
        int idx = path.lastIndexOf(".");
        if (idx < 0) {
            return null;
        }
        String ext = path.substring(idx + 1);
        ext = ext.toLowerCase();
        String mapClassName = _extToClsName.get(ext);
        try {
            Class<?> mapClass = Thread.currentThread().getContextClassLoader().loadClass(mapClassName);
            return mapClass;
        }
        catch (ClassNotFoundException e) {
            System.out.println("Map Object class not found. " + e);
            return null;
        }
        catch (NullPointerException npe) {
            System.out.println("Map Object class not found for file: " + path);
            return null;
        }
    }

    public static void addMapping(String mapFileExt, String mapObjectClsName) {
        if (mapFileExt == null || mapObjectClsName == null) {
            return;
        }
        _extToClsName.put(mapFileExt, mapObjectClsName);
    }

    static {
        _extToClsName.put("dlg", "hec.map.dlg.DlgMap");
        _extToClsName.put("dlgbin", "hec.map.dlg.DlgMap");
        _extToClsName.put("dxf", "hec.map.dxf.DxfMap");
        _extToClsName.put("img", "hec.map.image.ImageMap");
        _extToClsName.put("tin", "hec.map.tin.TinMap");
        _extToClsName.put("shp", "hec.map.aishape.AiShapeMap");
        _extToClsName.put("dem", "hec.map.dem.DemMap");
        _extToClsName.put("asc", "hec.map.aidem.AiDemMap");
        _extToClsName.put("ascbin", "hec.map.aidem.AiDemMap");
        _extToClsName.put("flt", "hec.map.aidem.AiDemFltMap");
        _extToClsName.put("net", "hec.map.nettin.NetTinMap");
        _extToClsName.put("netbin", "hec.map.nettin.NetTinMap");
        _extToClsName.put("ifg", "hec.map.inundation.InundationGroup");
        _extToClsName.put("smrmp", "hec.map.raster.RasterMap");
        _extToClsName.put("rdbf", "hec.watershed.map.raster.dbf.RasterDbfMap");
        _extToClsName.put("sid", "hec.map.mrsid.MrSidMap");
        _extToClsName.put("out", "hec.map.flo2d.Flo2dDepthMap");
        _extToClsName.put("ele", "hec.map.aidem.GrassAsciiMap");
        _extToClsName.put("tms", "hec.map.tms.TmsMap");
        ServiceLoader<MapObjectMappingProvider> serviceLoader = ServiceLoader.load(MapObjectMappingProvider.class);
        for (MapObjectMappingProvider provider : serviceLoader) {
            _extToClsName.put(provider.getMapExtension(), provider.getMapObjectClass());
        }
    }

    public static interface MapObjectMappingProvider {
        public String getMapObjectClass();

        public String getMapExtension();
    }
}

