/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.MapObjectInterface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

public class MapObjectLookupFactory {
    static MapObjectLookupFactory factory = null;
    List<Lookup> mLookups = null;

    private MapObjectLookupFactory() {
    }

    public static MapObjectLookupFactory getDefault() {
        if (factory == null) {
            factory = new MapObjectLookupFactory();
        }
        return factory;
    }

    public MapObjectInterface lookupMapObject(Object object) {
        if (this.mLookups == null) {
            this.mLookups = new ArrayList<Lookup>();
            ServiceLoader<Lookup> sl = ServiceLoader.load(Lookup.class);
            Iterator<Lookup> iter = sl.iterator();
            while (iter.hasNext()) {
                this.mLookups.add(iter.next());
            }
            this.mLookups.add(new DefaultLookup());
        }
        for (int i = 0; i < this.mLookups.size(); ++i) {
            MapObjectInterface moi = this.mLookups.get(i).lookupMapObject(object);
            if (moi == null) continue;
            return moi;
        }
        return null;
    }

    public static interface Lookup {
        public MapObjectInterface lookupMapObject(Object var1);
    }

    private class DefaultLookup
    implements Lookup {
        @Override
        public MapObjectInterface lookupMapObject(Object object) {
            if (object instanceof MapObjectInterface) {
                return (MapObjectInterface)object;
            }
            return null;
        }
    }
}

