/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.appInterface.AppDaddy;
import hec.appInterface.Workspace;
import hec.event.MapGlyphListener;
import hec.lang.Logger;
import hec.map.ButtonGifStrings;
import hec.map.DisplayCoordinateReferenceSystem;
import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.MapCanvas;
import hec.map.MapGlyph;
import hec.map.MapGlyphFactory;
import hec.map.MapIdentifier;
import hec.map.MapMouseAdapter;
import hec.map.MapObjectInterface;
import hec.map.MapObjectInterface2;
import hec.map.MapPosition;
import hec.map.MapScale;
import hec.map.MapToolClassLoader;
import hec.map.MapToolPanel;
import hec.map.MousePanAdapter;
import hec.map.MouseZoomAdapter;
import hec.map.TransformMapScale;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.appInterface.MapWorkspace;
import hec.map.crs.CRSException;
import hec.map.crs.CoordinateReferenceSystem;
import hec.map.event.PaintCompleteEvent;
import hec.map.event.PaintCompleteListener;
import hec.map.legend.LegendLayerUI;
import hec.map.legend.LegendRenderer;
import hec.model.UserInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.ServiceLoader;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import rma.swing.RMAJScrollBar;
import rma.swing.RmaGlyphButtonInfo;
import rma.swing.RmaJToolbarButton;
import rma.util.RMAIO;

public class MapPanel
extends JPanel
implements AdjustmentListener,
ActionListener {
    LegendLayerUI _legendLayer;
    JLayer<MapCanvas> _jlayer;
    private RmaJToolbarButton _button = null;
    private RmaGlyphButtonInfo _binfo = null;
    protected RMAJScrollBar _horizScrollbar;
    protected RMAJScrollBar _vertScrollbar;
    protected MapCanvas _viewport = null;
    protected MapToolPanel _defaultToolsPanel = null;
    protected MapToolPanel _currentToolsPanel = null;
    protected Map _mouseAdapters = new HashMap(10);
    public static final String OBS_ZOOMIN = "zoomIn";
    public static final String OBS_ZOOMBYFACTOR = "zoomByFactor";
    public static final String OBS_SCROLLED = "scrolled";
    public static final String OBS_SHOWALL = "showAll";
    public static final String OBS_ORIGIN_SET = "originSet";
    protected WorldRect _maxExtents = new WorldRect(0.0, 100.0, 100.0, 0.0);
    protected WorldRect _extents = new WorldRect(0.0, 100.0, 100.0, 0.0);
    protected MapScale _scale = new MapScale();
    protected List _glyphList = new ArrayList();
    protected List _managerGlyphList = new ArrayList();
    protected List _backgroundGlyphList = new ArrayList(1);
    protected List _combinedGlyphList = null;
    protected List _orderList = null;
    protected Thread _paintThread = null;
    protected boolean _paintEnabled = true;
    protected UserInterface _userInterface = null;
    protected Vector _observerList = new Vector(4);
    protected boolean _changed = false;
    protected boolean _isAdjusting = false;
    protected int _oldVerticalValue = -1;
    protected int _oldHorizontalValue = -1;
    private List _paintCompleteListeners = new ArrayList();
    private JPanel LEFT_MAP_TOOL_CONTAINER = new JPanel(new BorderLayout());
    private JPanel RIGHT_MAP_TOOL_CONTAINER = new JPanel(new BorderLayout());
    private JPanel TOP_MAP_TOOL_CONTAINER = new JPanel(new BorderLayout());
    private JPanel BOTTOM_MAP_TOOL_CONTAINER = new JPanel(new BorderLayout());
    private JPanel _viewportContainerPanel;
    List<MapToolClassLoader> mapToolClassLoaders = new ArrayList<MapToolClassLoader>();
    protected boolean useRenderer = Boolean.getBoolean(MapCanvas.USE_RENDER);

    public MapPanel(boolean buildControls) {
        this.init(buildControls);
    }

    public MapPanel() {
        this.init(true);
    }

    private void loadMapToolClassLoaders() {
        this.mapToolClassLoaders.add(new MapToolClassLoader(){

            @Override
            public Class getMapToolClass(String className) throws ClassNotFoundException {
                return Thread.currentThread().getContextClassLoader().loadClass(className);
            }
        });
        ServiceLoader<MapToolClassLoader> toolLoaders = ServiceLoader.load(MapToolClassLoader.class);
        Iterator<MapToolClassLoader> iterator = toolLoaders.iterator();
        while (iterator.hasNext()) {
            this.mapToolClassLoaders.add(iterator.next());
        }
    }

    public MapPanel(JFrame frame) {
        this();
    }

    public void addMapToolClassLoader(MapToolClassLoader classLoader) {
        if (classLoader == null) {
            return;
        }
        this.mapToolClassLoaders.add(classLoader);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.notifyPaintComplete();
    }

    private void notifyPaintComplete() {
        if (this._paintCompleteListeners == null || this._paintCompleteListeners.size() == 0) {
            return;
        }
        PaintCompleteEvent event = new PaintCompleteEvent(this);
        for (int i = 0; i < this._paintCompleteListeners.size(); ++i) {
            PaintCompleteListener listener = (PaintCompleteListener)this._paintCompleteListeners.get(i);
            listener.paintComplete(event);
        }
    }

    public void addPaintCompleteListener(PaintCompleteListener listener) {
        if (listener == null) {
            return;
        }
        if (this._paintCompleteListeners.contains(listener)) {
            return;
        }
        this._paintCompleteListeners.add(listener);
    }

    public void removePaintCompleteListener(PaintCompleteListener listener) {
        if (listener == null) {
            return;
        }
        this._paintCompleteListeners.remove(listener);
    }

    public int getGlyphLevel(MapGlyph glyph) {
        if (this._combinedGlyphList == null) {
            return 1;
        }
        return this._combinedGlyphList.size() - this._combinedGlyphList.indexOf(glyph);
    }

    protected void init(boolean buildControls) {
        this.loadMapToolClassLoaders();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.setLayout(new BorderLayout());
        this._viewportContainerPanel = new JPanel(gridbag);
        this.add((Component)this._viewportContainerPanel, "Center");
        this.setBorder(new BevelBorder(0));
        SymComponent aSymComponent = new SymComponent();
        this.addComponentListener(aSymComponent);
        this._viewport = this.createViewport();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(2, 2, 2, 2);
        this._legendLayer = new LegendLayerUI();
        this._jlayer = new JLayer<MapCanvas>(this._viewport, this._legendLayer);
        this._viewportContainerPanel.add(this._jlayer, constraints);
        UIManager.put("ScrollBar.track", new Color(215, 215, 215));
        if (buildControls) {
            this._defaultToolsPanel = this.createDefaultMapTools();
            this.setMapTools(this._defaultToolsPanel);
            this._horizScrollbar = new RMAJScrollBar(0);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.fill = 2;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            gridbag.setConstraints(this._horizScrollbar, constraints);
            this._viewportContainerPanel.add(this._horizScrollbar);
            this._horizScrollbar.addAdjustmentListener(this);
            this._vertScrollbar = new RMAJScrollBar(1);
            constraints = new GridBagConstraints();
            constraints.gridx = 2;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.fill = 3;
            constraints.weightx = 0.0;
            constraints.weighty = 1.0;
            gridbag.setConstraints(this._vertScrollbar, constraints);
            this._viewportContainerPanel.add(this._vertScrollbar);
            this._vertScrollbar.addAdjustmentListener(this);
            this._viewport.addMouseWheelListener(new MouseWheelHandler());
            this._viewport.setMouseAdapter(new MouseZoomAdapter(this, this._viewport));
        }
        this._scale.showAll();
        this.addListeners();
    }

    public void setGlassPane(JPanel glassPane) {
        this._jlayer.setGlassPane(glassPane);
    }

    public JPanel getGlassPane() {
        return this._jlayer.getGlassPane();
    }

    protected void addListeners() {
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((JFrame)((Object)AppDaddy.getFrame())).getContentPane().repaint();
                    }
                });
            }
        }, KeyStroke.getKeyStroke(82, 2, true), 1);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MapPanel.this.paintMap();
                    }
                });
            }
        });
        InputMap imap = this.getInputMap(1);
        ActionMap amap = this.getActionMap();
        imap.put(KeyStroke.getKeyStroke(77, 3), "showHideScrollbars");
        AbstractAction showHideScrollbarsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapPanel.this.showHideScrollbars();
            }
        };
        amap.put("showHideScrollbars", showHideScrollbarsAction);
    }

    protected void showHideScrollbars() {
        if (this._horizScrollbar.isVisible()) {
            this._horizScrollbar.setVisible(false);
            this._vertScrollbar.setVisible(false);
        } else {
            this._horizScrollbar.setVisible(true);
            this._vertScrollbar.setVisible(true);
        }
    }

    public void setLegendRenderer(LegendRenderer renderer) {
        this._legendLayer.setLegendModel(renderer);
    }

    public MapCanvas createViewport() {
        return new MapCanvas(this);
    }

    public boolean setPaintEnabled(boolean state) {
        boolean oldstate = this._paintEnabled;
        this._paintEnabled = state;
        return oldstate;
    }

    public boolean isPaintEnabled() {
        return this._paintEnabled;
    }

    public MapToolPanel createDefaultMapTools() {
        MapToolPanel tools = new MapToolPanel(this);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 11;
        gbc.fill = 0;
        JToggleButton button = new JToggleButton();
        ButtonGifStrings bgstr = new ButtonGifStrings();
        bgstr.up = "Images/Point.gif";
        bgstr.down = "Images/Point.gif";
        bgstr.over = "Images/Point.gif";
        bgstr.on = "Images/Point.gif";
        bgstr.adapter = "hec.map.PointerMouseAdapter";
        bgstr.toolTipText = "Select Tool";
        bgstr.borderPainted = true;
        tools.addToolButton(button, bgstr);
        button = new JToggleButton();
        bgstr = new ButtonGifStrings();
        bgstr.up = "Images/ZoomUp.gif";
        bgstr.down = "Images/ZoomDown.gif";
        bgstr.over = "Images/ZoomUp.gif";
        bgstr.on = "Images/ZoomDown.gif";
        bgstr.adapter = "hec.map.MouseZoomAdapter";
        bgstr.borderPainted = true;
        bgstr.toolTipText = "Zoom Tool";
        tools.addToolButton(button, bgstr);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 11;
        gbc.fill = 0;
        button = new JToggleButton();
        bgstr = MousePanAdapter.buildDefaultButtonGifStrings();
        tools.addToolButton(button, bgstr);
        tools.selectButton(0);
        return tools;
    }

    public MapToolPanel getMapToolPanel() {
        return this._currentToolsPanel;
    }

    public void setMapTools(MapToolPanel tools) {
        if (this._currentToolsPanel == tools) {
            return;
        }
        if (this._currentToolsPanel != null) {
            this.remove(this._currentToolsPanel);
        }
        this._currentToolsPanel = tools != null ? tools : this._defaultToolsPanel;
        this.add((Component)this._currentToolsPanel, "West");
        if (this._currentToolsPanel.getSelectedButton() >= 0) {
            this._currentToolsPanel.forceSelectButton(this._currentToolsPanel.getSelectedButton());
        }
    }

    public void addMaps(List maps) throws IOException {
        this._combinedGlyphList = null;
        for (int i = 0; i < maps.size(); ++i) {
            Object obj = maps.get(i);
            if (obj == null || !(obj instanceof MapObjectInterface)) continue;
            this.addMap((MapObjectInterface)obj, false);
        }
    }

    public void resetManagerMaps(List mapVec) {
        int size = this._managerGlyphList.size();
        for (int i = 0; i < size; ++i) {
            ((MapGlyph)this._managerGlyphList.get(i)).close();
        }
        this._managerGlyphList.clear();
        try {
            if (mapVec != null) {
                this.addManagerMaps(mapVec);
            }
        }
        catch (IOException e) {
            System.out.println("resetManagerMaps: IOException " + e);
        }
    }

    public void resetBackgroundMaps(List mapVec) {
        int size = this._backgroundGlyphList.size();
        for (int i = 0; i < size; ++i) {
            ((MapGlyph)this._backgroundGlyphList.get(i)).close();
        }
        this._backgroundGlyphList.clear();
        try {
            if (mapVec != null) {
                this.addBackgroundMaps(mapVec);
            }
        }
        catch (Exception e) {
            System.out.println("resetBackgroundMaps: IOException " + e);
        }
    }

    public void addBackgroundMaps(List mapVec) throws IOException {
        this._combinedGlyphList = null;
        for (int i = 0; i < mapVec.size(); ++i) {
            Object obj = mapVec.get(i);
            if (obj == null || !(obj instanceof MapObjectInterface)) continue;
            this.addBackgroundMap((MapObjectInterface)obj, false);
        }
        this.fireGlyphVectorChanged();
    }

    public void addManagerMaps(List mapVec) throws IOException {
        if (mapVec == null) {
            return;
        }
        this._combinedGlyphList = null;
        for (int i = 0; i < mapVec.size(); ++i) {
            Object obj = mapVec.get(i);
            if (obj == null || !(obj instanceof MapObjectInterface)) continue;
            this.addManagerMap((MapObjectInterface)obj, false);
        }
        this.fireGlyphVectorChanged();
    }

    public void setGlyphList(List newGlyphList) {
        this.setGlyphList(newGlyphList, true);
    }

    public void setGlyphList(List newGlyphList, boolean saveToWksp) {
        if (newGlyphList == null) {
            return;
        }
        if (newGlyphList.hashCode() != this._glyphList.hashCode()) {
            MapWorkspace wksp = (MapWorkspace)AppDaddy.getWorkspace();
            int newIdx = 0;
            int oldIdx = 0;
            while (oldIdx < this._glyphList.size()) {
                MapObjectInterface mo;
                int newIdxForOldG;
                MapGlyph newG = null;
                MapGlyph oldG = (MapGlyph)this._glyphList.get(oldIdx);
                if (newIdx < newGlyphList.size()) {
                    newG = (MapGlyph)newGlyphList.get(newIdx);
                }
                if (newG == null) {
                    newIdxForOldG = newGlyphList.indexOf(oldG);
                    if (newIdxForOldG == -1 && (mo = oldG.getMap()) != null) {
                        oldG.fillMap(false);
                        if (saveToWksp && wksp != null) {
                            wksp.removeMap(mo.getMapIdentifier());
                        }
                    }
                } else if (newG != oldG && (newIdxForOldG = newGlyphList.indexOf(oldG)) == -1 && (mo = oldG.getMap()) != null) {
                    oldG.fillMap(false);
                    if (saveToWksp && wksp != null) {
                        wksp.removeMap(mo.getMapIdentifier());
                    }
                }
                ++oldIdx;
                ++newIdx;
            }
            ArrayList<MapIdentifier> orderedMapIds = new ArrayList<MapIdentifier>(newGlyphList.size());
            for (int ii = 0; ii < newGlyphList.size(); ++ii) {
                MapGlyph mg = (MapGlyph)newGlyphList.get(ii);
                MapObjectInterface moi = mg.getMap();
                orderedMapIds.add(moi.getMapIdentifier());
            }
            if (saveToWksp && wksp != null) {
                wksp.setMapOrder(orderedMapIds);
            }
        }
        this._combinedGlyphList = null;
        this._glyphList = newGlyphList;
    }

    public void resetManagerOrder(List positionList) {
        this._orderList = positionList;
        this._combinedGlyphList = null;
        this.fireGlyphVectorChanged();
        if (this._orderList != null) {
            for (int i = 0; i < this._orderList.size(); ++i) {
                MapPosition pos = (MapPosition)this._orderList.get(i);
            }
        }
    }

    public void setManagerOrder(List positionList) {
        this.setManagerOrder(positionList, true);
    }

    public void setManagerOrder(List positionList, boolean saveToWksp) {
        this._orderList = positionList;
        this._combinedGlyphList = null;
        this.fireGlyphVectorChanged();
        if (this._orderList != null) {
            for (int i = 0; i < this._orderList.size(); ++i) {
                MapPosition pos = (MapPosition)this._orderList.get(i);
            }
        }
        if (saveToWksp) {
            Workspace wksp = AppDaddy.getWorkspace();
            if (wksp == null) {
                return;
            }
            wksp.setManagerOrder(this._orderList);
        }
    }

    public void setManagerGlyphList(List list) {
        this._managerGlyphList = list;
    }

    public void setBackgroundGlyphList(List list) {
        this._backgroundGlyphList = list;
    }

    public List cloneCombinedGlyphList() {
        int size = this.getCombinedGlyphList().size();
        ArrayList list = new ArrayList(size);
        list.addAll(this.getCombinedGlyphList());
        return list;
    }

    public List cloneGlyphList() {
        ArrayList list = new ArrayList(this._glyphList.size());
        list.addAll(this._glyphList);
        return list;
    }

    public List cloneManagerGlyphList() {
        ArrayList list = new ArrayList(this._managerGlyphList.size());
        for (int i = 0; i < this._managerGlyphList.size(); ++i) {
            list.add(this._managerGlyphList.get(i));
        }
        return list;
    }

    public List cloneBackgroundGlyphList() {
        ArrayList list = new ArrayList(this._backgroundGlyphList.size());
        for (int i = 0; i < this._backgroundGlyphList.size(); ++i) {
            list.add(this._backgroundGlyphList.get(i));
        }
        return list;
    }

    public JToggleButton findToolButtonFor(String name) {
        if (this._currentToolsPanel == null || name == null || name.length() == 0) {
            return null;
        }
        return this._currentToolsPanel.findToolButtonFor(name);
    }

    public boolean setMouseAdapter(String className) {
        MapMouseAdapter adapter;
        block12: {
            if (className == null) {
                return false;
            }
            if (this._viewport == null) {
                return false;
            }
            adapter = null;
            adapter = (MapMouseAdapter)this._mouseAdapters.get(className);
            if (adapter == null) {
                try {
                    Class adapterClass = null;
                    for (int i = 0; i < this.mapToolClassLoaders.size(); ++i) {
                        try {
                            adapterClass = this.mapToolClassLoaders.get(i).getMapToolClass(className);
                        }
                        catch (ClassNotFoundException e) {
                            continue;
                        }
                        if (adapterClass != null) break;
                    }
                    Class[] cparamClasses = new Class[]{MapPanel.class, MapCanvas.class};
                    Constructor c2 = adapterClass.getDeclaredConstructor(cparamClasses);
                    Object[] cparam = new Object[]{this, this._viewport};
                    adapter = (MapMouseAdapter)c2.newInstance(cparam);
                    this._mouseAdapters.put(className, adapter);
                }
                catch (InvocationTargetException ite) {
                    System.out.println("Can't load MouseAdapter class " + className);
                    if (Logger.canDebug("maps")) {
                        System.out.println("Exception is " + ite.getTargetException());
                        ite.getTargetException().printStackTrace(System.out);
                    }
                }
                catch (Exception e) {
                    System.out.println("Can't load MouseAdapter class " + className);
                    if (!Logger.canDebug("maps")) break block12;
                    System.out.println("Exception is " + e);
                    e.printStackTrace(System.out);
                }
            }
        }
        if (adapter != null) {
            this._viewport.setMouseAdapter(adapter);
            final JToggleButton btn = this.findToolButtonFor(adapter.getClass().getName());
            if (btn != null) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        btn.setSelected(true);
                    }
                });
            }
            return true;
        }
        return false;
    }

    public MapMouseAdapter getMapMouseAdapter() {
        return this._viewport.getMapMouseAdapter();
    }

    public void paintImage() {
        if (!this.isPaintEnabled()) {
            return;
        }
        if (!this.useRenderer) {
            this._viewport.stop();
        }
        this._viewport.repaint();
    }

    public void paintMap() {
        if (!this.isPaintEnabled()) {
            return;
        }
        if (!this.useRenderer) {
            this._viewport.stop();
        }
        this._viewport.redrawMaps();
        this._viewport.repaint();
    }

    public void paintMap(int x, int y, int width, int height) {
        if (!this.isPaintEnabled()) {
            return;
        }
        this._viewport.stop();
        this._viewport.redrawMaps();
        this._viewport.repaint(x, y, width, height);
    }

    synchronized void paintComplete() {
        this._paintThread = null;
        this.notifyAll();
    }

    public synchronized void waitforPaintComplete() {
        while (this._paintThread != null && this._paintThread.isAlive()) {
            try {
                this.wait();
            }
            catch (Exception e) {
                System.out.println("waitforPaintComplete(): " + e);
                break;
            }
        }
        this.notifyAll();
    }

    List getCombinedGlyphList() {
        block9: {
            int j;
            boolean found;
            int size;
            Object obj;
            int i;
            block10: {
                int i2;
                if (this._combinedGlyphList != null) break block9;
                this._combinedGlyphList = new ArrayList(this._glyphList.size() + this._managerGlyphList.size() + this._backgroundGlyphList.size());
                if (this._orderList != null && this._orderList.size() >= 1) break block10;
                int size2 = this._backgroundGlyphList.size();
                for (i2 = 0; i2 < size2; ++i2) {
                    this._combinedGlyphList.add(this._backgroundGlyphList.get(i2));
                }
                size2 = this._glyphList.size();
                for (i2 = 0; i2 < size2; ++i2) {
                    this._combinedGlyphList.add(this._glyphList.get(i2));
                }
                size2 = this._managerGlyphList.size();
                for (i2 = 0; i2 < size2; ++i2) {
                    this._combinedGlyphList.add(this._managerGlyphList.get(i2));
                }
                break block9;
            }
            int orderSize = this._orderList.size();
            this._combinedGlyphList.addAll(this._glyphList);
            for (i = 0; i < orderSize; ++i) {
                obj = this._orderList.get(i);
                if (!(obj instanceof MapPosition)) continue;
                MapPosition pos = (MapPosition)obj;
                if (pos.position >= 0 && !this.addMapItem(this._backgroundGlyphList, pos, this._combinedGlyphList) && !this.addMapItem(this._managerGlyphList, pos, this._combinedGlyphList)) continue;
            }
            for (i = size = this._combinedGlyphList.size() - 1; i >= 0; --i) {
                if (this._combinedGlyphList.get(i) != null) continue;
                this._combinedGlyphList.remove(i);
            }
            if (this._combinedGlyphList.size() == this._glyphList.size() + this._managerGlyphList.size() + this._backgroundGlyphList.size()) break block9;
            size = this._combinedGlyphList.size();
            for (i = 0; i < this._managerGlyphList.size(); ++i) {
                obj = this._managerGlyphList.get(i);
                found = false;
                for (j = 0; j < size; ++j) {
                    if (obj != this._combinedGlyphList.get(j)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this._combinedGlyphList.add(obj);
            }
            for (i = 0; i < this._backgroundGlyphList.size(); ++i) {
                obj = this._backgroundGlyphList.get(i);
                found = false;
                for (j = 0; j < size; ++j) {
                    if (obj != this._combinedGlyphList.get(j)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this._combinedGlyphList.add(0, obj);
            }
        }
        return this._combinedGlyphList;
    }

    private boolean addMapItem(List mapList, MapPosition pos, List combinedGlyphList) {
        int size = mapList.size();
        boolean found = false;
        int position = pos.position;
        for (int ii = 0; ii < size; ++ii) {
            Object obj = mapList.get(ii);
            if (obj == null || combinedGlyphList.contains(obj) || !obj.getClass().getName().equals(pos.mapClass)) continue;
            while (position >= combinedGlyphList.size()) {
                combinedGlyphList.add(null);
            }
            if (combinedGlyphList.get(position) == null) {
                combinedGlyphList.set(position, obj);
            } else {
                combinedGlyphList.add(position, obj);
            }
            found = true;
            break;
        }
        return found;
    }

    public List glyphList() {
        return this._glyphList;
    }

    public List managerGlyphList() {
        return this._managerGlyphList;
    }

    public List backGroundGlyphList() {
        return this._backgroundGlyphList;
    }

    public boolean hasMap(MapObjectInterface map) {
        if (map == null) {
            return false;
        }
        for (int ii = 0; ii < this._glyphList.size(); ++ii) {
            MapGlyph glyphInList = (MapGlyph)this._glyphList.get(ii);
            if (!map.getName().equals(glyphInList.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean addMap(MapObjectInterface map) {
        return this.addMap(map, true);
    }

    public boolean addMap(MapObjectInterface map, boolean fireEvent) {
        return this.addMap(map, fireEvent, false);
    }

    public boolean addMap(MapObjectInterface map, boolean fireEvent, boolean toBottom) {
        if (this.hasMap(map)) {
            return false;
        }
        MapGlyph glyph = MapGlyphFactory.newMapGlyph(this, map);
        if (glyph == null) {
            return false;
        }
        if (map instanceof MapObjectInterface2) {
            this.addMaptools((MapObjectInterface2)map);
        }
        if (toBottom) {
            this._glyphList.add(0, glyph);
        } else {
            this._glyphList.add(glyph);
        }
        if (fireEvent) {
            this.fireGlyphVectorChanged();
        }
        this._scale.showAll();
        this.paintMap();
        return true;
    }

    public boolean addBackgroundMap(MapObjectInterface map) {
        return this.addBackgroundMap(map, true);
    }

    private boolean addBackgroundMap(MapObjectInterface map, boolean fireEvent) {
        for (int ii = 0; ii < this._backgroundGlyphList.size(); ++ii) {
            MapGlyph glyphInList = (MapGlyph)this._backgroundGlyphList.get(ii);
            if (!map.getName().equals(glyphInList.getName())) continue;
            return false;
        }
        MapGlyph glyph = MapGlyphFactory.newMapGlyph(this, map);
        if (glyph == null) {
            return false;
        }
        this.growRegionExtents(glyph.getBounds());
        map.getMapIdentifier().setIsBackground(true);
        this._backgroundGlyphList.add(glyph);
        if (fireEvent) {
            this.fireGlyphVectorChanged();
        }
        return true;
    }

    public boolean addManagerMap(MapObjectInterface map) {
        return this.addManagerMap(map, true);
    }

    protected boolean canAddManagerMap(MapObjectInterface map) {
        for (int ii = 0; ii < this._managerGlyphList.size(); ++ii) {
            MapGlyph glyphInList = (MapGlyph)this._managerGlyphList.get(ii);
            if (glyphInList == null || !map.getName().equals(glyphInList.getName())) continue;
            return false;
        }
        return true;
    }

    public boolean addManagerMap(MapObjectInterface map, boolean fireEvent) {
        if (!this.canAddManagerMap(map)) {
            return false;
        }
        MapGlyph glyph = MapGlyphFactory.newMapGlyph(this, map);
        if (glyph == null) {
            return false;
        }
        return this.addManagerMap(map, glyph, fireEvent);
    }

    public boolean addManagerMap(MapObjectInterface map, MapGlyph mapGlyph, boolean fireEvent) {
        map.getMapIdentifier().setIsManager(true);
        this.addManagerMapGlyph(mapGlyph);
        if (fireEvent) {
            this.fireGlyphVectorChanged();
        }
        if (map instanceof MapObjectInterface2) {
            this.addMaptools((MapObjectInterface2)map);
        }
        return true;
    }

    protected void addMaptools(MapObjectInterface2 map) {
        this._currentToolsPanel.addMapTools(map.getMapTools());
    }

    protected void addManagerMapGlyph(MapGlyph mapGlyph) {
        this._managerGlyphList.add(mapGlyph);
    }

    protected void fireGlyphVectorChanged() {
        this._combinedGlyphList = null;
        EventListener[] listeners = this.listenerList.getListeners(MapGlyphListener.class);
        for (int i = listeners.length - 1; i >= 0; --i) {
            ((MapGlyphListener)listeners[i]).mapGlyphsChanged();
        }
    }

    public List buildGlyphList() {
        this._combinedGlyphList = null;
        return this.glyphList();
    }

    public void addMapGlyphListener(MapGlyphListener l) {
        this.listenerList.add(MapGlyphListener.class, l);
    }

    public void removeMapGlyphListener(MapGlyphListener l) {
        this.listenerList.remove(MapGlyphListener.class, l);
    }

    public void growRegionExtents(WorldRect rect) {
        MapWorkspace wksp = (MapWorkspace)AppDaddy.getWorkspace();
        if (wksp == null || wksp.getGrowToExtents()) {
            this._scale.growRegionExtents(rect);
        }
    }

    public void removeAllMaps() {
        int i;
        int size = this._backgroundGlyphList.size();
        for (i = 0; i < size; ++i) {
            ((MapGlyph)this._backgroundGlyphList.get(i)).close();
        }
        this._backgroundGlyphList.clear();
        size = this._glyphList.size();
        for (i = 0; i < size; ++i) {
            MapGlyph mg = (MapGlyph)this._glyphList.get(i);
            mg.fillMap(false);
            mg.close();
            MapObjectInterface mapObject = mg.getMap();
            if (!(mapObject instanceof MapObjectInterface2)) continue;
            this._currentToolsPanel.removeMapTools(((MapObjectInterface2)mapObject).getMapTools());
        }
        this._glyphList.clear();
        size = this._managerGlyphList.size();
        for (i = 0; i < size; ++i) {
            ((MapGlyph)this._managerGlyphList.get(i)).close();
            MapObjectInterface mapObject = ((MapGlyph)this._managerGlyphList.get(i)).getMap();
            if (!(mapObject instanceof MapObjectInterface2)) continue;
            this._currentToolsPanel.removeMapTools(((MapObjectInterface2)mapObject).getMapTools());
        }
        this._managerGlyphList.clear();
        WorldRect rc = new WorldRect(-1000.0, 1000.0, 1000.0, -1000.0);
        this._scale.setRegionExtents(rc);
        this._scale.setDefaultRegionExtents(true);
        WorldPt pt = new WorldPt(0.0, 0.0);
        this._scale.setOrigin(pt);
        this._scale.setZoom(1.0);
        this._combinedGlyphList = null;
        this._scale.showAll();
        this.paintMap();
    }

    public void zoomIn(LocalRect rc) {
        boolean tf = this._scale.zoomIn(rc);
        if (tf) {
            this.resetScrollbars();
        }
        this.paintMap();
        if (tf) {
            this.notifyObservers(OBS_ZOOMIN);
        }
    }

    public void zoomByFactor(double factor) {
        this._scale.zoomByFactor(factor);
        this.resetScrollbars();
        this.paintMap();
        this.notifyObservers(OBS_ZOOMBYFACTOR);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Class<?> cls = null;
        Object obj = e.getSource();
        if (obj instanceof RmaJToolbarButton) {
            this._button = (RmaJToolbarButton)obj;
            this._button.changeIcon(this._button.isSelected());
            this._binfo = this._button.getGlyphButtonInfo();
            try {
                cls = Class.forName(this._binfo.getMapGlyphClass());
            }
            catch (Exception E) {
                System.out.println("MapPanel.actionPerformed: unknown class " + this._binfo.getMapGlyphClass());
                return;
            }
            if (!this.showMapElement(this._managerGlyphList, cls, this._binfo.getAttributeSetName(), false) && !this.showMapElement(this._backgroundGlyphList, cls, this._binfo.getAttributeSetName(), false)) {
                this.showMapElement(this._glyphList, cls, this._binfo.getAttributeSetName(), true);
            }
        }
    }

    boolean showMapElement(List glyphs, Class cls, String name, boolean isMap) {
        boolean found = false;
        boolean set = false;
        for (int i = 0; i < glyphs.size(); ++i) {
            Object obj = glyphs.get(i);
            if (obj.getClass() != cls || !(obj instanceof MapGlyph)) continue;
            if (!isMap) {
                set = true;
            } else if (isMap && RMAIO.getFileFromPath(((MapGlyph)obj).getMap().getMapIdentifier().getName()).equals(name)) {
                set = true;
            }
            if (!set) continue;
            ((MapGlyph)obj).showMapElement(name, this._binfo.getGlyphElement(), this._button.isSelected());
            found = true;
            break;
        }
        if (found) {
            this.paintMap();
        }
        return found;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent event) {
        int ival;
        WorldRect rc = this._scale.getWorldRect();
        WorldRect region = this._scale.getRegionExtents();
        WorldPt origin = new WorldPt();
        this._oldHorizontalValue = ival = this._horizScrollbar.getValue();
        int pgwidth = this._horizScrollbar.getVisibleAmount();
        origin.e = (double)(ival + pgwidth / 2) / 10000.0 * region.width() + region.w;
        this._oldVerticalValue = ival = this._vertScrollbar.getValue();
        pgwidth = this._vertScrollbar.getVisibleAmount();
        origin.n = region.n - (double)(ival + pgwidth / 2) / 10000.0 * region.height();
        this._scale.setOrigin(origin);
        boolean vadj = this._vertScrollbar.getValueIsAdjusting();
        boolean hadj = this._horizScrollbar.getValueIsAdjusting();
        if (!this._isAdjusting) {
            if (hadj || vadj) {
                this.paintImage();
            } else {
                this.paintMap();
            }
        }
        this.notifyObservers(OBS_SCROLLED);
    }

    public void resetScrollbars() {
        int lineinc;
        Dimension d = this._viewport.getSize();
        this._scale.setViewRect(d);
        WorldRect rc = this._scale.getWorldRect();
        WorldRect region = this._scale.getRegionExtents();
        int pgwidth = (int)(rc.width() / region.width() * 10000.0);
        if (pgwidth > 10000) {
            pgwidth = 10000;
        }
        if ((lineinc = pgwidth / 100) < 1) {
            lineinc = 1;
        }
        int ival = pgwidth == 10000 ? 0 : (int)((rc.w - region.w) / region.width() * 10000.0);
        this._isAdjusting = true;
        if (this._horizScrollbar != null) {
            this._horizScrollbar.removeAdjustmentListener(this);
            this._horizScrollbar.setValues(ival, pgwidth, 0, 10000);
            this._horizScrollbar.setBlockIncrement(lineinc * 10);
            this._horizScrollbar.setUnitIncrement(lineinc);
            this._horizScrollbar.addAdjustmentListener(this);
        }
        if ((pgwidth = (int)(rc.height() / region.height() * 10000.0)) > 10000) {
            pgwidth = 10000;
        }
        if ((lineinc = pgwidth / 100) < 1) {
            lineinc = 1;
        }
        ival = pgwidth == 10000 ? 0 : (int)((region.n - rc.n) / region.height() * 10000.0);
        if (this._vertScrollbar != null) {
            this._vertScrollbar.removeAdjustmentListener(this);
            this._vertScrollbar.setValues(ival, pgwidth, 0, 10000);
            this._vertScrollbar.setBlockIncrement(lineinc * 10);
            this._vertScrollbar.setUnitIncrement(lineinc);
            this._vertScrollbar.addAdjustmentListener(this);
        }
        this._isAdjusting = false;
    }

    public void scrollUp() {
        this.scrollTowardMin(this._vertScrollbar);
    }

    public void scrollLeft() {
        this.scrollTowardMin(this._horizScrollbar);
    }

    public void scrollRight() {
        this.scrollTowardMax(this._horizScrollbar);
    }

    public void scrollDown() {
        this.scrollTowardMax(this._vertScrollbar);
    }

    protected void scrollTowardMin(JScrollBar scrollbar) {
        int value = scrollbar.getValue();
        if (value == 0) {
            return;
        }
        if ((value -= scrollbar.getBlockIncrement()) < 0) {
            value = 0;
        }
        scrollbar.setValue(value);
    }

    protected void scrollTowardMax(JScrollBar scrollbar) {
        int max;
        int value = scrollbar.getValue();
        if (value == (max = scrollbar.getMaximum())) {
            return;
        }
        if ((value += scrollbar.getBlockIncrement()) > max) {
            value = max;
        }
        scrollbar.setValue(value);
    }

    public MapScale scale() {
        return this._scale;
    }

    public MapScale scale(MapGlyph glyph) {
        try {
            return new TransformMapScale(this._scale, this.getCoordinateReferenceSystem(), glyph.getMap().getCoordinateReferenceSystem());
        }
        catch (CRSException ex) {
            java.util.logging.Logger.getLogger(MapPanel.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return DisplayCoordinateReferenceSystem.getDefault().getCoordinateRefereceSystem();
    }

    public MapCanvas viewport() {
        return this._viewport;
    }

    public WorldRect getExtents() {
        return new WorldRect(this._extents);
    }

    public void setExtents(WorldRect e) {
        this.setExtents(e, true);
    }

    public void setExtents(WorldRect e, boolean resetWkspExtents) {
        if (Logger.canDebug("maps")) {
            System.out.println("setExtents: now " + e + " reset wksp=" + resetWkspExtents);
        }
        this._extents.set(e);
        if (resetWkspExtents && AppDaddy.getWorkspace() != null) {
            MapWorkspace wksp = (MapWorkspace)AppDaddy.getWorkspace();
            wksp.setExtents(e);
        }
    }

    public WorldRect getMaxExtents() {
        return new WorldRect(this._maxExtents);
    }

    public void setMaxExtents(WorldRect e) {
        this._maxExtents.set(e);
    }

    public Dimension getViewportSize() {
        Dimension d;
        if (this._viewport != null) {
            d = this._viewport.getSize();
        } else {
            System.out.println("Error: Viewport not accessible");
            d = new Dimension();
        }
        return d;
    }

    public void addGlyphs(List glyphs) throws IOException {
        if (this._viewport != null) {
            // empty if block
        }
    }

    void MapPanel_componentResized(ComponentEvent event) {
        this.resetScrollbars();
    }

    public void showAll() {
        this._scale.showAll();
        this.resetScrollbars();
        this.paintMap();
        this.notifyObservers(OBS_SHOWALL);
    }

    public void setOrigin(WorldPt p, boolean computeScaling) {
        this._scale.setOrigin(p, computeScaling);
        this.resetScrollbars();
        this.paintImage();
        this.notifyObservers(OBS_ORIGIN_SET);
    }

    public MapGlyph findGlyphForMapObject(MapObjectInterface map) {
        MapGlyph g;
        int i;
        if (map == null) {
            return null;
        }
        for (i = 0; i < this._glyphList.size(); ++i) {
            g = (MapGlyph)this._glyphList.get(i);
            if (g == null || g.getMap() != map) continue;
            return g;
        }
        for (i = 0; i < this._managerGlyphList.size(); ++i) {
            g = (MapGlyph)this._managerGlyphList.get(i);
            if (g == null || g.getMap() != map) continue;
            return g;
        }
        for (i = 0; i < this._backgroundGlyphList.size(); ++i) {
            g = (MapGlyph)this._backgroundGlyphList.get(i);
            if (g == null || g.getMap() != map) continue;
            return g;
        }
        MapIdentifier mi = map.getMapIdentifier();
        if (mi == null) {
            return null;
        }
        String origPath = mi.getPath();
        if (origPath == null) {
            return null;
        }
        for (int i2 = 0; i2 < this._glyphList.size(); ++i2) {
            String path;
            MapGlyph g2 = (MapGlyph)this._glyphList.get(i2);
            if (g2 == null || (mi = g2.getMap().getMapIdentifier()) == null || (path = mi.getPath()) == null || !path.equalsIgnoreCase(origPath)) continue;
            return g2;
        }
        return null;
    }

    public MapGlyph findGlyphForMapObjectClass(String classname) {
        if (classname == null) {
            return null;
        }
        try {
            MapGlyph g;
            int i;
            Class<?> c2 = Class.forName(classname);
            if (c2 == null) {
                return null;
            }
            for (i = 0; i < this._glyphList.size(); ++i) {
                g = (MapGlyph)this._glyphList.get(i);
                if (g == null || !c2.isInstance(g.getMap())) continue;
                return g;
            }
            for (i = 0; i < this._managerGlyphList.size(); ++i) {
                g = (MapGlyph)this._managerGlyphList.get(i);
                if (g == null || !c2.isInstance(g.getMap())) continue;
                return g;
            }
            for (i = 0; i < this._backgroundGlyphList.size(); ++i) {
                g = (MapGlyph)this._backgroundGlyphList.get(i);
                if (g == null || !c2.isInstance(g.getMap())) continue;
                return g;
            }
        }
        catch (Exception e) {
            System.out.println("Class " + classname + " not found.");
        }
        return null;
    }

    public MapGlyph findGlyphOfClass(String classname) {
        return this.findGlyphOfClass(classname, false);
    }

    public MapGlyph findGlyphOfClass(String classname, boolean searchChildren) {
        if (classname == null) {
            return null;
        }
        try {
            Class<?> c2 = Class.forName(classname);
            if (c2 == null) {
                return null;
            }
            return this.findGlyphOfClass(c2, searchChildren);
        }
        catch (ClassNotFoundException c3) {
            System.out.println("findGlyphOfClass:WARNING can't find Glyph class " + classname + " Error " + c3);
            return null;
        }
    }

    public <T extends MapGlyph> T findGlyphOfClass(Class<T> c2, boolean searchChildren) {
        try {
            MapGlyph g;
            int i;
            for (i = 0; i < this._glyphList.size(); ++i) {
                g = (MapGlyph)this._glyphList.get(i);
                if (g == null || !c2.isInstance(g)) continue;
                return (T)g;
            }
            for (i = 0; i < this._managerGlyphList.size(); ++i) {
                g = (MapGlyph)this._managerGlyphList.get(i);
                if (g == null) continue;
                if (c2.isInstance(g)) {
                    return (T)g;
                }
                if (!searchChildren || !g.hasChildGlyphs()) continue;
                Vector<MapGlyph> children = g.glyphVector();
                for (int j = 0; j < children.size(); ++j) {
                    g = children.get(j);
                    if (!c2.isInstance(g)) continue;
                    return (T)g;
                }
            }
            for (i = 0; i < this._backgroundGlyphList.size(); ++i) {
                g = (MapGlyph)this._backgroundGlyphList.get(i);
                if (g == null || !c2.isInstance(g)) continue;
                return (T)g;
            }
        }
        catch (Exception e) {
            System.out.println("Class " + c2.getName() + " not found.");
        }
        return null;
    }

    public List findGlyphsOfClass(String classname) {
        ArrayList<MapGlyph> glyphs = new ArrayList<MapGlyph>();
        if (classname == null) {
            return glyphs;
        }
        try {
            MapGlyph g;
            int i;
            Class<?> c2 = Class.forName(classname);
            if (c2 == null) {
                return glyphs;
            }
            for (i = 0; i < this._glyphList.size(); ++i) {
                g = (MapGlyph)this._glyphList.get(i);
                if (g == null || !c2.isInstance(g)) continue;
                glyphs.add(g);
            }
            for (i = 0; i < this._managerGlyphList.size(); ++i) {
                g = (MapGlyph)this._managerGlyphList.get(i);
                if (g == null || !c2.isInstance(g)) continue;
                glyphs.add(g);
            }
            for (i = 0; i < this._backgroundGlyphList.size(); ++i) {
                g = (MapGlyph)this._backgroundGlyphList.get(i);
                if (g == null || !c2.isInstance(g)) continue;
                glyphs.add(g);
            }
        }
        catch (Exception e) {
            System.out.println("Class " + classname + " not found.");
        }
        return glyphs;
    }

    public boolean getGrowToExtents() {
        MapWorkspace wksp = (MapWorkspace)AppDaddy.getWorkspace();
        if (wksp == null) {
            return false;
        }
        return wksp.getGrowToExtents();
    }

    public void updateExtents() {
        MapWorkspace wksp = (MapWorkspace)AppDaddy.getWorkspace();
        if (wksp == null) {
            return;
        }
        boolean growtoext = wksp.getGrowToExtents();
        this._scale.setRegionExtents(wksp.getExtents());
        if (growtoext) {
            WorldRect bounds;
            MapGlyph g;
            int i;
            boolean defaultext = true;
            this._scale.setDefaultRegionExtents(defaultext);
            for (i = 0; i < this._backgroundGlyphList.size(); ++i) {
                g = (MapGlyph)this._backgroundGlyphList.get(i);
                if (g == null) continue;
                this._scale.setDefaultRegionExtents(defaultext);
                bounds = g.getBounds();
                if (bounds == null) continue;
                this._scale.growRegionExtents(g.getBounds());
                defaultext = false;
            }
            for (i = 0; i < this._glyphList.size(); ++i) {
                g = (MapGlyph)this._glyphList.get(i);
                if (g == null) continue;
                this._scale.setDefaultRegionExtents(defaultext);
                bounds = g.getBounds();
                if (bounds == null) continue;
                this._scale.growRegionExtents(g.getBounds());
                defaultext = false;
            }
            for (i = 0; i < this._managerGlyphList.size(); ++i) {
                g = (MapGlyph)this._managerGlyphList.get(i);
                if (g == null) continue;
                this._scale.setDefaultRegionExtents(defaultext);
                this._scale.growRegionExtents(g.getBounds());
                defaultext = false;
            }
            wksp.setExtents(this._scale.getRegionExtents());
        }
        this.showAll();
        this._maxExtents = this._scale.getRegionExtents();
        this._extents = this._scale.getRegionExtents();
    }

    public WorldRect getCurrentExtents() {
        return this._scale.getWorldRect();
    }

    public void setUserInterface(UserInterface ui) {
        this._userInterface = ui;
    }

    public UserInterface getUserInterface() {
        return this._userInterface;
    }

    public void printStatus(String msg) {
        if (msg == null) {
            return;
        }
        if (this._userInterface != null) {
            this._userInterface.printStatus(msg);
        }
    }

    public synchronized void addObserver(Observer o) {
        if (this._observerList.indexOf(o) == -1) {
            this._observerList.addElement(o);
        }
    }

    public synchronized void deleteObserver(Observer o) {
        this._observerList.removeElement(o);
    }

    public void notifyObservers(String chgMsg) {
        for (int i = 0; i < this._observerList.size(); ++i) {
            Observer o = (Observer)this._observerList.get(i);
            o.update(null, chgMsg);
        }
    }

    public void removeManagerMap(MapObjectInterface mapObject) {
        if (mapObject == null) {
            return;
        }
        MapGlyph glyphInList = null;
        for (int ii = 0; ii < this._managerGlyphList.size(); ++ii) {
            glyphInList = (MapGlyph)this._managerGlyphList.get(ii);
            if (!mapObject.getName().equals(glyphInList.getName())) continue;
            this._managerGlyphList.remove(glyphInList);
            glyphInList.close();
            if (mapObject instanceof MapObjectInterface2) {
                this._currentToolsPanel.removeMapTools(((MapObjectInterface2)mapObject).getMapTools());
            }
            this.fireGlyphVectorChanged();
            return;
        }
    }

    public void removeMaps() {
        int size = this._glyphList.size();
        for (int i = 0; i < size; ++i) {
            MapGlyph mg = (MapGlyph)this._glyphList.get(i);
            mg.fillMap(false);
            mg.close();
        }
        this._glyphList.clear();
        this.fireGlyphVectorChanged();
        this.paintMap();
    }

    public boolean removeMap(MapObjectInterface map) {
        if (map == null) {
            return false;
        }
        MapGlyph glyphInList = null;
        for (int ii = 0; ii < this._glyphList.size(); ++ii) {
            glyphInList = (MapGlyph)this._glyphList.get(ii);
            if (!map.getName().equals(glyphInList.getName())) continue;
            this._glyphList.remove(glyphInList);
            this.fireGlyphVectorChanged();
            this.paintMap();
            return true;
        }
        return false;
    }

    public boolean removeMap(MapIdentifier mapId) {
        if (mapId == null) {
            return false;
        }
        MapGlyph glyphInList = null;
        for (int ii = 0; ii < this._glyphList.size(); ++ii) {
            glyphInList = (MapGlyph)this._glyphList.get(ii);
            if (!mapId.equals(glyphInList.getMap().getMapIdentifier())) continue;
            this._glyphList.remove(glyphInList);
            this.fireGlyphVectorChanged();
            this.paintMap();
            return true;
        }
        return false;
    }

    public List getVisibleMaps() {
        List maps = this.glyphList();
        ArrayList<MapObjectInterface> visibleMaps = new ArrayList<MapObjectInterface>(maps.size());
        for (int i = 0; i < maps.size(); ++i) {
            MapGlyph glyph = (MapGlyph)maps.get(i);
            if (!glyph.isShown()) continue;
            visibleMaps.add(glyph.getMap());
        }
        return visibleMaps;
    }

    public int getVerticalScrollBarWidth() {
        if (this._vertScrollbar != null && this._vertScrollbar.isVisible()) {
            return this._vertScrollbar.getWidth();
        }
        return 0;
    }

    public int getHorizontalScrollBarHeight() {
        int height = 0;
        if (this._horizScrollbar != null && this._horizScrollbar.isVisible() && (height = this._horizScrollbar.getHeight()) < 1) {
            height = 20;
        }
        return height;
    }

    public JPanel getViewportPanel() {
        return this._viewportContainerPanel;
    }

    class SymComponent
    extends ComponentAdapter {
        SymComponent() {
        }

        @Override
        public void componentResized(ComponentEvent event) {
            Object object = event.getSource();
            if (object == MapPanel.this) {
                MapPanel.this.MapPanel_componentResized(event);
            }
        }
    }

    protected class MouseWheelHandler
    implements MouseWheelListener {
        private Point _lastPoint;

        protected MouseWheelHandler() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.getScrollAmount() != 0) {
                int direction = 0;
                RMAJScrollBar toScroll = null;
                if (e.isShiftDown()) {
                    toScroll = MapPanel.this._horizScrollbar;
                } else if (e.isControlDown()) {
                    toScroll = MapPanel.this._vertScrollbar;
                } else {
                    this.mouseWheelZoom(e);
                    return;
                }
                int n = direction = e.getWheelRotation() < 0 ? -1 : 1;
                if (e.getScrollType() == 0) {
                    this.scrollByUnits(toScroll, direction, e.getScrollAmount());
                } else if (e.getScrollType() == 1) {
                    this.scrollByBlock(toScroll, direction);
                }
            }
        }

        private void mouseWheelZoom(MouseWheelEvent e) {
            int direction = e.getWheelRotation() < 0 ? -1 : 1;
            Point p = e.getPoint();
            double zf = 1.0;
            if (!p.equals(this._lastPoint)) {
                this._lastPoint = p;
            }
            zf = direction == 1 ? 1.105 : 0.905;
            LocalPt lpt = new LocalPt(p.x, p.y);
            WorldPt wpt = MapPanel.this.scale().lp2wp(lpt);
            WorldPt wpt0 = MapPanel.this.scale().getOrigin();
            wpt.e += (wpt0.e - wpt.e) * zf;
            wpt.n += (wpt0.n - wpt.n) * zf;
            MapPanel.this.scale().setOrigin(wpt);
            MapPanel.this.zoomByFactor(zf);
        }

        void scrollByBlock(JScrollBar scrollbar, int direction) {
            int oldValue = scrollbar.getValue();
            int blockIncrement = scrollbar.getBlockIncrement(direction);
            int delta = blockIncrement * (direction > 0 ? 1 : -1);
            scrollbar.setValue(oldValue + delta);
        }

        void scrollByUnits(JScrollBar scrollbar, int direction, int units) {
            int delta = units;
            delta = direction > 0 ? (delta *= scrollbar.getUnitIncrement(direction)) : (delta *= -scrollbar.getUnitIncrement(direction));
            int oldValue = scrollbar.getValue();
            int newValue = oldValue + delta;
            if (delta > 0 && newValue < oldValue) {
                newValue = scrollbar.getMaximum();
            } else if (delta < 0 && newValue > oldValue) {
                newValue = scrollbar.getMinimum();
            }
            scrollbar.setValue(newValue);
        }
    }
}

