/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.WorldPt;
import hec.map.WorldRect;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;

public class MapScale {
    protected WorldRect _regionExtents = new WorldRect();
    protected WorldPt _origin = new WorldPt();
    protected double _zoom = 1.0;
    protected LocalRect _viewRect = new LocalRect();
    protected double _aniso = 1.0;
    protected WorldRect _worldRect = new WorldRect();
    protected double _xscale = 1.0;
    protected double _yscale = 1.0;
    protected boolean _defaultRegionExtents = true;

    public MapScale() {
        this._regionExtents = new WorldRect(-5000.0, 5000.0, 5000.0, -5000.0);
        this._defaultRegionExtents = false;
        this._origin = new WorldPt(1000.0, 1000.0);
        this._zoom = 0.2;
        this.computeScaling();
        this._defaultRegionExtents = true;
    }

    public MapScale(MapScale scl) {
        this._regionExtents.init(scl._regionExtents);
        this._origin.init(scl._origin);
        this._zoom = scl._zoom;
        this._viewRect.init(scl._viewRect);
        this._aniso = scl._aniso;
        this._worldRect.init(scl._worldRect);
        this._xscale = scl._xscale;
        this._yscale = scl._yscale;
    }

    public double getXScale() {
        return this._xscale;
    }

    public double getYScale() {
        return this._yscale;
    }

    public double getAvgW2LScale() {
        return (Math.abs(this._xscale) + Math.abs(this._yscale)) / 2.0;
    }

    public boolean contains(WorldPt wpt) {
        return this._worldRect.contains(wpt);
    }

    public boolean contains(LocalPt pt) {
        return this._viewRect.contains(pt);
    }

    public void showAll() {
        if (!this._regionExtents.isValid()) {
            return;
        }
        this._origin.e = (this._regionExtents.e + this._regionExtents.w) / 2.0;
        this._origin.n = (this._regionExtents.n + this._regionExtents.s) / 2.0;
        this._zoom = 1.0;
        this.computeScaling();
    }

    public void setRegionExtents(WorldRect rc) {
        if (rc == null || !rc.isValid()) {
            return;
        }
        this._regionExtents.init(rc);
        this._origin.e = (rc.w + rc.e) / 2.0;
        this._origin.n = (rc.s + rc.n) / 2.0;
        this._defaultRegionExtents = false;
        this.computeScaling();
    }

    public void growRegionExtents(WorldRect rc) {
        if (rc == null || !rc.isValid()) {
            return;
        }
        if (this._defaultRegionExtents) {
            this.setRegionExtents(rc);
            return;
        }
        this._regionExtents.growToRect(rc);
        this.computeScaling();
    }

    public void setDefaultRegionExtents(boolean onOff) {
        this._defaultRegionExtents = onOff;
    }

    public boolean isDefaultRegionExtents() {
        return this._defaultRegionExtents;
    }

    public WorldRect getRegionExtents() {
        return new WorldRect(this._regionExtents);
    }

    public void setOrigin(WorldPt p) {
        this._origin.init(p);
        this.computeScaling();
    }

    public void setOrigin(WorldPt p, boolean computeScaling) {
        this._origin.init(p);
        if (computeScaling) {
            this.computeScaling();
        }
    }

    public WorldPt getOrigin() {
        return new WorldPt(this._origin);
    }

    public void setZoom(double z) {
        this._zoom = z;
        this.computeScaling();
    }

    public double getZoom() {
        return this._zoom;
    }

    public void setViewRect(LocalRect rc) {
        this._viewRect.init(rc);
        this.computeScaling();
    }

    public void setViewRect(Dimension d) {
        this._viewRect.init(0, 0, d.width, d.height);
        this.computeScaling();
    }

    public LocalRect getViewRect() {
        return new LocalRect(this._viewRect);
    }

    public WorldRect getWorldRect() {
        return new WorldRect(this._worldRect);
    }

    public boolean computeScaling() {
        double shift;
        if (!this._regionExtents.isValid()) {
            return false;
        }
        if (!this._origin.isValid()) {
            return false;
        }
        if (!this._viewRect.isValid()) {
            return false;
        }
        if (this._zoom < 1.0E-9) {
            return false;
        }
        double w = this._regionExtents.width() * this._zoom;
        double h = this._regionExtents.height() * this._zoom;
        double xscl = (double)this._viewRect.width() / w;
        double yscl = (double)this._viewRect.height() / h;
        if (yscl > xscl * this._aniso) {
            yscl = xscl * this._aniso;
        } else {
            xscl = yscl / this._aniso;
        }
        w = (double)this._viewRect.width() / xscl;
        h = (double)this._viewRect.height() / yscl;
        this._xscale = xscl;
        this._yscale = -yscl;
        this._worldRect.w = this._origin.e - w / 2.0;
        this._worldRect.e = this._worldRect.w + w;
        this._worldRect.n = this._origin.n + h / 2.0;
        this._worldRect.s = this._worldRect.n - h;
        if (w > this._regionExtents.width()) {
            this._origin.e = (this._regionExtents.w + this._regionExtents.e) / 2.0;
            shift = (w - this._regionExtents.width()) / 2.0;
            this._worldRect.w = this._regionExtents.w - shift;
            this._worldRect.e = this._worldRect.w + w;
        } else if (this._worldRect.w < this._regionExtents.w) {
            this._worldRect.w = this._regionExtents.w;
            this._worldRect.e = this._worldRect.w + w;
            this._origin.e = (this._worldRect.w + this._worldRect.e) / 2.0;
        } else if (this._worldRect.e > this._regionExtents.e) {
            this._worldRect.e = this._regionExtents.e;
            this._worldRect.w = this._worldRect.e - w;
            this._origin.e = (this._worldRect.w + this._worldRect.e) / 2.0;
        }
        if (h > this._regionExtents.height()) {
            this._origin.n = (this._regionExtents.s + this._regionExtents.n) / 2.0;
            shift = (h - this._regionExtents.height()) / 2.0;
            this._worldRect.s = this._regionExtents.s - shift;
            this._worldRect.n = this._worldRect.s + h;
        } else if (this._worldRect.s < this._regionExtents.s) {
            this._worldRect.s = this._regionExtents.s;
            this._worldRect.n = this._worldRect.s + h;
            this._origin.n = (this._worldRect.s + this._worldRect.n) / 2.0;
        } else if (this._worldRect.n > this._regionExtents.n) {
            this._worldRect.n = this._regionExtents.n;
            this._worldRect.s = this._worldRect.n - h;
            this._origin.n = (this._worldRect.s + this._worldRect.n) / 2.0;
        }
        return true;
    }

    public void zoomByFactor(double factor) {
        double zm;
        if (factor < 0.1) {
            factor = 0.1;
        }
        if ((zm = this._zoom * factor) < 1.0E-5) {
            zm = 1.0E-5;
        }
        if (zm > 2.0) {
            zm = 2.0;
        }
        this._zoom = zm;
        this.computeScaling();
    }

    public boolean zoomIn(WorldRect wc) {
        return this.zoomIn(this.wr2lr(wc));
    }

    public boolean zoomIn(LocalRect rc) {
        double zm;
        double yfactor;
        if (!this._viewRect.isValid()) {
            return false;
        }
        int top = rc.t;
        int bottom = rc.b;
        int left = rc.l;
        int right = rc.r;
        double factor = (double)rc.width() / (double)this._viewRect.width();
        if (factor < (yfactor = (double)rc.height() / (double)this._viewRect.height())) {
            factor = yfactor;
        }
        int x = (rc.l + rc.r) / 2;
        int y = (rc.t + rc.b) / 2;
        this._origin.e = this.x2e(x);
        this._origin.n = this.y2n(y);
        if (factor < 0.1) {
            factor = 0.1;
        }
        if ((zm = this._zoom * factor) < 1.0E-5) {
            zm = 1.0E-5;
        }
        if (zm > 2.0) {
            zm = 2.0;
        }
        this._zoom = zm;
        this.computeScaling();
        return true;
    }

    public AffineTransform world2LocalTransform(AffineTransform transform) {
        if (transform == null) {
            transform = new AffineTransform();
        }
        transform.scale(this.getXScale(), this.getYScale());
        transform.translate(-this.getWorldRect().w, -this.getWorldRect().n);
        return transform;
    }

    public AffineTransform local2WorldTransform(AffineTransform transform) {
        if (transform == null) {
            transform = new AffineTransform();
        }
        transform.translate(this.getWorldRect().w, this.getWorldRect().n);
        transform.scale(this.getXScale(), this.getYScale());
        return transform;
    }

    @Deprecated
    public int e2x(double e) {
        return (int)((e - this._worldRect.w) * this._xscale);
    }

    @Deprecated
    public int n2y(double n) {
        return (int)((n - this._worldRect.n) * this._yscale);
    }

    @Deprecated
    public double x2e(int x) {
        return (double)x / this._xscale + this._worldRect.w;
    }

    @Deprecated
    public double y2n(int y) {
        return (double)y / this._yscale + this._worldRect.n;
    }

    public void wp2lp(WorldPt wpt, LocalPt lpt) {
        lpt.x = (int)((wpt.e - this._worldRect.w) * this._xscale);
        lpt.y = (int)((wpt.n - this._worldRect.n) * this._yscale);
    }

    public final LocalPt wp2lp(WorldPt wpt) {
        LocalPt lpt = new LocalPt();
        this.wp2lp(wpt, lpt);
        return lpt;
    }

    public void lp2wp(LocalPt lpt, WorldPt wpt) {
        wpt.e = (double)lpt.x / this._xscale + this._worldRect.w;
        wpt.n = (double)lpt.y / this._yscale + this._worldRect.n;
    }

    public final WorldPt lp2wp(LocalPt lpt) {
        WorldPt wpt = new WorldPt();
        this.lp2wp(lpt, wpt);
        return wpt;
    }

    public LocalRect wr2lr(WorldRect wr) {
        LocalRect lr = new LocalRect();
        lr.l = this.e2x(wr.w);
        lr.r = this.e2x(wr.e);
        lr.t = this.n2y(wr.n);
        lr.b = this.n2y(wr.s);
        return lr;
    }

    public LocalRect wr2lr(WorldRect wr, LocalRect lr) {
        if (lr == null) {
            lr = new LocalRect();
        }
        lr.l = this.e2x(wr.w);
        lr.r = this.e2x(wr.e);
        lr.t = this.n2y(wr.n);
        lr.b = this.n2y(wr.s);
        return lr;
    }

    public WorldRect lr2wr(LocalRect lr) {
        WorldRect wr = new WorldRect();
        wr.w = this.x2e(lr.l);
        wr.e = this.x2e(lr.r);
        wr.n = this.y2n(lr.t);
        wr.s = this.y2n(lr.b);
        return wr;
    }
}

